/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.text;

import org.jpedal.fonts.CodeSpaceRange;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.text.GlyphData;
import org.jpedal.parser.text.TD;

final class CIDTextUtils {
    private CIDTextUtils() {
    }

    static int getNonEmbedCIDCharValues(int i2, byte[] stream, int streamLength, GlyphData glyphData, PdfFont currentFontData) {
        CodeSpaceRange cmap = glyphData.getCodeSpaceRange();
        int nn = 0;
        int v2 = 0;
        int p2 = 1;
        while (i2 + nn < stream.length) {
            int b1 = stream[i2 + nn] & 0xFF;
            ++nn;
            if (b1 == 92) {
                b1 = stream[i2 + nn] & 0xFF;
                ++nn;
                if (CIDTextUtils.isDigit(b1)) {
                    StringBuilder sb = new StringBuilder();
                    sb.append((char)b1);
                    if (i2 + nn < streamLength && CIDTextUtils.isDigit(stream[i2 + nn] & 0xFF)) {
                        sb.append((char)(stream[i2 + nn] & 0xFF));
                        if (i2 + ++nn < streamLength && CIDTextUtils.isDigit(stream[i2 + nn] & 0xFF)) {
                            sb.append((char)(stream[i2 + nn] & 0xFF));
                            ++nn;
                        }
                    }
                    b1 = Integer.parseInt(sb.toString(), 8);
                } else {
                    b1 = CIDTextUtils.convertEscapeChar(b1);
                }
            }
            if (cmap.isInCodeSpaceRange(v2 = v2 << 8 | b1, p2)) break;
            ++p2;
        }
        int cid = cmap.cidMap[v2];
        int uni = cmap.uniMap[cid];
        glyphData.setRawInt(v2);
        glyphData.setRawChar((char)v2);
        glyphData.setDisplayValue(String.valueOf((char)uni).intern());
        glyphData.setUnicodeValue(String.valueOf((char)uni).intern());
        CIDTextUtils.setActualWidth(glyphData, currentFontData, p2, cid);
        return i2 + nn - 1;
    }

    static int getCIDtoGIDandUNICharValues(int i2, byte[] stream, int streamLength, GlyphData glyphData, PdfFont currentFontData) {
        int nn = 0;
        int v2 = 0;
        int p2 = 1;
        while (i2 + nn < stream.length) {
            int b1 = stream[i2 + nn] & 0xFF;
            ++nn;
            if (b1 == 92) {
                b1 = stream[i2 + nn] & 0xFF;
                ++nn;
                if (CIDTextUtils.isDigit(b1)) {
                    StringBuilder sb = new StringBuilder();
                    sb.append((char)b1);
                    if (i2 + nn < streamLength && CIDTextUtils.isDigit(stream[i2 + nn] & 0xFF)) {
                        sb.append((char)(stream[i2 + nn] & 0xFF));
                        if (i2 + ++nn < streamLength && CIDTextUtils.isDigit(stream[i2 + nn] & 0xFF)) {
                            sb.append((char)(stream[i2 + nn] & 0xFF));
                            ++nn;
                        }
                    }
                    b1 = Integer.parseInt(sb.toString(), 8);
                } else {
                    b1 = CIDTextUtils.convertEscapeChar(b1);
                }
            }
            if (currentFontData.getUnicodeMapping(v2 = v2 << 8 | b1) != null || p2 == 2) break;
            ++p2;
        }
        glyphData.setRawInt(v2);
        glyphData.setRawChar((char)v2);
        int cid = v2;
        glyphData.setDisplayValue(currentFontData.getUnicodeMapping(cid));
        glyphData.setUnicodeValue(currentFontData.getUnicodeMapping(cid));
        CIDTextUtils.setActualWidth(glyphData, currentFontData, p2, cid);
        return i2 + nn - 1;
    }

    private static void setActualWidth(GlyphData glyphData, PdfFont currentFontData, int p2, int cid) {
        float actualWidth;
        if (p2 > 1) {
            actualWidth = currentFontData.getDefaultWidth(cid);
            if (actualWidth == -1.0f) {
                actualWidth = currentFontData.getDefaultWidth(-1);
            }
        } else {
            actualWidth = -1.0f;
            if ((currentFontData.getFontType() == -1684566726 || currentFontData.getFontType() == -1684566724) && (actualWidth = currentFontData.getDefaultWidth(cid)) == -1.0f) {
                actualWidth = currentFontData.getDefaultWidth(-1) / 2.0f;
            }
        }
        if (actualWidth > 0.0f) {
            glyphData.setActualWidth(actualWidth);
        }
    }

    private static boolean isDigit(int v2) {
        return v2 >= 48 && v2 <= 57;
    }

    static int getCIDCharValues(int i2, byte[] stream, int streamLength, GlyphData glyphData, PdfFont curFont, ParserOptions parserOptions) {
        boolean hasCharString;
        float actualWidth = 0.0f;
        if (StandardFonts.CMAP == null) {
            StandardFonts.readCMAP();
        }
        int firstVal = glyphData.getRawInt();
        String newValue = null;
        if (firstVal == 92) {
            firstVal = stream[++i2] & 0xFF;
            if (streamLength > i2 + 2 && Character.isDigit((char)stream[i2])) {
                int numberCount = CIDTextUtils.getNumberCount(i2, stream);
                firstVal = TD.readEscapeValue(i2, numberCount, 8, stream);
                i2 = i2 + numberCount - 1;
                firstVal = firstVal > 255 ? firstVal - 256 : firstVal;
            } else if (firstVal == 117) {
                firstVal = TD.readEscapeValue(i2 + 1, 4, 16, stream);
                i2 += 4;
            } else {
                firstVal = CIDTextUtils.convertEscapeChar(firstVal);
            }
            glyphData.setRaw(firstVal);
        } else {
            firstVal = glyphData.getRawChar();
        }
        String firstValue = StandardFonts.CMAP[glyphData.getRawChar()];
        boolean isEmbedded = curFont.isFontEmbedded;
        boolean bl2 = hasCharString = glyphData.getRawInt() > 0 && curFont.CMapName != null && curFont.getFontType() == -1684566726 && curFont.getGlyphData().containsKey(String.valueOf(glyphData.getRawInt()));
        if (!"OneByteIdentityH".equals(curFont.CMapName)) {
            if (!hasCharString && (curFont.hasDoubleBytes || firstValue == null || curFont.isDoubleBytes() != 0 || glyphData.getRawInt() > 128 && glyphData.getRawInt() != 233)) {
                int iBefore = i2++;
                int secondVal = stream[i2] & 0xFF;
                boolean secondByteIsEscaped = false;
                if (stream[i2] == 92) {
                    ++i2;
                    secondByteIsEscaped = true;
                    if (glyphData.getRawInt() == 0) {
                        while (stream[i2] == 13 || stream[i2] == 92 && stream[i2 - 1] == 13) {
                            ++i2;
                        }
                    }
                    secondVal = stream[i2] & 0xFF;
                    if (streamLength > i2 + 2 && Character.isDigit((char)stream[i2])) {
                        int numberCount = CIDTextUtils.getNumberCount(i2, stream);
                        secondVal = TD.readEscapeValue(i2, numberCount, 8, stream);
                        i2 = i2 + numberCount - 1;
                        secondVal = secondVal > 255 ? secondVal - 256 : secondVal;
                    } else if (secondVal == 117) {
                        secondVal = TD.readEscapeValue(i2 + 1, 4, 16, stream);
                        i2 += 4;
                    } else {
                        secondVal = CIDTextUtils.convertEscapeChar(secondVal);
                    }
                }
                char combinedVal = (char)((glyphData.getRawChar() << 8) + secondVal);
                newValue = StandardFonts.CMAP[combinedVal];
                int isDouble = -1;
                if (curFont.isCIDFont() && curFont.getGlyphData().getTable(2) == null) {
                    int first = curFont.getEncodedCMAPValue(firstVal);
                    int second = curFont.getEncodedCMAPValue(secondVal);
                    int combined = curFont.getEncodedCMAPValue(combinedVal);
                    if (combined <= 0 && (first > 0 || second > 0)) {
                        newValue = null;
                        isDouble = 0;
                    }
                }
                if (isDouble == -1) {
                    isDouble = curFont.isDoubleBytes(firstVal, secondVal, secondByteIsEscaped);
                }
                if (isEmbedded && (isDouble == 1 || combinedVal < '\u0100' || newValue != null)) {
                    glyphData.setRaw(combinedVal);
                } else if (!isEmbedded && isDouble == 1 && (newValue != null || combinedVal < '\u0100' || !secondByteIsEscaped && secondVal != 41)) {
                    glyphData.setRaw(combinedVal);
                } else if (!isEmbedded && isDouble == 0 && firstVal > 128 && newValue != null && firstValue == null) {
                    glyphData.setRaw(combinedVal);
                } else if (!isEmbedded && isDouble == 0 && firstVal > 128 && newValue == null && firstValue != null) {
                    i2 = iBefore;
                    newValue = firstValue;
                } else {
                    i2 = iBefore;
                }
                if (!isEmbedded && (actualWidth = curFont.getDefaultWidth(glyphData.getRawInt())) == -1.0f) {
                    actualWidth = curFont.getDefaultWidth(-1);
                }
            } else {
                actualWidth = CIDTextUtils.getActualWidth(glyphData, curFont, isEmbedded);
            }
        }
        CIDTextUtils.setGlyphDetails(glyphData, curFont, parserOptions.isTextExtracted(), newValue, actualWidth);
        return i2;
    }

    private static void setGlyphDetails(GlyphData glyphData, PdfFont curFont, boolean isTextExtracted, String newValue, float actualWidth) {
        glyphData.setActualWidth(actualWidth);
        String dValue = newValue != null ? newValue : String.valueOf(glyphData.getRawChar()).intern();
        glyphData.setDisplayValue(dValue);
        if (isTextExtracted) {
            glyphData.setUnicodeValue(curFont.getUnicodeValue(glyphData.getDisplayValue(), glyphData.getRawChar()));
            if (!curFont.isFontEmbedded) {
                glyphData.setDisplayValue(String.valueOf(curFont.getUnicodeValue(glyphData.getDisplayValue(), glyphData.getRawChar())));
            }
        }
        if (glyphData.getRawChar() == '\\') {
            glyphData.setRawChar('x');
        }
    }

    private static float getActualWidth(GlyphData glyphData, PdfFont currentFontData, boolean isEmbedded) {
        float actualWidth = -1.0f;
        if (!(isEmbedded || currentFontData.getFontType() != -1684566726 && currentFontData.getFontType() != -1684566724 || (actualWidth = currentFontData.getDefaultWidth(glyphData.getRawInt())) != -1.0f)) {
            actualWidth = currentFontData.getDefaultWidth(-1) / 2.0f;
        }
        return actualWidth;
    }

    private static int getNumberCount(int i2, byte[] stream) {
        int numberCount = 1;
        if (Character.isDigit((char)stream[i2 + 1])) {
            ++numberCount;
            if (Character.isDigit((char)stream[i2 + 2])) {
                ++numberCount;
            }
        }
        return numberCount;
    }

    private static int convertEscapeChar(int secondVal) {
        switch (secondVal) {
            case 110: {
                return 10;
            }
            case 98: {
                return 8;
            }
            case 116: {
                return 9;
            }
            case 114: {
                return 13;
            }
            case 102: {
                return 12;
            }
        }
        return secondVal;
    }
}

