/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.shape;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.color.ShearedTexturePaint;
import org.jpedal.external.ShapeTracker;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfShape;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.PdfObjectCache;
import org.jpedal.parser.image.PDFObjectToImage;
import org.jpedal.parser.image.mask.MaskUtils;
import org.jpedal.render.DynamicVectorRenderer;

public final class F {
    private F() {
    }

    public static void execute(int tokenNumber, boolean isStar, int formLevel, PdfShape currentDrawShape, GraphicsState gs, PdfObjectReader currentPdfFile, DynamicVectorRenderer current, ParserOptions parserOptions, float multiplyer, PdfObjectCache cache) {
        if (gs.SMask != null && gs.SMask.getDictionary(23) != null && (gs.nonstrokeColorSpace.getID() == 1568372915 || gs.nonstrokeColorSpace.getID() == 1785221209 || gs.nonstrokeColorSpace.getID() == 1498837125)) {
            if (isStar) {
                currentDrawShape.setEVENODDWindingRule();
            } else {
                currentDrawShape.setNONZEROWindingRule();
            }
            currentDrawShape.closeShape();
            Shape currentShape = currentDrawShape.generateShapeFromPath(gs.CTM, gs.getLineWidth(), 70);
            if (currentShape == null) {
                F.createSMaskFill(gs, currentPdfFile, current, parserOptions, formLevel, multiplyer, cache);
            } else {
                F.renderShapeAsG2Shape(formLevel, currentDrawShape, gs, currentPdfFile, current, parserOptions, multiplyer, cache);
            }
            currentDrawShape.resetPath();
            return;
        }
        if (parserOptions.isLayerVisible()) {
            if (isStar) {
                currentDrawShape.setEVENODDWindingRule();
            } else {
                currentDrawShape.setNONZEROWindingRule();
            }
            currentDrawShape.closeShape();
            Shape currentShape = currentDrawShape.generateShapeFromPath(gs.CTM, gs.getLineWidth(), 70);
            ShapeTracker customShapeTracker = parserOptions.getCustomShapeTraker();
            if (customShapeTracker != null) {
                if (isStar) {
                    customShapeTracker.addShape(tokenNumber, 17962, currentShape, gs.nonstrokeColorSpace.getColor(), gs.strokeColorSpace.getColor());
                } else {
                    customShapeTracker.addShape(tokenNumber, 70, currentShape, gs.nonstrokeColorSpace.getColor(), gs.strokeColorSpace.getColor());
                }
            }
            if (currentShape != null && parserOptions.isRenderPage()) {
                gs.setFillType(2);
                current.drawShape(currentDrawShape, gs, 70);
            }
        }
        currentDrawShape.setClip(false);
        currentDrawShape.resetPath();
    }

    private static void renderShapeAsG2Shape(int formLevel, PdfShape currentDrawShape, GraphicsState gs, PdfObjectReader currentPdfFile, DynamicVectorRenderer current, ParserOptions parserOptions, float multiplyer, PdfObjectCache cache) {
        BufferedImage result = F.getSmaskAppliedImage(gs, currentPdfFile, parserOptions, formLevel, multiplyer, cache);
        PdfObject maskObj = gs.SMask.getDictionary(23);
        currentPdfFile.checkResolved(maskObj);
        float[] BBox = maskObj.getFloatArray(303185736);
        int fx1 = (int)(BBox[0] + 0.5f);
        int fy1 = (int)(BBox[1] + 0.5f);
        int fx2 = (int)(BBox[2] + 0.5f);
        int fy2 = (int)(BBox[3] + 0.5f);
        if (fx1 < 0) {
            fx1 = 0;
        }
        if (fy1 < 0) {
            fy1 = 0;
        }
        int w2 = fx2 - fx1;
        int h2 = fy2 - fy1;
        if (w2 < 0) {
            w2 = -w2;
        } else if (w2 == 0) {
            w2 = 1;
        }
        if (h2 < 0) {
            h2 = -h2;
        } else if (h2 == 0) {
            h2 = 1;
        }
        Rectangle rect = new Rectangle(fx1, fy1, w2, h2);
        GraphicsState gs1 = gs.deepCopy();
        if (formLevel == 0) {
            gs1.nonstrokeColorSpace.setColor(new ShearedTexturePaint(result, rect, gs.CTM));
        } else {
            gs1.nonstrokeColorSpace.setColor(new ShearedTexturePaint(result, rect, new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}}));
        }
        gs1.setFillType(2);
        gs1.strokeColorSpace.setColor(gs.strokeColorSpace.getColor());
        current.drawShape(currentDrawShape, gs1, 70);
    }

    private static BufferedImage getSmaskAppliedImage(GraphicsState gs, PdfObjectReader currentPdfFile, ParserOptions parserOptions, int formLevel, float multiplyer, PdfObjectCache cache) {
        PdfObject maskObj = gs.SMask.getDictionary(23);
        currentPdfFile.checkResolved(maskObj);
        float[] BBox = maskObj.getFloatArray(303185736);
        int x1 = (int)(BBox[0] + 0.5f);
        int y1 = (int)(BBox[1] + 0.5f);
        int x2 = (int)(BBox[2] + 0.5f);
        int y2 = (int)(BBox[3] + 0.5f);
        if (x1 < 0) {
            x1 = 0;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        BufferedImage smaskImage = PDFObjectToImage.getImageFromPdfObject(maskObj, x1, x2, y1, y2, currentPdfFile, parserOptions, cache, formLevel, multiplyer, false, 1.0f);
        BufferedImage result = F.blendBackgroundIntoImage(gs, currentPdfFile, smaskImage);
        smaskImage.flush();
        return result;
    }

    private static BufferedImage blendBackgroundIntoImage(GraphicsState gs, PdfObjectReader currentPdfFile, BufferedImage smaskImage) {
        PdfPaint prev = gs.nonstrokeColorSpace.getColor();
        int prevInt = prev.getRGB();
        float[] BC2 = gs.SMask.getFloatArray(4627);
        int brgb = 0;
        boolean hasBC = false;
        if (BC2 != null) {
            int rgb = MaskUtils.getBCasRGB(gs, currentPdfFile, BC2);
            PdfColor backgroundColor = new PdfColor(rgb);
            gs.nonstrokeColorSpace.setColor(backgroundColor);
            brgb = gs.nonstrokeColorSpace.getColor().getRGB();
            gs.nonstrokeColorSpace.setColor(prev);
            hasBC = true;
        }
        int pa = prevInt >>> 24;
        int br2 = brgb >> 16 & 0xFF;
        int bg2 = brgb >> 8 & 0xFF;
        int bb2 = brgb & 0xFF;
        BufferedImage result = new BufferedImage(smaskImage.getWidth(), smaskImage.getHeight(), 2);
        int[] sPixels = ((DataBufferInt)smaskImage.getRaster().getDataBuffer()).getData();
        int[] dPixels = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
        for (int i2 = 0; i2 < sPixels.length; ++i2) {
            int sargb = sPixels[i2];
            int sa = sargb >>> 24 & 0xFF;
            int sr = sargb >> 16 & 0xFF;
            int sg = sargb >> 8 & 0xFF;
            int sb = sargb & 0xFF;
            if (hasBC) {
                if (sa == 0) {
                    sr = br2;
                    sg = bg2;
                    sb = bb2;
                } else if (sa < 255) {
                    int alpha_ = 255 - sa;
                    sr = sr * sa + br2 * alpha_ >> 8;
                    sg = sg * sa + bg2 * alpha_ >> 8;
                    sb = sb * sa + bb2 * alpha_ >> 8;
                }
            }
            int y2 = sr * 77 + sg * 152 + sb * 28;
            y2 = pa * y2 >> 16;
            dPixels[i2] = y2 << 24 | prevInt & 0xFFFFFF;
        }
        return result;
    }

    private static void createSMaskFill(GraphicsState gs, PdfObjectReader currentPdfFile, DynamicVectorRenderer current, ParserOptions parserOptions, int formLevel, float multiplyer, PdfObjectCache cache) {
        PdfObject maskObj = gs.SMask.getDictionary(23);
        currentPdfFile.checkResolved(maskObj);
        float[] BBox = maskObj.getFloatArray(303185736);
        int fx = (int)(BBox[0] + 0.5f);
        int fy = (int)(BBox[1] + 0.5f);
        int fw = (int)(BBox[2] + 0.5f);
        int fh = (int)(BBox[3] + 0.5f);
        if (fx < 0) {
            fx = 0;
        }
        if (fy < 0) {
            fy = 0;
        }
        BufferedImage smaskImage = PDFObjectToImage.getImageFromPdfObject(maskObj, fx, fw, fy, fh, currentPdfFile, parserOptions, cache, formLevel, multiplyer, false, 1.0f);
        GraphicsState gs1 = gs.deepCopy();
        gs1.CTM = new float[][]{{smaskImage.getWidth(), 0.0f, 0.0f}, {0.0f, -smaskImage.getHeight(), 0.0f}, {0.0f, 0.0f, 1.0f}};
        gs1.x = fx;
        gs1.y = fy;
        gs1.CTM[2][0] = gs1.x;
        gs1.CTM[2][1] = gs1.y;
        PdfPaint prev = gs.nonstrokeColorSpace.getColor();
        int prevInt = prev.getRGB();
        float[] BC2 = gs.SMask.getFloatArray(4627);
        int brgb = 0;
        if (BC2 != null) {
            gs.nonstrokeColorSpace.setColor(BC2);
            brgb = gs.nonstrokeColorSpace.getColor().getRGB();
            gs.nonstrokeColorSpace.setColor(prev);
        }
        int br2 = brgb >> 16 & 0xFF;
        int bg2 = brgb >> 8 & 0xFF;
        int bb2 = brgb & 0xFF;
        BufferedImage result = new BufferedImage(smaskImage.getWidth(), smaskImage.getHeight(), 2);
        int[] sPixels = ((DataBufferInt)smaskImage.getRaster().getDataBuffer()).getData();
        int[] dPixels = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
        for (int i2 = 0; i2 < sPixels.length; ++i2) {
            int sargb = sPixels[i2];
            int sa = sargb >>> 24 & 0xFF;
            int sr = sargb >> 16 & 0xFF;
            int sg = sargb >> 8 & 0xFF;
            int sb = sargb & 0xFF;
            if (sa == 0) {
                sr = br2;
                sg = bg2;
                sb = bb2;
            } else if (sa < 255) {
                int alpha_ = 255 - sa;
                sr = sr * sa + br2 * alpha_ >> 8;
                sg = sg * sa + bg2 * alpha_ >> 8;
                sb = sb * sa + bb2 * alpha_ >> 8;
            }
            int y2 = sr * 77 + sg * 152 + sb * 28;
            sa = sa * y2 >> 16;
            dPixels[i2] = sa << 24 | prevInt & 0xFFFFFF;
        }
        current.drawImage(parserOptions.getPageNumber(), result, gs1, false, "F", -1);
        smaskImage.flush();
    }
}

