/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image.mask;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.image.data.ImageData;
import org.jpedal.utils.LogWriter;

public final class SMaskDecoder {
    private SMaskDecoder() {
    }

    public static byte[] apply_Smask(ImageData imageData, ImageData smaskData, byte[] maskData, PdfObject imageObject, PdfObject maskObject, GenericColorSpace colorSpace) {
        int maskDim;
        int imageDim;
        byte[] objectData = imageData.getObjectData();
        int iw = imageData.getWidth();
        int ih = imageData.getHeight();
        int id2 = imageData.getDepth();
        float[] matte = maskObject.getFloatArray(826557522);
        if (matte != null) {
            matte = new float[]{matte[0], matte[0], matte[0]};
        }
        int sw = smaskData.getWidth();
        int sh = smaskData.getHeight();
        int sd = smaskData.getDepth();
        byte[] index = colorSpace.getIndexedMap();
        if (index != null) {
            index = colorSpace.convertIndexToRGB(index);
            objectData = ColorSpaceConvertor.convertIndexToRGBByte(index, iw, ih, id2, objectData, false, false);
        } else {
            objectData = colorSpace.dataToRGBByteArray(ColorSpaceConvertor.normaliseTo8Bit(1, id2, iw, ih, objectData), iw, ih, imageData.getRenderingIntent());
        }
        maskData = ColorSpaceConvertor.normaliseTo8Bit(1, sd, sw, sh, maskData);
        float[] decodeArr = maskObject.getFloatArray(859785322);
        if (decodeArr != null) {
            SMaskDecoder.applyDecodeArray(maskData, decodeArr);
        }
        if ((imageDim = iw * ih) > (maskDim = sw * sh)) {
            maskData = SMaskDecoder.getScaledBytes(maskData, sw, sh, iw, ih);
        } else if (maskDim > imageDim) {
            objectData = SMaskDecoder.getScaledBytes(objectData, iw, ih, sw, sh);
            imageDim = maskDim;
            iw = sw;
            ih = sh;
        }
        ByteBuffer buffer = ByteBuffer.allocate(iw * ih * 4);
        if (imageDim == objectData.length) {
            int aa2 = 0;
            for (int i2 = 0; i2 < imageDim; ++i2) {
                byte r2 = objectData[i2];
                for (int j2 = 0; j2 < 3; ++j2) {
                    buffer.put(r2);
                }
                buffer.put(maskData[aa2++]);
            }
        } else {
            SMaskDecoder.handleIncorrectlySizedMask(maskData, objectData, iw, ih, matte, imageDim, buffer);
        }
        imageObject.setIntNumber(959726687, iw);
        imageObject.setIntNumber(959926393, ih);
        imageObject.setIntNumber(-1344207655, 8);
        return buffer.array();
    }

    private static void applyDecodeArray(byte[] maskData, float[] decodeArr) {
        int i2;
        float ratio = Math.abs(decodeArr[1] - decodeArr[0]);
        if (decodeArr[0] > decodeArr[1]) {
            for (i2 = 0; i2 < maskData.length; ++i2) {
                maskData[i2] = (byte)(255 - (maskData[i2] & 0xFF));
            }
        }
        if (ratio != 1.0f) {
            for (i2 = 0; i2 < maskData.length; ++i2) {
                int raw = maskData[i2] & 0xFF;
                raw = (int)((float)raw * ratio);
                maskData[i2] = (byte)raw;
            }
        }
    }

    private static void handleIncorrectlySizedMask(byte[] maskData, byte[] objectData, int iw, int ih, float[] matte, int imageDim, ByteBuffer buffer) {
        int p2 = 0;
        if (matte != null) {
            for (byte aMaskData : maskData) {
                int a10 = aMaskData & 0xFF;
                int r2 = objectData[p2++] & 0xFF;
                int g2 = objectData[p2++] & 0xFF;
                int b2 = objectData[p2++] & 0xFF;
                if (a10 != 0) {
                    double k2 = 255.0 / (double)a10;
                    r2 = (int)((double)((float)r2 - matte[0]) * k2 + (double)matte[0]);
                    g2 = (int)((double)((float)g2 - matte[1]) * k2 + (double)matte[1]);
                    b2 = (int)((double)((float)b2 - matte[2]) * k2 + (double)matte[2]);
                    r2 = r2 < 0 ? 0 : Math.min(r2, 255);
                    g2 = g2 < 0 ? 0 : Math.min(g2, 255);
                    b2 = b2 < 0 ? 0 : Math.min(b2, 255);
                }
                byte[] bb2 = new byte[]{(byte)r2, (byte)g2, (byte)b2, (byte)a10};
                buffer.put(bb2);
            }
        } else {
            int expected = imageDim * 3;
            if (objectData.length < expected) {
                byte[] temp = new byte[expected];
                System.arraycopy(objectData, 0, temp, 0, objectData.length);
                objectData = temp;
            }
            int iter = Math.min(maskData.length, iw * ih);
            for (int i2 = 0; i2 < iter; ++i2) {
                buffer.put(new byte[]{objectData[p2++], objectData[p2++], objectData[p2++], maskData[i2]});
            }
        }
    }

    private static byte[] getScaledBytes(byte[] data, int sw, int sh, int dw, int dh) {
        if (data.length == sw * sh) {
            return SMaskDecoder.rescaleComponent(data, sw, sh, dw, dh);
        }
        int dim = sw * sh;
        int maxSize = data.length / 3;
        if (dim > maxSize) {
            dim = maxSize;
        }
        byte[] rr = new byte[dim];
        byte[] gg = new byte[dim];
        byte[] bb2 = new byte[dim];
        int p2 = 0;
        for (int i2 = 0; i2 < dim; ++i2) {
            rr[i2] = data[p2++];
            gg[i2] = data[p2++];
            bb2[i2] = data[p2++];
        }
        rr = SMaskDecoder.rescaleComponent(rr, sw, sh, dw, dh);
        gg = SMaskDecoder.rescaleComponent(gg, sw, sh, dw, dh);
        bb2 = SMaskDecoder.rescaleComponent(bb2, sw, sh, dw, dh);
        p2 = 0;
        dim = dw * dh;
        byte[] temp = new byte[dim * 3];
        for (int i3 = 0; i3 < dim; ++i3) {
            temp[p2++] = rr[i3];
            temp[p2++] = gg[i3];
            temp[p2++] = bb2[i3];
        }
        return temp;
    }

    private static byte[] rescaleComponent(byte[] data, int sw, int sh, int dw, int dh) {
        if (data.length == 1) {
            byte a10 = data[0];
            data = new byte[dw * dh];
            Arrays.fill(data, a10);
            return data;
        }
        if (sh == 1) {
            byte[] temp = new byte[2 * sw];
            System.arraycopy(data, 0, temp, 0, sw);
            System.arraycopy(data, 0, temp, sw, sw);
            sh = 2;
            data = temp;
        }
        float ratioW = (float)sw / (float)dw;
        float ratioH = (float)sh / (float)dh;
        byte[] combinedData = new byte[dw * dh];
        int rawDataSize = data.length;
        int i2 = 0;
        try {
            for (int mY = 0; mY < dh; ++mY) {
                for (int mX = 0; mX < dw; ++mX) {
                    int rgbPtr = (int)((float)mX * ratioW) + (int)((float)mY * ratioH) * sw;
                    if (rgbPtr < rawDataSize) {
                        combinedData[i2] = data[rgbPtr];
                    }
                    ++i2;
                }
            }
        }
        catch (Exception e2) {
            LogWriter.writeLog(e2);
        }
        return combinedData;
    }
}

