/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image.mask;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import org.jpedal.function.PDFFunction;
import org.jpedal.io.ColorSpaceConvertor;

final class SMask {
    private SMask() {
    }

    public static BufferedImage applyLuminosityMask(BufferedImage image, BufferedImage smask, int[] tr, boolean hasBC, int bc2) {
        int sh;
        int sw;
        int smaskDim;
        int ih;
        int iw;
        int imageDim;
        if (smask == null) {
            return image;
        }
        if (smask.getType() != 2) {
            smask = ColorSpaceConvertor.convertToARGB(smask);
        }
        if (image.getType() != 2) {
            image = ColorSpaceConvertor.convertToARGB(image);
        }
        if ((imageDim = (iw = image.getWidth()) * (ih = image.getHeight())) < (smaskDim = (sw = smask.getWidth()) * (sh = smask.getHeight()))) {
            image = SMask.scaleImage(image, sw, sh);
        } else if (smaskDim < imageDim) {
            smask = SMask.scaleImage(smask, iw, ih);
        }
        int[] imagePixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int[] maskPixels = ((DataBufferInt)smask.getRaster().getDataBuffer()).getData();
        int r0 = bc2 >> 16 & 0xFF;
        int g0 = bc2 >> 8 & 0xFF;
        int b0 = bc2 & 0xFF;
        for (int i2 = 0; i2 < imagePixels.length; ++i2) {
            int mp = maskPixels[i2];
            int a10 = mp >>> 24;
            int r2 = mp >> 16 & 0xFF;
            int g2 = mp >> 8 & 0xFF;
            int b2 = mp & 0xFF;
            if (hasBC) {
                if (a10 == 0) {
                    r2 = r0;
                    g2 = g0;
                    b2 = b0;
                } else if (a10 < 255) {
                    int a_2 = 255 - a10;
                    r2 = r2 * a10 + r0 * a_2 >> 8;
                    g2 = g2 * a10 + g0 * a_2 >> 8;
                    b2 = b2 * a10 + b0 * a_2 >> 8;
                }
            }
            int y2 = r2 * 77 + g2 * 152 + b2 * 28;
            int ip = imagePixels[i2];
            int resA = ip >> 24 & 0xFF;
            resA = tr != null ? resA * tr[y2 >> 8] >> 8 : resA * y2 >> 16;
            imagePixels[i2] = resA << 24 | ip & 0xFFFFFF;
        }
        return image;
    }

    public static BufferedImage applyAlphaMask(BufferedImage image, BufferedImage smask, PDFFunction trFunction) {
        int sh;
        int sw;
        int smaskDim;
        int ih;
        int iw;
        int imageDim;
        if (smask == null) {
            return image;
        }
        if (smask.getType() != 2) {
            smask = ColorSpaceConvertor.convertToARGB(smask);
        }
        if (image.getType() != 2) {
            image = ColorSpaceConvertor.convertToARGB(image);
        }
        if ((imageDim = (iw = image.getWidth()) * (ih = image.getHeight())) < (smaskDim = (sw = smask.getWidth()) * (sh = smask.getHeight()))) {
            image = SMask.scaleImage(image, sw, sh);
        } else if (smaskDim < imageDim) {
            smask = SMask.scaleImage(smask, iw, ih);
        }
        int[] imagePixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int[] maskPixels = ((DataBufferInt)smask.getRaster().getDataBuffer()).getData();
        float sc = 0.003921569f;
        int lastMa = -1;
        int lastComputed = -1;
        for (int i2 = 0; i2 < imagePixels.length; ++i2) {
            int mp = maskPixels[i2];
            int ip = imagePixels[i2];
            int ia = ip >> 24 & 0xFF;
            int ma = mp >> 24 & 0xFF;
            if (trFunction != null) {
                if (ma == lastMa) {
                    ma = lastComputed;
                } else {
                    lastMa = ma;
                    lastComputed = ma = (int)(255.0f * trFunction.compute(new float[]{(float)ma / 255.0f})[0]);
                }
            }
            int a10 = (int)((float)(ia * ma) * 0.003921569f);
            imagePixels[i2] = a10 << 24 | ip & 0xFFFFFF;
        }
        return image;
    }

    private static BufferedImage scaleImage(BufferedImage src, int w2, int h2) {
        BufferedImage dimg = new BufferedImage(w2, h2, 2);
        Graphics2D g2 = dimg.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(src, 0, 0, w2, h2, null);
        g2.dispose();
        return dimg;
    }
}

