/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image.mask;

import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import org.jpedal.color.ColorspaceFactory;
import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.FunctionFactory;
import org.jpedal.function.PDFFunction;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.FunctionObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.PdfObjectCache;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.image.PDFObjectToImage;
import org.jpedal.parser.image.mask.SMask;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.SwingDisplay;
import org.jpedal.utils.LogWriter;

public final class MaskUtils {
    private MaskUtils() {
    }

    public static void createMaskForm(PdfObject XObject2, String name, PdfObject newSMask, GraphicsState gs, DynamicVectorRenderer current, PdfObjectReader currentPdfFile, ParserOptions parserOptions, int formLevel, float multiplyer, PdfObjectCache cache, boolean useTransparancy, int blendMode) {
        GraphicsState gs1;
        BufferedImage image;
        float[] BBox = XObject2.getFloatArray(303185736);
        int x1 = (int)BBox[0];
        int y1 = (int)BBox[1];
        int x2 = (int)BBox[2];
        int y2 = (int)BBox[3];
        String upscaleMasks = System.getProperty("org.jpedal.upscaleMasks");
        float scaling = upscaleMasks == null || "true".equalsIgnoreCase(upscaleMasks) ? 4.0f : 1.0f;
        if (x1 < 0) {
            x1 = 0;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        String sMaskRef = newSMask != null ? '_' + newSMask.getObjectRefAsString() : "";
        String maskCacheKey = "Mask_" + XObject2.getObjectRefAsString() + sMaskRef;
        ObjectStore objectCache = currentPdfFile.getObjectStore();
        if (objectCache.checkTempFileExists(maskCacheKey + ".jpl")) {
            image = objectCache.loadStoredImage(maskCacheKey);
            if (image == null) {
                image = PDFObjectToImage.getImageFromPdfObject(XObject2, x1, x2, y1, y2, currentPdfFile, parserOptions, cache, formLevel, multiplyer, newSMask == null && useTransparancy, scaling);
                if (newSMask != null) {
                    image = MaskUtils.handleSMask(newSMask, gs, currentPdfFile, parserOptions, cache, formLevel, multiplyer, x1, y1, x2, y2, scaling, image);
                }
                objectCache.saveStoredImageAsBytes(maskCacheKey, image, false);
            }
        } else {
            image = PDFObjectToImage.getImageFromPdfObject(XObject2, x1, x2, y1, y2, currentPdfFile, parserOptions, cache, formLevel, multiplyer, newSMask == null && useTransparancy, scaling);
            if (newSMask != null) {
                image = MaskUtils.handleSMask(newSMask, gs, currentPdfFile, parserOptions, cache, formLevel, multiplyer, x1, y1, x2, y2, scaling, image);
            }
            objectCache.saveStoredImageAsBytes(maskCacheKey, null, false);
        }
        int iw = (int)((float)image.getWidth() / scaling);
        int ih = (int)((float)image.getHeight() / scaling);
        boolean isChanged = false;
        if (newSMask == null && gs.getAlphaMax(2) < 1.0f) {
            isChanged = true;
            gs1 = new GraphicsState();
            gs1.setMaxAlpha(2, gs.getAlphaMax(2));
            gs1.setMaxAlpha(1, gs.getAlphaMax(1));
            current.setGraphicsState(1, gs.getAlpha(1), 1111314299);
            current.setGraphicsState(2, gs.getAlpha(2), blendMode);
        } else {
            gs1 = new GraphicsState(gs);
        }
        int prevBM = gs1.getBMValue();
        gs1.setBMValue(blendMode);
        gs1.CTM = new float[][]{{iw, 0.0f, 0.0f}, {0.0f, ih, 0.0f}, {0.0f, 0.0f, 1.0f}};
        gs1.x = x1;
        gs1.y = y1 < y2 ? (float)y1 : (float)(y1 - ih);
        int xScaleToBBox = Math.abs(x2 - x1) / iw;
        int yScaleToBBox = Math.abs(y2 - y1) / ih;
        MaskUtils.loadGraphicsStateValues(gs1, gs, xScaleToBBox, yScaleToBBox);
        if (current.isHTMLorSVG()) {
            Area clip = gs.getClippingShape();
            if (clip != null) {
                gs1.updateClip(clip);
            }
            current.drawImage(parserOptions.getPageNumber(), image, gs1, false, name, -2);
        } else {
            gs1.x = gs1.CTM[2][0];
            gs1.y = gs1.CTM[2][1];
            current.drawImage(parserOptions.getPageNumber(), image, gs1, false, name, -1);
        }
        gs1.setBMValue(prevBM);
        if (isChanged) {
            current.setGraphicsState(1, gs.getAlpha(1), gs.getBMValue());
            current.setGraphicsState(2, gs.getAlpha(2), gs.getBMValue());
        }
    }

    private static void loadGraphicsStateValues(GraphicsState gs1, GraphicsState gs, int xScaleToBBox, int yScaleToBBox) {
        gs1.CTM[2][0] = gs1.x * gs.CTM[0][0] + gs.CTM[2][0];
        gs1.CTM[2][1] = gs1.y * gs.CTM[1][1] + gs.CTM[2][1];
        float[] fArray = gs1.CTM[0];
        fArray[0] = fArray[0] * gs.CTM[0][0];
        gs1.CTM[1][1] = -gs1.CTM[1][1] * gs.CTM[1][1];
        float[] fArray2 = gs1.CTM[0];
        fArray2[0] = fArray2[0] * (float)xScaleToBBox;
        float[] fArray3 = gs1.CTM[1];
        fArray3[1] = fArray3[1] * (float)yScaleToBBox;
        float[] fArray4 = gs1.CTM[2];
        fArray4[1] = fArray4[1] - gs1.CTM[1][1];
    }

    private static BufferedImage handleSMask(PdfObject newSMask, GraphicsState gs, PdfObjectReader currentPdfFile, ParserOptions parserOptions, PdfObjectCache cache, int formLevel, float multiplyer, int x1, int y1, int x2, int y2, float scaling, BufferedImage image) {
        PDFFunction function;
        BufferedImage smaskImage = PDFObjectToImage.getImageFromPdfObject(newSMask, x1, x2, y1, y2, currentPdfFile, parserOptions, cache, formLevel, multiplyer, false, scaling);
        PdfObject objTR = gs.SMask.getDictionary(9250);
        if (objTR != null) {
            FunctionObject funcObj = new FunctionObject(objTR.getObjectRefAsString());
            currentPdfFile.readObject(funcObj);
            function = FunctionFactory.getFunction(funcObj, currentPdfFile);
        } else {
            function = null;
        }
        if (gs.SMask.getNameAsConstant(35) == -2139971891) {
            int[] tr;
            float[] bcFloats = gs.SMask.getFloatArray(4627);
            if (function != null) {
                tr = new int[256];
                for (int i2 = 0; i2 < 256; ++i2) {
                    tr[i2] = (int)(function.compute(new float[]{(float)i2 / 255.0f})[0] * 255.0f);
                }
            } else {
                tr = null;
            }
            if (bcFloats != null) {
                int bc2 = MaskUtils.getBCasRGB(gs, currentPdfFile, bcFloats);
                image = SMask.applyLuminosityMask(image, smaskImage, tr, true, bc2);
            } else {
                image = SMask.applyLuminosityMask(image, smaskImage, tr, false, 0);
            }
        } else {
            image = SMask.applyAlphaMask(image, smaskImage, function);
        }
        if (smaskImage != null) {
            smaskImage.flush();
        }
        return image;
    }

    public static int getBCasRGB(GraphicsState gs, PdfObjectReader currentPdfFile, float[] bcFloats) {
        PdfObject group;
        GenericColorSpace decodeColorData = new DeviceRGBColorSpace();
        PdfObject g2 = gs.SMask.getDictionary(23);
        if (g2 != null && (group = g2.getDictionary(1111442775)) != null) {
            currentPdfFile.checkResolved(group);
            PdfArrayIterator ColorSpace2 = group.getMixedArray(2087749783);
            if (ColorSpace2 != null && ColorSpace2.getTokenCount() > 0) {
                decodeColorData = ColorspaceFactory.getColorSpaceInstance(currentPdfFile, ColorSpace2);
            }
        }
        ((GenericColorSpace)decodeColorData).setColor(bcFloats);
        return decodeColorData.getColor().getRGB();
    }

    public static BufferedImage createTransparentForm(PdfObject XObject2, int fy, int fw, int fh, PdfObjectReader currentPdfFile, int formLevel, float multiplyer) {
        byte[] objectData1 = currentPdfFile.readStream(XObject2, true, true, false, false, false, XObject2.getCacheName(currentPdfFile.getObjectReader()));
        ObjectStore localStore = currentPdfFile.getObjectStore();
        SwingDisplay glyphDisplay = new SwingDisplay(0, false, 20, localStore);
        PdfStreamDecoder glyphDecoder = new PdfStreamDecoder(currentPdfFile);
        glyphDecoder.setParameters(true, true, 3, 65, false);
        glyphDecoder.setObjectValue(-8, localStore);
        glyphDecoder.setFormLevel(formLevel);
        glyphDecoder.setMultiplyer(multiplyer);
        glyphDecoder.setRenderer(glyphDisplay);
        try {
            PdfObject SMaskResources = XObject2.getDictionary(2004251818);
            if (SMaskResources != null) {
                glyphDecoder.readResources(SMaskResources, false);
            }
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
        if (objectData1 != null) {
            glyphDecoder.decodeStreamIntoObjects(objectData1, false, false);
        }
        int hh = fh;
        if (fy > fh) {
            hh = fy - fh;
        }
        float scaling = MaskUtils.getSanitisedScalingValue(fw);
        BufferedImage image = new BufferedImage((int)((float)fw * scaling), (int)((float)hh * scaling), 2);
        Graphics2D formG2 = image.createGraphics();
        formG2.translate(0.0, scaling * (float)hh);
        formG2.scale(1.0, -1.0);
        formG2.scale(scaling, scaling);
        glyphDisplay.setG2(formG2);
        glyphDisplay.paint(null, null, null);
        return image;
    }

    private static float getSanitisedScalingValue(int fw) {
        float scaling = 4.0f;
        while (scaling * (float)fw > 4000.0f) {
            scaling /= 2.0f;
        }
        return scaling;
    }
}

