/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image.mask;

import com.idrsolutions.image.jpeg2000.EnumeratedSpace;
import com.idrsolutions.pdf.color.shading.BitReader;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.parser.image.data.ImageData;

public final class MaskDataDecoder {
    private MaskDataDecoder() {
    }

    public static BufferedImage applyMaskArray(ImageData imageData, int[] maskArray) {
        int bitDepth = imageData.getDepth();
        int nComp = maskArray.length / 2;
        int dim = imageData.getWidth() * imageData.getHeight();
        BufferedImage img = new BufferedImage(imageData.getWidth(), imageData.getHeight(), 2);
        int[] output = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        byte[] data = imageData.getObjectData();
        block0 : switch (bitDepth) {
            case 1: 
            case 2: 
            case 4: {
                int padding = 8 - imageData.getWidth() % 8;
                MaskDataDecoder.handleNonByteBitMask(maskArray, bitDepth, nComp, dim, output, data, imageData.getWidth(), padding == 8 ? 0 : padding);
                break;
            }
            case 8: {
                switch (nComp) {
                    case 1: {
                        MaskDataDecoder.apply1CompMask(maskArray, dim, output, data);
                        break block0;
                    }
                    case 3: {
                        MaskDataDecoder.apply3CompMask(maskArray, dim, output, data);
                        break block0;
                    }
                    case 4: {
                        MaskDataDecoder.processJPEG(dim, data, maskArray, output);
                        break block0;
                    }
                }
            }
        }
        return img;
    }

    private static void processJPEG(int dim, byte[] data, int[] maskArray, int[] output) {
        EnumeratedSpace cmyk = new EnumeratedSpace();
        int p2 = 0;
        for (int i2 = 0; i2 < dim; ++i2) {
            boolean isMask;
            int c2 = data[p2++] & 0xFF;
            int m2 = data[p2++] & 0xFF;
            int y2 = data[p2++] & 0xFF;
            int k2 = data[p2++] & 0xFF;
            boolean bl2 = isMask = c2 >= maskArray[0] && c2 <= maskArray[1] && m2 >= maskArray[2] && m2 <= maskArray[3] && y2 >= maskArray[4] && y2 <= maskArray[5] && k2 >= maskArray[4] && k2 <= maskArray[5];
            if (isMask) continue;
            output[i2] = 0xFF000000 | cmyk.getRGB(c2, m2, y2, k2);
        }
    }

    private static void apply3CompMask(int[] maskArray, int dim, int[] output, byte[] data) {
        int p2 = 0;
        for (int i2 = 0; i2 < dim; ++i2) {
            boolean isMask;
            int r2 = data[p2++] & 0xFF;
            int g2 = data[p2++] & 0xFF;
            int b2 = data[p2++] & 0xFF;
            boolean bl2 = isMask = r2 >= maskArray[0] && r2 <= maskArray[1] && g2 >= maskArray[2] && g2 <= maskArray[3] && b2 >= maskArray[4] && b2 <= maskArray[5];
            if (isMask) continue;
            output[i2] = 0xFF000000 | r2 << 16 | g2 << 8 | b2;
        }
    }

    private static void apply1CompMask(int[] maskArray, int dim, int[] output, byte[] data) {
        int p2 = 0;
        for (int i2 = 0; i2 < dim; ++i2) {
            int t2;
            boolean isMask;
            boolean bl2 = isMask = (t2 = data[p2++] & 0xFF) >= maskArray[0] && t2 <= maskArray[1];
            if (isMask) continue;
            output[i2] = 0xFF000000 | t2 << 16 | t2 << 8 | t2;
        }
    }

    private static void handleNonByteBitMask(int[] maskArray, int bitDepth, int nComp, int dim, int[] output, byte[] data, int width, int padding) {
        BitReader reader = new BitReader(data, true);
        for (int i2 = 0; i2 < dim; ++i2) {
            boolean isMask;
            if (nComp == 1) {
                int t2 = reader.getPositive(bitDepth);
                boolean bl2 = isMask = t2 >= maskArray[0] && t2 <= maskArray[1];
                if (!isMask) {
                    output[i2] = 0xFF000000 | t2 << 16 | t2 << 8 | t2;
                }
            } else {
                int r2 = reader.getPositive(bitDepth);
                int g2 = reader.getPositive(bitDepth);
                int b2 = reader.getPositive(bitDepth);
                boolean bl3 = isMask = r2 >= maskArray[0] && r2 <= maskArray[1] && g2 >= maskArray[2] && g2 <= maskArray[3] && b2 >= maskArray[4] && b2 <= maskArray[5];
                if (!isMask) {
                    output[i2] = 0xFF000000 | (r2 ^= 0xFF) << 16 | (g2 ^= 0xFF) << 8 | (b2 ^= 0xFF);
                }
            }
            if (padding == 0 || (i2 + 1) % width != 0) continue;
            reader.getPositive(padding);
        }
    }

    static byte[] convertData(GenericColorSpace decodeColorData, byte[] objectData, int w2, int h2, ImageData imageData, int d2) {
        byte[] index = decodeColorData.getIndexedMap();
        if (index != null) {
            index = decodeColorData.convertIndexToRGB(index);
            objectData = ColorSpaceConvertor.convertIndexToRGBByte(index, w2, h2, imageData.getDepth(), objectData, false, false);
        } else if (d2 > 1) {
            objectData = decodeColorData.dataToRGBByteArray(objectData, w2, h2, imageData.getRenderingIntent());
            if (d2 == 8) {
                MaskDataDecoder.check4BitData(objectData);
            }
        }
        return objectData;
    }

    private static void check4BitData(byte[] objectData) {
        int size = objectData.length;
        boolean is4Bit = true;
        for (byte b2 : objectData) {
            if (b2 >= 0 && b2 <= 15) continue;
            is4Bit = false;
            break;
        }
        if (is4Bit) {
            int ii = 0;
            while (ii < size) {
                int n2 = ii++;
                objectData[n2] = (byte)(objectData[n2] << 4);
            }
        }
    }
}

