/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image.downsample;

import org.jpedal.images.SamplingFactory;
import org.jpedal.parser.image.data.ImageData;

final class KernelUtils {
    private KernelUtils() {
    }

    static void applyKernel(ImageData imageData, int compCount) {
        double[][] kernel = SamplingFactory.getSharpenKernel();
        byte[] input = imageData.getObjectData();
        int w2 = imageData.getWidth();
        int h2 = imageData.getHeight();
        if (compCount == 3) {
            compCount = 4;
        }
        byte[] output = new byte[w2 * h2 * compCount];
        int value = 0;
        int lineBytes = w2 * compCount;
        int matrixSize = kernel.length;
        for (int x2 = 0; x2 < w2; ++x2) {
            for (int y2 = 0; y2 < h2; ++y2) {
                for (int i2 = 0; i2 < matrixSize; ++i2) {
                    for (int j2 = 0; j2 < matrixSize; ++j2) {
                        int imageX = (x2 - matrixSize / 2 + i2 + w2) % w2;
                        int imageY = (y2 - matrixSize / 2 + j2 + h2) % h2;
                        int currentPixel = input[imageY * lineBytes + imageX] & 0xFF;
                        value = (int)((double)value + (double)currentPixel * kernel[i2][j2]);
                    }
                }
                if (value < 0) {
                    value = 0;
                } else if (value > 255) {
                    value = 255;
                }
                output[y2 * lineBytes + x2] = (byte)value;
                value = 0;
            }
        }
        imageData.setObjectData(output);
    }
}

