/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image.downsample;

import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.images.SamplingFactory;
import org.jpedal.parser.image.PdfImageTypes;
import org.jpedal.parser.image.data.ImageData;
import org.jpedal.parser.image.downsample.KernelUtils;

final class EightBitDownSampler {
    private EightBitDownSampler() {
    }

    static GenericColorSpace downSample(ImageData imageData, GenericColorSpace decodeColorData, int sampling) {
        boolean needsSharpening;
        int origLineLength;
        byte[] newData;
        int comp;
        byte[] index = decodeColorData.getIndexedMap();
        boolean hasIndex = index != null;
        int indexCount = 1;
        boolean isBinary = true;
        if (hasIndex) {
            comp = 1;
            imageData.setCompCount(3);
            indexCount = 3;
            index = decodeColorData.convertIndexToRGB(index);
            isBinary = index.length == 6;
            decodeColorData = new DeviceRGBColorSpace();
        } else {
            comp = decodeColorData.getColorComponentCount();
        }
        int newW = imageData.getWidth() / sampling;
        int newH = imageData.getHeight() / sampling;
        byte[] data = imageData.getObjectData();
        int oldSize = data.length;
        if (imageData.getWidth() * imageData.getHeight() == oldSize || decodeColorData.getID() == 1568372915) {
            comp = 1;
        }
        if (hasIndex) {
            newData = new byte[newW * newH * indexCount];
            origLineLength = imageData.getWidth();
        } else {
            newData = new byte[newW * newH * comp];
            origLineLength = imageData.getWidth() * comp;
        }
        isBinary = hasIndex ? EightBitDownSampler.setIndexedPixels(imageData, sampling, index, comp, indexCount, isBinary, newW, newH, data, oldSize, origLineLength, newData) : EightBitDownSampler.setPixels(imageData, sampling, comp, newW, newH, data, oldSize, origLineLength, newData);
        if (isBinary) {
            imageData.setImageType(PdfImageTypes.Binary);
        }
        imageData.setObjectData(newData);
        imageData.setWidth(newW);
        imageData.setHeight(newH);
        boolean bl2 = needsSharpening = SamplingFactory.kernelSharpen || SamplingFactory.downsampleLevel == 5 || SamplingFactory.downsampleLevel == 6;
        if (needsSharpening && imageData.getImageType() == PdfImageTypes.Binary && sampling < 8) {
            KernelUtils.applyKernel(imageData, comp);
        }
        return decodeColorData;
    }

    private static boolean setPixels(ImageData imageData, int sampling, int comp, int newW, int newH, byte[] data, int oldSize, int origLineLength, byte[] newData) {
        boolean isBinary = true;
        for (int y2 = 0; y2 < newH; ++y2) {
            for (int x2 = 0; x2 < newW; ++x2) {
                int wCount = EightBitDownSampler.getwCount(imageData, sampling, x2);
                int hCount = EightBitDownSampler.gethCount(imageData, sampling, y2);
                isBinary = EightBitDownSampler.scanPixels(sampling, comp, newW, data, oldSize, origLineLength, newData, y2, x2, isBinary, wCount, hCount);
            }
        }
        return isBinary;
    }

    private static boolean scanPixels(int sampling, int comp, int newW, byte[] data, int oldSize, int origLineLength, byte[] newData, int y2, int x2, boolean isBinary, int wCount, int hCount) {
        for (int jj = 0; jj < comp; ++jj) {
            int byteTotal = 0;
            int count = 0;
            for (int yy = 0; yy < hCount; ++yy) {
                for (int xx = 0; xx < wCount; ++xx) {
                    int ptr = (yy + y2 * sampling) * origLineLength + (x2 * sampling * comp + xx * comp + jj);
                    if (ptr >= oldSize) continue;
                    byteTotal += data[ptr] & 0xFF;
                    isBinary = isBinary && (data[ptr] == 0 || data[ptr] == -1);
                    ++count;
                }
            }
            if (count <= 0) continue;
            int newPtr = jj + x2 * comp + newW * y2 * comp;
            newData[newPtr] = (byte)(byteTotal / count);
        }
        return isBinary;
    }

    private static int getwCount(ImageData imageData, int sampling, int x2) {
        int wCount = sampling;
        int wGapLeft = imageData.getWidth() - x2;
        if (wCount > wGapLeft) {
            wCount = wGapLeft;
        }
        return wCount;
    }

    private static int gethCount(ImageData imageData, int sampling, int y2) {
        int hCount = sampling;
        int hGapLeft = imageData.getHeight() - y2;
        if (hCount > hGapLeft) {
            hCount = hGapLeft;
        }
        return hCount;
    }

    private static boolean setIndexedPixels(ImageData imageData, int sampling, byte[] index, int comp, int indexCount, boolean isBinary, int newW, int newH, byte[] data, int oldSize, int origLineLength, byte[] newData) {
        for (int y2 = 0; y2 < newH; ++y2) {
            for (int x2 = 0; x2 < newW; ++x2) {
                isBinary = EightBitDownSampler.scanIndexedPixels(imageData, sampling, index, comp, indexCount, isBinary, newW, data, oldSize, origLineLength, newData, y2, x2);
            }
        }
        return isBinary;
    }

    private static boolean scanIndexedPixels(ImageData imageData, int sampling, byte[] index, int comp, int indexCount, boolean isBinary, int newW, byte[] data, int oldSize, int origLineLength, byte[] newData, int y2, int x2) {
        int wCount = EightBitDownSampler.getwCount(imageData, sampling, x2);
        int hCount = EightBitDownSampler.gethCount(imageData, sampling, y2);
        for (int jj = 0; jj < comp; ++jj) {
            int count = 0;
            int[] indexAv = new int[indexCount];
            for (int yy = 0; yy < hCount; ++yy) {
                for (int xx = 0; xx < wCount; ++xx) {
                    int ptr = (yy + y2 * sampling) * origLineLength + (x2 * sampling * comp + xx * comp + jj);
                    if (ptr >= oldSize) continue;
                    isBinary = EightBitDownSampler.scanValues(index, indexCount, isBinary, (data[ptr] & 0xFF) * indexCount, indexAv);
                    ++count;
                }
            }
            int newPtr = jj + x2 * indexCount + newW * y2 * indexCount;
            for (int aa2 = 0; aa2 < indexCount; ++aa2) {
                newData[newPtr + aa2] = (byte)(indexAv[aa2] / count);
            }
        }
        return isBinary;
    }

    private static boolean scanValues(byte[] index, int indexCount, boolean isBinary, int i2, int[] indexAv) {
        int aa2 = 0;
        while (aa2 < indexCount) {
            int byteValue = index[i2 + aa2] & 0xFF;
            isBinary = isBinary && (byteValue == 0 || byteValue == 255);
            int n2 = aa2++;
            indexAv[n2] = indexAv[n2] + byteValue;
        }
        return isBinary;
    }
}

