/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.Matrix;

public final class XForm {
    private static final float[] matches = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};

    private XForm() {
    }

    private static boolean hasEmptySMask(GraphicsState gs) {
        return gs.SMask != null && gs.SMask.getGeneralType(489767774) == 507461173;
    }

    public static PdfObject getSMask(GraphicsState gs, PdfObjectReader currentPdfFile) {
        PdfObject newSMask = null;
        if (XForm.hasEmptySMask(gs)) {
            return null;
        }
        if (gs.SMask != null) {
            newSMask = gs.SMask.getDictionary(23);
            currentPdfFile.checkResolved(newSMask);
        }
        return newSMask;
    }

    public static boolean isIdentity(float[] matrix) {
        if (matrix == null) {
            return true;
        }
        for (int ii = 0; ii < 6; ++ii) {
            if (matrix[ii] == matches[ii]) continue;
            return false;
        }
        return true;
    }

    public static Area setClip(Shape defaultClip, float[] BBox, GraphicsState gs, DynamicVectorRenderer current) {
        float maxY;
        float minY;
        float maxX;
        float minX;
        if (BBox[0] < BBox[2]) {
            minX = (float)Math.floor(BBox[0]);
            maxX = (float)Math.ceil(BBox[2]);
        } else {
            minX = (float)Math.floor(BBox[2]);
            maxX = (float)Math.ceil(BBox[0]);
        }
        if (BBox[1] < BBox[3]) {
            minY = (float)Math.floor(BBox[1]);
            maxY = (float)Math.ceil(BBox[3]);
        } else {
            minY = (float)Math.floor(BBox[3]);
            maxY = (float)Math.ceil(BBox[1]);
        }
        float[] p1 = Matrix.transformPoint(gs.CTM, minX, minY);
        float[] p2 = Matrix.transformPoint(gs.CTM, maxX, minY);
        float[] p3 = Matrix.transformPoint(gs.CTM, maxX, maxY);
        float[] p4 = Matrix.transformPoint(gs.CTM, minX, maxY);
        GeneralPath gp = new GeneralPath();
        gp.moveTo(p1[0], p1[1]);
        gp.lineTo(p2[0], p2[1]);
        gp.lineTo(p3[0], p3[1]);
        gp.lineTo(p4[0], p4[1]);
        gp.closePath();
        Area clip = gs.getClippingShape() == null ? null : (Area)gs.getClippingShape().clone();
        gs.updateClip(new Area(gp));
        current.drawClip(gs, defaultClip, false);
        return clip;
    }
}

