/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.jpedal.color.ColorspaceFactory;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.PdfObjectCache;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.ImageDisplay;
import org.jpedal.utils.LogWriter;

public final class PDFObjectToImage {
    private PDFObjectToImage() {
    }

    public static BufferedImage getImageFromPdfObject(PdfObject newSMask, int x1, int x2, int y1, int y2, PdfObjectReader currentPdfFile, ParserOptions parserOptions, PdfObjectCache cache, int formLevel, float multiplyer, boolean useTransparency, float scaling) {
        BufferedImage smaskImage;
        int h2;
        int w2;
        PdfObject SMaskResources;
        if (x1 < 0 || y1 < 0) {
            throw new RuntimeException("Negative values should not be used");
        }
        byte[] objectData = currentPdfFile.readStream(newSMask, true, true, false, false, false, newSMask.getCacheName(currentPdfFile.getObjectReader()));
        ObjectStore localStore = currentPdfFile.getObjectStore();
        ImageDisplay glyphDisplay = new ImageDisplay(0, false, 20, localStore);
        PdfStreamDecoder glyphDecoder = new PdfStreamDecoder(currentPdfFile);
        glyphDecoder.setParameters(parserOptions.isPageContent(), parserOptions.isRenderPage(), parserOptions.getRenderMode(), parserOptions.getExtractionMode(), false);
        glyphDecoder.setObjectValue(-8, localStore);
        glyphDecoder.setRenderer(glyphDisplay);
        glyphDecoder.setMultiplyer(multiplyer);
        glyphDecoder.setFormLevel(formLevel);
        if (cache != null) {
            glyphDecoder.getObjectCache().reset(cache);
        }
        if ((SMaskResources = newSMask.getDictionary(2004251818)) != null) {
            glyphDecoder.readResources(SMaskResources, false);
        }
        if ((w2 = x2 - x1) < 0) {
            w2 = -w2;
            x1 -= w2;
        }
        if (w2 == 0) {
            w2 = 1;
        }
        if ((h2 = y2 - y1) < 0) {
            h2 = -h2;
            y1 -= h2;
        }
        if (h2 == 0) {
            h2 = 1;
        }
        try {
            PdfObject group;
            float maxWidth = 2000.0f * scaling;
            float maxHeight = 2000.0f * scaling;
            while ((float)w2 * scaling > maxWidth && (float)h2 * scaling > maxHeight) {
                scaling /= 2.0f;
            }
            smaskImage = new BufferedImage((int)((float)w2 * scaling), (int)((float)h2 * scaling), 2);
            Graphics2D formG2 = smaskImage.createGraphics();
            formG2.scale(scaling, scaling);
            formG2.translate(-x1, -y1);
            glyphDisplay.setG2(formG2);
            if (useTransparency && (group = newSMask.getDictionary(1111442775)) != null) {
                currentPdfFile.checkResolved(group);
                if ("Transparency".equals(group.getName(35)) && group.getBoolean(27)) {
                    formG2.setComposite(AlphaComposite.getInstance(3));
                }
            }
        }
        catch (Error err) {
            LogWriter.writeLog("Exception: " + err.getMessage());
            smaskImage = null;
        }
        if (objectData != null) {
            glyphDecoder.decodeStreamIntoObjects(objectData, false, false);
        }
        glyphDecoder.dispose();
        return smaskImage;
    }

    public static BufferedImage getImageFromFloatCoordinates(PdfObject newSMask, float x1, float x2, float y1, float y2, PdfObjectReader currentPdfFile, ParserOptions parserOptions, int formLevel, float multiplyer, boolean useTransparency, float scaling) {
        BufferedImage smaskImage;
        float h2;
        float w2;
        byte[] objectData = currentPdfFile.readStream(newSMask, true, true, false, false, false, newSMask.getCacheName(currentPdfFile.getObjectReader()));
        ObjectStore localStore = currentPdfFile.getObjectStore();
        ImageDisplay glyphDisplay = new ImageDisplay(0, false, 20, localStore);
        PdfStreamDecoder glyphDecoder = new PdfStreamDecoder(currentPdfFile);
        glyphDecoder.setParameters(parserOptions.isPageContent(), parserOptions.isRenderPage(), parserOptions.getRenderMode(), parserOptions.getExtractionMode(), false);
        glyphDecoder.setObjectValue(-8, localStore);
        glyphDecoder.setRenderer(glyphDisplay);
        glyphDecoder.setMultiplyer(multiplyer);
        glyphDecoder.setFormLevel(formLevel);
        PdfObject SMaskResources = newSMask.getDictionary(2004251818);
        if (SMaskResources != null) {
            glyphDecoder.readResources(SMaskResources, false);
        }
        if ((w2 = x2 - x1) < 0.0f) {
            w2 = -w2;
        }
        if (w2 == 0.0f) {
            w2 = 1.0f;
        }
        if ((h2 = y2 - y1) < 0.0f) {
            h2 = -h2;
        }
        if (h2 == 0.0f) {
            h2 = 1.0f;
        }
        try {
            PdfObject group;
            float maxWidth = 3000.0f * scaling;
            float maxHeight = 3000.0f * scaling;
            while (w2 * scaling > maxWidth && h2 * scaling > maxHeight) {
                scaling /= 2.0f;
            }
            smaskImage = new BufferedImage(Math.round(w2 * scaling), Math.round(h2 * scaling), 2);
            Graphics2D formG2 = smaskImage.createGraphics();
            formG2.scale(scaling, scaling);
            formG2.translate(-x1, -y1);
            glyphDisplay.setG2(formG2);
            if (useTransparency && (group = newSMask.getDictionary(1111442775)) != null) {
                currentPdfFile.checkResolved(group);
                String Tname = group.getName(35);
                PdfArrayIterator ColorSpace2 = group.getMixedArray(2087749783);
                if (ColorSpace2 != null && ColorSpace2.getTokenCount() > 0) {
                    GenericColorSpace newColorSpace = ColorspaceFactory.getColorSpaceInstance(currentPdfFile, ColorSpace2);
                    if ((group.getBoolean(25) || group.getBoolean(27) || newColorSpace == null || newColorSpace.getID() != 1498837125) && "Transparency".equals(Tname) && (newColorSpace != null ? newColorSpace.getID() : 0) != 1785221209) {
                        formG2.setComposite(AlphaComposite.getInstance(3, 0.5f));
                    }
                }
            }
        }
        catch (Error err) {
            LogWriter.writeLog("Exception: " + err.getMessage());
            smaskImage = null;
        }
        if (objectData != null) {
            glyphDecoder.decodeStreamIntoObjects(objectData, false, false);
        }
        glyphDecoder.dispose();
        return smaskImage;
    }
}

