/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.parser.image.data.ImageData;
import org.jpedal.utils.LogWriter;

final class IndexedImage {
    private IndexedImage() {
    }

    public static BufferedImage make(GenericColorSpace decodeColorData, ImageData imageData) {
        int w2 = imageData.getWidth();
        int h2 = imageData.getHeight();
        int d2 = imageData.getDepth();
        byte[] data = imageData.getObjectData();
        byte[] index = decodeColorData.getIndexedMap();
        BufferedImage image = null;
        LogWriter.writeLog("Indexed " + w2 + ' ' + h2);
        if (!decodeColorData.isIndexConverted()) {
            index = decodeColorData.convertIndexToRGB(index);
        }
        if (d2 == 8 && decodeColorData.getIndexSize() == 0 && decodeColorData.getID() == 1785221209 && decodeColorData.getRawColorSpacePDFType() != 1247168582) {
            boolean hasPixels = false;
            for (byte b2 : index) {
                if (b2 == 0) continue;
                hasPixels = true;
                break;
            }
            if (!hasPixels) {
                for (byte datum : data) {
                    if (datum == 0) continue;
                    hasPixels = true;
                    break;
                }
            }
            if (!hasPixels) {
                return new BufferedImage(1, 1, 2);
            }
        }
        try {
            if (d2 == 1 && index.length == 6 && index[0] == index[3] && index[1] == index[4] && index[2] == index[5]) {
                imageData.setRemoved(true);
            } else if (d2 == 8 && w2 == 1 && h2 == 1 && index[0] == -1 && index[1] == -1 && index[2] == -1 && IndexedImage.allBytesZero(data)) {
                image = new BufferedImage(1, 1, 1);
                image.createGraphics().setPaint(Color.CYAN);
                Raster raster = ColorSpaceConvertor.createInterleavedRaster(new byte[]{-1, -1, -1}, 1, 1);
                image.setData(raster);
            } else {
                image = ColorSpaceConvertor.convertIndexedToFlat(d2, w2, h2, data, index, false, false);
            }
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
        return image;
    }

    private static boolean allBytesZero(byte[] data) {
        for (byte bytes : data) {
            if (bytes == 0) continue;
            return false;
        }
        return true;
    }
}

