/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.GraphicsState;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.image.BinaryImage;
import org.jpedal.parser.image.ImageCommands;
import org.jpedal.parser.image.ImageDecoder;
import org.jpedal.parser.image.IndexedImage;
import org.jpedal.parser.image.data.ImageData;
import org.jpedal.parser.image.mask.MaskDecoder;
import org.jpedal.parser.image.utils.ConvertImageToShape;
import org.jpedal.parser.image.utils.ConvertMaskToShape;
import org.jpedal.render.DynamicVectorRenderer;

public final class ImageDataToJavaImage {
    private ImageDataToJavaImage() {
    }

    public static BufferedImage makeImage(GenericColorSpace decodeColorData, ImageData imageData) {
        BufferedImage image;
        int comp = imageData.getCompCount();
        int w2 = imageData.getWidth();
        int h2 = imageData.getHeight();
        int d2 = imageData.getDepth();
        byte[] data = imageData.getObjectData();
        int ID2 = decodeColorData.getID();
        boolean isConverted = imageData.isConvertedToARGB() || ID2 == 1785221209 && comp == 4;
        byte[] index = decodeColorData.getIndexedMap();
        if (isConverted) {
            DataBufferByte db = new DataBufferByte(data, data.length);
            int[] bands = new int[]{0, 1, 2, 3};
            image = new BufferedImage(w2, h2, 2);
            WritableRaster raster = Raster.createInterleavedRaster(db, w2, h2, w2 * 4, 4, bands, null);
            image.setData(raster);
        } else if (index != null) {
            image = IndexedImage.make(decodeColorData, imageData);
        } else if (d2 == 1) {
            image = BinaryImage.make(w2, h2, data, decodeColorData, 1);
        } else {
            if (d2 != 8) {
                data = ColorSpaceConvertor.normaliseTo8Bit(comp, d2, w2, h2, data);
            }
            image = decodeColorData.dataToRGB(data, w2, h2, imageData.getRenderingIntent());
        }
        return image;
    }

    public static BufferedImage makeMaskImage(ParserOptions parserOptions, GraphicsState gs, DynamicVectorRenderer current, ImageData imageData, GenericColorSpace decodeColorData, byte[] maskCol) {
        int w2 = imageData.getWidth();
        int h2 = imageData.getHeight();
        int d2 = imageData.getDepth();
        byte[] data = imageData.getObjectData();
        BufferedImage image = null;
        float ratio = (float)h2 / (float)w2;
        if (w2 == 1 && h2 == 1 && imageData.hasDecodeArrayInverted() && imageData.getImageSource() == 6420) {
            image = MaskDecoder.createMaskImage(parserOptions.isPrinting() && !ImageDecoder.allowPrintTransparency, data, 1, 1, imageData, d2, decodeColorData, maskCol);
        } else if (w2 == 1 && h2 == 1 && data[0] != -128) {
            ConvertMaskToShape.convert(gs, current, parserOptions);
            imageData.setRemoved(true);
        } else if (h2 == 2 && d2 == 1 && ImageCommands.isRepeatingLine(data, h2)) {
            ConvertImageToShape.convert(data, 2, gs, current, parserOptions);
            imageData.setRemoved(true);
        } else {
            image = MaskDecoder.createMaskImage(parserOptions.isPrinting() && !ImageDecoder.allowPrintTransparency, data, w2, h2, imageData, d2, decodeColorData, maskCol);
        }
        return image;
    }
}

