/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.jpedal.function.FunctionFactory;
import org.jpedal.function.PDFFunction;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.security.DecryptionFactory;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.FunctionObject;
import org.jpedal.parser.image.data.ImageData;
import org.jpedal.spotbugs.SuppressFBWarnings;

public final class ImageCommands {
    public static final int ID = 0;
    public static final int XOBJECT = 2;
    public static boolean trackImages;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_REFACTORED_TO_BE_FINAL"})
    public static boolean rejectSuperimposedImages;

    private ImageCommands() {
    }

    static byte[] getMaskColor(GraphicsState gs) {
        byte[] maskCol = new byte[4];
        int foreground = gs.nonstrokeColorSpace.getColor().getRGB();
        maskCol[0] = (byte)(foreground >> 16 & 0xFF);
        maskCol[1] = (byte)(foreground >> 8 & 0xFF);
        maskCol[2] = (byte)(foreground & 0xFF);
        return maskCol;
    }

    static boolean isRepeatingLine(byte[] lineData, int height) {
        if (lineData.length % height != 0) {
            return false;
        }
        int step = lineData.length / height;
        for (int x2 = 0; x2 < lineData.length / height - 1; ++x2) {
            for (int targetIndex = step; targetIndex < lineData.length - 1; targetIndex += step) {
                if (lineData[x2] == lineData[targetIndex]) continue;
                return false;
            }
        }
        return true;
    }

    static BufferedImage addBackgroundToMask(BufferedImage image, boolean isMask) {
        if (isMask) {
            int cw = image.getWidth();
            int ch = image.getHeight();
            BufferedImage background = new BufferedImage(cw, ch, 1);
            Graphics2D g2 = background.createGraphics();
            g2.setColor(Color.white);
            g2.fillRect(0, 0, cw, ch);
            g2.drawImage((Image)image, 0, 0, null);
            image = background;
        }
        return image;
    }

    static void applyTR(ImageData imageData, Object[] TR2, PdfObjectReader currentPdfFile) {
        try {
            PDFFunction[] functions = ImageCommands.getFunctions(TR2, currentPdfFile);
            if (functions != null) {
                int w2 = imageData.getWidth();
                int h2 = imageData.getHeight();
                byte[] data = imageData.getObjectData();
                int compCount = imageData.getCompCount();
                int ptr = 0;
                for (int y2 = 0; y2 < h2; ++y2) {
                    for (int x2 = 0; x2 < w2; ++x2) {
                        for (int a10 = 0; a10 < compCount; ++a10) {
                            float[] raw = new float[]{(float)(data[ptr] & 0xFF) / 255.0f};
                            if (functions[a10] != null) {
                                float[] processed = functions[a10].compute(raw);
                                data[ptr] = (byte)(255.0f * processed[0]);
                            }
                            ++ptr;
                        }
                    }
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace(System.out);
        }
    }

    private static PDFFunction[] getFunctions(Object[] TRvalues, PdfObjectReader currentPdfFile) {
        PDFFunction[] functions = null;
        int total = 0;
        byte[][] kidList = (byte[][])TRvalues[1];
        if (kidList != null) {
            total = kidList.length;
            functions = new PDFFunction[total];
        }
        for (int count = 0; count < total; ++count) {
            if (kidList[count] == null) continue;
            String ref = new String(kidList[count]);
            FunctionObject Function2 = new FunctionObject(ref);
            byte[] possIdent = kidList[count];
            if (possIdent != null && possIdent.length > 4 && possIdent[0] == 47 && possIdent[1] == 73 && possIdent[2] == 100 && possIdent[3] == 101) {
                Function2 = null;
            } else {
                currentPdfFile.readObject(Function2);
            }
            if (Function2 == null) continue;
            functions[count] = FunctionFactory.getFunction(Function2, currentPdfFile);
        }
        return functions;
    }

    public static void applyDecodeArray(byte[] data, int d2, float[] decodeArray, int type, boolean isIndexed) {
        int maxValue = 0;
        int maxCompValue = (int)Math.pow(2.0, d2) - 1;
        for (float aDecodeArray : decodeArray) {
            if (!((float)maxValue < aDecodeArray)) continue;
            maxValue = (int)aDecodeArray;
        }
        boolean isIdentify = true;
        boolean isInverse = true;
        int compCount = decodeArray.length;
        for (int comp = 0; comp < compCount && isIdentify; comp += 2) {
            isIdentify = decodeArray[comp] == 0.0f && decodeArray[comp + 1] == (float)maxCompValue;
            isInverse = decodeArray[comp + 1] == 0.0f && decodeArray[comp] == (float)maxCompValue;
        }
        if (isIdentify) {
            return;
        }
        if (isInverse) {
            ImageCommands.invertBitsInByteArray(data, d2 == 8 && type == 1785221209 && !isIndexed);
            return;
        }
        if (d2 == 1 && decodeArray[0] > decodeArray[1]) {
            ImageCommands.invertBitsInByteArray(data, false);
        } else if (d2 == 8 && maxValue == 1 && type == 1498837125) {
            ImageCommands.capCMYKDataToDecodeArrayBounds(data, decodeArray);
        } else if (d2 == 8 && maxValue > 1) {
            ImageCommands.capByteValuesToDecodeArrayBounds(data, decodeArray, type == 1785221209);
        } else {
            ImageCommands.capBitValuesToDecodeArrayBounds(data, decodeArray, type == 1785221209);
        }
    }

    private static void invertBitsInByteArray(byte[] data, boolean isRGB) {
        int byteCount = data.length;
        for (int ii = 0; ii < byteCount; ++ii) {
            if (isRGB && (ii & 3) == 3) continue;
            data[ii] = ~data[ii];
        }
    }

    private static void capBitValuesToDecodeArrayBounds(byte[] data, float[] decodeArray, boolean isRGB) {
        int count = decodeArray.length;
        int maxValue = 255;
        int[] tempDecode = new int[decodeArray.length];
        for (int i2 = 0; i2 < decodeArray.length; ++i2) {
            tempDecode[i2] = (int)(decodeArray[i2] * 255.0f);
        }
        int dd = 0;
        int minIndex = 0;
        int maxIndex = 1;
        for (int ii = 0; ii < data.length; ++ii) {
            if (isRGB && (ii & 3) == 3) continue;
            int current = data[ii] & 0xFF;
            if ((current = current * ((tempDecode[maxIndex] - tempDecode[minIndex]) / 255) + tempDecode[dd]) > 255) {
                current = 255;
            }
            if (current < 0) {
                current = 0;
            }
            if ((dd += 2) == count) {
                dd = 0;
                minIndex = 0;
                maxIndex = 1;
            } else {
                minIndex += 2;
                maxIndex += 2;
            }
            data[ii] = (byte)current;
        }
    }

    private static void capByteValuesToDecodeArrayBounds(byte[] data, float[] decodeArray, boolean isRGB) {
        int j2 = 0;
        for (int ii = 0; ii < data.length; ++ii) {
            if (isRGB && (ii & 3) == 3) continue;
            int currentByte = data[ii] & 0xFF;
            if ((float)currentByte < decodeArray[j2]) {
                currentByte = (int)decodeArray[j2];
            } else if ((float)currentByte > decodeArray[j2 + 1]) {
                currentByte = (int)decodeArray[j2 + 1];
            }
            if ((j2 += 2) == decodeArray.length) {
                j2 = 0;
            }
            data[ii] = (byte)currentByte;
        }
    }

    private static void capCMYKDataToDecodeArrayBounds(byte[] data, float[] decodeArray) {
        int[] tempDecode = new int[decodeArray.length];
        for (int i2 = 0; i2 < decodeArray.length; ++i2) {
            tempDecode[i2] = (int)(decodeArray[i2] * 255.0f);
        }
        int j2 = 0;
        for (int ii = 0; ii < data.length; ++ii) {
            int pp = data[ii] & 0xFF;
            pp = pp * (tempDecode[j2 + 1] - tempDecode[j2]) / 255 + tempDecode[j2];
            if ((j2 += 2) == decodeArray.length) {
                j2 = 0;
            }
            data[ii] = (byte)pp;
        }
    }

    static boolean isExtractionAllowed(PdfObjectReader currentPdfFile) {
        PdfFileReader objectReader = currentPdfFile.getObjectReader();
        DecryptionFactory decryption = objectReader.getDecryptionObject();
        return decryption == null || decryption.getBooleanValue(103);
    }

    static {
        String imgSetting;
        rejectSuperimposedImages = true;
        String operlapValue = System.getProperty("org.jpedal.rejectsuperimposedimages");
        if (operlapValue != null) {
            rejectSuperimposedImages = operlapValue.toLowerCase().contains("true");
        }
        if ((imgSetting = System.getProperty("org.jpedal.trackImages")) != null) {
            trackImages = imgSetting.toLowerCase().contains("true");
        }
    }
}

