/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.color;

import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.objects.GraphicsState;
import org.jpedal.parser.CommandParser;
import org.jpedal.parser.PdfObjectCache;

public final class K {
    private K() {
    }

    public static void execute(boolean isLowerCase, GraphicsState gs, CommandParser parser, PdfObjectCache cache) {
        boolean isStroke = !isLowerCase;
        float[] operand = parser.getValuesAsFloat();
        int operandCount = operand.length;
        if (operandCount > 3) {
            boolean isNormalised = true;
            float[] tempValues = new float[operandCount];
            for (int ii = 0; ii < operandCount; ++ii) {
                float op;
                tempValues[operandCount - ii - 1] = op = operand[ii];
                isNormalised = isNormalised && op <= 1.0f;
            }
            operand = isNormalised ? tempValues : K.normalise(tempValues);
            if (isStroke) {
                if (gs.strokeColorSpace.getID() != 1498837125) {
                    gs.strokeColorSpace = new DeviceCMYKColorSpace();
                }
                gs.strokeColorSpace.setColor(operand);
                cache.put(1, gs.strokeColorSpace.getID(), (Object)"x");
            } else {
                if (gs.nonstrokeColorSpace.getID() != 1498837125) {
                    gs.nonstrokeColorSpace = new DeviceCMYKColorSpace();
                }
                for (int i2 = 0; i2 < operand.length; ++i2) {
                    if (operand[i2] != 32767.0f) continue;
                    operand[i2] = 1.0f;
                }
                gs.nonstrokeColorSpace.setColor(operand);
                cache.put(1, gs.nonstrokeColorSpace.getID(), (Object)"x");
            }
        }
    }

    private static float[] normalise(float[] operand) {
        int i2 = 0;
        while (i2 != operand.length) {
            int n2 = i2++;
            operand[n2] = operand[n2] / 255.0f;
        }
        return operand;
    }
}

