/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.color;

import org.jpedal.color.ColorspaceFactory;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.parser.PdfObjectCache;

public final class CS {
    private CS() {
    }

    public static void execute(boolean isLowerCase, String colorspaceObject, GraphicsState gs, PdfObjectCache cache, PdfObjectReader currentPdfFile) {
        Object rawDict;
        PdfArrayIterator array;
        boolean isStroke = !isLowerCase;
        GenericColorSpace newColorSpace = (GenericColorSpace)cache.get(3, colorspaceObject + "_Stroke_" + !isLowerCase);
        if (newColorSpace == null && (newColorSpace = ColorspaceFactory.getColorSpaceInstance(currentPdfFile, array = ColorspaceFactory.convertColValueToMixedArray(currentPdfFile, (byte[])(rawDict = cache.get(2, colorspaceObject))))).getID() != 1146450818) {
            cache.put(3, colorspaceObject + "_Stroke_" + !isLowerCase, (Object)newColorSpace);
        }
        if (newColorSpace.getID() == 1146450818) {
            newColorSpace.setPattern(cache.getPatterns());
            newColorSpace.setGS(gs);
        } else {
            CS.setDefaultColor(newColorSpace);
        }
        cache.put(1, newColorSpace.getID(), (Object)"x");
        if (isStroke) {
            gs.strokeColorSpace = newColorSpace;
        } else {
            gs.nonstrokeColorSpace = newColorSpace;
        }
    }

    private static void setDefaultColor(GenericColorSpace newColorSpace) {
        if (newColorSpace.getIndexedMap() != null) {
            newColorSpace.setColor(new float[]{0.0f});
        } else {
            switch (newColorSpace.getID()) {
                case 319951691: 
                case 1008872003: 
                case 1785221209: {
                    newColorSpace.setColor(new float[]{0.0f, 0.0f, 0.0f});
                    break;
                }
                case 391471749: 
                case 1568372915: {
                    newColorSpace.setColor(new float[]{0.0f});
                    break;
                }
                case 1847602: 
                case 689115931: 
                case 1247168582: {
                    int iccComps = newColorSpace.getColorComponentCount();
                    float[] iccValues = new float[iccComps];
                    for (int i2 = 0; i2 < iccComps; ++i2) {
                        iccValues[i2] = Math.max(newColorSpace.getColorSpace().getMinValue(i2), 0.0f);
                    }
                    newColorSpace.setColor(iccValues);
                    break;
                }
                case 1498837125: {
                    newColorSpace.setColor(new float[]{0.0f, 0.0f, 0.0f, 1.0f});
                    break;
                }
                case -2073385820: 
                case 960981604: {
                    int nComps = newColorSpace.getColorComponentCount();
                    float[] nValues = new float[nComps];
                    newColorSpace.setColor(nValues);
                }
            }
        }
    }
}

