/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.CommandParser;
import org.jpedal.parser.PdfObjectCache;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.image.ImageCommands;
import org.jpedal.parser.image.XForm;
import org.jpedal.parser.image.mask.MaskUtils;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;

final class XFormDecoder {
    private XFormDecoder() {
    }

    static void processXForm(PdfStreamDecoder pdfStreamDecoder, PdfObject XObject2, CommandParser parser) {
        String oldFormName = pdfStreamDecoder.formName;
        String name = parser.generateOpAsString(0, true);
        pdfStreamDecoder.graphicsStates.pushGraphicsState(pdfStreamDecoder.gs, pdfStreamDecoder.current);
        if (!pdfStreamDecoder.isHTML) {
            pdfStreamDecoder.gs.setGroupAlpha(pdfStreamDecoder.gs.getAlpha(2));
            pdfStreamDecoder.gs.setAlpha(2, 1.0f);
            pdfStreamDecoder.gs.setAlpha(1, 1.0f);
        }
        try {
            if (ImageCommands.trackImages) {
                pdfStreamDecoder.imagesInFile = pdfStreamDecoder.imagesInFile == null ? name + " Form" : name + " Form\n" + pdfStreamDecoder.imagesInFile;
            }
            parser.reset();
            byte[] objectData = pdfStreamDecoder.currentPdfFile.readStream(XObject2, true, true, false, false, false, XObject2.getCacheName(pdfStreamDecoder.currentPdfFile.getObjectReader()));
            if (objectData != null) {
                XFormDecoder.decodeFormData(pdfStreamDecoder, XObject2, name, objectData);
            }
        }
        catch (Error e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
            pdfStreamDecoder.parserOptions.imagesProcessedFully = false;
            pdfStreamDecoder.errorTracker.addPageFailureMessage("Error " + e2 + " in DO");
        }
        pdfStreamDecoder.formName = oldFormName;
        pdfStreamDecoder.gs = pdfStreamDecoder.graphicsStates.restoreGraphicsState(pdfStreamDecoder.current);
    }

    private static void decodeFormData(PdfStreamDecoder pdfStreamDecoder, PdfObject XObject2, String name, byte[] objectData) {
        boolean isIdentity;
        String oldIndent = PdfStreamDecoder.indent;
        PdfStreamDecoder.indent = PdfStreamDecoder.indent + "   ";
        float[] transformMatrix = new float[6];
        float[] matrix = XObject2.getFloatArray(1145198201);
        boolean bl2 = isIdentity = matrix == null || XForm.isIdentity(matrix);
        if (matrix != null) {
            transformMatrix = matrix;
        }
        int currentDepth = pdfStreamDecoder.graphicsStates.getDepth();
        float[][] currentCTM = new float[3][3];
        for (int i2 = 0; i2 < 3; ++i2) {
            System.arraycopy(pdfStreamDecoder.gs.CTM[i2], 0, currentCTM[i2], 0, 3);
        }
        float[][] oldCTM = currentCTM;
        float[][] CTM = pdfStreamDecoder.gs.CTM;
        float[][] scaleF = XFormDecoder.setScaling(pdfStreamDecoder, transformMatrix, matrix, isIdentity, CTM);
        ++pdfStreamDecoder.formLevel;
        if (pdfStreamDecoder.formLevel == 1) {
            pdfStreamDecoder.formName = name;
        } else if (pdfStreamDecoder.formLevel < 20) {
            pdfStreamDecoder.formName = pdfStreamDecoder.formName + '_' + name;
        }
        int mainStrokeColorData = pdfStreamDecoder.gs.strokeColorSpace.getColor().getRGB();
        int mainnonStrokeColorData = pdfStreamDecoder.gs.nonstrokeColorSpace.getColor().getRGB();
        float maxStrokeValue = pdfStreamDecoder.gs.getAlphaMax(1);
        float maxFillValue = pdfStreamDecoder.gs.getAlphaMax(2);
        PdfObjectCache mainCache = pdfStreamDecoder.cache.copy();
        pdfStreamDecoder.cache.reset(mainCache);
        pdfStreamDecoder.cache.groupObj = XObject2.getDictionary(1111442775);
        pdfStreamDecoder.currentPdfFile.checkResolved(pdfStreamDecoder.cache.groupObj);
        XFormDecoder.decodeXForm(pdfStreamDecoder, XObject2, name, objectData);
        --pdfStreamDecoder.formLevel;
        pdfStreamDecoder.graphicsStates.correctDepth(currentDepth, pdfStreamDecoder.current);
        pdfStreamDecoder.gs.CTM = oldCTM;
        pdfStreamDecoder.gs.scaleFactor = scaleF;
        pdfStreamDecoder.gs.resetColorSpaces(mainStrokeColorData, mainnonStrokeColorData);
        pdfStreamDecoder.cache.restore(mainCache);
        pdfStreamDecoder.gs.setMaxAlpha(1, maxStrokeValue);
        pdfStreamDecoder.gs.setMaxAlpha(2, maxFillValue);
        PdfStreamDecoder.indent = oldIndent;
    }

    private static void decodeXForm(PdfStreamDecoder pdfStreamDecoder, PdfObject XObject2, String name, byte[] objectData) {
        PdfObject Resources = XObject2.getDictionary(2004251818);
        if (Resources != null) {
            pdfStreamDecoder.readResources(Resources, false);
        }
        float[] BBox = XObject2.getFloatArray(303185736);
        Area orginalClip = null;
        boolean clipChanged = false;
        if (BBox != null && BBox[1] < BBox[3]) {
            orginalClip = XForm.setClip(null, BBox, pdfStreamDecoder.gs, pdfStreamDecoder.current);
            clipChanged = true;
        }
        if (objectData.length > 0) {
            XFormDecoder.decode(pdfStreamDecoder, XObject2, name, objectData);
        }
        if (clipChanged) {
            pdfStreamDecoder.gs.setClippingShape(orginalClip);
            pdfStreamDecoder.current.drawClip(pdfStreamDecoder.gs, orginalClip, false);
        }
    }

    private static void decode(PdfStreamDecoder pdfStreamDecoder, PdfObject XObject2, String name, byte[] objectData) {
        boolean needsRasterizing;
        PdfObject newSMask = XForm.getSMask(pdfStreamDecoder.gs, pdfStreamDecoder.currentPdfFile);
        int blendMode = pdfStreamDecoder.gs.getBMValue();
        if ((pdfStreamDecoder.parserOptions.getExtractionMode() & 0x400) == 1024) {
            XFormDecoder.processXFormAsImage(XObject2, pdfStreamDecoder);
        }
        boolean isSvg = pdfStreamDecoder.current.getBooleanValue(46);
        boolean bl2 = needsRasterizing = !pdfStreamDecoder.parserOptions.isClippedImagesExtracted() && (newSMask != null || blendMode != 1111314299 && !isSvg);
        if (needsRasterizing && !XFormDecoder.isSmallForMasking(XObject2)) {
            XFormDecoder.processXFormWithMaskOrBlend(newSMask, pdfStreamDecoder, blendMode, XObject2, name);
            if (pdfStreamDecoder.isHTML) {
                int TR2 = pdfStreamDecoder.gs.getTextRenderType();
                pdfStreamDecoder.gs.setTextRenderType(4);
                pdfStreamDecoder.lockTR = true;
                pdfStreamDecoder.decodeStreamIntoObjects(objectData, false, true);
                pdfStreamDecoder.lockTR = false;
                pdfStreamDecoder.gs.setTextRenderType(TR2);
            }
        } else {
            int BM = pdfStreamDecoder.gs.getBMValue();
            float groupAlpha = pdfStreamDecoder.gs.getGroupAlpha();
            float fillAlpha = pdfStreamDecoder.gs.getAlpha(2);
            float strokeAlpha = pdfStreamDecoder.gs.getAlpha(1);
            float maxFillAlpha = pdfStreamDecoder.gs.getAlphaMax(2);
            float maxStrokeAlpha = pdfStreamDecoder.gs.getAlphaMax(1);
            if (isSvg) {
                pdfStreamDecoder.current.startXForm(pdfStreamDecoder.gs);
                pdfStreamDecoder.gs.setMaxAlpha(2, 1.0f);
                pdfStreamDecoder.gs.setMaxAlpha(1, 1.0f);
                pdfStreamDecoder.gs.setAlpha(2, 1.0f);
                pdfStreamDecoder.gs.setAlpha(1, 1.0f);
                pdfStreamDecoder.gs.setBMValue(1111314299);
            } else {
                pdfStreamDecoder.gs.setGroupAlpha(fillAlpha);
            }
            pdfStreamDecoder.decodeStreamIntoObjects(objectData, false, false);
            if (isSvg) {
                pdfStreamDecoder.gs.setAlpha(2, fillAlpha);
                pdfStreamDecoder.gs.setAlpha(1, strokeAlpha);
                pdfStreamDecoder.gs.setMaxAlpha(2, maxFillAlpha);
                pdfStreamDecoder.gs.setMaxAlpha(1, maxStrokeAlpha);
                pdfStreamDecoder.gs.setBMValue(BM);
                pdfStreamDecoder.current.endXForm(pdfStreamDecoder.gs);
            } else {
                pdfStreamDecoder.gs.setGroupAlpha(groupAlpha);
            }
            pdfStreamDecoder.current.setGraphicsState(1, pdfStreamDecoder.gs.getAlpha(1), BM);
            pdfStreamDecoder.current.setGraphicsState(2, pdfStreamDecoder.gs.getAlpha(2), BM);
        }
    }

    private static boolean isSmallForMasking(PdfObject XObject2) {
        float[] BBox = XObject2.getFloatArray(303185736);
        float[] matrix = XObject2.getFloatArray(1145198201);
        if (matrix != null) {
            BBox = Matrix.transformBBOX(BBox, matrix);
        }
        float xMin = Math.min(BBox[0], BBox[2]);
        float xMax = Math.max(BBox[0], BBox[2]);
        float yMin = Math.min(BBox[1], BBox[3]);
        float yMax = Math.max(BBox[1], BBox[3]);
        return xMax - xMin < 2.0f || yMax - yMin < 2.0f;
    }

    private static float[][] setScaling(PdfStreamDecoder pdfStreamDecoder, float[] transformMatrix, float[] matrix, boolean isIdentity, float[][] CTM) {
        float lineWidthInForm = -1.0f;
        Object scaleF = pdfStreamDecoder.gs.scaleFactor;
        if (matrix != null && !isIdentity) {
            float[][] scaleFactor = new float[][]{{transformMatrix[0], transformMatrix[1], 0.0f}, {transformMatrix[2], transformMatrix[3], 0.0f}, {transformMatrix[4], transformMatrix[5], 1.0f}};
            scaleF = scaleFactor;
            pdfStreamDecoder.gs.CTM = Matrix.multiply(scaleFactor, CTM);
            lineWidthInForm = transformMatrix[0] * pdfStreamDecoder.gs.getLineWidth();
            if (lineWidthInForm == 0.0f) {
                lineWidthInForm = transformMatrix[1] * pdfStreamDecoder.gs.getLineWidth();
            }
            if (lineWidthInForm < 0.0f) {
                lineWidthInForm = -lineWidthInForm;
            }
        }
        if (lineWidthInForm > 0.0f) {
            pdfStreamDecoder.gs.setLineWidth(lineWidthInForm);
        }
        return scaleF;
    }

    private static void processXFormWithMaskOrBlend(PdfObject newSMask, PdfStreamDecoder pdfStreamDecoder, int blendMode, PdfObject XObject2, String name) {
        boolean useTransparancy = newSMask != null || blendMode != 1111314299 || pdfStreamDecoder.gs.getAlpha(2) == 1.0f;
        MaskUtils.createMaskForm(XObject2, name, newSMask, pdfStreamDecoder.gs, pdfStreamDecoder.current, pdfStreamDecoder.currentPdfFile, pdfStreamDecoder.parserOptions, pdfStreamDecoder.formLevel, pdfStreamDecoder.multiplyer, pdfStreamDecoder.cache, useTransparancy, blendMode);
        ++pdfStreamDecoder.imageCount;
    }

    private static void processXFormAsImage(PdfObject XObject2, PdfStreamDecoder pdfStreamDecoder) {
        float[] BBox = XObject2.getFloatArray(303185736);
        int fy = (int)BBox[1];
        int fw = (int)BBox[2];
        int fh = (int)BBox[3];
        BufferedImage currentImage = MaskUtils.createTransparentForm(XObject2, fy, fw, fh, pdfStreamDecoder.currentPdfFile, pdfStreamDecoder.formLevel, pdfStreamDecoder.multiplyer);
        String imgName = 'R' + pdfStreamDecoder.formName;
        pdfStreamDecoder.pdfImages.setImageInfo(imgName, pdfStreamDecoder.parserOptions.getPageNumber(), pdfStreamDecoder.gs.CTM[2][0], pdfStreamDecoder.gs.CTM[2][1], fw, fh);
        pdfStreamDecoder.objectStoreStreamRef.saveStoredImageAsBytes('R' + imgName, currentImage, false);
        pdfStreamDecoder.objectStoreStreamRef.saveStoredImageAsBytes(imgName, currentImage, false);
    }
}

