/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.util.HashMap;
import java.util.Map;
import javax.print.attribute.SetOfIntegerSyntax;
import org.jpedal.PdfDecoderInt;
import org.jpedal.color.ColorSpaces;
import org.jpedal.display.DisplayOffsets;
import org.jpedal.display.Overlays;
import org.jpedal.exception.PdfException;
import org.jpedal.external.CustomFormPrint;
import org.jpedal.external.CustomPrintHintingHandler;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.gui.UIViewerInt;
import org.jpedal.gui.ViewerInt;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfResources;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.PrintStreamDecoder;
import org.jpedal.render.SwingDisplay;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.PrintUtils;

public class SwingPrinter {
    private Overlays overlays;
    private int duplexGapOdd;
    private int duplexGapEven;
    private ObjectStore objectPrintStoreRef;
    private boolean centerPrintedPage;
    private boolean rotatePrintedPage;
    private boolean operationSuccessful = true;
    public ViewerInt viewer;
    public UIViewerInt uiViewer;
    private int pageScalingMode = 2;
    private String pageErrorMessages = "";
    public boolean printOnlyVisible;
    private int logicalPageOffset;
    private SwingDisplay printRender;
    public int lastPrintedPage = -1;
    public int currentPrintPage;
    public boolean isCustomPrinting;
    private final Map<Integer, PageFormat> pageFormats = new HashMap<Integer, PageFormat>(100);
    private final Map<Integer, String> pageFormatsAlign = new HashMap<Integer, String>(100);
    private int[] listOfPages;
    public boolean allowDifferentPrintPageSizes;
    private int start;
    private int end = -1;
    private boolean oddPagesOnly;
    private boolean evenPagesOnly;
    private SetOfIntegerSyntax range;
    private boolean pagesPrintedInReverse;
    private boolean stopPrinting;
    public boolean usePDFPaperSize;
    public PrintStreamDecoder currentPrintDecoder;
    public boolean legacyPrintMode = true;
    private float scaling;
    private int insetW;
    private int insetH;

    public int getNumberOfPages(int pageCount) {
        if (this.range != null) {
            int rangeCount = 0;
            for (int ii = 1; ii < pageCount + 1; ++ii) {
                if (!this.range.contains(ii) || this.oddPagesOnly && (ii & 1) != 1 || this.evenPagesOnly && (ii & 1) != 0) continue;
                ++rangeCount;
            }
            return rangeCount;
        }
        int count = 1;
        if (this.end != -1 && (count = this.end - this.start + 1) < 0) {
            count = 2 - count;
        }
        if (this.oddPagesOnly || this.evenPagesOnly) {
            return (count + 1) / 2;
        }
        return count;
    }

    public PageFormat getPageFormat(int p2, PdfPageData pageData, int pageCount) throws IndexOutOfBoundsException {
        int actualPage;
        PageFormat returnValue;
        if (this.listOfPages != null && p2 < this.listOfPages.length) {
            p2 = this.listOfPages[p2];
        }
        if ((returnValue = this.pageFormats.get(actualPage = this.end == -1 ? p2 + 1 : (this.end > this.start ? this.start + p2 : this.start - p2))) == null) {
            returnValue = this.pageFormats.get(-1);
        }
        PageFormat pf = null;
        this.pageFormatsAlign.put(actualPage, "normal");
        if (this.usePDFPaperSize) {
            int crw = pageData.getCropBoxWidth(actualPage);
            int crh = pageData.getCropBoxHeight(actualPage);
            int rotation = pageData.getRotation(actualPage);
            if (this.allowDifferentPrintPageSizes) {
                int tmp;
                if (rotation == 90 || rotation == 270) {
                    tmp = crw;
                    crw = crh;
                    crh = tmp;
                }
                if (crw > crh) {
                    tmp = crw;
                    crw = crh;
                    crh = tmp;
                    if (rotation == 90) {
                        this.pageFormatsAlign.put(actualPage, "inverted");
                    }
                }
            }
            pf = new PageFormat();
            this.createCustomPaper(pf, crw, crh, pageCount, pageData);
        } else if (returnValue != null) {
            pf = returnValue;
        }
        return pf;
    }

    private void createCustomPaper(PageFormat pf, int clipW, int clipH, int pageCount, PdfPageData pageData) {
        Paper customPaper = new Paper();
        if (pageCount == 1 || this.allowDifferentPrintPageSizes) {
            customPaper.setSize(clipW, clipH);
        } else {
            int paperClipW = 0;
            int paperClipH = 0;
            for (int t2 = this.start; t2 <= this.end; ++t2) {
                if (clipW > pageData.getMediaBoxWidth(t2) + 1 || clipH > pageData.getMediaBoxHeight(t2) + 1) continue;
                paperClipW = pageData.getMediaBoxWidth(t2) + 1;
                paperClipH = pageData.getMediaBoxHeight(t2) + 1;
            }
            customPaper.setSize(paperClipW, paperClipH);
        }
        customPaper.setImageableArea(0.0, 0.0, clipW, clipH);
        pf.setPaper(customPaper);
    }

    public void setPagePrintRange(SetOfIntegerSyntax range, int pageCount) throws PdfException {
        this.range = range;
        this.start = range.next(0);
        int rangeCount = 0;
        for (int ii = 0; ii < pageCount; ++ii) {
            if (!range.contains(ii)) continue;
            ++rangeCount;
        }
        this.listOfPages = new int[rangeCount + 1];
        int i2 = this.start;
        this.end = this.start;
        if (range.contains(Integer.MAX_VALUE)) {
            this.end = pageCount;
        } else {
            while (range.next(i2) != -1) {
                ++i2;
            }
            this.end = i2;
        }
        if (this.start > this.end) {
            int tmp = this.start;
            this.start = this.end;
            this.end = tmp;
        }
        int j2 = 0;
        for (int ii = this.start; ii < this.end + 1; ++ii) {
            if (!range.contains(ii) || this.oddPagesOnly && (ii & 1) != 1 || this.evenPagesOnly && (ii & 1) != 0) continue;
            this.listOfPages[j2] = ii - this.start;
            ++j2;
        }
        if (this.start < 1 || this.end < 1 || this.start > pageCount || this.end > pageCount) {
            throw new PdfException("Invalid page range with " + this.start + ' ' + this.end);
        }
    }

    public void setPrintPageMode(int mode) {
        this.oddPagesOnly = (mode & 0x10) == 16;
        this.evenPagesOnly = (mode & 0x20) == 32;
        this.pagesPrintedInReverse = (mode & 0x40) == 64;
    }

    public void putPageFormat(Integer key, PageFormat value) {
        this.pageFormats.put(key, value);
    }

    public int getCurrentPrintPage() {
        return this.currentPrintPage;
    }

    public final void stopPrinting() {
        this.stopPrinting = true;
    }

    public void setPagePrintRange(int start, int end, int pageCount) throws PdfException {
        this.start = start;
        this.end = end;
        if (end == Integer.MAX_VALUE) {
            end = pageCount;
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (start < 1 || start > pageCount || end > pageCount) {
            throw new PdfException("Invalid page range with " + start + ' ' + end);
        }
    }

    public void useLogicalPrintOffset(int pagesPrinted) {
        this.logicalPageOffset = pagesPrinted;
    }

    public boolean isPageSuccessful() {
        return this.operationSuccessful;
    }

    public String getPageFailureMessage() {
        return this.pageErrorMessages;
    }

    public void setPrintPageScalingMode(int pageScalingMode) {
        this.pageScalingMode = pageScalingMode;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int page, PdfObjectReader currentPdfFile, PdfDecoderInt pdfDecoder, ExternalHandlers externalHandlers, PdfResources res, int pageNumber, DecoderOptions options) throws PrinterException {
        if (this.objectPrintStoreRef == null) {
            this.objectPrintStoreRef = currentPdfFile.getObjectStore();
        }
        PdfPageData pageData = pdfDecoder.getPdfPageData();
        AcroRenderer formRenderer = pdfDecoder.getFormRenderer();
        int pageCount = pdfDecoder.getPageCount();
        this.scaling = pdfDecoder.getScaling();
        this.insetW = pdfDecoder.getInsetW();
        this.insetH = pdfDecoder.getInsetH();
        int lastPage = this.end;
        int firstPage = this.start;
        if (this.legacyPrintMode) {
            CustomFormPrint customFormPrint = (CustomFormPrint)externalHandlers.getExternalHandler(14);
            if (customFormPrint != null) {
                formRenderer.getCompData().setCustomPrintInterface(customFormPrint);
            }
            if (!this.pagesPrintedInReverse && this.end != -1 && this.end < this.start) {
                firstPage = this.end;
                lastPage = this.start;
            }
        }
        page = this.updatePageNumber(page);
        PageObject pdfObject = null;
        PdfObject Resources = null;
        if (this.stopPrinting) {
            this.stopPrinting = false;
            return 1;
        }
        int i2 = 0;
        this.currentPrintPage = page;
        if (page > pageCount) {
            this.currentPrintPage = -1;
            return 1;
        }
        if (!this.legacyPrintMode || this.end == -1 || page >= firstPage && page <= lastPage) {
            this.operationSuccessful = true;
            this.pageErrorMessages = "";
            String currentPageOffset = currentPdfFile.getReferenceforPage(page);
            if (currentPageOffset != null || this.isCustomPrinting || formRenderer.isXFA() && formRenderer.useXFA()) {
                if (!this.isCustomPrinting && this.lastPrintedPage != page) {
                    pdfObject = new PageObject(currentPageOffset);
                    currentPdfFile.readObject(pdfObject);
                    Resources = ((PdfObject)pdfObject).getDictionary(2004251818);
                }
                if (this.lastPrintedPage != page) {
                    this.currentPrintDecoder = SwingPrinter.createPrintDecoder(formRenderer, currentPdfFile, pdfDecoder, res, this.objectPrintStoreRef, page);
                    if (!this.isCustomPrinting) {
                        res.setupResources((PdfStreamDecoder)((Object)this.currentPrintDecoder), true, Resources, pageNumber, currentPdfFile);
                    }
                }
                SwingDisplay dvr = SwingPrinter.setupDisplayForPatterns(this.currentPrintDecoder, externalHandlers, page);
                if (this.lastPrintedPage != page) {
                    if (!this.isCustomPrinting) {
                        if (pdfObject != null) {
                            this.decodePageForPrint(dvr, pdfObject, page);
                        }
                    } else {
                        this.printRender = this.getPrintDisplay(page);
                        pageData = this.viewer.getPageData();
                    }
                    this.lastPrintedPage = page;
                }
                this.renderPageForPrint(pageData, externalHandlers, pdfDecoder, graphics, pageFormat, options, page);
            }
        }
        if (!this.operationSuccessful) {
            i2 = 1;
        }
        return i2;
    }

    private static SwingDisplay setupDisplayForPatterns(PrintStreamDecoder currentPrintDecoder, ExternalHandlers externalHandlers, int page) {
        SwingDisplay dvr = (SwingDisplay)currentPrintDecoder.getObjectValue(23);
        dvr.setScaling(1.0f);
        dvr.setPrintPage(page);
        dvr.writeCustom(8, externalHandlers.getExternalHandler(19));
        return dvr;
    }

    private void renderPageForPrint(PdfPageData pageData, ExternalHandlers externalHandlers, PdfDecoderInt pdfDecoder, Graphics graphics, PageFormat pageFormat, DecoderOptions options, int page) {
        int cropX = pageData.getCropBoxX(page);
        int cropY = pageData.getCropBoxY(page);
        int cropWidth = pageData.getCropBoxWidth(page);
        int cropHeight = pageData.getCropBoxHeight(page);
        int rotation = pageData.getRotation(page);
        Rectangle cropBox = new Rectangle(cropX, cropY, cropWidth, cropHeight);
        CustomPrintHintingHandler customPrintHintingHandler = (CustomPrintHintingHandler)externalHandlers.getExternalHandler(18);
        Rectangle printAnnot = graphics.getClipBounds();
        Graphics2D g2 = (Graphics2D)graphics;
        g2.setRenderingHints(ColorSpaces.hints);
        AffineTransform transform = this.getPrintTransformation(pdfDecoder, pageFormat, page, cropBox, rotation);
        g2.transform(transform);
        if (customPrintHintingHandler != null) {
            if (this.printRender != null) {
                this.printRender.stopG2HintSetting(true);
            }
            customPrintHintingHandler.preprint(g2, pdfDecoder);
        }
        this.paintPageForPrint(g2, cropBox, printAnnot, page, pdfDecoder, customPrintHintingHandler);
        AcroRenderer formRenderer = pdfDecoder.getFormRenderer();
        if (formRenderer != null) {
            int[] formsNoPrint = DecoderOptions.getFormsNoPrint();
            int[] instance_formsNoPrint = options.getInstance_FormsNoPrint();
            this.paintPageFormsForPrint(g2, formRenderer, pageData, instance_formsNoPrint, formsNoPrint, page);
        }
        if (customPrintHintingHandler != null) {
            customPrintHintingHandler.postprint(g2, pdfDecoder);
        }
        if (!this.currentPrintDecoder.getBooleanValue(1)) {
            this.operationSuccessful = false;
            this.pageErrorMessages = this.pageErrorMessages + this.currentPrintDecoder.getErrorTracker().getPageFailureMessage();
        }
    }

    private void paintPageFormsForPrint(Graphics2D g2, AcroRenderer formRenderer, PdfPageData pageData, int[] instanceFormsNoPrint, int[] formsNoPrint, int page) {
        Rectangle cropBox = new Rectangle(pageData.getCropBoxX(page), pageData.getCropBoxY(page), pageData.getCropBoxWidth(page), pageData.getCropBoxHeight(page));
        formRenderer.createDisplayComponentsForPage(page, (PdfStreamDecoder)((Object)this.currentPrintDecoder));
        Map<Integer, String> componentsToIgnore = SwingPrinter.toMap(instanceFormsNoPrint);
        if (componentsToIgnore == null) {
            componentsToIgnore = SwingPrinter.toMap(formsNoPrint);
        }
        Shape origClip = g2.getClip();
        g2.setClip(cropBox);
        if (!formRenderer.getCompData().formsRasterizedForDisplay()) {
            formRenderer.getCompData().renderFormsOntoG2(g2, page, 0, pageData.getRotation(page), componentsToIgnore, formRenderer.getFormFactory(), pageData.getMediaBoxHeight(page));
        }
        g2.setClip(origClip);
    }

    private void paintPageForPrint(Graphics2D g2, Rectangle cropBox, Rectangle printAnnot, int page, PdfDecoderInt pdfDecoder, CustomPrintHintingHandler customPrintHintingHandler) {
        Shape origClip = g2.getClip();
        if (origClip != null) {
            Rectangle2D clip = new Rectangle(g2.getClipBounds());
            clip = ((Rectangle2D)clip).createIntersection(cropBox);
            g2.setClip(clip);
        }
        if (!this.isCustomPrinting) {
            this.currentPrintDecoder.print(g2, null, this.currentPrintPage, null, customPrintHintingHandler, pdfDecoder);
        } else if (this.printRender == null) {
            LogWriter.writeLog("No data for page " + page);
        } else {
            this.printRender.setG2(g2);
            this.printRender.paint(null, null, printAnnot);
        }
        g2.setClip(origClip);
    }

    private static PrintStreamDecoder createPrintDecoder(AcroRenderer formRenderer, PdfObjectReader currentPdfFile, PdfDecoderInt pdfDecoder, PdfResources res, ObjectStore objectPrintStoreRef, int page) {
        PrintStreamDecoder currentPrintDecoder = formRenderer.getStreamDecoderForPrinting(currentPdfFile, res.getPdfLayerList());
        currentPrintDecoder.setParameters(false, true, 15, 0, true);
        currentPrintDecoder.setIntValue(-15, pdfDecoder.getTextPrint());
        currentPrintDecoder.setObjectValue(-8, objectPrintStoreRef);
        currentPrintDecoder.setObjectValue(-18, pdfDecoder.getPdfPageData());
        currentPrintDecoder.setIntValue(-10, page);
        pdfDecoder.getExternalHandler().addHandlers((PdfStreamDecoder)((Object)currentPrintDecoder));
        return currentPrintDecoder;
    }

    private void decodePageForPrint(SwingDisplay dvr, PdfObject pdfObject, int page) throws PrinterException {
        if (pdfObject.getPageNumber() == -1) {
            pdfObject.setPageNumber(page);
        }
        try {
            this.currentPrintDecoder.decodePageContent(pdfObject);
            if (this.overlays != null) {
                this.overlays.printOverlays(dvr, page);
            }
        }
        catch (PdfException e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
            throw new PrinterException(e2.getMessage());
        }
    }

    private SwingDisplay getPrintDisplay(int page) {
        byte[] pdfBytes = ObjectStore.getCachedPageAsBytes("page" + page);
        if (pdfBytes == null) {
            this.viewer.resetPrintData();
            this.uiViewer.invokeServerMethod("sendPageToPrint", new Object[]{page});
            while (pdfBytes == null) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e2) {
                    LogWriter.writeLog("Exception: " + e2.getMessage());
                }
                pdfBytes = this.viewer.getPrintData();
            }
        }
        return new SwingDisplay(pdfBytes, this.viewer.getFontList());
    }

    private int updatePageNumber(int page) {
        if (this.legacyPrintMode) {
            page -= this.logicalPageOffset;
            if (this.range == null && (this.oddPagesOnly || this.evenPagesOnly)) {
                page *= 2;
            } else if (this.range != null) {
                page = this.listOfPages[page];
            }
            page = this.pagesPrintedInReverse ? this.end - page : (this.end != -1 && this.end < this.start ? this.start - page : this.start + page);
            if (this.end == -1) {
                ++page;
            }
        } else {
            ++page;
        }
        return page;
    }

    private AffineTransform getPrintTransformation(PdfDecoderInt pdfDecoder, PageFormat pageFormat, int page, Rectangle cropBox, int rotation) {
        AffineTransform transform = new AffineTransform();
        if (this.duplexGapOdd != 0 || this.duplexGapEven != 0) {
            SwingPrinter.setDuplexOffset(transform, page, this.duplexGapEven, this.duplexGapOdd);
        }
        DisplayOffsets displayOffsets = pdfDecoder.getDisplayOffsets();
        int userPrintOffsetX = displayOffsets.getUserPrintOffsetX();
        int userPrintOffsetY = -displayOffsets.getUserPrintOffsetY();
        if (userPrintOffsetX != 0 || userPrintOffsetY != 0) {
            transform.translate(userPrintOffsetX, userPrintOffsetY);
        }
        Rectangle modifiedCropBox = this.printOnlyVisible ? new Rectangle(this.workoutClipping(pdfDecoder.getDisplayRotation(), pdfDecoder.getVisibleRect(), (int)cropBox.getWidth(), (int)cropBox.getHeight())) : new Rectangle(cropBox);
        AffineTransform pageTransform = PrintUtils.getPageTransform(modifiedCropBox, rotation, pageFormat, this.rotatePrintedPage, this.centerPrintedPage, this.usePDFPaperSize, this.pageScalingMode);
        transform.concatenate(pageTransform);
        return transform;
    }

    private static void setDuplexOffset(AffineTransform transform, int page, int duplexGapEven, int duplexGapOdd) {
        if (page % 2 != 1) {
            transform.translate(duplexGapEven, 0.0);
        } else {
            transform.translate(duplexGapOdd, 0.0);
        }
    }

    private static Map<Integer, String> toMap(int[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        int count = values.length;
        HashMap<Integer, String> newList = new HashMap<Integer, String>(count);
        for (int value : values) {
            newList.put(value, "x");
        }
        return newList;
    }

    private Rectangle workoutClipping(int displayRotation, Rectangle vr, int print_x_size, int print_y_size) {
        double x2 = vr.getX();
        double y2 = vr.getY();
        double w2 = vr.getWidth();
        double h2 = vr.getHeight();
        int newX = 0;
        int newY = 0;
        int newW = 0;
        int newH = 0;
        switch (displayRotation) {
            case 0: {
                newX = (int)((float)(vr.x - this.insetW) / this.scaling);
                newY = (int)((float)print_y_size - (float)(vr.y + vr.height - this.insetH) / this.scaling);
                newW = (int)((float)vr.width / this.scaling - 1.0f);
                newH = (int)((float)vr.height / this.scaling);
                break;
            }
            case 90: {
                newX = (int)((y2 - (double)this.insetH) / (double)this.scaling);
                newY = (int)((x2 - (double)this.insetW) / (double)this.scaling);
                newW = (int)(h2 / (double)this.scaling);
                newH = (int)(w2 / (double)this.scaling);
                break;
            }
            case 180: {
                newY = (int)(y2 / (double)this.scaling - (double)((float)this.insetH / this.scaling));
                newX = (int)((double)print_x_size - (x2 + w2 - (double)this.insetW) / (double)this.scaling);
                newW = (int)(w2 / (double)this.scaling);
                newH = (int)(h2 / (double)this.scaling);
                break;
            }
            case 270: {
                newX = (int)((double)print_x_size - (y2 + h2 - (double)this.insetH) / (double)this.scaling);
                newY = (int)((double)print_y_size - (x2 + w2 - (double)this.insetW) / (double)this.scaling);
                newW = (int)(h2 / (double)this.scaling);
                newH = (int)(w2 / (double)this.scaling);
            }
        }
        Rectangle cRect = new Rectangle(newX, newY, newW, newH);
        return cRect;
    }

    public void printAdditionalObjectsOverPage(int page, int[] type, Color[] colors, Object[] obj) {
        if (this.overlays == null) {
            this.overlays = new Overlays();
        }
        this.overlays.printAdditionalObjectsOverPage(page, type, colors, obj);
    }

    public void printAdditionalObjectsOverAllPages(int[] type, Color[] colors, Object[] obj) {
        if (this.overlays == null) {
            this.overlays = new Overlays();
        }
        this.overlays.printAdditionalObjectsOverAllPages(type, colors, obj);
    }

    public void clear() {
        if (this.overlays != null) {
            this.overlays.clear();
        }
    }

    public void setPrintIndent(int oddPages, int evenPages) {
        this.duplexGapOdd = oddPages;
        this.duplexGapEven = evenPages;
    }

    public void setCenterOnScaling(boolean center) {
        this.centerPrintedPage = center;
    }

    public void setAutoRotate(boolean rotate) {
        this.rotatePrintedPage = rotate;
    }
}

