/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jpedal.fonts.PdfFont;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfFileReader;
import org.jpedal.objects.raw.ObjectFactory;
import org.jpedal.objects.raw.PdfKeyPairsIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.StringUtils;

public class PdfObjectCache {
    public static final int ColorspacesUsed = 1;
    public static final int Colorspaces = 2;
    public static final int ColorspacesObjects = 3;
    public static final int GlobalShadings = 4;
    public static final int LocalShadings = 5;
    private static final int initSize = 50;
    private final Map<Serializable, Object> colorspacesUsed = new HashMap<Serializable, Object>(50);
    private Map<String, byte[]> colorspaces = PdfObjectCache.getColorSpaceWithDefaultValues();
    private Map<String, Object> colorspaceObjects = new HashMap<String, Object>(50);
    private Map<Object, byte[]> globalXObjects = new HashMap<Object, byte[]>(50);
    private Map<Object, byte[]> localXObjects = new HashMap<Object, byte[]>(50);
    private Map<String, byte[]> patterns = new HashMap<String, byte[]>(50);
    private Map<String, byte[]> globalShadings = new HashMap<String, byte[]>(50);
    private Map<String, byte[]> localShadings = new HashMap<String, byte[]>(50);
    private Map<Object, Integer> imposedImages = new HashMap<Object, Integer>(50);
    public PdfObject groupObj;
    private Map<Object, byte[]> OCRs = new HashMap<Object, byte[]>(50);
    public Map<Object, byte[]> unresolvedFonts = new HashMap<Object, byte[]>(50);
    public Map<String, PdfObject> directFonts = new HashMap<String, PdfObject>(50);
    public Map<String, PdfFont> resolvedFonts = new HashMap<String, PdfFont>(50);
    public Map<String, String> objRef2FontKey = new HashMap<String, String>(50);
    Map<Object, byte[]> GraphicsStates = new HashMap<Object, byte[]>(50);

    public PdfObjectCache copy() {
        PdfObjectCache copy = new PdfObjectCache();
        copy.colorspaces = this.colorspaces;
        copy.colorspaceObjects = this.colorspaceObjects;
        copy.directFonts = this.directFonts;
        copy.globalShadings = this.globalShadings;
        copy.globalXObjects = this.globalXObjects;
        copy.GraphicsStates = this.GraphicsStates;
        copy.groupObj = this.groupObj;
        copy.imposedImages = this.imposedImages;
        copy.localShadings = this.localShadings;
        copy.localXObjects = this.localXObjects;
        copy.objRef2FontKey = this.objRef2FontKey;
        copy.OCRs = this.OCRs;
        copy.patterns = this.patterns;
        copy.resolvedFonts = this.resolvedFonts;
        copy.unresolvedFonts = this.unresolvedFonts;
        return copy;
    }

    public void put(int type, int key, Object value) {
        if (type == 1) {
            this.colorspacesUsed.put(Integer.valueOf(key), value);
        }
    }

    public void put(int type, String key, Object value) {
        if (type == 3) {
            this.colorspaceObjects.put(key, value);
        }
    }

    public Iterator<Serializable> iterator(int type) {
        Iterator<Serializable> returnValue = null;
        if (type == 1) {
            returnValue = this.colorspacesUsed.keySet().iterator();
        }
        return returnValue;
    }

    public Object get(int key, Object value) {
        Object returnValue = null;
        switch (key) {
            case 3: {
                returnValue = this.colorspaceObjects.get(value);
                break;
            }
            case 1: {
                returnValue = this.colorspacesUsed.get(value);
                break;
            }
            case 2: {
                returnValue = this.colorspaces.get(value);
                break;
            }
            case 4: {
                returnValue = this.globalShadings.get(value);
                break;
            }
            case 5: {
                returnValue = this.localShadings.get(value);
            }
        }
        return returnValue;
    }

    public void resetFonts() {
        this.resolvedFonts.clear();
        this.objRef2FontKey.clear();
        this.unresolvedFonts.clear();
        this.directFonts.clear();
    }

    public byte[] getProperties(String name) {
        return this.OCRs.get(name);
    }

    public byte[] getXObjects(String localName) {
        String convertedName = StringUtils.convertHexChars(localName);
        byte[] XObject2 = this.localXObjects.get(convertedName);
        if (XObject2 == null) {
            XObject2 = this.globalXObjects.get(convertedName);
        }
        return XObject2;
    }

    public void readResources(PdfObject Resources, boolean resetList, PdfFileReader objectReader) {
        int[] keys = new int[]{2087749783, -1938465939, -2089186617, 373243460, 1146450818, 878474856, 979194486};
        boolean verifyResourcesAvaiable = Resources.isDataExternal();
        for (int key : keys) {
            PdfObject resObj = Resources.getDictionary(key);
            if (resObj == null) continue;
            this.readArrayPairs(resObj, (key == 373243460 || key == 979194486) && resetList, key, objectReader, verifyResourcesAvaiable);
            if (!verifyResourcesAvaiable || resObj.isFullyResolved()) continue;
            Resources.setFullyResolved(false);
            break;
        }
    }

    private void readArrayPairs(PdfObject resObj, boolean resetFontList, int type, PdfFileReader objectReader, boolean verifyResourcesAvaiable) {
        PdfKeyPairsIterator keyPairs = resObj.getKeyPairsIterator();
        while (keyPairs.hasMorePairs()) {
            String id2 = keyPairs.getNextKeyAsString();
            byte[] data = keyPairs.getNextValueAsBytes();
            if (verifyResourcesAvaiable && PdfObjectCache.cannotFullyLoadObjectAndChildren(data, type, objectReader, resObj)) {
                return;
            }
            switch (type) {
                case 2087749783: {
                    this.colorspaces.put(id2, data);
                    break;
                }
                case -1938465939: {
                    this.GraphicsStates.put(id2, data);
                    break;
                }
                case 373243460: {
                    if (id2.contains("#")) {
                        id2 = StringUtils.convertHexChars(id2);
                    }
                    this.unresolvedFonts.put(id2, data);
                    break;
                }
                case 1146450818: {
                    this.patterns.put(id2, data);
                    break;
                }
                case -2089186617: {
                    this.OCRs.put(id2, data);
                    break;
                }
                case 878474856: {
                    if (resetFontList) {
                        this.globalShadings.put(id2, data);
                        break;
                    }
                    this.localShadings.put(id2, data);
                    break;
                }
                case 979194486: {
                    if (resetFontList) {
                        this.globalXObjects.put(StringUtils.convertHexChars(id2), data);
                        break;
                    }
                    this.localXObjects.put(StringUtils.convertHexChars(id2), data);
                }
            }
            keyPairs.nextPair();
        }
    }

    private static boolean cannotFullyLoadObjectAndChildren(byte[] data, int type, PdfFileReader objectReader, PdfObject resObj) {
        PdfObject pdfObject = ObjectFactory.createObject(type, 0, 0, type);
        pdfObject.setUnresolvedData(data, type);
        pdfObject.isDataExternal(true);
        if (!ObjectDecoder.resolveFully(pdfObject, objectReader)) {
            resObj.setFullyResolved(false);
            return true;
        }
        return false;
    }

    public void reset(PdfObjectCache newCache) {
        this.colorspaces = PdfObjectCache.getColorSpaceWithDefaultValues();
        this.colorspaceObjects = new HashMap<String, Object>(50);
        this.directFonts = new HashMap<String, PdfObject>(50);
        this.globalShadings = new HashMap<String, byte[]>(50);
        this.globalXObjects = new HashMap<Object, byte[]>(50);
        this.GraphicsStates = new HashMap<Object, byte[]>(50);
        this.groupObj = newCache.groupObj;
        this.imposedImages = new HashMap<Object, Integer>(50);
        this.localShadings = new HashMap<String, byte[]>(50);
        this.localXObjects = new HashMap<Object, byte[]>(50);
        this.objRef2FontKey = new HashMap<String, String>(50);
        this.OCRs = new HashMap<Object, byte[]>(50);
        this.patterns = new HashMap<String, byte[]>(50);
        this.resolvedFonts = new HashMap<String, PdfFont>(50);
        this.unresolvedFonts = new HashMap<Object, byte[]>(50);
        for (String key : newCache.colorspaces.keySet()) {
            this.colorspaces.put(key, newCache.colorspaces.get(key));
        }
        for (String key : newCache.patterns.keySet()) {
            this.patterns.put(key, newCache.patterns.get(key));
        }
        for (String key : newCache.globalShadings.keySet()) {
            this.globalShadings.put(key, newCache.globalShadings.get(key));
        }
        for (String key : newCache.localShadings.keySet()) {
            this.localShadings.put(key, newCache.localShadings.get(key));
        }
        for (Object key : newCache.GraphicsStates.keySet()) {
            this.GraphicsStates.put(key, newCache.GraphicsStates.get(key));
        }
        for (Object key : newCache.localXObjects.keySet()) {
            this.localXObjects.put(key, newCache.localXObjects.get(key));
        }
        for (Object key : newCache.globalXObjects.keySet()) {
            this.globalXObjects.put(key, newCache.globalXObjects.get(key));
        }
        for (Object key : newCache.imposedImages.keySet()) {
            this.imposedImages.put(key, newCache.imposedImages.get(key));
        }
        for (Object key : newCache.OCRs.keySet()) {
            this.OCRs.put(key, newCache.OCRs.get(key));
        }
        if (this.unresolvedFonts.isEmpty()) {
            for (Object key : newCache.unresolvedFonts.keySet()) {
                this.unresolvedFonts.put(key, newCache.unresolvedFonts.get(key));
            }
        }
    }

    public void restore(PdfObjectCache mainCache) {
        this.colorspaces = mainCache.colorspaces;
        this.colorspaceObjects = mainCache.colorspaceObjects;
        this.directFonts = mainCache.directFonts;
        this.globalShadings = mainCache.globalShadings;
        this.globalXObjects = mainCache.globalXObjects;
        this.GraphicsStates = mainCache.GraphicsStates;
        this.groupObj = mainCache.groupObj;
        this.imposedImages = mainCache.imposedImages;
        this.localShadings = mainCache.localShadings;
        this.localXObjects = mainCache.localXObjects;
        this.objRef2FontKey = mainCache.objRef2FontKey;
        this.OCRs = mainCache.OCRs;
        this.patterns = mainCache.patterns;
        this.resolvedFonts = mainCache.resolvedFonts;
        this.unresolvedFonts = mainCache.unresolvedFonts;
    }

    public void setImposedKey(String key, int id2) {
        this.imposedImages.put(key, id2);
    }

    public Map<String, byte[]> getPatterns() {
        return Collections.unmodifiableMap(this.patterns);
    }

    private static Map<String, byte[]> getColorSpaceWithDefaultValues() {
        HashMap<String, byte[]> colorValues = new HashMap<String, byte[]>(50);
        String[] keys = new String[]{"DeviceRGB", "Pattern", "Separation", "CalRGB", "CalGray", "ICC", "DeviceGray", "DeviceN", "Lab", "DeviceCMYK"};
        String[] values = new String[]{"/DeviceRGB", "/Pattern", "/Separation", "/CalRGB", "/CalGray", "/ICC", "/DeviceGray", "/DeviceN", "/Lab", "/DeviceCMYK"};
        int keyCount = keys.length;
        for (int i2 = 0; i2 < keyCount; ++i2) {
            colorValues.put(keys[i2], values[i2].getBytes());
        }
        return colorValues;
    }
}

