/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import org.jpedal.exception.PdfException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.FontObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.PdfFontFactory;
import org.jpedal.parser.PdfObjectCache;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.output.HTMLFontHandler;
import org.jpedal.utils.LogWriter;

public final class FontResolver {
    private FontResolver() {
    }

    public static PdfFont resolveFont(GraphicsState gs, PdfStreamDecoder pdfStreamDecoder, String fontID, PdfFontFactory pdfFontFactory, PdfObjectCache cache) {
        PdfObjectReader currentPdfFile = pdfStreamDecoder.currentPdfFile;
        ParserOptions parserOptions = pdfStreamDecoder.parserOptions;
        String fontKey = fontID;
        if (gs != null && cache.resolvedFonts.get("t-" + fontID) != null) {
            fontKey = fontID + ':' + gs.nonstrokeColorSpace.getColor().getRGB();
        }
        PdfFont restoredFont = cache.resolvedFonts.get(fontKey);
        boolean fontIsUsedMultipleTimes = false;
        if (restoredFont == null) {
            FontObject newFont = null;
            byte[] newFontData = cache.unresolvedFonts.get(fontID);
            if (newFontData == null) {
                cache.directFonts.remove(fontID);
            } else {
                boolean isRef;
                boolean bl2 = isRef = newFontData[0] != 60;
                if (isRef) {
                    String objRef = new String(newFontData);
                    String key = cache.objRef2FontKey.get(objRef);
                    fontIsUsedMultipleTimes = key != null;
                    restoredFont = cache.resolvedFonts.get(key);
                    if (restoredFont != null && restoredFont.getFontType() == 1228944679) {
                        restoredFont = null;
                    }
                }
                if (restoredFont == null) {
                    newFont = FontResolver.getFontObjectFromRefOrDirect(currentPdfFile, newFontData);
                    if (isRef) {
                        cache.objRef2FontKey.put(new String(newFontData), fontKey);
                    }
                }
            }
            if (restoredFont == null) {
                if (newFont == null) {
                    newFont = new FontObject("0 0 R");
                    fontID = FontResolver.resolveFlattenedFont(fontID, newFont);
                }
                currentPdfFile.checkResolved(newFont);
                try {
                    DynamicVectorRenderer current = pdfStreamDecoder.current;
                    boolean isHTML = current != null && current.isHTMLorSVG();
                    restoredFont = pdfFontFactory.createFont(newFont, fontID, pdfStreamDecoder.objectStoreStreamRef, parserOptions.isRenderPage(), pdfStreamDecoder.errorTracker, isHTML);
                    if (isHTML) {
                        HTMLFontHandler.processFont(restoredFont, current, newFont, currentPdfFile);
                    }
                }
                catch (PdfException e2) {
                    LogWriter.writeLog("Exception: " + e2.getMessage());
                }
            }
            if (fontIsUsedMultipleTimes && restoredFont != null && !pdfStreamDecoder.parserOptions.isFlattenedForm()) {
                cache.resolvedFonts.put(fontKey, restoredFont);
                if (restoredFont.getFontType() == 1228944679) {
                    cache.resolvedFonts.put("t-" + fontID, new PdfFont());
                }
            }
        }
        return restoredFont;
    }

    private static String resolveFlattenedFont(String fontID, PdfObject newFont) {
        String expandedName = StandardFonts.expandName(fontID.replace(',', '-'));
        String nameLowerCase = expandedName.toLowerCase();
        newFont.setConstant(1147962727, 1217103210);
        if (FontMappings.fontSubstitutionAliasTable.get(nameLowerCase) == null && FontMappings.fontSubstitutionTable != null && FontMappings.fontSubstitutionTable.get(nameLowerCase) == null) {
            if (nameLowerCase.contains("bold")) {
                return "Arial-Bold";
            }
            if (nameLowerCase.contains("italic")) {
                return "Arial-Italic";
            }
            return "Arial";
        }
        return expandedName;
    }

    private static FontObject getFontObjectFromRefOrDirect(PdfObjectReader currentPdfFile, byte[] data) {
        FontObject obj = new FontObject(new String(data));
        obj.setUnresolvedData(data, 373243460);
        ObjectDecoder objectDecoder = new ObjectDecoder(currentPdfFile.getObjectReader());
        objectDecoder.checkResolved(obj);
        return obj;
    }
}

