/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

public class FallbackFont {
    private final BaseType baseType;
    private final FontStyle fontStyle;

    FallbackFont(BaseType baseType, FontStyle fontStyle) {
        this.baseType = baseType;
        this.fontStyle = fontStyle;
    }

    public String getName() {
        return this.baseType.toString() + '-' + (Object)((Object)this.fontStyle);
    }

    public String getID() {
        return this.baseType.id + this.fontStyle.id;
    }

    public String getPath() {
        return this.baseType.path;
    }

    public boolean isUnicode() {
        return this.baseType.isUnicode;
    }

    public int getUnitsPerEm() {
        return this.baseType.unitsPerEm;
    }

    public static enum FontStyle {
        Regular("r"),
        Bold("b"),
        Italic("i"),
        BoldItalic("bi");

        private final String id;

        private FontStyle(String id2) {
            this.id = id2;
        }
    }

    public static enum BaseType {
        LiberationSerif(false, "liberationserif", 2048, "lf", false),
        LiberationSans(false, "liberationsans", 2048, "ls", false),
        NotoSansCondensed(false, "notosanscondensed", 1000, "n", false),
        NotoSansSymbols2(false, "notosanssymbols2", 1000, "s", true),
        Texgyrecursor(false, "texgyrecursor", 1000, "t", false),
        Unifont(true, "unifont", 1024, "u", true),
        Anton(true, "anton", 2048, "a", true);

        private final boolean isUnicode;
        private final String path;
        private final int unitsPerEm;
        private final String id;
        private final boolean isRegularOnly;

        private BaseType(boolean isUnicode, String path, int unitsPerEm, String id2, boolean isRegularOnly) {
            this.isUnicode = isUnicode;
            this.path = path;
            this.unitsPerEm = unitsPerEm;
            this.id = id2;
            this.isRegularOnly = isRegularOnly;
        }

        boolean isRegularOnly() {
            return this.isRegularOnly;
        }
    }
}

