/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw.xfa;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.jpedal.objects.raw.FormAppearanceObject;

final class PushButtonAP {
    private static final float[] patternDashed = new float[]{15.0f, 3.0f, 15.0f, 3.0f};
    private static final float[] patternDotted = new float[]{8.0f, 3.0f, 8.0f, 3.0f};
    private static final float[] patternDashDot = new float[]{15.0f, 3.0f, 8.0f, 3.0f};
    private static final float[] patternDashDotDot = new float[]{15.0f, 3.0f, 8.0f, 3.0f, 8.0f, 3.0f};

    private PushButtonAP() {
    }

    public static void draw(FormAppearanceObject XObject2, BufferedImage image) {
        int strokeType = XObject2.getBorderStroke();
        Color bgColor = null;
        float[] arr = XObject2.getFloatArray(4631);
        if (arr != null) {
            bgColor = new Color((int)arr[0], (int)arr[1], (int)arr[2]);
        }
        if (bgColor == null) {
            bgColor = new Color(150, 150, 150);
        }
        switch (strokeType) {
            case 0: 
            case 5: {
                PushButtonAP.drawPushButtonSolid(image, bgColor);
                break;
            }
            case 1: {
                PushButtonAP.drawPushButtonPattern(patternDashed, image, bgColor);
                break;
            }
            case 2: {
                PushButtonAP.drawPushButtonPattern(patternDotted, image, bgColor);
                break;
            }
            case 3: {
                PushButtonAP.drawPushButtonPattern(patternDashDot, image, bgColor);
                break;
            }
            case 4: {
                PushButtonAP.drawPushButtonPattern(patternDashDotDot, image, bgColor);
                break;
            }
            case 6: {
                PushButtonAP.drawPushButtonLowered(image, bgColor);
                break;
            }
            case 7: {
                PushButtonAP.drawPushButtonRaised(image, bgColor);
                break;
            }
            case 9: {
                PushButtonAP.drawPushButtonEmbossed(image, bgColor);
                break;
            }
            case 8: {
                PushButtonAP.drawPushButtonEtched(image, bgColor);
            }
        }
    }

    private static void drawPushButtonPattern(float[] pattern, BufferedImage image, Color bgColor) {
        int height = image.getHeight();
        int width = image.getWidth();
        Graphics2D g2 = image.createGraphics();
        g2.setColor(bgColor);
        g2.fill3DRect(0, 0, width, height, true);
        g2.setColor(Color.BLACK);
        g2.setStroke(new BasicStroke(2.0f, 0, 0, 10.0f, pattern, 0.0f));
        g2.drawRect(0, 0, width, height);
    }

    private static void drawPushButtonRaised(BufferedImage image, Color bgColor) {
        int height = image.getHeight();
        int width = image.getWidth();
        Graphics2D g2 = image.createGraphics();
        Color darkGrey = new Color(128, 128, 128);
        g2.setColor(Color.BLACK);
        g2.fill(new Rectangle2D.Double(0.0, 0.0, width, height));
        g2.setColor(Color.WHITE);
        g2.fill(new Rectangle2D.Double(2.0, 2.0, width - 4, height - 4));
        g2.setColor(darkGrey);
        g2.fill(new Rectangle2D.Double(4.0, 4.0, width - 6, height - 6));
        g2.setColor(bgColor);
        g2.fill(new Rectangle2D.Double(4.0, 4.0, width - 8, height - 8));
        g2.setColor(darkGrey);
        int[] x2 = new int[]{width - 4, width - 2, width - 2};
        int[] y2 = new int[]{4, 2, 4};
        Polygon p2 = new Polygon(x2, y2, 3);
        g2.fillPolygon(p2);
        x2 = new int[]{2, 4, 4};
        y2 = new int[]{height - 2, height - 2, height - 4};
        p2 = new Polygon(x2, y2, 3);
        g2.fillPolygon(p2);
    }

    private static void drawPushButtonLowered(BufferedImage image, Color bgColor) {
        int height = image.getHeight();
        int width = image.getWidth();
        Graphics2D g2 = image.createGraphics();
        Color darkGrey = new Color(128, 128, 128);
        g2.setColor(Color.BLACK);
        g2.fill(new Rectangle2D.Double(0.0, 0.0, width, height));
        g2.setColor(darkGrey);
        g2.fill(new Rectangle2D.Double(2.0, 2.0, width - 4, height - 4));
        g2.setColor(bgColor);
        g2.fill(new Rectangle2D.Double(4.0, 4.0, width - 6, height - 6));
        g2.setColor(bgColor);
        int[] x2 = new int[]{width - 4, width - 2, width - 2};
        int[] y2 = new int[]{4, 2, 4};
        Polygon p2 = new Polygon(x2, y2, 3);
        g2.fillPolygon(p2);
        x2 = new int[]{2, 4, 4};
        y2 = new int[]{height - 2, height - 2, height - 4};
        p2 = new Polygon(x2, y2, 3);
        g2.fillPolygon(p2);
    }

    private static void drawPushButtonEtched(BufferedImage image, Color bgColor) {
        int height = image.getHeight();
        int width = image.getWidth();
        Graphics2D g2 = image.createGraphics();
        Color darkGrey = new Color(128, 128, 128);
        g2.setColor(darkGrey);
        g2.fill(new Rectangle2D.Double(0.0, 0.0, width, height));
        g2.setColor(Color.WHITE);
        g2.fill(new Rectangle2D.Double(2.0, 2.0, width, height));
        g2.setColor(darkGrey);
        g2.fill(new Rectangle2D.Double(4.0, 4.0, width - 6, height - 6));
        g2.setColor(bgColor);
        g2.fill(new Rectangle2D.Double(4.0, 4.0, width - 8, height - 8));
        g2.setColor(darkGrey);
        int[] x2 = new int[]{width - 4, width - 2, width - 2};
        int[] y2 = new int[]{4, 2, 4};
        Polygon p2 = new Polygon(x2, y2, 3);
        g2.fillPolygon(p2);
        g2.setColor(Color.WHITE);
        p2.translate(2, -2);
        g2.fillPolygon(p2);
        g2.setColor(darkGrey);
        x2 = new int[]{2, 4, 4};
        y2 = new int[]{height - 2, height - 2, height - 4};
        p2 = new Polygon(x2, y2, 3);
        g2.fillPolygon(p2);
        g2.setColor(Color.WHITE);
        p2.translate(-2, 2);
        g2.fillPolygon(p2);
    }

    private static void drawPushButtonEmbossed(BufferedImage image, Color bgColor) {
        int height = image.getHeight();
        int width = image.getWidth();
        Graphics2D g2 = image.createGraphics();
        Color darkGrey = new Color(128, 128, 128);
        g2.setColor(darkGrey);
        g2.fill(new Rectangle2D.Double(0.0, 0.0, width, height));
        g2.setColor(Color.BLACK);
        g2.fill(new Rectangle2D.Double(2.0, 2.0, width, height));
        g2.setColor(darkGrey);
        g2.fill(new Rectangle2D.Double(4.0, 4.0, width - 6, height - 6));
        g2.setColor(bgColor);
        g2.fill(new Rectangle2D.Double(4.0, 4.0, width - 8, height - 8));
        g2.setColor(darkGrey);
        int[] x2 = new int[]{width - 4, width - 2, width - 2};
        int[] y2 = new int[]{4, 2, 4};
        Polygon p2 = new Polygon(x2, y2, 3);
        g2.fillPolygon(p2);
        g2.setColor(Color.BLACK);
        p2.translate(2, -2);
        g2.fillPolygon(p2);
        g2.setColor(darkGrey);
        x2 = new int[]{2, 4, 4};
        y2 = new int[]{height - 2, height - 2, height - 4};
        p2 = new Polygon(x2, y2, 3);
        g2.fillPolygon(p2);
        g2.setColor(Color.BLACK);
        p2.translate(-2, 2);
        g2.fillPolygon(p2);
    }

    private static void drawPushButtonSolid(BufferedImage image, Color bgColor) {
        int height = image.getHeight();
        int width = image.getWidth();
        Graphics2D g2 = image.createGraphics();
        g2.setColor(Color.BLACK);
        g2.fillRect(0, 0, width, height);
        g2.setColor(bgColor);
        g2.fill(new Rectangle2D.Double(2.0, 2.0, width - 4, height - 4));
    }
}

