/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw.xfa;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.jpedal.objects.raw.FormAppearanceObject;

final class CheckBoxAP {
    private static final int[] chkXPoints1 = new int[]{2, 68, 2};
    private static final int[] chkYPoints1 = new int[]{3, 3, 68};
    private static final int[] chkXPoints2 = new int[]{2, 69, 69};
    private static final int[] chkYPoints2 = new int[]{70, 70, 3};
    private static final int[] chkXPoints3 = new int[]{5, 65, 5};
    private static final int[] chkYPoints3 = new int[]{6, 6, 65};
    private static final int[] chkXPoints4 = new int[]{4, 65, 66};
    private static final int[] chkYPoints4 = new int[]{66, 66, 6};
    private static final float[] patternDashed = new float[]{15.0f, 3.0f, 15.0f, 3.0f};
    private static final float[] patternDotted = new float[]{8.0f, 3.0f, 8.0f, 3.0f};
    private static final float[] patternDashDot = new float[]{15.0f, 3.0f, 8.0f, 3.0f};
    private static final float[] patternDashDotDot = new float[]{15.0f, 3.0f, 8.0f, 3.0f, 8.0f, 3.0f};
    private static final float[] patternSolid = new float[]{1.0f, 0.0f};
    private static final Color acrobatColor = new Color(255, 255, 255);

    private CheckBoxAP() {
    }

    static void draw(BufferedImage image, FormAppearanceObject XObject2) {
        int stroke = XObject2.getBorderStroke();
        switch (stroke) {
            case 0: {
                break;
            }
            case 1: {
                CheckBoxAP.drawDashedCheckbox(image, XObject2, patternDashed);
                break;
            }
            case 2: {
                CheckBoxAP.drawDashedCheckbox(image, XObject2, patternDotted);
                break;
            }
            case 3: {
                CheckBoxAP.drawDashedCheckbox(image, XObject2, patternDashDot);
                break;
            }
            case 4: {
                CheckBoxAP.drawDashedCheckbox(image, XObject2, patternDashDotDot);
                break;
            }
            case 6: {
                CheckBoxAP.drawCheckboxLowered(image, XObject2);
                break;
            }
            case 7: {
                CheckBoxAP.drawCheckboxRaised(image, XObject2);
                break;
            }
            case 8: {
                CheckBoxAP.drawCheckboxEtched(image, XObject2);
                break;
            }
            case 9: {
                CheckBoxAP.drawCheckboxEmbossed(image, XObject2);
                break;
            }
            default: {
                CheckBoxAP.drawDashedCheckbox(image, XObject2, patternSolid);
            }
        }
    }

    private static void drawCheckboxLowered(BufferedImage image, FormAppearanceObject XObject2) {
        int height = image.getHeight();
        int width = image.getWidth();
        Graphics2D g2 = image.createGraphics();
        g2.setTransform(AffineTransform.getScaleInstance((float)width / 80.0f, (float)height / 80.0f));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(3.0f, 2, 0));
        g2.setColor(Color.BLACK);
        g2.fillRect(2, 3, 67, 67);
        g2.setColor(new Color(77, 80, 89));
        g2.fillPolygon(chkXPoints1, chkYPoints1, 3);
        g2.fillPolygon(chkXPoints2, chkYPoints2, 3);
        g2.setColor(new Color(161, 163, 172));
        g2.fillPolygon(chkXPoints3, chkYPoints3, 3);
        g2.setColor(new Color(215, 215, 219));
        g2.fillPolygon(chkXPoints4, chkYPoints4, 3);
        g2.setColor(acrobatColor);
        g2.fill(new Rectangle2D.Double(9.0, 10.0, 53.0, 53.0));
        CheckBoxAP.drawCheckBoxMarkType(image, XObject2);
    }

    private static void drawCheckBoxMarkType(BufferedImage image, FormAppearanceObject XObject2) {
        int height = image.getHeight();
        int width = image.getWidth();
        Graphics2D g2 = image.createGraphics();
        if (XObject2.isSelected) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            switch (XObject2.getXFACheckButtonMarkType()) {
                case 94935104: {
                    CheckBoxAP.drawCross(g2, width, height);
                    break;
                }
                case -1360216880: {
                    CheckBoxAP.drawCircle(g2, width, height);
                    break;
                }
                case 94627080: {
                    CheckBoxAP.drawTick(g2, width, height);
                    break;
                }
                case 1655054676: {
                    CheckBoxAP.drawDiamond(g2, width, height);
                    break;
                }
                case -894674659: {
                    CheckBoxAP.drawSquare(g2, width, height);
                    break;
                }
                case 3540562: {
                    CheckBoxAP.drawStar(g2, width, height);
                }
            }
        } else {
            g2.setColor(acrobatColor);
        }
    }

    private static void drawCheckboxRaised(BufferedImage image, FormAppearanceObject XObject2) {
        int height = image.getHeight();
        int width = image.getWidth();
        Graphics2D g2 = image.createGraphics();
        g2.setTransform(AffineTransform.getScaleInstance((float)width / 80.0f, (float)height / 80.0f));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(3.0f, 2, 0));
        g2.setColor(Color.BLACK);
        g2.fillRect(2, 3, 67, 67);
        g2.setColor(new Color(77, 80, 89));
        g2.fillPolygon(chkXPoints1, chkYPoints1, 3);
        g2.fillPolygon(chkXPoints2, chkYPoints2, 3);
        g2.setColor(new Color(243, 246, 255));
        g2.fillPolygon(chkXPoints3, chkYPoints3, 3);
        g2.setColor(new Color(161, 163, 172));
        g2.fillPolygon(chkXPoints4, chkYPoints4, 3);
        g2.setColor(acrobatColor);
        g2.fill(new Rectangle2D.Double(9.0, 10.0, 53.0, 53.0));
        CheckBoxAP.drawCheckBoxMarkType(image, XObject2);
    }

    private static void drawCheckboxEtched(BufferedImage image, FormAppearanceObject XObject2) {
        int height = image.getHeight();
        int width = image.getWidth();
        Graphics2D g2 = image.createGraphics();
        g2.setTransform(AffineTransform.getScaleInstance((float)width / 80.0f, (float)height / 80.0f));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(3.0f, 2, 0));
        g2.setColor(new Color(161, 163, 172));
        g2.fillRect(2, 3, 67, 67);
        g2.setColor(new Color(161, 163, 172));
        g2.fillPolygon(chkXPoints1, chkYPoints1, 3);
        g2.setColor(new Color(243, 246, 255));
        g2.fillPolygon(chkXPoints2, chkYPoints2, 3);
        g2.setColor(new Color(243, 246, 255));
        g2.fillPolygon(chkXPoints3, chkYPoints3, 3);
        g2.setColor(new Color(161, 163, 172));
        g2.fillPolygon(chkXPoints4, chkYPoints4, 3);
        g2.setColor(acrobatColor);
        g2.fill(new Rectangle2D.Double(9.0, 10.0, 53.0, 53.0));
        CheckBoxAP.drawCheckBoxMarkType(image, XObject2);
    }

    private static void drawCheckboxEmbossed(BufferedImage image, FormAppearanceObject XObject2) {
        int height = image.getHeight();
        int width = image.getWidth();
        Graphics2D g2 = image.createGraphics();
        g2.setTransform(AffineTransform.getScaleInstance((float)width / 80.0f, (float)height / 80.0f));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(3.0f, 2, 0));
        g2.setColor(new Color(161, 163, 172));
        g2.fillRect(2, 3, 67, 67);
        g2.setColor(new Color(161, 163, 172));
        g2.fillPolygon(chkXPoints1, chkYPoints1, 3);
        g2.setColor(new Color(77, 80, 89));
        g2.fillPolygon(chkXPoints2, chkYPoints2, 3);
        g2.setColor(new Color(77, 80, 89));
        g2.fillPolygon(chkXPoints3, chkYPoints3, 3);
        g2.setColor(new Color(161, 163, 172));
        g2.fillPolygon(chkXPoints4, chkYPoints4, 3);
        g2.setColor(acrobatColor);
        g2.fill(new Rectangle2D.Double(9.0, 10.0, 53.0, 53.0));
        CheckBoxAP.drawCheckBoxMarkType(image, XObject2);
    }

    static void drawRollover(BufferedImage image) {
        int height = image.getHeight();
        int width = image.getWidth();
        Graphics2D g2 = image.createGraphics();
        g2.setStroke(new BasicStroke(1.0f, 0, 0));
        g2.setColor(Color.BLACK);
        g2.drawRect(0, 0, width - 2, height - 2);
    }

    private static void drawDashedCheckbox(BufferedImage image, FormAppearanceObject XObject2, float[] dashPattern) {
        int height = image.getHeight();
        int width = image.getWidth();
        Graphics2D g2 = image.createGraphics();
        g2.setTransform(AffineTransform.getScaleInstance((float)width / 80.0f, (float)height / 80.0f));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(acrobatColor);
        g2.fillRect(3, 3, 66, 65);
        g2.setColor(new Color(21, 21, 21));
        g2.setComposite(AlphaComposite.getInstance(3, 0.6f));
        g2.setStroke(new BasicStroke(6.0f, 0, 0, 10.0f, dashPattern, 0.0f));
        g2.drawRect(3, 3, 66, 64);
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        CheckBoxAP.drawCheckBoxMarkType(image, XObject2);
    }

    private static void drawSquare(Graphics2D g2, int width, int height) {
        g2.setColor(Color.BLACK);
        g2.fillRect(width / 3, height / 3, width / 3, height / 3);
    }

    private static void drawDiamond(Graphics2D g2, int width, int height) {
        g2.setColor(Color.BLACK);
        g2.rotate(95.0, width / 2, height / 2);
        g2.fillRect(width / 3, height / 3, width / 3, height / 3);
    }

    private static void drawCircle(Graphics2D g2, int width, int height) {
        g2.setColor(Color.BLACK);
        Ellipse2D.Double circle = new Ellipse2D.Double(width / 4, height / 4, (double)width / 2.5, (double)height / 2.5);
        g2.fill(circle);
    }

    private static void drawStar(Graphics2D g2, int width, int height) {
        double p1x = 0.0;
        double p1y = (double)height / 3.9;
        double p2y = (double)height / 4.1;
        double p3x = (double)width / 2.9;
        double p4x = (double)width / 2.5;
        double p4y = (double)height / 4.4;
        double p5x = (double)width / 1.5;
        double p6x = (double)width / 1.9;
        double p6y = (double)height / 2.8;
        double p7x = (double)width / 1.8;
        double p7y = (double)height / 1.6;
        double p8x = (double)width / 3.2;
        double p8y = (double)height / 2.1;
        double p9x = (double)width / 9.4;
        double p10x = (double)width / 6.9;
        double p10y = height / 3;
        g2.setColor(Color.BLACK);
        double[][] points = new double[][]{{0.0, p1y}, {p1y, p2y}, {p3x, 0.0}, {p4x, p4y}, {p5x, p1y}, {p6x, p6y}, {p7x, p7y}, {p8x, p8y}, {p9x, p7y}, {p10x, p10y}, {0.0, p1y}};
        GeneralPath star = new GeneralPath();
        star.moveTo(points[0][0], points[0][1]);
        for (int k2 = 1; k2 < points.length; ++k2) {
            star.lineTo(points[k2][0], points[k2][1]);
        }
        star.closePath();
        star.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, width / 8, height / 8));
        g2.fill(star);
    }

    private static void drawTick(Graphics2D g2, int width, int height) {
        g2.setColor(Color.BLACK);
        double p1x = 0.0;
        double p1y = (double)height / 2.7;
        double p2x = (double)width / 10.7;
        double p2y = (double)height / 3.05;
        double p3x = (double)width / 5.3;
        double p3y = (double)height / 2.4;
        double p4x = (double)width / 1.6;
        double p4y = 0.0;
        double p5x = (double)width / 1.5;
        double p6y = (double)height / 1.3;
        double[][] points = new double[][]{{0.0, p1y}, {p2x, p2y}, {p3x, p3y}, {p4x, 0.0}, {p5x, 0.0}, {p3x, p6y}, {0.0, p1y}};
        GeneralPath tick = new GeneralPath();
        tick.moveTo(points[0][0], points[0][1]);
        for (int k2 = 1; k2 < points.length; ++k2) {
            tick.lineTo(points[k2][0], points[k2][1]);
        }
        tick.closePath();
        tick.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, width / 8, height / 8));
        g2.fill(tick);
    }

    private static void drawCross(Graphics2D g2, int width, int height) {
        g2.setColor(Color.BLACK);
        double p1x = 0.0;
        double p1y = height / 8;
        double p2x = width / 8;
        double p2y = 0.0;
        double p3x = width / 3;
        double p3y = height / 4;
        double p4x = (double)width / 2.1;
        double p4y = height / 16;
        double p5x = (double)width / 1.5;
        double p6x = (double)width / 2.5;
        double p6y = (double)height / 2.7;
        double p7y = (double)height / 1.6;
        double p9x = (double)width / 3.2;
        double p9y = (double)height / 2.3;
        double p10x = (double)width / 5.3;
        double p12x = (double)width / 4.6;
        double p13x = width / 32;
        double[][] points = new double[][]{{0.0, p1y}, {p2x, 0.0}, {p3x, p3y}, {p4x, p4y}, {p5x, 0.0}, {p6x, p6y}, {p5x, p7y}, {p4x, p7y}, {p9x, p9y}, {p10x, p7y}, {0.0, p7y}, {p12x, p6y}, {p13x, p4y}};
        GeneralPath cross = new GeneralPath();
        cross.moveTo(points[0][0], points[0][1]);
        for (int k2 = 1; k2 < points.length; ++k2) {
            cross.lineTo(points[k2][0], points[k2][1]);
        }
        cross.closePath();
        cross.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, width / 8, height / 8));
        g2.fill(cross);
    }
}

