/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw;

import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.StringUtils;

public class SoundObject
extends PdfObject {
    private byte[] rawE;
    private String E;
    private int B = -1;
    private int Cint = -1;
    private int R = -1;

    public SoundObject(String ref) {
        super(ref);
    }

    public SoundObject(int ref, int gen) {
        super(ref, gen);
    }

    @Override
    public void setIntNumber(int id2, int value) {
        switch (id2) {
            case 18: {
                this.B = value;
                break;
            }
            case 19: {
                this.Cint = value;
                break;
            }
            case 34: {
                this.R = value;
                break;
            }
            default: {
                super.setIntNumber(id2, value);
            }
        }
    }

    @Override
    public int getInt(int id2) {
        switch (id2) {
            case 18: {
                return this.B;
            }
            case 19: {
                return this.Cint;
            }
            case 34: {
                return this.R;
            }
        }
        return super.getInt(id2);
    }

    @Override
    public void setName(int id2, byte[] value) {
        if (id2 == 21) {
            this.rawE = value;
        } else {
            super.setName(id2, value);
        }
    }

    @Override
    public void setTextStreamValue(int id2, byte[] value) {
        if (id2 == 21) {
            this.rawE = value;
        } else {
            super.setTextStreamValue(id2, value);
        }
    }

    @Override
    public String getName(int id2) {
        if (id2 == 21) {
            if (this.E == null && this.rawE != null) {
                this.E = StringUtils.getTextString(this.rawE, false);
            }
            return this.E;
        }
        return super.getName(id2);
    }

    @Override
    public boolean decompressStreamWhenRead() {
        return true;
    }

    @Override
    public int getNameAsConstant(int id2) {
        if (id2 != 21) {
            return super.getNameAsConstant(id2);
        }
        byte[] raw = this.rawE;
        if (raw == null) {
            return super.getNameAsConstant(id2);
        }
        return PdfDictionary.generateChecksum(0, raw.length, raw);
    }

    @Override
    public int getObjectType() {
        return 1061502534;
    }
}

