/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw;

public class PdfKeyPairsIterator {
    private final byte[][] keys;
    private final byte[][] values;
    private int maxCount;
    private int current;

    public PdfKeyPairsIterator(byte[][] keys, byte[][] values) {
        this.keys = keys;
        this.values = values;
        if (keys != null) {
            this.maxCount = keys.length;
        }
        this.current = 0;
    }

    public int getTokenCount() {
        return this.maxCount;
    }

    public void nextPair() {
        if (this.current < this.maxCount) {
            ++this.current;
        } else {
            throw new RuntimeException("No keys left in PdfKeyPairsIterator");
        }
    }

    public String getNextKeyAsString() {
        return new String(this.keys[this.current]);
    }

    public boolean hasMorePairs() {
        return this.current < this.maxCount;
    }

    public byte[] getNextValueAsBytes() {
        if (this.values[this.current] == null) {
            return null;
        }
        return this.values[this.current];
    }

    public String getNextValueAsString() {
        if (this.values[this.current] == null) {
            return null;
        }
        return new String(this.values[this.current]);
    }
}

