/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.StringTokenizer;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.T3Glyph;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectFactory;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfKeyPairsIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.T3Display;
import org.jpedal.utils.LogWriter;

public class FormStream {
    private static final boolean debug = false;
    private static boolean showFontMessage;
    protected PdfObjectReader currentPdfFile;
    protected boolean isXFA;
    private static final int[] id;

    public static Object[] getRolloverKeyValues(PdfObject form, PdfFileReader pdfFileReader) {
        String key = null;
        PdfObject val = null;
        PdfObject rollOffDic = null;
        PdfKeyPairsIterator APkeys = form.getKeyPairsIterator();
        if (APkeys != null && APkeys.getTokenCount() > 0) {
            while (APkeys.hasMorePairs()) {
                String glyphKey = APkeys.getNextKeyAsString();
                byte[] data = APkeys.getNextValueAsBytes();
                if (data != null) {
                    if ("Off".equals(glyphKey)) {
                        rollOffDic = PdfObjectFactory.getPDFObjectObjectFromRefOrDirect(new FormObject(glyphKey), pdfFileReader, data, 4384);
                    } else {
                        key = glyphKey;
                        val = PdfObjectFactory.getPDFObjectObjectFromRefOrDirect(new FormObject(glyphKey), pdfFileReader, data, 4384);
                    }
                }
                APkeys.nextPair();
            }
        } else {
            if (form.getDictionary(2045494) != null) {
                rollOffDic = form.getDictionary(2045494);
            } else if (form.getDecodedStream() != null) {
                rollOffDic = form;
            }
            if (form.getDictionary(7998) != null) {
                key = "On";
                val = form.getDictionary(7998);
            }
        }
        return new Object[]{key, val, rollOffDic};
    }

    public static Object[] getNormalKeyValues(PdfObject form, PdfFileReader pdfFileReader) {
        PdfObject APobjN = form.getDictionary(4384).getDictionary(30);
        String key = null;
        PdfObject val = null;
        PdfObject normalOffDic = null;
        PdfKeyPairsIterator APkeys = APobjN.getKeyPairsIterator();
        if (APkeys != null && APkeys.getTokenCount() > 0) {
            while (APkeys.hasMorePairs()) {
                String glyphKey = APkeys.getNextKeyAsString();
                byte[] data = APkeys.getNextValueAsBytes();
                if (data != null) {
                    if ("Off".equals(glyphKey)) {
                        normalOffDic = PdfObjectFactory.getPDFObjectObjectFromRefOrDirect(new FormObject(glyphKey), pdfFileReader, data, 4384);
                    } else {
                        if (glyphKey != null) {
                            key = glyphKey.replace("\"", "#22");
                        }
                        val = PdfObjectFactory.getPDFObjectObjectFromRefOrDirect(new FormObject(glyphKey), pdfFileReader, data, 4384);
                    }
                }
                APkeys.nextPair();
            }
        } else {
            if (APobjN.getDictionary(2045494) != null) {
                normalOffDic = APobjN.getDictionary(2045494);
            } else if (form.getDictionary(7451).getDictionary(25) != null && form.getDictionary(7451).getDictionary(6422) == null) {
                normalOffDic = form.getDictionary(7451).getDictionary(25);
            } else if (APobjN.getDecodedStream() != null) {
                normalOffDic = APobjN;
            }
            if (APobjN.getDictionary(7998) != null) {
                val = APobjN.getDictionary(7998);
                key = "On";
            }
        }
        return new Object[]{key, val, normalOffDic};
    }

    public static Object[] getDownKeyValues(PdfObject form, PdfFileReader pdfFileReader) {
        String key = null;
        PdfObject val = null;
        PdfObject downOffDic = null;
        PdfKeyPairsIterator APkeys = form.getKeyPairsIterator();
        if (APkeys != null && APkeys.getTokenCount() > 0) {
            while (APkeys.hasMorePairs()) {
                String glyphKey = APkeys.getNextKeyAsString();
                byte[] data = APkeys.getNextValueAsBytes();
                if (data != null) {
                    if ("Off".equals(glyphKey)) {
                        downOffDic = PdfObjectFactory.getPDFObjectObjectFromRefOrDirect(new FormObject(glyphKey), pdfFileReader, data, 4384);
                    } else {
                        key = glyphKey;
                        val = PdfObjectFactory.getPDFObjectObjectFromRefOrDirect(new FormObject(glyphKey), pdfFileReader, data, 4384);
                    }
                }
                APkeys.nextPair();
            }
        } else {
            if (form.getDictionary(7998) != null) {
                key = "On";
                val = form.getDictionary(7998);
            }
            if (form.getDecodedStream() != null) {
                downOffDic = form;
            } else if (form.getDictionary(2045494) != null) {
                downOffDic = form.getDictionary(2045494);
            }
        }
        return new Object[]{key, val, downOffDic};
    }

    public void createAppearanceString(FormObject formObj, PdfObjectReader inCurrentPdfFile) {
        this.currentPdfFile = inCurrentPdfFile;
        this.init(formObj);
    }

    private void init(FormObject formObject) {
        String textStream;
        int Ff = formObject.getInt(5686);
        if (Ff != -1) {
            formObject.commandFf(Ff);
        }
        this.resolveAdditionalAction(formObject);
        FormStream.setupAPimages(formObject, this.currentPdfFile.getObjectReader());
        int key = formObject.getNameAsConstant(24);
        if (key != -1) {
            switch (key) {
                case 32: 
                case 36: {
                    if (formObject.hasDownImage()) break;
                    formObject.setOffsetDownApp();
                    break;
                }
                case 30: {
                    formObject.setNoDownIcon();
                    break;
                }
                case 25: {
                    formObject.setInvertForDownIcon();
                    break;
                }
            }
        }
        if ((textStream = formObject.getTextStreamValue(5137)) != null) {
            FormStream.decodeFontCommandObj(textStream, formObject);
        }
    }

    private static void setupAPimages(FormObject formObject, PdfFileReader pdfFileReader) {
        PdfObject APobjN = formObject.getDictionary(4384).getDictionary(30);
        if (APobjN != null) {
            String ASvalue = formObject.getName(4387);
            formObject.setAppreancesUsed(true);
            String key = (String)FormStream.getNormalKeyValues(formObject, pdfFileReader)[0];
            if (key != null) {
                formObject.setNormalOnState(key);
                if (key.equals(ASvalue)) {
                    formObject.setSelected(true);
                }
            }
        }
    }

    private void resolveAdditionalAction(FormObject formObject) {
        int[] nArray = id;
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int anId;
            int idValue = anId = nArray[i2];
            this.currentPdfFile.setJavascriptForObject(formObject, 4369, idValue);
            this.currentPdfFile.setJavascriptForObject(formObject, 17, idValue);
        }
    }

    public static BufferedImage decode(PdfObject formObj, PdfObjectReader currentPdfFile, PdfObject XObject2, int subtype, int width, int height, int offsetImage, float pageScaling) {
        if (XObject2.getObjectType() == 129) {
            return ExternalHandlers.decode(formObj, currentPdfFile, XObject2, subtype, width, height, offsetImage, pageScaling);
        }
        currentPdfFile.checkResolved(XObject2);
        try {
            float RH;
            float RW;
            float[] apBBox;
            T3Glyph form = FormStream.decodeStream(currentPdfFile, XObject2);
            float[] matrix = XObject2.getFloatArray(1145198201);
            AffineTransform invertedAPMatrix = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
            if (matrix != null) {
                invertedAPMatrix.concatenate(new AffineTransform(matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5]));
            }
            if ((apBBox = XObject2.getFloatArray(303185736)) != null) {
                FormStream.correctBoundingBoxOrder(apBBox);
            } else {
                apBBox = new float[]{0.0f, 0.0f, width, height};
            }
            for (int i2 = 0; i2 < 4; ++i2) {
                if (apBBox[i2] != -32768.0f && apBBox[i2] != 32768.0f) continue;
                LogWriter.writeLog("[Warning] Extreme AP BBox value, defaulting 0");
                apBBox[i2] = 0.0f;
            }
            Shape matrixModifiedBBox = invertedAPMatrix.createTransformedShape(new Rectangle((int)apBBox[0], (int)apBBox[1], (int)(apBBox[2] - apBBox[0]), (int)(apBBox[3] - apBBox[1])));
            Rectangle MBB = matrixModifiedBBox.getBounds();
            float BBW = (float)MBB.getWidth();
            float BBH = (float)MBB.getHeight();
            if (width > 0 && height > 0) {
                RW = width;
                RH = height;
            } else {
                RW = BBW;
                RH = BBH;
            }
            float scaleX = RW / BBW;
            float scaleY = RH / BBH;
            float transX = -((float)MBB.getX() * scaleX) * pageScaling;
            float transY = -((float)MBB.getY() * scaleY) * pageScaling;
            AffineTransform bbToDisplayImage = new AffineTransform(scaleX * pageScaling, 0.0f, 0.0f, scaleY * pageScaling, transX, transY);
            bbToDisplayImage.concatenate(invertedAPMatrix);
            invertedAPMatrix = bbToDisplayImage;
            if (offsetImage == 2) {
                invertedAPMatrix.scale(-1.0, -1.0);
            }
            BufferedImage aa2 = new BufferedImage((int)(RW * pageScaling) + 2, (int)(RH * pageScaling) + 2, 2);
            Graphics2D g2 = (Graphics2D)aa2.getGraphics();
            g2.translate(1, 1);
            g2.transform(invertedAPMatrix);
            form.render(0, g2, 1.0f, true);
            g2.dispose();
            if (subtype == 1919840408) {
                BufferedImage i3 = new BufferedImage(aa2.getWidth(), aa2.getHeight(), aa2.getType());
                Graphics2D gg = i3.createGraphics();
                gg.setComposite(AlphaComposite.getInstance(3, 0.5f));
                gg.drawImage((Image)aa2, 0, 0, null);
                gg.dispose();
                return i3;
            }
            return aa2;
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
            return null;
        }
        catch (Error e3) {
            LogWriter.writeLog(e3);
            return null;
        }
    }

    private static void correctBoundingBoxOrder(float[] BBox) {
        float t2;
        if (BBox[1] > BBox[3]) {
            t2 = BBox[1];
            BBox[1] = BBox[3];
            BBox[3] = t2;
        }
        if (BBox[0] > BBox[2]) {
            t2 = BBox[0];
            BBox[0] = BBox[2];
            BBox[2] = t2;
        }
    }

    private static T3Glyph decodeStream(PdfObjectReader currentPdfFile, PdfObject XObject2) {
        ObjectStore localStore = currentPdfFile.getObjectStore();
        T3Display glyphDisplay = new T3Display(0, false, 20, localStore);
        PdfStreamDecoder glyphDecoder = new PdfStreamDecoder(currentPdfFile);
        glyphDecoder.setParameters(false, true, 15, 0, false);
        glyphDecoder.setStreamType(1);
        glyphDecoder.setObjectValue(-8, localStore);
        glyphDecoder.setRenderer(glyphDisplay);
        try {
            PdfObject Resources = XObject2.getDictionary(2004251818);
            if (Resources != null) {
                glyphDecoder.readResources(Resources, false);
            }
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
        byte[] commands = XObject2.getDecodedStream();
        if (commands != null) {
            glyphDecoder.decodeStreamIntoObjects(commands, false, false);
        }
        boolean ignoreColors = glyphDecoder.ignoreColors;
        return new T3Glyph(glyphDisplay, 0, 0, ignoreColors);
    }

    public static String decipherTextFromAP(PdfObjectReader currentPdfFile, PdfObject Xobject) {
        try {
            ObjectStore localStore = currentPdfFile.getObjectStore();
            T3Display glyphDisplay = new T3Display(0, false, 20, localStore);
            PdfStreamDecoder glyphDecoder = new PdfStreamDecoder(currentPdfFile, null);
            glyphDecoder.setParameters(false, true, 15, 0, false);
            glyphDecoder.setObjectValue(-8, localStore);
            glyphDecoder.setRenderer(glyphDisplay);
            try {
                PdfObject Resources = Xobject.getDictionary(2004251818);
                if (Resources != null) {
                    glyphDecoder.readResources(Resources, false);
                }
            }
            catch (Exception e2) {
                LogWriter.writeLog("Exception: " + e2.getMessage());
            }
            byte[] commands = Xobject.getDecodedStream();
            String textString = "";
            if (commands != null) {
                textString = glyphDecoder.decodeStreamIntoObjects(commands, true, false);
            }
            if (textString == null || textString.isEmpty()) {
                textString = null;
            }
            return textString;
        }
        catch (Exception e3) {
            LogWriter.writeLog("Exception: " + e3.getMessage());
            return null;
        }
        catch (Error e4) {
            LogWriter.writeLog("Error: " + e4.getMessage());
            return null;
        }
    }

    public static BufferedImage rotate(BufferedImage src, int rotation) {
        if (src == null) {
            return null;
        }
        if (rotation == 0) {
            return src;
        }
        double angle = (double)rotation * Math.PI / 180.0;
        int w2 = src.getWidth();
        int h2 = src.getHeight();
        int newW = (int)Math.round((double)h2 * Math.abs(Math.sin(angle)) + (double)w2 * Math.abs(Math.cos(angle)));
        int newH = (int)Math.round((double)h2 * Math.abs(Math.cos(angle)) + (double)w2 * Math.abs(Math.sin(angle)));
        AffineTransform at2 = AffineTransform.getTranslateInstance((newW - w2) / 2, (newH - h2) / 2);
        at2.rotate(angle, w2 / 2, h2 / 2);
        BufferedImage dst = new BufferedImage(newW, newH, 2);
        Graphics2D g2 = dst.createGraphics();
        g2.drawRenderedImage(src, at2);
        g2.dispose();
        return dst;
    }

    public boolean hasXFADataSet() {
        return false;
    }

    private static void decodeFontCommandObj(String fontStream, FormObject formObject) {
        StringTokenizer tokens = new StringTokenizer(fontStream, "() []");
        int tokenCount = tokens.countTokens();
        String[] tokenValues = new String[tokenCount];
        int i2 = 0;
        while (tokens.hasMoreTokens()) {
            tokenValues[i2] = tokens.nextToken();
            ++i2;
        }
        for (i2 = tokenCount - 1; i2 > -1; --i2) {
            if ("g".equals(tokenValues[i2])) {
                if (i2 <= 0) continue;
                FormStream.setFormTextColor(formObject, tokenValues[--i2]);
                continue;
            }
            if ("Tf".equals(tokenValues[i2])) {
                if (i2 < 2) continue;
                String textSize = tokenValues[i2 - 1];
                String fontName = tokenValues[i2 - 2];
                i2 -= 2;
                FormStream.setFormFont(formObject, textSize, fontName);
                continue;
            }
            if ("rg".equals(tokenValues[i2]) || "r".equals(tokenValues[i2])) {
                if (i2 < 3) continue;
                String b2 = tokenValues[i2 - 1];
                String g2 = tokenValues[i2 - 2];
                String r2 = tokenValues[i2 - 3];
                i2 -= 3;
                FormStream.setFormTextColor(formObject, r2, g2, b2);
                continue;
            }
            if ("Sig".equals(tokenValues[i2])) {
                LogWriter.writeLog("[forms] Sig-  UNIMPLEMENTED=" + fontStream + "< " + i2);
                continue;
            }
            if ("\\n".equals(tokenValues[i2]) || showFontMessage) continue;
            showFontMessage = true;
            LogWriter.writeLog("[forms] {stream} Unknown FONT command " + tokenValues[i2] + ' ' + i2 + " string=" + fontStream);
        }
    }

    private static void setFormFont(FormObject formObject, String textSizeStr, String fontNameStr) {
        int textSize = 8;
        try {
            textSize = (int)Float.parseFloat(FormStream.handleComma(textSizeStr));
        }
        catch (Exception e2) {
            LogWriter.writeLog("Error in generating Tf size " + textSizeStr + ' ' + e2);
        }
        String font = null;
        try {
            font = fontNameStr;
            if (font.startsWith("/")) {
                font = font.substring(1);
            }
        }
        catch (Exception e3) {
            LogWriter.writeLog("Error in generating Tf font " + fontNameStr + "  " + e3);
        }
        PdfFont currentFont = new PdfFont();
        currentFont.setFont(font, textSize);
        String fontName = StandardFonts.expandName(font);
        String altName = FontMappings.fontSubstitutionAliasTable.get(fontName.toLowerCase());
        if (altName != null) {
            fontName = altName;
        }
        formObject.setFontName(fontName);
        formObject.setTextFont(currentFont.getGlyphData().getUnscaledFont());
        formObject.setTextSize(textSize);
    }

    private static void setFormTextColor(FormObject formObject, String rStr, String gStr, String bStr) {
        float r2 = Float.parseFloat(FormStream.handleComma(rStr));
        float g2 = Float.parseFloat(FormStream.handleComma(gStr));
        float b2 = Float.parseFloat(FormStream.handleComma(bStr));
        formObject.setTextColor(new float[]{r2, g2, b2});
    }

    private static void setFormTextColor(FormObject formObject, String colorStr) {
        float col = 0.0f;
        try {
            col = Float.parseFloat(FormStream.handleComma(colorStr));
        }
        catch (Exception e2) {
            LogWriter.writeLog("Error in generating g value " + colorStr + ' ' + e2);
        }
        formObject.setTextColor(new float[]{col});
    }

    private static String handleComma(String tokenValue) {
        int comma = tokenValue.indexOf(44);
        if (comma != -1) {
            tokenValue = tokenValue.substring(0, comma);
        }
        return tokenValue;
    }

    public byte[] getXFA(int xfaTemplate) {
        throw new RuntimeException("getXFA Should never be called in base class");
    }

    public boolean isXFA() {
        return this.isXFA;
    }

    static {
        id = new int[]{17, 4866, 4668, 21, 40, 20, 37, 5695, 8223, 8211, 8230, 8217, 31, 4865, 27, 22, 38, 4866, 5139, 10019, 5155, 10016, 5152};
    }
}

