/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.outlines;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.acroforms.actions.DestHandler;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.SecureDocumentBuilderFactory;
import org.jpedal.utils.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OutlineData {
    private Document OutlineDataXML;
    private final Set<Integer> seenOutlineRefs = new HashSet<Integer>();
    private final Map<String, PdfObject> DestObjs = new HashMap<String, PdfObject>();

    public OutlineData() {
        SecureDocumentBuilderFactory factory = new SecureDocumentBuilderFactory();
        try {
            this.OutlineDataXML = factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e2) {
            System.err.println("Exception " + e2 + " generating XML document");
        }
    }

    public Document getList() {
        return this.OutlineDataXML;
    }

    public int readOutlineFileMetadata(PdfObject OutlinesObj, PdfObjectReader currentPdfFile) {
        int count = OutlinesObj.getInt(1061502502);
        PdfObject FirstObj = OutlinesObj.getDictionary(960643930);
        currentPdfFile.checkResolved(FirstObj);
        if (FirstObj != null) {
            Element root = this.OutlineDataXML.createElement("root");
            this.OutlineDataXML.appendChild(root);
            boolean level = false;
            this.readOutlineLevel(root, currentPdfFile, FirstObj, 0, false);
        }
        return count;
    }

    private void readOutlineLevel(Element root, PdfObjectReader currentPdfFile, PdfObject outlineObj, int level, boolean isClosed) {
        Element child = this.OutlineDataXML.createElement("title");
        this.seenOutlineRefs.add(outlineObj.getObjectRefID());
        while (true) {
            String ID2 = outlineObj.getObjectRefAsString();
            PdfObject FirstObj = outlineObj.getDictionary(960643930);
            currentPdfFile.checkResolved(FirstObj);
            PdfObject NextObj = outlineObj.getDictionary(506808388);
            currentPdfFile.checkResolved(NextObj);
            int numberOfItems = outlineObj.getInt(1061502502);
            if (numberOfItems != 0) {
                isClosed = numberOfItems < 0;
            }
            PdfArrayIterator dest = DestHandler.resolveIfIndirect(outlineObj, DestHandler.getDestFromObject(outlineObj, currentPdfFile), currentPdfFile);
            int page = DestHandler.getPageNumberFromLink(dest, currentPdfFile);
            Object[] zoomArray = DestHandler.getZoomFromDest(currentPdfFile, dest);
            byte[] titleData = outlineObj.getTextStreamValueAsByte(960773209);
            if (titleData != null) {
                String title = StringUtils.getTextString(titleData, false);
                child = this.OutlineDataXML.createElement("title");
                root.appendChild(child);
                child.setAttribute("title", title);
            }
            child.setAttribute("isClosed", String.valueOf(isClosed));
            this.DestObjs.put(ID2, outlineObj);
            if (page == 69561) {
                child.setAttribute("page", "-1");
            } else {
                child.setAttribute("page", String.valueOf(page));
            }
            if (zoomArray != null) {
                child.setAttribute("zoom", DestHandler.convertZoomArrayToString(zoomArray));
            }
            child.setAttribute("level", String.valueOf(level));
            child.setAttribute("objectRef", ID2);
            if (FirstObj != null) {
                if (!this.seenOutlineRefs.add(FirstObj.getObjectRefID())) {
                    return;
                }
                this.readOutlineLevel(child, currentPdfFile, FirstObj, level + 1, isClosed);
            }
            if (NextObj == null || !this.seenOutlineRefs.add(NextObj.getObjectRefID())) break;
            outlineObj = NextObj;
        }
    }

    public PdfObject getAobj(String ref) {
        return this.DestObjs.get(ref);
    }
}

