/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.layers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectFactory;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.objects.raw.OCObject;
import org.jpedal.objects.raw.PdfKeyPairsIterator;
import org.jpedal.objects.raw.PdfObject;

public class PdfLayerList {
    private int OCpageNumber = -1;
    public static final char deliminator = '\uffff';
    private static final String layerNameSeparator = Character.toString('\ufffe');
    private final Map<String, Integer> layerNames = new LinkedHashMap<String, Integer>();
    private final Map<String, String> streamToName = new HashMap<String, String>();
    private final Map<String, String> layersEnabled = new HashMap<String, String>();
    private final Map<String, String> metaData = new HashMap<String, String>();
    private final Map<String, String> layersTested = new HashMap<String, String>();
    private final Map<String, String> layerLocks = new HashMap<String, String>();
    private boolean changesMade;
    private int OCBaseState;
    private Map<String, PdfObject> propertyMap;
    private Map<String, String> refToPropertyID;
    private Map<String, String> refTolayerName;
    private Map<String, String> RBconstraints;
    private final Map<String, Float> minScale = new HashMap<String, Float>();
    private final Map<String, Float> maxScale = new HashMap<String, Float>();
    private int layerCount;
    private Object[] order;
    private byte[][] on;
    private byte[][] off;
    private PdfObjectReader currentPdfFile;

    public void init(PdfObject OCProperties, PdfObject PropertiesObj, PdfObjectReader currentPdfFile, int pageNumber) {
        String val;
        PdfObject layerDict;
        this.OCpageNumber = pageNumber;
        this.propertyMap = new HashMap<String, PdfObject>();
        this.refToPropertyID = new HashMap<String, String>();
        this.refTolayerName = new HashMap<String, String>();
        this.RBconstraints = new HashMap<String, String>();
        this.currentPdfFile = currentPdfFile;
        if (PropertiesObj != null) {
            this.setupOCMaps(PropertiesObj, currentPdfFile);
        }
        if ((layerDict = OCProperties.getDictionary(20)) == null) {
            return;
        }
        this.OCBaseState = layerDict.getNameAsConstant(1970567530);
        if (this.OCBaseState == -1) {
            this.OCBaseState = 7966;
        }
        this.order = layerDict.getObjectArray(1110717793);
        this.addLayer(this.OCBaseState, this.order, null, false);
        this.on = layerDict.getKeyArray(7966);
        if (this.OCBaseState != 7966) {
            this.addLayer(7966, this.on);
        }
        this.off = layerDict.getKeyArray(0x1F1616);
        if (this.OCBaseState != 0x1F1616) {
            this.addLayer(0x1F1616, this.off);
        }
        if (this.OCBaseState == 7966) {
            for (String ref : this.refToPropertyID.keySet()) {
                String layerName = this.refToPropertyID.get(ref);
                String layerTitle = this.streamToName.get(layerName);
                if (layerTitle != null) {
                    layerName = layerTitle;
                }
                this.refTolayerName.put(ref, layerName);
                if (this.layersTested.containsKey(layerName)) continue;
                this.layersTested.put(layerName, "x");
                this.layersEnabled.put(layerName, "x");
            }
        }
        this.setLocks(currentPdfFile, layerDict.getKeyArray(859525491));
        this.setConstraints(layerDict.getKeyArray(1633113989));
        this.setAS(layerDict.getKeyArray(4387), currentPdfFile);
        Object keys = new int[]{506543413, 827818359};
        String[] titles = new String[]{"Name", "Creator"};
        int count = ((Object)keys).length;
        for (int jj = 0; jj < count; ++jj) {
            val = layerDict.getTextStreamValue((int)keys[jj]);
            if (val == null) continue;
            this.metaData.put(titles[jj], val);
        }
        val = layerDict.getName(964196217);
        if (val != null) {
            this.metaData.put("ListMode", val);
        }
    }

    private void setConstraints(byte[][] layer) {
        int ii;
        if (layer == null) {
            return;
        }
        int layerCount = layer.length;
        String[] layers = new String[layerCount];
        for (ii = 0; ii < layerCount; ++ii) {
            String ref = new String(layer[ii]);
            layers[ii] = this.refTolayerName.get(ref);
        }
        for (ii = 0; ii < layerCount; ++ii) {
            if (!this.isLayerName(layers[ii])) continue;
            StringBuilder effectedLayers = new StringBuilder();
            for (int ii2 = 0; ii2 < layerCount; ++ii2) {
                if (ii == ii2) continue;
                effectedLayers.append(layers[ii2]).append(layerNameSeparator);
            }
            this.RBconstraints.put(layers[ii], effectedLayers.toString());
        }
    }

    private void setupOCMaps(PdfObject propertiesObj, PdfObjectReader currentPdfFile) {
        PdfKeyPairsIterator keyPairs = propertiesObj.getKeyPairsIterator();
        PdfFileReader pdfFileReader = currentPdfFile.getObjectReader();
        while (keyPairs.hasMorePairs()) {
            String glyphKey = keyPairs.getNextKeyAsString();
            PdfObject glyphObj = PdfObjectFactory.getPDFObjectObjectFromRefOrDirect(new OCObject(propertiesObj.getObjectRefAsString()), pdfFileReader, keyPairs.getNextValueAsBytes(), -1567847737);
            String ref = glyphObj.getObjectRefAsString();
            currentPdfFile.checkResolved(glyphObj);
            byte[][] childPairs = glyphObj.getKeyArray(521344835);
            if (childPairs != null) {
                this.setupchildOCMaps(childPairs, glyphKey, currentPdfFile);
            } else {
                this.propertyMap.put(ref, glyphObj);
                String currentNames = this.refToPropertyID.get(ref);
                if (currentNames == null) {
                    this.refToPropertyID.put(ref, glyphKey);
                } else {
                    this.refToPropertyID.put(ref, currentNames + layerNameSeparator + glyphKey);
                }
                String layerName = glyphObj.getTextStreamValue(506543413);
                if (layerName != null) {
                    PdfLayerList.addStreamToNameMapping(this.streamToName, glyphKey, layerName);
                }
            }
            keyPairs.nextPair();
        }
    }

    private void setupchildOCMaps(byte[][] keys, String glyphKey, PdfObjectReader currentPdfFile) {
        for (byte[] key : keys) {
            String ref = new String(key);
            OCObject glyphObj = new OCObject(ref);
            currentPdfFile.readObject(glyphObj);
            currentPdfFile.checkResolved(glyphObj);
            byte[][] childPairs = ((PdfObject)glyphObj).getKeyArray(521344835);
            if (childPairs != null) {
                this.setupchildOCMaps(childPairs, glyphKey, currentPdfFile);
                continue;
            }
            this.propertyMap.put(ref, glyphObj);
            String currentNames = this.refToPropertyID.get(ref);
            if (currentNames == null) {
                this.refToPropertyID.put(ref, glyphKey);
                continue;
            }
            this.refToPropertyID.put(ref, currentNames + layerNameSeparator + glyphKey);
        }
    }

    private void addLayer(int status, Object[] layer, String parentName, boolean allowTextLabels) {
        int startPosition;
        if (layer == null) {
            return;
        }
        int layers = layer.length;
        if (allowTextLabels && layer[0] instanceof byte[] && !StreamReaderUtils.isRef((byte[])layer[0], 0)) {
            parentName = PdfLayerList.getTextLabelForLayerGroup(parentName, new String((byte[])layer[0]));
            startPosition = 1;
        } else {
            startPosition = 0;
        }
        for (int ii = startPosition; ii < layers; ++ii) {
            if (layer[ii] instanceof byte[]) {
                String newLayerName = this.addSingleLayer((byte[])layer[ii], parentName, status);
                if (newLayerName == null) continue;
                layer[ii] = newLayerName;
                continue;
            }
            if (layer[ii] instanceof String) continue;
            this.addLayer(status, (Object[])layer[ii], parentName, true);
        }
    }

    private String addSingleLayer(byte[] rawRef, String parentName, int status) {
        String layerName = null;
        String ref = new String(rawRef);
        String name = this.refToPropertyID.get(ref);
        PdfObject nextObject = this.propertyMap.get(ref);
        if (nextObject == null && StreamReaderUtils.isRef(rawRef, 0)) {
            nextObject = new OCObject(ref);
            this.currentPdfFile.readObject(nextObject);
            name = ref;
        }
        if (nextObject != null) {
            ++this.layerCount;
            layerName = nextObject.getTextStreamValue(506543413);
            if (parentName != null) {
                layerName = layerName + '\uffff' + parentName;
            }
            this.refTolayerName.put(ref, layerName);
            this.layerNames.put(layerName, status);
            PdfLayerList.addStreamToNameMapping(this.streamToName, name, layerName);
            if (status == 7966) {
                this.layersEnabled.put(layerName, "x");
            } else {
                this.layersEnabled.remove(layerName);
            }
        }
        return layerName;
    }

    private static String getTextLabelForLayerGroup(String parentName, String ref) {
        if (parentName == null) {
            return ref;
        }
        return ref + '\uffff' + parentName;
    }

    private void addLayer(int status, byte[][] layer) {
        if (layer == null) {
            return;
        }
        for (byte[] aLayer : layer) {
            String layerName;
            String ref = new String(aLayer);
            String name = this.refToPropertyID.get(ref);
            PdfObject nextObject = this.propertyMap.get(ref);
            if (nextObject != null) {
                String possName;
                ++this.layerCount;
                String potentialName = nextObject.getTextStreamValue(506543413);
                if ((status == 7966 || status == 0x1F1616) && (possName = this.refTolayerName.get(ref)) != null) {
                    potentialName = possName;
                }
                layerName = potentialName;
            } else {
                layerName = this.refTolayerName.get(ref);
            }
            if (layerName == null) continue;
            if (this.refTolayerName.get(ref) == null) {
                this.refTolayerName.put(ref, layerName);
                this.layerNames.put(layerName, status);
            }
            if (this.streamToName.get(name) == null) {
                PdfLayerList.addStreamToNameMapping(this.streamToName, name, layerName);
            }
            if (status == 7966) {
                this.layersEnabled.put(layerName, "x");
            } else {
                this.layersEnabled.remove(layerName);
            }
            this.layersTested.put(layerName, "x");
        }
    }

    private void setAS(byte[][] AS, PdfObjectReader currentPdfFile) {
        if (AS == null) {
            return;
        }
        for (byte[] A2 : AS) {
            byte[][] OCGs;
            if (A2 == null) continue;
            String ref = new String(A2);
            OCObject nextObject = new OCObject(ref);
            nextObject.setUnresolvedData(A2, 4387);
            currentPdfFile.checkResolved(nextObject);
            int event = ((PdfObject)nextObject).getNameAsConstant(1177894489);
            if (event != 641283399 || (OCGs = ((PdfObject)nextObject).getKeyArray(521344835)) == null) continue;
            for (byte[] OCG : OCGs) {
                float max;
                PdfObject zoomObj;
                ref = new String(OCG);
                nextObject = new OCObject(ref);
                nextObject.setUnresolvedData(OCG, 521344835);
                currentPdfFile.checkResolved(nextObject);
                String layerName = nextObject.getTextStreamValue(506543413);
                String name = this.refToPropertyID.get(ref);
                if (name == null && this.refToPropertyID.isEmpty()) {
                    name = "MC0";
                }
                PdfLayerList.addStreamToNameMapping(this.streamToName, name, layerName);
                PdfObject usageObj = ((PdfObject)nextObject).getDictionary(1127298906);
                if (usageObj == null || (zoomObj = usageObj.getDictionary(708788029)) == null) continue;
                float min = zoomObj.getFloatNumber(4012350);
                if (min != 0.0f) {
                    this.minScale.put(layerName, Float.valueOf(min));
                }
                if ((max = zoomObj.getFloatNumber(4010312)) == 0.0f) continue;
                this.maxScale.put(layerName, Float.valueOf(max));
            }
        }
    }

    private void setLocks(PdfObjectReader currentPdfFile, byte[][] layer) {
        if (layer == null) {
            return;
        }
        for (byte[] aLayer : layer) {
            String nextValue = new String(aLayer);
            OCObject nextObject = new OCObject(nextValue);
            currentPdfFile.readObject(nextObject);
            String layerName = nextObject.getTextStreamValue(506543413);
            this.layerLocks.put(layerName, "x");
        }
    }

    public Map<String, String> getMetaData() {
        return Collections.unmodifiableMap(this.metaData);
    }

    public Object[] getDisplayTree() {
        if (this.order != null) {
            return this.order;
        }
        return this.getNames();
    }

    private String[] getNames() {
        int count = this.layerNames.size();
        String[] nameList = new String[count];
        Iterator<String> names = this.layerNames.keySet().iterator();
        int jj = 0;
        while (names.hasNext()) {
            nameList[jj] = names.next();
            ++jj;
        }
        return nameList;
    }

    public boolean decodeLayer(String name, boolean isID) {
        boolean isLayerVisible;
        block6: {
            String layerName;
            block5: {
                String mappedName;
                if (this.layerCount == 0) {
                    return true;
                }
                isLayerVisible = false;
                layerName = name;
                if (isID && (mappedName = this.streamToName.get(name)) != null) {
                    layerName = mappedName;
                }
                if (layerName == null) {
                    return false;
                }
                if (layerName.contains(layerNameSeparator)) break block5;
                isLayerVisible = this.layersEnabled.containsKey(layerName);
                if (!isLayerVisible) break block6;
                isLayerVisible = this.hiddenByParent(layerName);
                break block6;
            }
            StringTokenizer names = new StringTokenizer(layerName, layerNameSeparator);
            while (names.hasMoreTokens()) {
                String nextName = names.nextToken();
                isLayerVisible = this.layersEnabled.containsKey(nextName);
                if (isLayerVisible) {
                    isLayerVisible = this.hiddenByParent(nextName);
                }
                if (!isLayerVisible) continue;
                break;
            }
        }
        return isLayerVisible;
    }

    public void decodeOCRObjectFromXForm(byte[] OCR, String name) {
        if (!this.refTolayerName.containsKey(name)) {
            PdfObject viewState;
            PdfObject OCGDictionary;
            OCObject OCRobj = new OCObject(new String(OCR));
            this.currentPdfFile.readObject(OCRobj);
            this.currentPdfFile.checkResolved(OCRobj);
            byte[][] OCGS = ((PdfObject)OCRobj).getKeyArray(521344835);
            String layerName = null;
            if (OCGS != null) {
                for (byte[] OCG : OCGS) {
                    String ref = new String(OCG);
                    layerName = this.getNameFromRef(ref);
                }
            }
            if (layerName == null && (OCGDictionary = ((PdfObject)OCRobj).getDictionary(521344835)) != null) {
                layerName = OCGDictionary.getTextStreamValue(506543413);
            }
            if (layerName == null) {
                layerName = OCRobj.getTextStreamValue(506543413);
            }
            this.refTolayerName.put(name, layerName);
            if (!this.streamToName.containsKey(name)) {
                PdfLayerList.addStreamToNameMapping(this.streamToName, name, layerName);
            }
            PdfObject usage = ((PdfObject)OCRobj).getDictionary(1127298906);
            Set<String> keys = this.layerNames.keySet();
            String finalLayerName = layerName;
            boolean layerNotFound = keys.stream().noneMatch(s2 -> s2 != null && (s2.equals(finalLayerName) || s2.contains(finalLayerName + '\uffff')));
            if (layerNotFound) {
                this.layerNames.put(layerName, this.OCBaseState);
                if (this.OCBaseState == 7966) {
                    this.layersEnabled.put(layerName, "x");
                } else {
                    this.layersEnabled.remove(layerName);
                }
                if (this.OCBaseState != 7966) {
                    this.addLayer(7966, this.on);
                }
                if (this.OCBaseState != 0x1F1616) {
                    this.addLayer(0x1F1616, this.off);
                }
            }
            if (usage != null && (viewState = usage.getDictionary(641283399)) != null) {
                boolean isVisible;
                boolean bl2 = isVisible = viewState.getNameAsConstant(2103872382) == 7966;
                if (isVisible) {
                    this.layersEnabled.put(layerName, "X");
                } else {
                    this.layersEnabled.remove(layerName);
                }
            }
        }
    }

    private boolean hiddenByParent(String layerName) {
        boolean layerVisible = true;
        int id2 = layerName.indexOf(65535);
        if (id2 != -1) {
            String parent = layerName.substring(id2 + 1);
            while (parent != null && layerVisible && this.isLayerName(parent)) {
                layerVisible = this.decodeLayer(parent, false);
                layerName = parent;
                id2 = layerName.indexOf(65535);
                if (id2 == -1) {
                    parent = null;
                    continue;
                }
                parent = layerName.substring(id2 + 1);
            }
        }
        return layerVisible;
    }

    public boolean setZoom(float scaling) {
        String layerName;
        Iterator<String> minZoomLayers = this.minScale.keySet().iterator();
        while (minZoomLayers.hasNext()) {
            layerName = minZoomLayers.next();
            Float minScalingValue = this.minScale.get(layerName);
            if (minScalingValue == null) continue;
            if (scaling < minScalingValue.floatValue()) {
                this.layersEnabled.remove(layerName);
                this.changesMade = true;
                continue;
            }
            if (this.layersEnabled.containsKey(layerName)) continue;
            this.layersEnabled.put(layerName, "x");
            this.changesMade = true;
        }
        Iterator<String> maxZoomLayers = this.maxScale.keySet().iterator();
        while (maxZoomLayers.hasNext()) {
            layerName = minZoomLayers.next();
            Float maxScalingValue = this.maxScale.get(layerName);
            if (maxScalingValue == null) continue;
            if (scaling > maxScalingValue.floatValue()) {
                this.layersEnabled.remove(layerName);
                this.changesMade = true;
                continue;
            }
            if (this.layersEnabled.containsKey(layerName)) continue;
            this.layersEnabled.put(layerName, "x");
            this.changesMade = true;
        }
        return this.changesMade;
    }

    public boolean isVisible(String layerName) {
        return this.layersEnabled.containsKey(layerName);
    }

    public void setVisiblity(String layerName, boolean isVisible) {
        if (isVisible) {
            this.layersEnabled.put(layerName, "x");
            String layersToDisable = this.RBconstraints.get(layerName);
            if (layersToDisable != null) {
                StringTokenizer layers = new StringTokenizer(layersToDisable, layerNameSeparator);
                while (layers.hasMoreTokens()) {
                    this.layersEnabled.remove(layers.nextToken());
                }
            }
        } else {
            this.layersEnabled.remove(layerName);
        }
        this.changesMade = true;
    }

    public boolean isVisible(PdfObject XObject2) {
        boolean isVisible = true;
        PdfObject layerObj = XObject2.getDictionary(7955);
        if (layerObj != null) {
            String layerName = null;
            PdfObject OCGs_as_dictionary = layerObj.getDictionary(521344835);
            if (OCGs_as_dictionary != null) {
                PdfObject viewState;
                layerName = OCGs_as_dictionary.getTextStreamValue(506543413);
                PdfObject usage = OCGs_as_dictionary.getDictionary(1127298906);
                if (usage != null && (viewState = usage.getDictionary(641283399)) != null) {
                    return viewState.getNameAsConstant(2103872382) == 7966;
                }
            } else {
                byte[][] OCGS = layerObj.getKeyArray(521344835);
                if (OCGS != null) {
                    for (byte[] OCG : OCGS) {
                        String ref = new String(OCG);
                        layerName = this.getNameFromRef(ref);
                    }
                }
            }
            if (layerName == null) {
                layerName = layerObj.getTextStreamValue(506543413);
            }
            if (layerName != null && this.isLayerName(layerName)) {
                isVisible = this.isVisible(layerName);
            }
        }
        return isVisible;
    }

    public boolean isLocked(String layerName) {
        return this.layerLocks.containsKey(layerName);
    }

    public boolean getChangesMade() {
        return this.changesMade;
    }

    public boolean isLayerName(String name) {
        return this.layerNames.containsKey(name);
    }

    public int getLayersCount() {
        return this.layerCount;
    }

    public String getNameFromRef(String ref) {
        return this.refTolayerName.get(ref);
    }

    public int getOCpageNumber() {
        return this.OCpageNumber;
    }

    private static void addStreamToNameMapping(Map<String, String> streamToName, String name, String layerName) {
        if (name != null) {
            if (!name.contains(layerNameSeparator)) {
                PdfLayerList.addSingleNameMapping(streamToName, name, layerName);
            } else {
                StringTokenizer names = new StringTokenizer(name, layerNameSeparator);
                while (names.hasMoreTokens()) {
                    PdfLayerList.addSingleNameMapping(streamToName, names.nextToken(), layerName);
                }
            }
        }
    }

    private static void addSingleNameMapping(Map<String, String> streamToName, String name, String layerName) {
        String oldValue = streamToName.get(name);
        if (oldValue == null) {
            streamToName.put(name, layerName);
        } else {
            streamToName.put(name, oldValue + layerNameSeparator + layerName);
        }
    }
}

