/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.overridingImplementations;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.io.PdfObjectFactory;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.acroforms.GUIData;
import org.jpedal.objects.acroforms.overridingImplementations.CustomImageIcon;
import org.jpedal.objects.raw.FontObject;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.FormStream;
import org.jpedal.objects.raw.PdfKeyPairsIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.XObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.StringUtils;

public class ReadOnlyTextIcon
extends CustomImageIcon {
    private boolean currentlyPrinting;
    private int printMultiplier = 1;
    private int alignment = -1;
    private static final long serialVersionUID = 8946195842453749725L;
    private BufferedImage rootImage;
    private BufferedImage finalImage;
    private PdfObject fakeObj;
    private boolean textChanged;
    private String preFontStream = "";
    private String betweenFontAndTextStream = "";
    private String afterTextStream = "";
    private String text = "";
    private String fontName = "";
    private String fontSize = "12";
    private String fontCommand = "";
    private final PdfObjectReader currentpdffile;
    private final PdfObject resources;
    private final PdfObject form;

    public ReadOnlyTextIcon(PdfObject form, int iconRot, PdfObjectReader pdfObjectReader, PdfObject res) {
        super(iconRot);
        this.form = form;
        this.currentpdffile = pdfObjectReader;
        this.resources = res;
    }

    @Override
    public Image getImage() {
        this.checkAndCreateimage();
        BufferedImage image = this.finalImage;
        return image;
    }

    public BufferedImage drawToBufferedImage() {
        BufferedImage bufImg = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics g2 = bufImg.getGraphics();
        this.paintIcon(null, g2, 0, 0);
        g2.dispose();
        return bufImg;
    }

    @Override
    public synchronized void paintIcon(Component c2, Graphics g2, int x2, int y2) {
        BufferedImage image = (BufferedImage)this.getImage();
        if (image == null) {
            return;
        }
        if (c2 != null && c2.isEnabled()) {
            g2.setColor(c2.getBackground());
        } else {
            g2.setColor(Color.gray);
        }
        Graphics2D g22 = (Graphics2D)g2;
        if (this.iconWidth > 0 && this.iconHeight > 0) {
            int drawWidth = this.iconWidth;
            int drawHeight = this.iconHeight;
            if (this.displaySingle && (this.iconRotation == 270 || this.iconRotation == 90)) {
                drawWidth = this.iconHeight;
                drawHeight = this.iconWidth;
            }
            if (this.currentpdffile != null) {
                float hs;
                float ws = (float)drawWidth / (float)image.getWidth(null);
                if (ws < (hs = (float)drawHeight / (float)image.getHeight(null))) {
                    drawWidth = (int)(ws * (float)image.getWidth(null));
                    drawHeight = (int)(ws * (float)image.getHeight(null));
                } else {
                    drawWidth = (int)(hs * (float)image.getWidth(null));
                    drawHeight = (int)(hs * (float)image.getHeight(null));
                }
            }
            int posX = 0;
            int posY = 0;
            if (this.currentpdffile != null) {
                if (this.displaySingle && (this.iconRotation == 270 || this.iconRotation == 90)) {
                    posX = (this.iconHeight - drawWidth) / 2;
                    posY = (this.iconWidth - drawHeight) / 2;
                } else {
                    posX = (this.iconWidth - drawWidth) / 2;
                    posY = (this.iconHeight - drawHeight) / 2;
                }
            }
            if (this.alignment == 2) {
                posX = 0;
            }
            int finalRotation = this.displaySingle ? ReadOnlyTextIcon.validateRotationValue(this.pageRotate - this.iconRotation) : this.pageRotate;
            switch (finalRotation) {
                case 270: {
                    g22.rotate(-1.5707963267948966);
                    g22.translate(-drawWidth, 0);
                    g22.drawImage(image, -posX, posY, drawWidth, drawHeight, null);
                    break;
                }
                case 90: {
                    g22.rotate(1.5707963267948966);
                    g22.translate(0, -drawHeight);
                    g22.drawImage(image, posX, -posY, drawWidth, drawHeight, null);
                    break;
                }
                case 180: {
                    g22.rotate(Math.PI);
                    g22.translate(-drawWidth, -drawHeight);
                    g22.drawImage(image, -posX, -posY, drawWidth, drawHeight, null);
                    break;
                }
                default: {
                    g22.drawImage(image, posX, posY, drawWidth, drawHeight, null);
                    break;
                }
            }
        } else {
            g22.drawImage((Image)image, 0, 0, null);
        }
        g22.translate(-x2, -y2);
    }

    private void checkAndCreateimage() {
        if (this.currentpdffile == null) {
            return;
        }
        int newWidth = this.iconWidth;
        int newHeight = this.iconHeight;
        if (this.currentlyPrinting) {
            newWidth = this.iconWidth * this.printMultiplier;
            newHeight = this.iconHeight * this.printMultiplier;
        }
        if (this.textChanged || this.rootImage == null || newWidth > this.rootImage.getWidth(null) || newHeight > this.rootImage.getHeight(null) || (float)newWidth < (float)this.rootImage.getWidth(null) / 1.5f || (float)newHeight < (float)this.rootImage.getHeight(null) / 1.5f) {
            this.rootImage = FormStream.decode(this.form, this.currentpdffile, this.fakeObj, -1, newWidth, newHeight, 0, 1.0f);
            this.finalImage = FormStream.rotate(this.rootImage, this.iconRotation);
            this.textChanged = false;
        }
    }

    private static String escapeValues(String text) {
        return text.replace("\\", "\\\\").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t").replace("\b", "\\b").replace("\f", "\\f").replace("(", "\\050").replace(")", "\\051");
    }

    private static String wrapText(String textToWrap, int maxLength, String fontName, String fontSize) {
        FontMetrics fm = new Canvas().getFontMetrics(new Font(fontName, 0, (int)Float.parseFloat(fontSize)));
        String[] lines = textToWrap.split("[\\n\\r]");
        RectangularShape r2 = null;
        for (String line : lines) {
            if (r2 == null) {
                r2 = fm.getStringBounds(line, null);
                continue;
            }
            Rectangle2D bounds = fm.getStringBounds(line, null);
            if (bounds.getWidth() > r2.getWidth()) {
                ((Rectangle2D)r2).setRect(r2.getX(), r2.getY(), bounds.getWidth(), r2.getHeight());
            }
            ((Rectangle2D)r2).setRect(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight() + bounds.getHeight());
        }
        if (r2 != null && r2.getWidth() > (double)maxLength) {
            String[] words = textToWrap.split(" ");
            StringBuilder modifiedString = new StringBuilder();
            StringBuilder lineBuilder = new StringBuilder();
            for (String word : words) {
                r2 = fm.getStringBounds(lineBuilder + word, null);
                if (r2.getWidth() > (double)maxLength) {
                    lineBuilder.append(word).append('\n');
                    modifiedString.append((CharSequence)lineBuilder);
                    lineBuilder = new StringBuilder();
                    continue;
                }
                lineBuilder.append(word).append(' ');
            }
            modifiedString.append((CharSequence)lineBuilder);
            return modifiedString.toString();
        }
        return textToWrap;
    }

    public void setText(String str) {
        if (str == null) {
            str = "";
        }
        if (str.equals(this.text)) {
            return;
        }
        this.textChanged = true;
        this.text = str;
        PdfObject xobj = new PdfObject("1 10 X");
        do {
            xobj.setDecodedStream(StringUtils.toBytes(this.afterTextStream));
            String tj = FormStream.decipherTextFromAP(this.currentpdffile, xobj);
            if (tj == null || !this.text.contains(tj)) break;
            int endOfTj = this.afterTextStream.indexOf(" Tj", this.afterTextStream.indexOf(tj)) + 3;
            this.afterTextStream = this.afterTextStream.substring(endOfTj);
        } while (!this.afterTextStream.isEmpty());
        this.text = ReadOnlyTextIcon.escapeValues(ReadOnlyTextIcon.wrapText(this.text, this.getIconWidth(), this.fontName, this.fontSize));
        int encodingInt = ReadOnlyTextIcon.getTextEncoding(this.resources, this.currentpdffile, this.fontName);
        this.text = ReadOnlyTextIcon.encodeText(encodingInt, this.text);
        String decodedStreamAsString = this.createPDFStreamForText(this.form, this.text);
        try {
            this.fakeObj.setDecodedStream(decodedStreamAsString.getBytes("Cp1252"));
        }
        catch (UnsupportedEncodingException e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
    }

    private String createPDFStreamForText(PdfObject form, String text) {
        PdfObject MK;
        float[] bg2;
        StringBuilder builder = new StringBuilder();
        Rectangle rect = ((FormObject)form).getBoundingRectangle();
        builder.append(0).append(' ').append(0).append(' ').append(rect.width).append(' ').append(rect.height).append(" re\n");
        builder.append("W\n");
        builder.append("n\n");
        if (text.contains("\\n") || text.contains("\\r")) {
            builder.append(this.handleMultiLineText());
        } else {
            builder.append(this.handleSingleLineText());
        }
        Color BG = null;
        if (form.getDictionary(7451) != null && (bg2 = (MK = form.getDictionary(7451)).getFloatArray(4631)) != null) {
            int i2;
            boolean colorOutOfBounds = false;
            for (i2 = 0; i2 != bg2.length; ++i2) {
                if (!(bg2[i2] > 1.0f)) continue;
                colorOutOfBounds = true;
                break;
            }
            if (colorOutOfBounds) {
                for (i2 = 0; i2 != bg2.length; ++i2) {
                    if (!(bg2[i2] > 1.0f)) continue;
                    int n2 = i2;
                    bg2[n2] = bg2[n2] / 255.0f;
                }
            }
            if (bg2.length > 0) {
                switch (bg2.length) {
                    case 1: {
                        BG = new Color(bg2[0], bg2[0], bg2[0], 1.0f);
                        break;
                    }
                    case 3: {
                        BG = new Color(bg2[0], bg2[1], bg2[2], 1.0f);
                    }
                }
            }
        }
        if (BG != null) {
            builder.insert(0, ReadOnlyTextIcon.fillBackgroundCommands((FormObject)form, BG));
        }
        return builder.toString();
    }

    private static String encodeText(int encoding, String text) {
        StringBuilder encoded = new StringBuilder();
        for (int i2 = 0; i2 != text.length(); ++i2) {
            char character = text.charAt(i2);
            int glyphInt = character & 0xFF;
            String characterName = StandardFonts.getUnicodeChar(6, glyphInt);
            int charGlyph = StandardFonts.lookupCharacterIndex(characterName, encoding);
            if (charGlyph >= 128) {
                encoded.append('\\').append(Integer.toOctalString(charGlyph));
                continue;
            }
            encoded.append((char)charGlyph);
        }
        return encoded.toString();
    }

    private static int getTextEncoding(PdfObject resources, PdfObjectReader currentpdffile, String fontName) {
        int encodingInt = 0;
        if (resources != null) {
            PdfKeyPairsIterator fontKeys = resources.getDictionary(373243460).getKeyPairsIterator();
            while (fontKeys.hasMorePairs()) {
                String fontNameSubString;
                String resourceFontName = fontKeys.getNextKeyAsString();
                if (resourceFontName.equals(fontNameSubString = fontName.substring(1, fontName.length() - 1))) {
                    int fontEncoding;
                    String fontRefStr = fontKeys.getNextValueAsString();
                    byte[] fontRef = fontKeys.getNextValueAsBytes();
                    PdfObject fontObj = PdfObjectFactory.getPDFObjectObjectFromRefOrDirect(new FontObject(fontRefStr), currentpdffile.getObjectReader(), fontRef, 373243460);
                    PdfObject encoding = fontObj.getDictionary(1232564598);
                    if (encoding == null || (fontEncoding = encoding.getGeneralType(1232564598)) == -1) break;
                    encodingInt = fontEncoding;
                    break;
                }
                fontKeys.nextPair();
            }
        }
        return encodingInt;
    }

    private static String fillBackgroundCommands(FormObject form, Color BG) {
        return String.valueOf(BG.getRed()) + ' ' + BG.getGreen() + ' ' + BG.getBlue() + " rg 0 0 " + (form.getBoundingRectangle().width - 3) + ' ' + (form.getBoundingRectangle().height - 3) + " re f ";
    }

    private String handleSingleLineText() {
        int alignmentX = 2;
        int alignmentY = (int)((float)((FormObject)this.form).getBoundingRectangle().height - Float.parseFloat(this.fontSize)) + 2;
        if (this.form.getNameAsConstant(1147962727) != 980909433) {
            alignmentY = (int)((float)((FormObject)this.form).getBoundingRectangle().height - Float.parseFloat(this.fontSize)) / 2;
            if (alignmentY < 2) {
                alignmentY = 2;
            }
            if (((FormObject)this.form).getAlignment() != 2) {
                FontMetrics fm = new Canvas().getFontMetrics(new Font(this.fontName, 0, (int)Float.parseFloat(this.fontSize)));
                Rectangle2D r2 = fm.getStringBounds(this.text, null);
                switch (((FormObject)this.form).getAlignment()) {
                    case 0: {
                        alignmentX = (int)((double)((FormObject)this.form).getBoundingRectangle().width - r2.getWidth()) / 2;
                        break;
                    }
                    case 4: {
                        alignmentX = (int)((double)((FormObject)this.form).getBoundingRectangle().width - r2.getWidth()) - 2;
                    }
                }
            }
        }
        return this.preFontStream + this.fontName + this.fontSize + this.fontCommand + this.betweenFontAndTextStream + alignmentX + ' ' + alignmentY + " Td (" + this.text + ")Tj " + this.afterTextStream;
    }

    private String handleMultiLineText() {
        String unescaped = this.text.replaceAll("(\\\\n)|(\\\\r)", "\n");
        StringTokenizer lines = new StringTokenizer(unescaped, "\n\r", false);
        int alignmentX = 2;
        int alignmentY = ((FormObject)this.form).getBoundingRectangle().height;
        StringBuilder builder = new StringBuilder();
        builder.append(this.preFontStream).append(this.fontName).append(this.fontSize).append(this.fontCommand).append(this.betweenFontAndTextStream).append(' ').append(alignmentX).append(' ').append(alignmentY).append(" Td ");
        int xPoint = 0;
        while (lines.hasMoreTokens()) {
            String nextLine = lines.nextToken();
            FontMetrics fm = new Canvas().getFontMetrics(new Font(this.fontName, 0, (int)Float.parseFloat(this.fontSize)));
            Rectangle2D r2 = fm.getStringBounds(nextLine, null);
            if (((FormObject)this.form).getAlignment() != -1) {
                switch (((FormObject)this.form).getAlignment()) {
                    case 2: {
                        alignmentX = 0;
                        break;
                    }
                    case 0: {
                        alignmentX = (int)((double)((FormObject)this.form).getBoundingRectangle().width - r2.getWidth()) / 2;
                        alignmentX -= xPoint;
                        break;
                    }
                    case 4: {
                        alignmentX = (int)((double)((FormObject)this.form).getBoundingRectangle().width - r2.getWidth());
                        alignmentX -= xPoint;
                    }
                }
            }
            alignmentY = (int)(-(r2.getHeight() + 2.0));
            builder.append(' ').append(alignmentX).append(' ').append(alignmentY).append(" Td (").append(nextLine).append(")Tj ");
            xPoint += alignmentX;
        }
        builder.append(this.afterTextStream);
        return builder.toString();
    }

    public void decipherAppObject(FormObject form) {
        this.fakeObj = ReadOnlyTextIcon.createFakeObject(form, this.resources);
        String DA = form.getTextStreamValue(5137);
        if (DA != null && !DA.isEmpty()) {
            StringTokenizer tokens = new StringTokenizer(DA, "() []");
            int tokenCount = tokens.countTokens();
            String[] tokenValues = new String[tokenCount];
            int i2 = 0;
            while (tokens.hasMoreTokens()) {
                tokenValues[i2] = tokens.nextToken();
                ++i2;
            }
            StringBuilder builder = new StringBuilder();
            for (i2 = tokenCount - 1; i2 > -1; --i2) {
                if ("Tf".equals(tokenValues[i2])) {
                    if (i2 < 2) continue;
                    this.fontName = tokenValues[i2 - 2] + ' ';
                    this.fontSize = tokenValues[i2 - 1] + ' ';
                    float fontSizeFloat = Float.parseFloat(this.fontSize);
                    Rectangle BBox = form.getBoundingRectangle();
                    if (BBox != null && fontSizeFloat <= 0.0f) {
                        this.fontSize = GUIData.calculateFontSize(BBox.height, BBox.width, false, this.text) + " ";
                    }
                    this.fontCommand = "Tf ";
                    i2 -= 2;
                    continue;
                }
                builder.insert(0, tokenValues[i2] + ' ');
            }
            this.fontCommand = this.fontCommand + builder.toString();
        } else {
            Font textFont = form.getTextFont();
            this.fontName = '/' + textFont.getFontName() + ' ';
            this.fontCommand = "Tf ";
            this.fontSize = "12 ";
        }
        if (this.preFontStream.isEmpty() || !this.preFontStream.contains("BT")) {
            this.preFontStream = "BT 0 0 0 RG 1 TFS ";
            this.betweenFontAndTextStream = " 1 0 0 1 0 0 Tm ";
            this.afterTextStream = "";
        }
    }

    private static XObject createFakeObject(FormObject form, PdfObject resources) {
        Rectangle BBox;
        XObject fakeObj = new XObject(form.getObjectRefAsString());
        if (resources != null) {
            fakeObj.setDictionary(2004251818, resources);
        }
        if ((BBox = form.getBoundingRectangle()) != null) {
            fakeObj.setFloatArray(303185736, new float[]{BBox.width, 0.0f, 0.0f, BBox.height, 0.0f, 0.0f});
        }
        return fakeObj;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public void setPrinting(boolean print, int multiplier) {
        this.currentlyPrinting = print;
        this.printMultiplier = multiplier;
        this.checkAndCreateimage();
    }

    public PdfObject getFakeObject() {
        return this.fakeObj;
    }
}

