/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.overridingImplementations;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import org.jpedal.PdfDecoderInt;
import org.jpedal.objects.acroforms.actions.SwingListener;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.StringUtils;

public class PdfSwingPopup
extends JInternalFrame {
    private static final long serialVersionUID = 796302916236391896L;
    private final PopupTitleBar titleBar;
    private final PopupContentArea contentArea;
    private final FormObject formObject;

    public PdfSwingPopup(FormObject popupObj, int cropBoxWidth, SwingListener listener, PdfDecoderInt decode_pdf) {
        String contentString;
        String titleString;
        float[] col;
        this.formObject = popupObj;
        PdfObject parentObj = popupObj.getParentPdfObj();
        if (parentObj == null) {
            col = new float[]{255.0f, 255.0f, 0.0f};
            titleString = "";
            contentString = "";
        } else {
            String autherName;
            String modifiedDate;
            col = PdfSwingPopup.getColor(popupObj, parentObj);
            StringBuilder titleBuilder = new StringBuilder();
            String subject = parentObj.getTextStreamValue(591737402);
            if (subject != null) {
                titleBuilder.append(subject);
                titleBuilder.append('\t');
            }
            if ((modifiedDate = parentObj.getTextStreamValue(29)) != null) {
                PdfSwingPopup.addDate(titleBuilder, modifiedDate);
            }
            if ((autherName = popupObj.getTextStreamValue(36)) != null) {
                titleBuilder.append('\n');
                titleBuilder.append(autherName);
            }
            titleString = titleBuilder.toString();
            byte[] bContents = parentObj.getTextStreamValueAsByte(1216184967);
            if (bContents != null) {
                contentString = StringUtils.getTextString(bContents, true, true);
                if (contentString != null && contentString.indexOf(13) != -1) {
                    contentString = contentString.replaceAll("\r", "\n");
                }
            } else {
                contentString = "";
            }
        }
        ((BasicInternalFrameUI)this.getUI()).setNorthPane(null);
        this.setLayout(new BorderLayout());
        this.titleBar = new PopupTitleBar(titleString, decode_pdf);
        this.titleBar.setHighlighter(null);
        this.titleBar.setEditable(false);
        this.add((Component)this.titleBar, "North");
        this.setColor(col);
        this.contentArea = new PopupContentArea(contentString);
        this.contentArea.setWrapStyleWord(true);
        this.contentArea.setLineWrap(true);
        JScrollPane scrollPane = new JScrollPane(this.contentArea);
        this.add((Component)scrollPane, "Center");
        this.contentArea.addKeyListener(new PopupContentsUpdater());
        this.contentArea.addMouseListener(listener);
        this.contentArea.setOpaque(true);
        Font titFont = this.titleBar.getFont();
        int baseFontSize = (int)this.formObject.getFontSize();
        this.titleBar.setFont(new Font(titFont.getName(), titFont.getStyle(), baseFontSize - 1));
        Font curFont = this.contentArea.getFont();
        this.contentArea.setFont(new Font(curFont.getName(), curFont.getStyle(), baseFontSize - 2));
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e2) {
                PdfSwingPopup.this.toFront();
                super.focusGained(e2);
            }
        });
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameActivated(InternalFrameEvent e2) {
                JInternalFrame frame = e2.getInternalFrame();
                frame.getParent().setComponentZOrder(frame, 0);
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent e2) {
                JInternalFrame frame = e2.getInternalFrame();
                if (frame.getParent() != null) {
                    frame.getParent().setComponentZOrder(frame, 1);
                }
            }
        });
    }

    private static float[] getColor(FormObject popupObj, PdfObject parentObj) {
        float[] col = popupObj.getFloatArray(19);
        if (col == null) {
            col = parentObj.getFloatArray(19);
        }
        if (col == null || col.length != 3) {
            col = new float[]{255.0f, 255.0f, 0.0f};
        }
        return col;
    }

    private static void addDate(StringBuilder titleBuilder, String modifiedDate) {
        StringBuilder date = new StringBuilder(modifiedDate);
        date.delete(0, 2);
        date.insert(10, ':');
        date.insert(13, ':');
        date.insert(16, ' ');
        String year = date.substring(0, 4);
        String day = date.substring(6, 8);
        date.delete(6, 8);
        date.delete(0, 4);
        date.insert(0, day);
        date.insert(4, year);
        date.insert(2, '/');
        date.insert(5, '/');
        date.insert(10, ' ');
        titleBuilder.append((CharSequence)date);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        ((BasicInternalFrameUI)this.getUI()).setNorthPane(null);
    }

    public void setColor(float[] col) {
        Color bgColor = null;
        if (col != null) {
            bgColor = col[0] > 1.0f || col[1] > 1.0f || col[2] > 1.0f ? new Color((int)col[0], (int)col[1], (int)col[2]) : new Color(col[0], col[1], col[2]);
            this.setBorder(BorderFactory.createLineBorder(bgColor));
        }
        if (bgColor != null) {
            this.titleBar.setBackground(bgColor);
        }
    }

    @Override
    public void setFont(Font f2) {
        super.setFont(f2);
        int fontSize = f2.getSize();
        if (this.titleBar != null) {
            this.titleBar.setFont(this.titleBar.getFont().deriveFont((float)fontSize - 1.0f));
        }
        if (this.contentArea != null && this.titleBar != null) {
            this.contentArea.setFont(this.titleBar.getFont().deriveFont((float)fontSize - 2.0f));
        }
    }

    private class PopupContentsUpdater
    extends KeyAdapter {
        private PopupContentsUpdater() {
        }

        @Override
        public void keyReleased(KeyEvent e2) {
            PdfObject parentObj = PdfSwingPopup.this.formObject.getParentPdfObj();
            if (parentObj == null) {
                parentObj = PdfSwingPopup.this.formObject;
            }
            parentObj.setTextStreamValue(1216184967, StringUtils.toBytes(PdfSwingPopup.this.contentArea.getText()));
        }
    }

    private class PopupDragListener
    extends MouseInputAdapter {
        Point clickStart;
        final PdfDecoderInt decode_pdf;

        PopupDragListener(PdfDecoderInt decode_pdf) {
            this.decode_pdf = decode_pdf;
        }

        @Override
        public void mouseDragged(MouseEvent e2) {
            if (this.clickStart == null) {
                this.clickStart = e2.getPoint();
            }
            Point pt = e2.getPoint();
            Point curLoc = PdfSwingPopup.this.getLocation();
            int x2 = pt.x - this.clickStart.x;
            int y2 = pt.y - this.clickStart.y;
            curLoc.translate(x2, y2);
            x2 = curLoc.x - PdfSwingPopup.this.getLocation().x;
            y2 = curLoc.y - PdfSwingPopup.this.getLocation().y;
            float scaling = PdfSwingPopup.this.formObject.getCurrentScaling();
            float[] rect = PdfSwingPopup.this.formObject.getFloatArray(573911876);
            switch (this.decode_pdf.getDisplayRotation()) {
                case 90: {
                    rect[0] = rect[0] + (float)y2 / scaling;
                    rect[2] = rect[2] + (float)y2 / scaling;
                    rect[1] = rect[1] + (float)x2 / scaling;
                    rect[3] = rect[3] + (float)x2 / scaling;
                    break;
                }
                case 180: {
                    rect[0] = rect[0] - (float)x2 / scaling;
                    rect[2] = rect[2] - (float)x2 / scaling;
                    rect[1] = rect[1] + (float)y2 / scaling;
                    rect[3] = rect[3] + (float)y2 / scaling;
                    break;
                }
                case 270: {
                    rect[0] = rect[0] - (float)y2 / scaling;
                    rect[2] = rect[2] - (float)y2 / scaling;
                    rect[1] = rect[1] - (float)x2 / scaling;
                    rect[3] = rect[3] - (float)x2 / scaling;
                    break;
                }
                default: {
                    rect[0] = rect[0] + (float)x2 / scaling;
                    rect[2] = rect[2] + (float)x2 / scaling;
                    rect[1] = rect[1] - (float)y2 / scaling;
                    rect[3] = rect[3] - (float)y2 / scaling;
                }
            }
            PdfSwingPopup.this.formObject.setFloatArray(573911876, rect);
            if (!curLoc.equals(PdfSwingPopup.this.getLocation())) {
                PdfSwingPopup.this.setLocation(curLoc);
            }
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            this.clickStart = e2.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            this.clickStart = null;
        }
    }

    private class PopupContentArea
    extends JTextArea {
        PopupContentArea(String contents) {
            super(contents);
            PopupContentsUpdater listener = new PopupContentsUpdater();
            this.addKeyListener(listener);
        }
    }

    private class PopupTitleBar
    extends JTextArea {
        PopupTitleBar(String title, PdfDecoderInt decode_pdf) {
            super(title);
            PopupDragListener listener = new PopupDragListener(decode_pdf);
            this.addMouseMotionListener(listener);
            this.addMouseListener(listener);
        }
    }
}

