/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.creation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.jpedal.objects.acroforms.GUIData;
import org.jpedal.objects.acroforms.SwingData;
import org.jpedal.objects.acroforms.actions.SwingFormButtonListener;
import org.jpedal.objects.acroforms.actions.SwingListener;
import org.jpedal.objects.acroforms.creation.ComboColorRenderer;
import org.jpedal.objects.acroforms.creation.ComboListener;
import org.jpedal.objects.acroforms.creation.GenericFormFactory;
import org.jpedal.objects.acroforms.creation.ListListener;
import org.jpedal.objects.acroforms.creation.RadioListener;
import org.jpedal.objects.acroforms.creation.SwingAPImageHandler;
import org.jpedal.objects.acroforms.creation.TextDocumentListener;
import org.jpedal.objects.acroforms.overridingImplementations.FixImageIcon;
import org.jpedal.objects.acroforms.overridingImplementations.PdfSwingPopup;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.Strip;

public class SwingFormFactory
extends GenericFormFactory {
    private JButton setupAnnotationButton(FormObject form) {
        JButton but = new JButton();
        this.setupButton(but, form);
        this.setupUniversalFeatures(but, form);
        but.setFocusPainted(false);
        but.setBackground(new Color(0, 0, 0, 0));
        return but;
    }

    private JComponent createAnnotationPopup(FormObject form) {
        PdfSwingPopup comp = this.getPopupComponent(form, this.pageData.getCropBoxWidth(form.getPageNumber()));
        form.setGUIComponent(comp, 1);
        comp.setVisible(form.getBoolean(524301630));
        return comp;
    }

    @Override
    public Object annotationButton(FormObject form) {
        int subtype = form.getNameAsConstant(1147962727);
        if (subtype == 1061176672) {
            return this.createAnnotationPopup(form);
        }
        return this.setupAnnotationButton(form);
    }

    @Override
    public Object comboBox(FormObject form) {
        JComboBox<Object> comboBox;
        String[][] options = form.getChoiceOptions();
        String[] items = form.getItemsList();
        if (items == null) {
            comboBox = new JComboBox();
        } else {
            comboBox = new JComboBox<String>(items);
            Color backgroundColor = FormObject.generateColor(form.getDictionary(7451).getFloatArray(4631));
            if (backgroundColor == null && FormObject.FieldsHightlightColor != null) {
                backgroundColor = FormObject.FieldsHightlightColor;
            }
            if (backgroundColor != null) {
                ComboColorRenderer renderer = new ComboColorRenderer(backgroundColor);
                comboBox.setRenderer(renderer);
            }
        }
        int selectedIndex = form.getSelectedIndex();
        String selectedExportValue = form.getSelectedItem();
        if (selectedIndex >= 0 && selectedIndex < comboBox.getItemCount()) {
            comboBox.setSelectedIndex(selectedIndex);
        } else if (selectedExportValue != null) {
            Optional<String[]> selectedValue = Arrays.stream(options).filter(strings -> strings[0].equals(selectedExportValue)).findAny();
            if (selectedValue.isPresent()) {
                comboBox.setSelectedItem(selectedValue.get()[0]);
            } else {
                comboBox.setSelectedItem(selectedExportValue);
            }
        } else {
            comboBox.setSelectedItem(null);
        }
        form.setSelection((String)comboBox.getSelectedItem(), comboBox.getSelectedIndex());
        boolean[] flags = form.getFieldFlags();
        comboBox.setEditable(flags[19]);
        this.setupUniversalFeatures(comboBox, form);
        if (flags[1]) {
            comboBox.setEditable(false);
            comboBox.setEnabled(false);
        }
        comboBox.addItemListener(new ComboListener(comboBox, form));
        return comboBox;
    }

    @Override
    public Object checkBoxBut(FormObject form) {
        boolean[] flags;
        JCheckBox checkBut = new JCheckBox();
        this.setupButton(checkBut, form);
        this.setupUniversalFeatures(checkBut, form);
        if (checkBut.getBorder() != null) {
            checkBut.setBorderPainted(true);
        }
        if ((flags = form.getFieldFlags()) != null && flags[1]) {
            checkBut.setEnabled(false);
            checkBut.setDisabledIcon(checkBut.getIcon());
            checkBut.setDisabledSelectedIcon(checkBut.getSelectedIcon());
        }
        return checkBut;
    }

    @Override
    public Object listField(FormObject form) {
        String[][] options = form.getChoiceOptions();
        String[] items = form.getItemsList();
        JList<Object> list = items != null ? new JList<String>(items) : new JList();
        if (!form.getFieldFlags()[22]) {
            list.setSelectionMode(0);
        }
        int[] selectedIndices = form.getSelectionIndices();
        String[] selectedValues = form.getSelectedItems();
        if (form.getSelectionIndices() != null) {
            list.setSelectedIndices(selectedIndices);
        } else if (selectedValues != null) {
            boolean first = true;
            for (String selectedExportValue : selectedValues) {
                Optional<String[]> selectedValue = Arrays.stream(options).filter(strings -> strings[0].equals(selectedExportValue)).findAny();
                if (selectedValue.isPresent()) {
                    list.setSelectedValue(selectedValue.get()[1], first);
                }
                first = false;
            }
        }
        form.setSelection((String[])list.getSelectedValuesList().stream().map(String.class::cast).toArray(String[]::new), list.getSelectedIndices());
        this.setupUniversalFeatures(list, form);
        list.addListSelectionListener(new ListListener(list, form));
        return list;
    }

    @Override
    public Object multiLinePassword(FormObject form) {
        JComponent comp;
        boolean[] flags = form.getFieldFlags();
        String textValue = form.getTextString();
        int maxLength = form.getInt(1209815663);
        final JPasswordField multipass = maxLength != -1 ? new JPasswordField(textValue, maxLength) : new JPasswordField(textValue);
        multipass.setEchoChar('*');
        this.setupUniversalFeatures(multipass, form);
        SwingFormFactory.setupTextFeatures(multipass, form);
        SwingFormFactory.setToolTip(form, multipass);
        if (flags != null && flags[1]) {
            multipass.setEditable(false);
        }
        if (flags == null || !flags[24]) {
            comp = new JScrollPane(multipass, 20, 31);
            comp.addPropertyChangeListener("font", evt -> multipass.setFont((Font)evt.getNewValue()));
            comp.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e2) {
                    super.componentResized(e2);
                    multipass.setBounds(e2.getComponent().getBounds());
                }
            });
            comp.setBorder(multipass.getBorder());
            multipass.setBorder(null);
            comp.setOpaque(false);
            ((JScrollPane)comp).getViewport().setOpaque(false);
        } else {
            comp = multipass;
        }
        return comp;
    }

    @Override
    public Object multiLineText(FormObject form) {
        JComponent comp;
        boolean[] flags = form.getFieldFlags();
        boolean[] characteristics = form.getCharacteristics();
        String text = form.getTextString();
        final JTextPane newTextarea = new JTextPane();
        newTextarea.setEditorKit(new WrapEditorKit());
        int maxLength = form.getInt(1209815663);
        if (maxLength != -1) {
            ((AbstractDocument)((Object)newTextarea.getStyledDocument())).setDocumentFilter(new WordCapFilter(maxLength));
        }
        newTextarea.setText(text);
        if (form.getAlignment() != -1) {
            StyledDocument doc = newTextarea.getStyledDocument();
            SimpleAttributeSet center = new SimpleAttributeSet();
            switch (form.getAlignment()) {
                case 0: {
                    StyleConstants.setAlignment(center, 1);
                    break;
                }
                case 4: {
                    StyleConstants.setAlignment(center, 2);
                }
            }
            doc.setParagraphAttributes(0, doc.getLength(), center, false);
        }
        newTextarea.getDocument().addDocumentListener(new TextDocumentListener(newTextarea, form));
        if (flags != null && flags[1] || characteristics != null && characteristics[9]) {
            newTextarea.setEditable(false);
        }
        SwingFormFactory.setToolTip(form, newTextarea);
        this.setupUniversalFeatures(newTextarea, form);
        if (flags == null || !flags[24]) {
            comp = new JScrollPane(newTextarea, 20, 31);
            comp.addPropertyChangeListener("font", evt -> newTextarea.setFont((Font)evt.getNewValue()));
            comp.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e2) {
                    super.componentResized(e2);
                    newTextarea.setBounds(((JScrollPane)comp).getViewport().getBounds());
                }
            });
            comp.setBorder(newTextarea.getBorder());
            newTextarea.setBorder(null);
            comp.setOpaque(false);
            ((JScrollPane)comp).getViewport().setOpaque(false);
        } else {
            comp = newTextarea;
        }
        return comp;
    }

    @Override
    public Object signature(FormObject form) {
        JButton sigBut = new JButton();
        this.setupButton(sigBut, form);
        this.setupUniversalFeatures(sigBut, form);
        boolean[] flags = form.getFieldFlags();
        if (flags != null && flags[1]) {
            sigBut.setEnabled(false);
            sigBut.setDisabledIcon(sigBut.getIcon());
            sigBut.setDisabledSelectedIcon(sigBut.getSelectedIcon());
        }
        if (!form.isAppearanceUsed()) {
            sigBut.setOpaque(false);
            BufferedImage img = new BufferedImage(1, 1, 2);
            Graphics2D imgG2 = img.createGraphics();
            imgG2.setPaint(new Color(221, 228, 255, 175));
            imgG2.fillRect(0, 0, 1, 1);
            sigBut.setIcon(new FixImageIcon(form, img, 0));
        }
        return sigBut;
    }

    @Override
    public Object pushBut(FormObject form) {
        JButton pushBut = new JButton();
        this.setupButton(pushBut, form);
        this.setupUniversalFeatures(pushBut, form);
        boolean[] flags = form.getFieldFlags();
        if (flags != null && flags[1]) {
            pushBut.setEnabled(false);
            pushBut.setDisabledIcon(pushBut.getIcon());
            pushBut.setDisabledSelectedIcon(pushBut.getSelectedIcon());
        }
        return pushBut;
    }

    @Override
    public Object radioBut(FormObject form) {
        JRadioButton radioBut = new JRadioButton();
        this.setupButton(radioBut, form);
        this.setupUniversalFeatures(radioBut, form);
        boolean[] flags = form.getFieldFlags();
        if (flags != null && flags[1]) {
            radioBut.setEnabled(false);
            radioBut.setDisabledIcon(radioBut.getIcon());
            radioBut.setDisabledSelectedIcon(radioBut.getSelectedIcon());
        }
        return radioBut;
    }

    @Override
    public Object singleLinePassword(FormObject form) {
        JPasswordField newPassword = new JPasswordField(form.getTextString());
        newPassword.setEchoChar('*');
        int maxLength = form.getInt(1209815663);
        if (maxLength != -1) {
            newPassword.setColumns(maxLength);
        }
        this.setupUniversalFeatures(newPassword, form);
        SwingFormFactory.setupTextFeatures(newPassword, form);
        boolean[] flags = form.getFieldFlags();
        if (flags != null && flags[1]) {
            newPassword.setEditable(false);
        }
        SwingFormFactory.setToolTip(form, newPassword);
        return newPassword;
    }

    @Override
    public Object singleLineText(FormObject form) {
        JTextField retComp;
        boolean[] flags = form.getFieldFlags();
        boolean[] characteristics = form.getCharacteristics();
        String aptext = this.readAPimagesForText(form);
        if (aptext != null && aptext.contains("&#")) {
            aptext = Strip.stripXML(aptext, true).toString();
        }
        if (aptext != null && !aptext.equals(form.getTextStreamValue(38))) {
            form.setTextStreamValue(38, aptext);
        }
        if (flags != null && flags[1] || characteristics != null && characteristics[9]) {
            JTextField newTextfield = new JTextField(form.getTextString());
            SwingFormFactory.setupTextFeatures(newTextfield, form);
            SwingFormFactory.setToolTip(form, newTextfield);
            newTextfield.setEditable(false);
            retComp = newTextfield;
        } else {
            JTextField newTextfield = new JTextField(form.getTextString());
            SwingFormFactory.setupTextFeatures(newTextfield, form);
            SwingFormFactory.setToolTip(form, newTextfield);
            retComp = newTextfield;
        }
        this.setupUniversalFeatures(retComp, form);
        return retComp;
    }

    private static void setupTextFeatures(JTextField textcomp, FormObject form) {
        if (form.getAlignment() != -1) {
            textcomp.setHorizontalAlignment(form.getAlignment());
        }
        textcomp.getDocument().addDocumentListener(new TextDocumentListener(textcomp, form));
    }

    private void setupButton(AbstractButton comp, FormObject form) {
        ButtonGroup bg2;
        String name = form.getTextStreamValue(36);
        if (name == null) {
            name = "";
        }
        if ((bg2 = (ButtonGroup)this.groups.get(name)) == null) {
            bg2 = new ButtonGroup();
            this.groups.put(name, bg2);
            this.firstButtons.put(name, comp);
        } else {
            AbstractButton firstButton = (AbstractButton)this.firstButtons.get(name);
            if (firstButton != null) {
                this.firstButtons.remove(name);
                bg2.add(firstButton);
            }
            bg2.add(comp);
        }
        String normalCaption = form.getDictionary(7451).getTextStreamValue(4881);
        comp.setText(normalCaption);
        comp.setContentAreaFilled(false);
        String downCaption = form.getDictionary(7451).getTextStreamValue(4371);
        String rolloverCaption = form.getDictionary(7451).getTextStreamValue(8723);
        if (downCaption != null && !downCaption.isEmpty() || rolloverCaption != null && !rolloverCaption.isEmpty()) {
            comp.addMouseListener(new SwingFormButtonListener(normalCaption, rolloverCaption, downCaption));
        }
        SwingAPImageHandler apImageHandler = new SwingAPImageHandler(this.currentPdfFile);
        apImageHandler.setAPImages(form, comp);
        int textPosition = form.getTextPosition();
        if (textPosition != -1) {
            switch (textPosition) {
                case 0: {
                    comp.setIcon(null);
                    comp.setText(normalCaption);
                    break;
                }
                case 1: 
                case 6: {
                    comp.setText(null);
                    break;
                }
                case 2: {
                    comp.setVerticalTextPosition(3);
                    break;
                }
                case 3: {
                    comp.setVerticalTextPosition(1);
                    break;
                }
                case 4: {
                    comp.setHorizontalTextPosition(4);
                    break;
                }
                case 5: {
                    comp.setHorizontalTextPosition(2);
                }
            }
        }
        Insets insetZero = new Insets(0, 0, 0, 0);
        comp.setMargin(insetZero);
        comp.addMouseListener((MouseListener)this.formsActionHandler.setHoverCursor());
        comp.addChangeListener(new RadioListener(comp, form));
    }

    private void setupUniversalFeatures(JComponent comp, FormObject form) {
        comp.setOpaque(false);
        Font textFont = form.getTextFont();
        if (textFont != null) {
            comp.setFont(textFont);
        }
        comp.setForeground(form.getTextColor());
        Border newBorder = SwingData.generateBorderfromForm(form, 1.0f);
        comp.setBorder(newBorder);
        Color backgroundColor = FormObject.generateColor(form.getDictionary(7451).getFloatArray(4631));
        if (backgroundColor == null && FormObject.FieldsHightlightColor != null) {
            backgroundColor = FormObject.FieldsHightlightColor;
        }
        if (backgroundColor != null) {
            comp.setBackground(backgroundColor);
            comp.setOpaque(true);
        } else if (DecoderOptions.isRunningOnMac && comp instanceof JButton) {
            ((AbstractButton)comp).setBorderPainted(false);
            comp.setBorder(null);
        }
        this.setupMouseListener(comp, form);
    }

    private void setupMouseListener(Component currentComp, FormObject form) {
        String noLinkToolTips;
        boolean[] characteristic = form.getCharacteristics();
        if (characteristic[0] || characteristic[1] || characteristic[5]) {
            currentComp.setVisible(false);
        }
        SwingListener jpedalListener = new SwingListener(form, this.formsActionHandler);
        if (currentComp instanceof JComboBox) {
            ((Container)currentComp).getComponent(0).addMouseListener(jpedalListener);
            ((Container)currentComp).getComponent(0).addKeyListener(jpedalListener);
            ((Container)currentComp).getComponent(0).addFocusListener(jpedalListener);
            ((JComboBox)currentComp).addActionListener(jpedalListener);
        }
        if (currentComp instanceof JList) {
            ((JList)currentComp).addListSelectionListener(jpedalListener);
        }
        currentComp.addMouseListener(jpedalListener);
        currentComp.addMouseMotionListener(jpedalListener);
        currentComp.addKeyListener(jpedalListener);
        currentComp.addFocusListener(jpedalListener);
        PdfObject aData = form.getDictionary(17);
        if (aData != null && aData.getNameAsConstant(35) == 2433561 && ((noLinkToolTips = System.getProperty("org.jpedal.noURLaccess")) == null || "false".equalsIgnoreCase(noLinkToolTips))) {
            String text = aData.getTextStreamValue(2433561);
            ((JComponent)currentComp).setToolTipText(text);
        }
    }

    private static void setToolTip(FormObject formObject, JComponent retComponent) {
        String userName = formObject.getTextStreamValue(9253);
        if (userName != null) {
            retComponent.setToolTipText(userName);
        }
    }

    @Override
    public GUIData getCustomCompData() {
        return new SwingData();
    }

    @Override
    public int getType() {
        return 1;
    }

    private PdfSwingPopup getPopupComponent(FormObject form, int cropBoxWith) {
        SwingListener listener = new SwingListener(form, this.formsActionHandler);
        return new PdfSwingPopup(form, cropBoxWith, listener, this.formsActionHandler.getPDFDecoder());
    }

    class WordCapFilter
    extends DocumentFilter {
        final int maxLength;

        WordCapFilter(int maxLen) {
            this.maxLength = maxLen;
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String str, AttributeSet a10) throws BadLocationException {
            int inputLimit = fb.getDocument().getLength() + str.length() - this.maxLength;
            if (inputLimit == 0) {
                str = "";
            } else if (inputLimit > 0 && inputLimit < str.length()) {
                str = str.substring(0, str.length() - inputLimit);
            }
            super.insertString(fb, offset, str, a10);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String str, AttributeSet a10) throws BadLocationException {
            int inputLimit = fb.getDocument().getLength() + str.length() - length - this.maxLength;
            if (inputLimit > 0) {
                str = inputLimit < str.length() ? str.substring(0, str.length() - inputLimit) : "";
            }
            super.replace(fb, offset, length, str, a10);
        }
    }

    class WrapLabelView
    extends LabelView {
        WrapLabelView(Element elem) {
            super(elem);
        }

        @Override
        public float getMinimumSpan(int axis) {
            switch (axis) {
                case 0: {
                    return 0.0f;
                }
                case 1: {
                    return super.getMinimumSpan(axis);
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + axis);
        }
    }

    class WrapColumnFactory
    implements ViewFactory {
        WrapColumnFactory() {
        }

        @Override
        public View create(Element elem) {
            String name = elem.getName();
            if (name != null) {
                switch (name) {
                    case "content": {
                        return new WrapLabelView(elem);
                    }
                    case "paragraph": {
                        return new ParagraphView(elem);
                    }
                    case "section": {
                        return new BoxView(elem, 1);
                    }
                    case "component": {
                        return new ComponentView(elem);
                    }
                    case "icon": {
                        return new IconView(elem);
                    }
                }
            }
            return new LabelView(elem);
        }
    }

    class WrapEditorKit
    extends StyledEditorKit {
        final ViewFactory defaultFactory;

        WrapEditorKit() {
            this.defaultFactory = new WrapColumnFactory();
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.defaultFactory;
        }
    }
}

