/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.creation;

import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.acroforms.actions.SwingDownIconListener;
import org.jpedal.objects.acroforms.creation.APImageHandler;
import org.jpedal.objects.acroforms.creation.AnnotationFactory;
import org.jpedal.objects.acroforms.overridingImplementations.FixImageIcon;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;

public class SwingAPImageHandler
extends APImageHandler {
    private AbstractButton rawComp;

    public SwingAPImageHandler(PdfObjectReader currentPdfFile) {
        this.currentPdfFile = currentPdfFile;
    }

    public void setAPImages(FormObject form, AbstractButton rawComp) {
        this.rawComp = rawComp;
        this.setAPImages(form, 0);
    }

    @Override
    public void completeAPImages(FormObject form, String offName, String onName, String downOffName, String downOnName, String rollOffName, String rollOnName) {
        if (form.isSelected()) {
            Icon icn;
            this.rawComp.setSelected(true);
            if (this.rawComp instanceof JToggleButton && (icn = this.rawComp.getPressedIcon()) instanceof FixImageIcon) {
                ((FixImageIcon)icn).swapImage(true);
            }
        }
    }

    @Override
    public String setUpImage(FormObject form, PdfObject dic, int textPosition, int subtype, String onOffState) {
        this.rawComp.setText(null);
        if ("On".equals(onOffState)) {
            this.rawComp.setSelectedIcon(new FixImageIcon(form, dic, form.getDictionary(7451).getInt(34), this.currentPdfFile, subtype, 0));
            if (this.rawComp.getIcon() == null) {
                this.rawComp.setIcon(new FixImageIcon(form, null, form.getDictionary(7451).getInt(34)));
            }
        } else {
            this.rawComp.setIcon(new FixImageIcon(form, dic, form.getDictionary(7451).getInt(34), this.currentPdfFile, subtype, 0));
        }
        return null;
    }

    @Override
    public void setNoDownIcon() {
        this.rawComp.setPressedIcon(this.rawComp.getIcon());
    }

    @Override
    public String setDownImageForNoOff(FormObject form, int subtype, PdfObject dic, int downStyle) {
        this.rawComp.setPressedIcon(new FixImageIcon(form, dic, null, form.getDictionary(7451).getInt(34), this.rawComp.isSelected() ? 1 : 0, this.currentPdfFile, subtype, downStyle));
        this.rawComp.addActionListener(new SwingDownIconListener());
        return null;
    }

    @Override
    public String setDownImage(FormObject form, int subtype, PdfObject dic, int downStyle, String key) {
        this.rawComp.setText(null);
        this.rawComp.setPressedIcon(new FixImageIcon(form, dic, form.getDictionary(7451).getInt(34), this.currentPdfFile, subtype, downStyle));
        return null;
    }

    @Override
    public String setRolloverImage(FormObject form, int subtype, PdfObject dic, String key) {
        if ("RollOn".equals(key)) {
            this.rawComp.setRolloverEnabled(true);
            this.rawComp.setText(null);
            this.rawComp.setRolloverSelectedIcon(new FixImageIcon(form, dic, form.getDictionary(7451).getInt(34), this.currentPdfFile, subtype, 0));
            if (this.rawComp.getRolloverIcon() == null) {
                this.rawComp.setRolloverIcon(new FixImageIcon(form, null, form.getDictionary(7451).getInt(34)));
            }
        } else {
            this.rawComp.setRolloverEnabled(true);
            this.rawComp.setText(null);
            this.rawComp.setRolloverIcon(new FixImageIcon(form, dic, form.getDictionary(7451).getInt(34), this.currentPdfFile, subtype, 0));
        }
        return null;
    }

    @Override
    public String setUpImageToFallbackAppearance(FormObject form, int textPosition) {
        BufferedImage fallbackAppearance = AnnotationFactory.getIcon(form);
        this.rawComp.setIcon(new FixImageIcon(form, fallbackAppearance, 0));
        return null;
    }
}

