/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.creation;

import java.awt.BasicStroke;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.jpedal.objects.acroforms.creation.DashBorder;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;

public final class JPedalBorderFactory {
    private static final boolean printouts = false;

    private JPedalBorderFactory() {
    }

    public static Border createBorderStyle(PdfObject BS, Color borderColor, Color borderBackgroundColor, float scaling) {
        int style;
        PdfArrayIterator dashPattern;
        int xfaBorderStyle;
        int w2;
        if (borderBackgroundColor == null) {
            // empty if block
        }
        if (borderColor == null) {
            return null;
        }
        Border insideBorder = null;
        if (BS != null) {
            int bsW = BS.getInt(39);
            w2 = bsW >= 0 ? (int)((double)((float)bsW * scaling) + 0.5) : (int)((double)scaling + 0.5);
            xfaBorderStyle = BS.getNameAsConstant(40);
            if (xfaBorderStyle != -1) {
                w2 /= 2;
            }
            dashPattern = BS.getMixedArray(20);
            int bsStyle = BS.getNameAsConstant(35);
            style = bsStyle == -1 ? 35 : bsStyle;
        } else {
            w2 = (int)((double)scaling + 0.5);
            dashPattern = new PdfArrayIterator(null);
            style = 35;
        }
        switch (style) {
            case 37: {
                insideBorder = BorderFactory.createMatteBorder(0, 0, w2, 0, borderColor);
                break;
            }
            case 25: {
                insideBorder = BorderFactory.createEtchedBorder(borderColor, borderBackgroundColor);
                break;
            }
            case 18: {
                if (borderBackgroundColor == null) break;
                insideBorder = BorderFactory.createBevelBorder(1, borderColor, borderBackgroundColor);
                break;
            }
            case 35: {
                insideBorder = BorderFactory.createLineBorder(borderColor, w2);
                break;
            }
            case 20: {
                insideBorder = JPedalBorderFactory.createDashBorder(dashPattern, w2, borderColor);
            }
        }
        Border outsideBorder = new EmptyBorder(0, 0, 0, 0);
        if (BS != null && (xfaBorderStyle = BS.getNameAsConstant(40)) != -1) {
            Border xfaBorder = BorderFactory.createLineBorder(borderColor, w2);
            if (xfaBorderStyle == 34) {
                outsideBorder = xfaBorder;
            }
        }
        return new CompoundBorder(outsideBorder, insideBorder);
    }

    private static DashBorder createDashBorder(PdfArrayIterator dashPattern, int width, Color borderColor) {
        int current_line_dash_phase = 0;
        float[] current_line_dash_array = new float[1];
        int count = dashPattern.getTokenCount();
        if (count > 0) {
            current_line_dash_array = dashPattern.getNextValueAsFloatArray();
        }
        if (count > 1) {
            current_line_dash_phase = dashPattern.getNextValueAsInteger();
        }
        BasicStroke current_stroke = width < 0 ? new BasicStroke(1.0f, 0, 0, 1.0f, current_line_dash_array, current_line_dash_phase) : new BasicStroke(width, 0, 0, 1.0f, current_line_dash_array, current_line_dash_phase);
        return new DashBorder(current_stroke, borderColor);
    }
}

