/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.creation;

import com.idrsolutions.image.JDeli;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.Arrays;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.io.annotation.utils.AnnotationUtils;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;

public final class AnnotationFactory {
    private static final int STYLE_KEY_FONT = 1718578804;
    private static final int STYLE_KEY_TEXT = 1952807028;
    private static final int STYLE_KEY_COLOR = 1668246639;

    private AnnotationFactory() {
    }

    public static BufferedImage getIcon(PdfObject form) {
        return AnnotationFactory.getIcon(form, 1.0f);
    }

    public static BufferedImage getIcon(PdfObject form, float scaling) {
        float alpha = form.getFloatNumber(4881);
        switch (form.getNameAsConstant(1147962727)) {
            case 607471684: {
                return AnnotationFactory.getTextIcon(form, alpha);
            }
            case 1919840408: {
                return AnnotationFactory.getHightlightIcon(form, scaling, alpha);
            }
            case 1160865142: {
                return AnnotationFactory.getSquareIcon(form, scaling, alpha);
            }
            case 2053993372: {
                return AnnotationFactory.getUnderLineIcon(form, alpha);
            }
            case 2036432546: {
                return AnnotationFactory.getStrikeOutIcon(form, alpha);
            }
            case 826422615: {
                return AnnotationFactory.getCaretIcon(form, alpha);
            }
            case -1113876231: {
                return AnnotationFactory.getFileAttachmentIcon();
            }
            case 473513525: {
                return AnnotationFactory.getLineIcon(form, scaling, alpha);
            }
            case 1230470778: {
                return AnnotationFactory.getPolyIcon(form, false, scaling, alpha);
            }
            case 1014528638: {
                return AnnotationFactory.getPolyIcon(form, true, scaling, alpha);
            }
            case 1110658926: {
                return AnnotationFactory.getCircleIcon(form, scaling, alpha);
            }
            case 1517846914: {
                return AnnotationFactory.getSquigglyIcon(form, alpha);
            }
            case 1061502534: {
                return AnnotationFactory.getSoundIcon(form, alpha);
            }
            case 1654331: {
                return AnnotationFactory.getInkIcon((FormObject)form, scaling, alpha);
            }
            case 473513531: {
                return AnnotationFactory.getLinkIcon((FormObject)form, scaling, alpha);
            }
        }
        return null;
    }

    private static BufferedImage getInkIcon(FormObject form, float scaling, float alpha) {
        float[] quad = form.getFloatArray(573911876);
        if (quad != null) {
            float[][] InkListArray = form.getFloat2DArray(475169151);
            BasicStroke stroke = AnnotationFactory.getStrokeFromBS(form, scaling, 1);
            int strokeWidth = (int)stroke.getLineWidth();
            Rectangle bounds = AnnotationFactory.getInkListBounds(InkListArray, strokeWidth);
            if (bounds.width > 0 && bounds.height > 0) {
                BufferedImage icon1 = new BufferedImage(bounds.width, bounds.height, 6);
                Graphics2D g2 = (Graphics2D)icon1.getGraphics();
                g2.setComposite(AlphaComposite.getInstance(3, alpha));
                g2.setStroke(stroke);
                g2.scale(1.0, -1.0);
                g2.translate(-bounds.getX(), -(bounds.getY() + (double)bounds.height));
                float[] r2 = AnnotationFactory.scanInkListFloatTree(InkListArray, form, g2, scaling);
                if (r2 != null) {
                    form.setFloatArray(573911876, new float[]{r2[0], r2[1], r2[2], r2[3]});
                }
                return icon1;
            }
        }
        return null;
    }

    private static Rectangle getInkListBounds(float[][] inkList, int strokeWidth) {
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float maxY = Float.MIN_VALUE;
        for (float[] inkValues : inkList) {
            float[] values = AnnotationFactory.createInkCurve(inkValues);
            for (int i2 = 0; i2 != values.length; ++i2) {
                if (i2 % 2 == 0) {
                    minX = Math.min(values[i2], minX);
                    maxX = Math.max(values[i2], maxX);
                    continue;
                }
                minY = Math.min(values[i2], minY);
                maxY = Math.max(values[i2], maxY);
            }
        }
        return new Rectangle((int)minX - strokeWidth, (int)minY - strokeWidth, (int)(maxX - minX) + strokeWidth * 2, (int)(maxY - minY) + strokeWidth * 2);
    }

    private static float[] scanInkListFloatTree(float[][] InkListArray, PdfObject form, Graphics g2, float scaling) {
        float[] quad = form.getFloatArray(573911876);
        if (quad == null) {
            return null;
        }
        Rectangle2D bounds = AnnotationFactory.getFormBounds((FormObject)form, quad, scaling);
        Graphics2D g22 = (Graphics2D)g2;
        if (InkListArray != null) {
            if (g22 != null) {
                float[] underlineColor = form.getFloatArray(19);
                Color c1 = new Color(0);
                if (underlineColor != null) {
                    switch (underlineColor.length) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            c1 = new Color(underlineColor[0], underlineColor[0], underlineColor[0], 1.0f);
                            break;
                        }
                        case 3: {
                            c1 = new Color(underlineColor[0], underlineColor[1], underlineColor[2], 1.0f);
                            break;
                        }
                        case 4: {
                            DeviceCMYKColorSpace cmyk = new DeviceCMYKColorSpace();
                            cmyk.setColor(underlineColor);
                            c1 = new Color(cmyk.getColor().getRGB());
                            break;
                        }
                    }
                }
                g22.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
                g22.fillRect(0, 0, (int)((RectangularShape)bounds).getWidth(), (int)((RectangularShape)bounds).getHeight());
                g22.setColor(c1);
                g22.setPaint(c1);
            }
            for (float[] coords : InkListArray) {
                if (coords.length < 4) {
                    if (g22 == null) continue;
                    g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    Line2D.Float line = new Line2D.Float(coords[0], coords[1], coords[0], coords[1]);
                    g22.draw(line);
                    continue;
                }
                if (coords.length < 6) {
                    if (g22 == null) continue;
                    g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    for (int i2 = 0; i2 < coords.length; i2 += 4) {
                        Line2D.Float line = new Line2D.Float(coords[0], coords[1], coords[2], coords[3]);
                        g22.draw(line);
                    }
                    continue;
                }
                float[] values = AnnotationFactory.createInkCurve(coords);
                if (g22 == null) continue;
                g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                for (int i3 = 0; i3 < values.length - 7; i3 += 6) {
                    CubicCurve2D.Double curve = new CubicCurve2D.Double(values[i3], values[i3 + 1], values[i3 + 2], values[i3 + 3], values[i3 + 4], values[i3 + 5], values[i3 + 6], values[i3 + 7]);
                    g22.draw(curve);
                    bounds = ((Rectangle2D)bounds).createUnion(curve.getBounds2D());
                }
            }
        }
        form.setFloatArray(573911876, new float[]{(float)bounds.getMinX(), (float)bounds.getMinY(), (float)bounds.getMaxX(), (float)bounds.getMaxY()});
        return form.getFloatArray(573911876);
    }

    private static Color convertFloatArrayToColor(float[] values, Color defaultColor) {
        Color c2 = defaultColor;
        if (values != null) {
            switch (values.length) {
                case 0: {
                    break;
                }
                case 1: {
                    c2 = new Color(values[0], values[0], values[0]);
                    break;
                }
                case 3: {
                    c2 = new Color(values[0], values[1], values[2]);
                    break;
                }
                case 4: {
                    DeviceCMYKColorSpace cmyk = new DeviceCMYKColorSpace();
                    cmyk.setColor(values);
                    c2 = new Color(cmyk.getColor().getRGB());
                    c2 = new Color(c2.getRed(), c2.getGreen(), c2.getBlue());
                    break;
                }
            }
        }
        return c2;
    }

    private static Rectangle getFormBounds(FormObject form, float[] rect, float scaling) {
        Rectangle bounds = form.getBoundingRectangle();
        if (bounds.getWidth() == 0.0 && bounds.getHeight() == 0.0) {
            for (int i2 = 0; i2 != rect.length; ++i2) {
                if (i2 % 2 == 0) {
                    if ((float)bounds.x > rect[i2]) {
                        bounds.x = (int)rect[i2];
                    }
                    if (!((float)(bounds.x + bounds.width) < rect[i2])) continue;
                    bounds.width = (int)(rect[i2] - (float)bounds.x);
                    continue;
                }
                if ((float)bounds.y > rect[i2]) {
                    bounds.y = (int)rect[i2];
                }
                if (!((float)(bounds.y + bounds.height) < rect[i2])) continue;
                bounds.height = (int)(rect[i2] - (float)bounds.y);
            }
        }
        bounds.x = (int)((float)bounds.x * scaling + 0.5f);
        bounds.y = (int)((float)bounds.y * scaling + 0.5f);
        bounds.width = (int)((float)bounds.width * scaling + 0.5f);
        bounds.height = (int)((float)bounds.height * scaling + 0.5f);
        return bounds;
    }

    private static BufferedImage getStrikeOutIcon(PdfObject form, float alpha) {
        Color color = AnnotationFactory.convertFloatArrayToColor(form.getFloatArray(19), new Color(0, 0, 0, 0));
        float[] quad = form.getFloatArray(1785890247);
        if (quad == null) {
            quad = form.getFloatArray(573911876);
        }
        Rectangle bounds = AnnotationFactory.getFormBounds((FormObject)form, quad, 1.0f);
        if (bounds.width > 0 && bounds.height > 0) {
            BufferedImage icon = new BufferedImage(bounds.width, bounds.height, 6);
            Graphics2D g2 = icon.createGraphics();
            g2.setComposite(AlphaComposite.getInstance(3, alpha));
            if (quad.length >= 8) {
                for (int hi = 0; hi != quad.length; hi += 8) {
                    int x2 = (int)quad[hi] - bounds.x;
                    int y2 = (int)quad[hi + 5] - bounds.y;
                    y2 = bounds.height - y2 - (int)(quad[hi + 1] - quad[hi + 5]);
                    int width = (int)(quad[hi + 2] - quad[hi]);
                    int height = (int)(quad[hi + 1] - quad[hi + 5]);
                    try {
                        g2.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
                        g2.fillRect(0, 0, width, height);
                        g2.setColor(color);
                        g2.fillRect(x2, y2 + height / 2, width, 1);
                        continue;
                    }
                    catch (Exception e2) {
                        LogWriter.writeLog("Exception: " + e2.getMessage());
                    }
                }
            }
            return icon;
        }
        return null;
    }

    private static BufferedImage getUnderLineIcon(PdfObject form, float alpha) {
        Color color = AnnotationFactory.convertFloatArrayToColor(form.getFloatArray(19), new Color(0, 0, 0, 0));
        float[] quad = form.getFloatArray(1785890247);
        if (quad == null) {
            quad = form.getFloatArray(573911876);
        }
        Rectangle bounds = AnnotationFactory.getFormBounds((FormObject)form, quad, 1.0f);
        if (bounds.width > 0 && bounds.height > 0) {
            BufferedImage icon = new BufferedImage(bounds.width, bounds.height, 6);
            Graphics2D g2 = icon.createGraphics();
            g2.setComposite(AlphaComposite.getInstance(3, alpha));
            if (quad.length >= 8) {
                for (int hi = 0; hi != quad.length; hi += 8) {
                    int x2 = (int)quad[hi] - bounds.x;
                    int y2 = (int)quad[hi + 5] - bounds.y;
                    y2 = bounds.height - y2 - (int)(quad[hi + 1] - quad[hi + 5]);
                    int width = (int)(quad[hi + 2] - quad[hi]);
                    int height = (int)(quad[hi + 1] - quad[hi + 5]);
                    try {
                        g2.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
                        g2.fillRect(x2, y2, width, height);
                        g2.setColor(color);
                        g2.fillRect(x2, y2 + height - 1, width, 1);
                        continue;
                    }
                    catch (Exception e2) {
                        LogWriter.writeLog("Exception: " + e2.getMessage());
                    }
                }
            }
            return icon;
        }
        return null;
    }

    private static BufferedImage getSquigglyIcon(PdfObject form, float alpha) {
        Color color = AnnotationFactory.convertFloatArrayToColor(form.getFloatArray(19), new Color(0, 0, 0, 0));
        float[] quad = form.getFloatArray(1785890247);
        if (quad == null) {
            quad = form.getFloatArray(573911876);
        }
        Rectangle bounds = AnnotationFactory.getFormBounds((FormObject)form, quad, 1.0f);
        if (bounds.width > 0 && bounds.height > 0) {
            BufferedImage icon = new BufferedImage(bounds.width, bounds.height, 6);
            Graphics2D g2 = icon.createGraphics();
            g2.setComposite(AlphaComposite.getInstance(3, alpha));
            if (quad.length >= 8) {
                for (int hi = 0; hi != quad.length; hi += 8) {
                    int x2 = (int)quad[hi] - bounds.x;
                    int y2 = (int)quad[hi + 5] - bounds.y;
                    y2 = bounds.height - y2 - (int)(quad[hi + 1] - quad[hi + 5]);
                    int width = (int)(quad[hi + 2] - quad[hi]);
                    int height = (int)(quad[hi + 1] - quad[hi + 5]);
                    int step = 6;
                    int bottom = y2 + height - 1;
                    int top = bottom - 3;
                    try {
                        g2.setColor(color);
                        for (int i2 = 0; i2 < width; i2 += 6) {
                            g2.drawLine(x2 + i2, bottom, x2 + i2 + 3, top);
                            g2.drawLine(x2 + i2 + 3, top, x2 + i2 + 6, bottom);
                        }
                        continue;
                    }
                    catch (Exception e2) {
                        LogWriter.writeLog("Exception: " + e2.getMessage());
                    }
                }
            }
            return icon;
        }
        return null;
    }

    private static BufferedImage getSquareIcon(PdfObject form, float scaling, float alpha) {
        Color c2 = AnnotationFactory.convertFloatArrayToColor(form.getFloatArray(19), new Color(0, 0, 0, 0));
        Color ic = AnnotationFactory.convertFloatArrayToColor(form.getFloatArray(6419), new Color(0, 0, 0, 0));
        float[] quad = form.getFloatArray(573911876);
        if (quad != null) {
            Rectangle bounds = AnnotationFactory.getFormBounds((FormObject)form, quad, scaling);
            if (bounds.width > 0 && bounds.height > 0) {
                BufferedImage icon = new BufferedImage(bounds.width, bounds.height, 6);
                Graphics2D g2 = icon.createGraphics();
                g2.setComposite(AlphaComposite.getInstance(3, alpha));
                BasicStroke stroke = AnnotationFactory.getStrokeFromBS(form, scaling, 2);
                int width = (int)stroke.getLineWidth();
                g2.setStroke(stroke);
                g2.setColor(ic);
                g2.fillRect(0, 0, bounds.width, bounds.height);
                g2.setColor(c2);
                g2.drawRect(width / 2, width / 2, bounds.width - width, bounds.height - width);
                return icon;
            }
        }
        return null;
    }

    private static BasicStroke getStrokeFromBS(PdfObject form, float scaling, int cap) {
        PdfObject BS = form.getDictionary(4643);
        if (BS != null) {
            String s2 = BS.getName(35);
            int borderWidth = BS.getInt(39);
            if (borderWidth == -1) {
                borderWidth = 1;
            }
            PdfArrayIterator d2 = BS.getMixedArray(20);
            if (s2 == null || "S".equals(s2)) {
                borderWidth = (int)((float)borderWidth * scaling);
                return new BasicStroke(borderWidth, cap, 0);
            }
            if ("D".equals(s2)) {
                int count;
                float[] dash = new float[]{3.0f};
                if (d2 != null && d2.hasMoreTokens() && (count = d2.getTokenCount()) > 0) {
                    dash = d2.getNextValueAsFloatArray();
                }
                borderWidth = (int)((float)borderWidth * scaling);
                return new BasicStroke(borderWidth, cap, 0, 10.0f, dash, 0.0f);
            }
        }
        return new BasicStroke(1.0f, cap, 0);
    }

    private static void renderLinkBorder(PdfObject form, Graphics2D g2, float scaling, int boundsWidth, int boundsHeight) {
        PdfObject bs2 = form.getDictionary(4643);
        if (bs2 != null) {
            float borderWidth;
            switch (bs2.getInt(39)) {
                case 0: {
                    borderWidth = 0.0f;
                    break;
                }
                case -1: {
                    borderWidth = scaling;
                    break;
                }
                default: {
                    borderWidth = (float)bs2.getInt(39) * scaling;
                }
            }
            int bsStyle = bs2.getNameAsConstant(35);
            PdfArrayIterator bsDash = bs2.getMixedArray(20);
            switch (bsStyle) {
                case 35: 
                case 37: {
                    g2.setStroke(new BasicStroke(borderWidth));
                    break;
                }
                case 20: {
                    int count;
                    float[] dash = new float[]{3.0f};
                    if (bsDash != null && bsDash.hasMoreTokens() && (count = bsDash.getTokenCount()) > 0) {
                        dash = bsDash.getNextValueAsFloatArray();
                    }
                    g2.setStroke(new BasicStroke(borderWidth, 2, 0, 10.0f, dash, 0.0f));
                    break;
                }
                default: {
                    LogWriter.writeLog("Border type: " + bsStyle + " currently unsupported");
                }
            }
            int bWidth = (int)borderWidth;
            g2.setColor(AnnotationFactory.convertFloatArrayToColor(form.getFloatArray(19), new Color(0, 0, 0, 255)));
            if (bsStyle == 37) {
                g2.drawLine(bWidth / 2, boundsHeight - bWidth / 2 - 1, (int)((float)boundsWidth * scaling) - bWidth, boundsHeight - bWidth / 2 - 1);
            } else {
                g2.drawRect(bWidth / 2, bWidth / 2, (int)((float)boundsWidth * scaling) - bWidth, (int)((float)boundsHeight * scaling) - bWidth);
            }
        } else {
            float borderWidth;
            if (form.getDictionary(1110722433) != null) {
                PdfArrayIterator border = form.getMixedArray(1110722433);
                if (form.getMixedArray(1110722433).hasMoreTokens()) {
                    border.getNextValueAsInteger();
                    border.getNextValueAsInteger();
                    borderWidth = (float)border.getNextValueAsInteger() * scaling;
                    g2.setStroke(new BasicStroke(borderWidth));
                } else {
                    borderWidth = scaling;
                }
            } else {
                borderWidth = scaling;
                g2.setStroke(new BasicStroke(borderWidth));
            }
            int bWidth = (int)borderWidth;
            g2.setColor(AnnotationFactory.convertFloatArrayToColor(form.getFloatArray(19), new Color(0, 0, 0, 255)));
            g2.drawRect(bWidth / 2, bWidth / 2, (int)((float)boundsWidth * scaling) - bWidth, (int)((float)boundsHeight * scaling) - bWidth);
        }
    }

    private static BufferedImage getCircleIcon(PdfObject form, float scaling, float alpha) {
        Color c2 = AnnotationFactory.convertFloatArrayToColor(form.getFloatArray(19), new Color(0, 0, 0, 0));
        Color ic = AnnotationFactory.convertFloatArrayToColor(form.getFloatArray(6419), new Color(0, 0, 0, 0));
        float[] quad = form.getFloatArray(573911876);
        if (quad != null) {
            Rectangle bounds = AnnotationFactory.getFormBounds((FormObject)form, quad, scaling);
            if (bounds.width > 0 && bounds.height > 0) {
                BufferedImage icon = new BufferedImage(bounds.width, bounds.height, 6);
                Graphics2D g2 = icon.createGraphics();
                g2.setComposite(AlphaComposite.getInstance(3, alpha));
                BasicStroke stroke = AnnotationFactory.getStrokeFromBS(form, scaling, 2);
                int width = (int)stroke.getLineWidth();
                g2.setStroke(stroke);
                g2.setColor(ic);
                g2.fillOval(width / 2, width / 2, bounds.width - width, bounds.height - width);
                g2.setColor(c2);
                g2.drawOval(width / 2, width / 2, bounds.width - width, bounds.height - width);
                return icon;
            }
        }
        return null;
    }

    private static BufferedImage getLineIcon(PdfObject form, float scaling, float alpha) {
        Color c2 = AnnotationFactory.convertFloatArrayToColor(form.getFloatArray(19), new Color(0, 0, 0, 0));
        float[] quad = form.getFloatArray(573911876);
        float[] line = form.getFloatArray(28);
        if (quad != null && line != null) {
            Rectangle bounds = AnnotationFactory.getFormBounds((FormObject)form, quad, scaling);
            if (bounds.width > 0 && bounds.height > 0) {
                BufferedImage icon = new BufferedImage(bounds.width, bounds.height, 6);
                Graphics2D g2 = icon.createGraphics();
                g2.setComposite(AlphaComposite.getInstance(3, alpha));
                BasicStroke stroke = AnnotationFactory.getStrokeFromBS(form, scaling, 2);
                g2.setStroke(stroke);
                g2.setColor(c2);
                g2.drawLine((int)(line[0] * scaling) - bounds.x, (int)((float)bounds.height - (line[1] * scaling - (float)bounds.y)), (int)(line[2] * scaling) - bounds.x, (int)((float)bounds.height - (line[3] * scaling - (float)bounds.y)));
                return icon;
            }
        }
        return null;
    }

    private static BufferedImage getPolyIcon(PdfObject form, boolean line, float scaling, float alpha) {
        Color c2 = AnnotationFactory.convertFloatArrayToColor(form.getFloatArray(19), new Color(0, 0, 0, 0));
        Color ic = AnnotationFactory.convertFloatArrayToColor(form.getFloatArray(6419), new Color(0, 0, 0, 0));
        float[] quad = form.getFloatArray(573911876);
        float[] vertices = form.getFloatArray(1600681863);
        if (quad != null && vertices != null) {
            Rectangle bounds = AnnotationFactory.getFormBounds((FormObject)form, quad, scaling);
            if (bounds.width > 0 && bounds.height > 0) {
                BufferedImage icon = new BufferedImage(bounds.width, bounds.height, 6);
                Graphics2D g2 = icon.createGraphics();
                g2.setComposite(AlphaComposite.getInstance(3, alpha));
                BasicStroke stroke = AnnotationFactory.getStrokeFromBS(form, scaling, 2);
                g2.setStroke(stroke);
                GeneralPath gPath = new GeneralPath(1);
                gPath.moveTo((int)(vertices[0] * scaling) - bounds.x, (int)((float)bounds.height - (vertices[1] * scaling - (float)bounds.y)));
                for (int i2 = 2; i2 != vertices.length; i2 += 2) {
                    gPath.lineTo((int)(vertices[i2] * scaling) - bounds.x, (int)((float)bounds.height - (vertices[i2 + 1] * scaling - (float)bounds.y)));
                }
                if (!line) {
                    gPath.lineTo((int)(vertices[0] * scaling) - bounds.x, (int)((float)bounds.height - (vertices[1] * scaling - (float)bounds.y)));
                    g2.setColor(ic);
                    g2.fill(gPath);
                }
                g2.setColor(c2);
                g2.draw(gPath);
                return icon;
            }
        }
        return null;
    }

    private static BufferedImage getCaretIcon(PdfObject form, float alpha) {
        Color c2 = AnnotationFactory.convertFloatArrayToColor(form.getFloatArray(19), new Color(0, 0, 0, 0));
        float[] rd = form.getFloatArray(8724);
        float[] quad = form.getFloatArray(573911876);
        if (quad != null) {
            Rectangle bounds = AnnotationFactory.getFormBounds((FormObject)form, quad, 1.0f);
            if (bounds.width > 0 && bounds.height > 0) {
                BufferedImage icon = new BufferedImage(bounds.width, bounds.height, 6);
                Graphics2D g2 = icon.createGraphics();
                g2.setComposite(AlphaComposite.getInstance(3, alpha));
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g2.setStroke(new BasicStroke(rd[1]));
                g2.setColor(c2);
                g2.drawLine(0, bounds.height, bounds.width / 2, 0);
                g2.drawLine(bounds.width / 2, 0, bounds.width, bounds.height);
                return icon;
            }
        }
        return null;
    }

    private static BufferedImage getHightlightIcon(PdfObject form, float scaling, float alpha) {
        Color c2 = AnnotationFactory.convertFloatArrayToColor(form.getFloatArray(19), new Color(0));
        c2 = new Color(c2.getRed(), c2.getGreen(), c2.getBlue(), 128);
        float[] quad = form.getFloatArray(1785890247);
        if (quad != null) {
            Rectangle bounds = AnnotationFactory.getBounds((FormObject)form, quad);
            int scaledWidth = (int)((float)bounds.width * scaling);
            int scaledHeight = (int)((float)bounds.height * scaling);
            if (scaledWidth > 0 && (float)scaledHeight * scaling > 0.0f) {
                BufferedImage icon = new BufferedImage(scaledWidth, scaledHeight, 6);
                Graphics2D g2 = icon.createGraphics();
                g2.setComposite(AlphaComposite.getInstance(3, alpha));
                if (quad.length >= 8) {
                    AnnotationFactory.handleLargeQuadValue(scaling, c2, quad, bounds, g2);
                }
                return icon;
            }
        }
        return null;
    }

    private static BufferedImage getLinkIcon(FormObject form, float scaling, float alpha) {
        float[] quad;
        if (AnnotationFactory.hasBorder(form) && (quad = form.getFloatArray(573911876)) != null) {
            Rectangle bounds = AnnotationFactory.getBounds(form, quad);
            int scaledWidth = (int)((float)bounds.width * scaling);
            int scaledHeight = (int)((float)bounds.height * scaling);
            if (scaledWidth > 0 && (float)scaledHeight * scaling > 0.0f) {
                BufferedImage icon = new BufferedImage(scaledWidth, scaledHeight, 6);
                Graphics2D g2 = icon.createGraphics();
                g2.setComposite(AlphaComposite.getInstance(3, alpha));
                AnnotationFactory.renderLinkBorder(form, g2, scaling, bounds.width, bounds.height);
                return icon;
            }
        }
        return null;
    }

    private static boolean hasBorder(FormObject form) {
        boolean hasBorder;
        if (form.getDictionary(4643) != null) {
            hasBorder = form.getDictionary(4643).getInt(39) != 0;
        } else {
            PdfArrayIterator border = form.getMixedArray(1110722433);
            if (border.hasMoreTokens()) {
                border.getNextValueAsInteger();
                border.getNextValueAsInteger();
                int width = border.getNextValueAsInteger();
                hasBorder = width > 0;
            } else {
                hasBorder = border.isRawDataNull();
            }
        }
        return hasBorder;
    }

    private static void handleLargeQuadValue(float scaling, Color c2, float[] quad, Rectangle bounds, Graphics g2) {
        for (int hi = 0; hi != quad.length; hi += 8) {
            float x1 = quad[hi];
            float x2 = quad[hi + 2];
            float y1 = quad[hi + 1];
            float y2 = quad[hi + 3];
            for (int j2 = 0; j2 < 8; ++j2) {
                if (j2 % 2 == 0) {
                    if (quad[hi + j2] < x1) {
                        x1 = quad[hi + j2];
                    }
                    if (!(quad[hi + j2] > x2)) continue;
                    x2 = quad[hi + j2];
                    continue;
                }
                if (quad[hi + j2] < y1) {
                    y1 = quad[hi + j2];
                }
                if (!(quad[hi + j2] > y2)) continue;
                y2 = quad[hi + j2];
            }
            int x3 = (int)x1 - bounds.x;
            int y3 = (int)y1 - bounds.y;
            y3 = bounds.height - y3 - (int)(y2 - y1);
            int width = (int)(x2 - x1);
            int height = (int)(y2 - y1);
            Rectangle rh = new Rectangle((int)((float)x3 * scaling), (int)((float)y3 * scaling), (int)((float)width * scaling), (int)((float)height * scaling));
            g2.setColor(c2);
            g2.fillRect(rh.x, rh.y, rh.width, rh.height);
        }
    }

    private static Rectangle getBounds(FormObject form, float[] quad) {
        Rectangle bounds = form.getBoundingRectangle();
        if (bounds.getWidth() == 0.0 && bounds.getHeight() == 0.0) {
            for (int i2 = 0; i2 != quad.length; ++i2) {
                if (i2 % 2 == 0) {
                    if ((float)bounds.x > quad[i2]) {
                        bounds.x = (int)quad[i2];
                    }
                    if (!((float)(bounds.x + bounds.width) < quad[i2])) continue;
                    bounds.width = (int)(quad[i2] - (float)bounds.x);
                    continue;
                }
                if ((float)bounds.y > quad[i2]) {
                    bounds.y = (int)quad[i2];
                }
                if (!((float)(bounds.y + bounds.height) < quad[i2])) continue;
                bounds.height = (int)(quad[i2] - (float)bounds.y);
            }
        }
        return bounds;
    }

    private static BufferedImage getTextIcon(PdfObject form, float alpha) {
        String iconFile = AnnotationFactory.getPngImageForAnnotation(form);
        BufferedImage commentIcon = null;
        try {
            commentIcon = JDeli.read(AnnotationFactory.class.getResource(iconFile).openStream());
            if (commentIcon != null) {
                float[] rect = form.getFloatArray(573911876);
                rect[1] = rect[3] - (float)commentIcon.getHeight();
                rect[2] = rect[0] + (float)commentIcon.getWidth();
                form.setFloatArray(573911876, rect);
            }
            AnnotationFactory.setColorForAnnotation(form, commentIcon, (int)(255.0f * alpha));
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
        return commentIcon;
    }

    public static void loadFontValues(byte[] DS, Component textInput, float scaling) {
        textInput.setFont(new Font("SansSerif", 0, 12));
        int dsLength = DS.length;
        block9: for (int position = 0; position < dsLength && (position = StreamReaderUtils.skipSpaces(DS, position)) + 4 < dsLength; ++position) {
            int key = (DS[position++] << 24) + (DS[position++] << 16) + (DS[position++] << 8) + DS[position++];
            switch (key) {
                case 1718578804: {
                    switch (DS[position]) {
                        case 58: {
                            position = AnnotationFactory.readDSFont(position + 1, DS, textInput, scaling);
                            continue block9;
                        }
                        case 45: {
                            position = StreamReaderUtils.skipToCharacter(DS, position, 59);
                            continue block9;
                        }
                    }
                    LogWriter.writeLog("Unknown style key for FreeText annotation.");
                    continue block9;
                }
                case 1952807028: {
                    position = StreamReaderUtils.skipToCharacter(DS, position, 59);
                    continue block9;
                }
                case 1668246639: {
                    position = AnnotationFactory.readDSColor(position, DS, textInput);
                }
            }
        }
    }

    private static int readDSColor(int start, byte[] DS, Component textInput) {
        int position = StreamReaderUtils.skipToCharacter(DS, start, 58) + 1;
        if (DS[position = StreamReaderUtils.skipSpaces(DS, position)] == 35) {
            int colorStart = position;
            int colorEnd = position = StreamReaderUtils.skipToCharacter(DS, position, 59);
            byte[] colorSegment = Arrays.copyOfRange(DS, colorStart, colorEnd);
            int[] rgb = AnnotationUtils.readDSColorValues(colorSegment);
            Color c2 = new Color(rgb[0], rgb[1], rgb[2]);
            textInput.setForeground(c2);
        } else {
            LogWriter.writeLog("Unknown color for FreeText annotation.");
        }
        return position;
    }

    private static int readDSFont(int start, byte[] DS, Component textInput, float scaling) {
        int endOfFont = StreamReaderUtils.skipToCharacter(DS, start, 59);
        byte[] fontSegment = Arrays.copyOfRange(DS, start, endOfFont);
        String fontName = AnnotationUtils.readDSFontName(fontSegment);
        float fontSize = AnnotationUtils.readDSFontSize(fontSegment);
        if (fontSize > 0.0f) {
            String fontNameStr = StandardFonts.expandName(fontName);
            String altName = FontMappings.fontSubstitutionAliasTable.get(fontNameStr.toLowerCase());
            if (altName != null) {
                fontNameStr = altName;
            }
            fontNameStr = StandardFonts.expandName(fontNameStr);
            int fontSizeStr = (int)(fontSize * scaling);
            textInput.setFont(new Font(fontNameStr, 0, fontSizeStr));
        }
        return endOfFont;
    }

    private static void setColorForAnnotation(PdfObject form, BufferedImage commentIcon, int alpha) {
        float[] col = form.getFloatArray(19);
        if (col == null) {
            col = new float[]{1.0f, 1.0f, 1.0f};
        }
        Color c2 = new Color(col[0], col[1], col[2]);
        int rgb = c2.getRGB();
        for (int x2 = 0; x2 != commentIcon.getWidth(); ++x2) {
            for (int y2 = 0; y2 != commentIcon.getHeight(); ++y2) {
                int rgba = commentIcon.getRGB(x2, y2);
                if (rgba == -256) {
                    rgba = rgb & 0xFFFFFF | alpha << 24;
                }
                commentIcon.setRGB(x2, y2, rgba);
            }
        }
    }

    public static String getPngImageForAnnotation(PdfObject form) {
        String name = form.getName(506543413);
        if (name == null) {
            name = "Note";
        }
        switch (name) {
            case "Comment": {
                return "/org/jpedal/objects/acroforms/res/comment.png";
            }
            case "Check": {
                return "/org/jpedal/objects/acroforms/res/Check.png";
            }
            case "Checkmark": {
                return "/org/jpedal/objects/acroforms/res/Checkmark.png";
            }
            case "Circle": {
                return "/org/jpedal/objects/acroforms/res/Circle.png";
            }
            case "Cross": {
                return "/org/jpedal/objects/acroforms/res/Cross.png";
            }
            case "CrossHairs": {
                return "/org/jpedal/objects/acroforms/res/CrossHairs.png";
            }
            case "Help": {
                return "/org/jpedal/objects/acroforms/res/Help.png";
            }
            case "Insert": {
                return "/org/jpedal/objects/acroforms/res/InsertText.png";
            }
            case "Key": {
                return "/org/jpedal/objects/acroforms/res/Key.png";
            }
            case "NewParagraph": {
                return "/org/jpedal/objects/acroforms/res/NewParagraph.png";
            }
            case "Paragraph": {
                return "/org/jpedal/objects/acroforms/res/Paragraph.png";
            }
            case "RightArrow": {
                return "/org/jpedal/objects/acroforms/res/RightArrow.png";
            }
            case "RightPointer": {
                return "/org/jpedal/objects/acroforms/res/RightPointer.png";
            }
            case "Star": {
                return "/org/jpedal/objects/acroforms/res/Star.png";
            }
            case "UpLeftArrow": {
                return "/org/jpedal/objects/acroforms/res/Up-LeftArrow.png";
            }
            case "UpArrow": {
                return "/org/jpedal/objects/acroforms/res/UpArrow.png";
            }
        }
        return "/org/jpedal/objects/acroforms/res/TextNote.png";
    }

    private static BufferedImage getFileAttachmentIcon() {
        String iconFile = "/org/jpedal/objects/acroforms/res/FileAttachment.png";
        BufferedImage icon = null;
        try {
            icon = JDeli.read(AnnotationFactory.class.getResource("/org/jpedal/objects/acroforms/res/FileAttachment.png").openStream());
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
        return icon;
    }

    private static BufferedImage getSoundIcon(PdfObject form, float alpha) {
        String iconFile = "/org/jpedal/objects/acroforms/res/Speaker.png";
        String name = form.getName(506543413);
        if ("Mic".equals(name)) {
            iconFile = "/org/jpedal/objects/acroforms/res/Microphone.png";
        }
        BufferedImage icon = null;
        try {
            icon = JDeli.read(AnnotationFactory.class.getResource(iconFile).openStream());
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
        if (icon != null) {
            for (int x2 = 0; x2 != icon.getWidth(); ++x2) {
                for (int y2 = 0; y2 != icon.getHeight(); ++y2) {
                    int rgba = icon.getRGB(x2, y2);
                    rgba = rgba & 0xFFFFFF | (int)(255.0f * alpha) << 24;
                    icon.setRGB(x2, y2, rgba);
                }
            }
        }
        return icon;
    }

    public static void renderFlattenedAnnotation(PdfObject form, DynamicVectorRenderer current, int pageNumber, int rotation) {
        BufferedImage image = AnnotationFactory.getIcon(form);
        if (image != null) {
            GraphicsState gs = new GraphicsState();
            int iconHeight = image.getHeight();
            int iconWidth = image.getWidth();
            float[] rect = form.getFloatArray(573911876);
            if (form.getNameAsConstant(1147962727) == 607471684) {
                rect[2] = rect[0] + (float)iconWidth;
                rect[1] = rect[3] - (float)iconHeight;
                form.setFloatArray(573911876, rect);
                switch (rotation % 360) {
                    case 0: {
                        gs.CTM = new float[][]{{iconWidth, 0.0f, 1.0f}, {0.0f, iconHeight, 1.0f}, {0.0f, 0.0f, 0.0f}};
                        gs.x = rect[0];
                        gs.y = rect[3] - (float)iconHeight;
                        gs.CTM[2][0] = rect[0];
                        gs.CTM[2][1] = rect[3] - (float)iconHeight;
                        break;
                    }
                    case 90: {
                        gs.CTM = new float[][]{{0.0f, iconWidth, 1.0f}, {-iconHeight, 0.0f, 1.0f}, {0.0f, 0.0f, 0.0f}};
                        gs.x = rect[0] + (float)iconHeight;
                        gs.y = rect[3];
                        gs.CTM[2][0] = rect[0] + (float)iconHeight;
                        gs.CTM[2][1] = rect[3];
                        break;
                    }
                    case 180: {
                        gs.CTM = new float[][]{{-iconWidth, 0.0f, 1.0f}, {0.0f, -iconHeight, 1.0f}, {0.0f, 0.0f, 0.0f}};
                        gs.x = rect[0];
                        gs.y = rect[3] + (float)iconHeight;
                        gs.CTM[2][0] = rect[0];
                        gs.CTM[2][1] = rect[3] + (float)iconHeight;
                        break;
                    }
                    case 270: {
                        gs.CTM = new float[][]{{0.0f, -iconWidth, 1.0f}, {iconHeight, 0.0f, 1.0f}, {0.0f, 0.0f, 0.0f}};
                        gs.x = rect[0] - (float)iconHeight;
                        gs.y = rect[3];
                        gs.CTM[2][0] = rect[0] - (float)iconHeight;
                        gs.CTM[2][1] = rect[3];
                    }
                }
            } else {
                gs.CTM = new float[][]{{iconWidth, 0.0f, 1.0f}, {0.0f, iconHeight, 1.0f}, {0.0f, 0.0f, 0.0f}};
                gs.x = rect[0];
                gs.y = rect[3] - (float)iconHeight;
                gs.CTM[2][0] = rect[0];
                gs.CTM[2][1] = rect[3] - (float)iconHeight;
            }
            if (form.getNameAsConstant(1147962727) == 1919840408) {
                current.setGraphicsState(1, gs.getAlpha(1), 1111181679);
                current.setGraphicsState(2, gs.getAlpha(2), 1111181679);
            }
            int previousUse = ((FormObject)form).isAddedToHTML() ? -3 : -1;
            current.drawImage(pageNumber, image, gs, false, form.getObjectRefAsString(), previousUse);
            if (form.getNameAsConstant(1147962727) == 1919840408) {
                current.setGraphicsState(1, gs.getAlpha(1), 1111314299);
                current.setGraphicsState(2, gs.getAlpha(2), 1111314299);
            }
        }
    }

    public static String getCurrentDateAsString() {
        String date = "D:" + LocalDateTime.now().getYear() + String.format("%02d", LocalDateTime.now().getMonthValue()) + String.format("%02d", LocalDateTime.now().getDayOfMonth()) + String.format("%02d", LocalDateTime.now().getHour()) + String.format("%02d", LocalDateTime.now().getMinute()) + String.format("%02d", LocalDateTime.now().getSecond());
        int offset = OffsetDateTime.now().getOffset().getTotalSeconds();
        if (offset > 0) {
            date = date + '+';
        }
        if (offset != 0) {
            date = date + String.format("%02d", offset / 3600);
            date = date + '\'';
            date = date + String.format("%02d", offset % 3600 / 60);
            date = date + '\'';
        }
        return date;
    }

    public static float[] createInkCurve(float[] points) {
        float[] inkPoint = new float[points.length];
        inkPoint[0] = points[0];
        inkPoint[1] = points[1];
        int duplicateIDX = 2;
        for (int i2 = 2; i2 != points.length; i2 += 2) {
            if (inkPoint[duplicateIDX - 2] == points[i2] && inkPoint[duplicateIDX - 1] == points[i2 + 1]) continue;
            inkPoint[duplicateIDX] = points[i2];
            inkPoint[duplicateIDX + 1] = points[i2 + 1];
            duplicateIDX += 2;
        }
        inkPoint = Arrays.copyOf(inkPoint, duplicateIDX);
        float[] curvePoints = new float[inkPoint.length * 3 - 4];
        curvePoints[0] = inkPoint[0];
        curvePoints[1] = inkPoint[1];
        float[] controlPoints = AnnotationFactory.getControlPoints(inkPoint[0], inkPoint[1], inkPoint[0], inkPoint[1], inkPoint[2], inkPoint[3]);
        curvePoints[2] = controlPoints[2];
        curvePoints[3] = controlPoints[3];
        int idx = 4;
        for (int i3 = 2; i3 != inkPoint.length - 2; i3 += 2) {
            controlPoints = AnnotationFactory.getControlPoints(inkPoint[i3 - 2], inkPoint[i3 - 1], inkPoint[i3], inkPoint[i3 + 1], inkPoint[i3 + 2], inkPoint[i3 + 3]);
            curvePoints[idx] = controlPoints[0];
            curvePoints[++idx] = controlPoints[1];
            curvePoints[++idx] = inkPoint[i3];
            curvePoints[++idx] = inkPoint[i3 + 1];
            curvePoints[++idx] = controlPoints[2];
            curvePoints[++idx] = controlPoints[3];
            ++idx;
        }
        controlPoints = AnnotationFactory.getControlPoints(inkPoint[inkPoint.length - 4], inkPoint[inkPoint.length - 3], inkPoint[inkPoint.length - 2], inkPoint[inkPoint.length - 1], inkPoint[inkPoint.length - 2], inkPoint[inkPoint.length - 1]);
        curvePoints[curvePoints.length - 4] = controlPoints[0];
        curvePoints[curvePoints.length - 3] = controlPoints[1];
        curvePoints[curvePoints.length - 2] = inkPoint[inkPoint.length - 2];
        curvePoints[curvePoints.length - 1] = inkPoint[inkPoint.length - 1];
        return curvePoints;
    }

    private static float[] getControlPoints(float p1x, float p1y, float p2x, float p2y, float p3x, float p3y) {
        float[] controls = new float[4];
        float sideA = p1x - p3x;
        float sideB = p1y - p3y;
        float sideC = (float)Math.sqrt(sideA * sideA + sideB * sideB);
        float length1 = (float)Math.sqrt((p1x - p2x) * (p1x - p2x) + (p1y - p2y) * (p1y - p2y)) / 3.0f;
        float scale1 = length1 / sideC;
        controls[0] = p2x + sideA * scale1;
        controls[1] = p2y + sideB * scale1;
        float length2 = (float)Math.sqrt((p2x - p3x) * (p2x - p3x) + (p2y - p3y) * (p2y - p3y)) / 3.0f;
        float scale2 = length2 / sideC;
        controls[2] = p2x - sideA * scale2;
        controls[3] = p2y - sideB * scale2;
        return controls;
    }
}

