/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.actions;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.jpedal.PdfDecoder;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.GUIDisplay;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.ReturnValues;
import org.jpedal.objects.acroforms.actions.ActionHandler;
import org.jpedal.objects.acroforms.actions.DestHandler;
import org.jpedal.objects.acroforms.actions.FieldsHideObject;
import org.jpedal.objects.acroforms.actions.SoundHandler;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class EmptyActionHandler
implements ActionHandler {
    static final boolean showMethods = false;
    PdfObjectReader currentPdfFile;
    Javascript javascript;
    AcroRenderer acrorend;
    PdfDecoderInt decode_pdf;
    private final Map<String, String> Ccalled = new HashMap<String, String>();

    @Override
    public void init(PdfDecoderInt decode_pdf, Javascript javascript, AcroRenderer acrorend) {
        if (decode_pdf != null) {
            this.currentPdfFile = decode_pdf.getIO();
        }
        this.javascript = javascript;
        this.acrorend = acrorend;
        this.decode_pdf = decode_pdf;
    }

    @Override
    public Object setHoverCursor() {
        return new MouseListener(){

            @Override
            public void mouseEntered(MouseEvent e2) {
            }

            @Override
            public void mouseExited(MouseEvent e2) {
            }

            @Override
            public void mouseClicked(MouseEvent e2) {
            }

            @Override
            public void mousePressed(MouseEvent e2) {
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
            }
        };
    }

    @Override
    public void A(Object raw, FormObject formObj, int eventType) {
        switch (eventType) {
            case 4: {
                this.javascript.execute(formObj, 21, -1, ' ');
                break;
            }
            case 5: {
                this.javascript.execute(formObj, 40, -1, ' ');
                break;
            }
            case 1: {
                this.javascript.execute(formObj, 20, -1, ' ');
                break;
            }
            case 2: {
                this.javascript.execute(formObj, 17, -1, ' ');
                this.javascript.execute(formObj, 37, -1, ' ');
                break;
            }
        }
        PdfObject aData = null;
        if (eventType == 2) {
            aData = formObj.getDictionary(17);
        }
        if (aData == null && (aData = formObj.getDictionary(4369)) != null) {
            switch (eventType) {
                case 4: {
                    aData = aData.getDictionary(21);
                    break;
                }
                case 5: {
                    aData = aData.getDictionary(40);
                    break;
                }
                case 1: {
                    aData = aData.getDictionary(20);
                    break;
                }
                case 2: {
                    aData = aData.getDictionary(37);
                    break;
                }
            }
        }
        this.setCursor(eventType);
        this.gotoDest(formObj, eventType, 339034948);
        int subtype = formObj.getNameAsConstant(1147962727);
        int formType = formObj.getNameAsConstant(5668);
        int popupFlag = formObj.getActionFlag();
        if (formType == 2308407) {
            this.additionalAction_Signature(formObj, eventType);
        } else if (eventType == 3 && (popupFlag == 1 || subtype == 607471684)) {
            if (formObj.getDictionary(1647140) != null && formObj.getNameAsConstant(8740) == 1111442775) {
                FormObject IRT = (FormObject)formObj.getDictionary(1647140);
                this.currentPdfFile.checkResolved(IRT);
                formObj = IRT;
            }
            this.popup(raw, formObj, this.currentPdfFile);
        } else if (eventType == 3 && subtype == -1113876231) {
            this.handleFileAttachment(raw, formObj, this.currentPdfFile);
        } else {
            if (aData == null) {
                return;
            }
            this.executeAction(formObj, eventType, aData);
        }
    }

    protected void setCursor(int eventType) {
        PdfDecoder decode_pdf = (PdfDecoder)this.decode_pdf;
        if (decode_pdf != null) {
            if (eventType == 4) {
                if (GUIDisplay.allowChangeCursor) {
                    decode_pdf.setCursor(new Cursor(12));
                }
            } else if (eventType == 5 && GUIDisplay.allowChangeCursor) {
                decode_pdf.setCursor(new Cursor(0));
            }
        }
    }

    private void executeAction(FormObject formObj, int eventType, PdfObject aData) {
        int command = aData.getNameAsConstant(35);
        switch (command) {
            case 826094930: {
                this.additionalAction_Named(eventType, aData);
                break;
            }
            case 390014015: 
            case 1059340089: {
                this.gotoDest(aData, eventType, command);
                break;
            }
            case 1266841507: {
                this.additionalAction_ResetForm(aData);
                break;
            }
            case 1216126662: {
                this.additionalAction_SubmitForm(aData);
                break;
            }
            case -2006286978: {
                break;
            }
            case 406402101: {
                this.additionalAction_Hide(aData);
                break;
            }
            case 2433561: {
                this.additionalAction_URI(aData.getTextStreamValue(2433561));
                break;
            }
            case 1161711465: {
                this.additionalAction_Launch(aData);
                break;
            }
            case 1667731612: {
                this.additionalAction_OCState(eventType, aData);
                break;
            }
            case 1061502534: {
                if (eventType != 3 && eventType != 2) break;
                this.additionalAction_Sound(aData);
                break;
            }
            case -1: {
                LogWriter.writeLog("[forms] {stream} Activate Action UNKNOWN command " + aData.getName(35) + ' ' + formObj.getObjectRefAsString());
                break;
            }
            default: {
                LogWriter.writeLog("[forms] {stream} UNKNOWN Command " + aData.getName(35) + " Action");
            }
        }
    }

    protected void additionalAction_Launch(PdfObject aData) {
        PdfObject dict = aData.getDictionary(22);
        String target = null;
        if (dict != null) {
            target = dict.getTextStreamValue(22);
        }
        LogWriter.writeLog("[forms] {stream} Can't open " + target + " launch activate action NOT IMPLEMENTED");
    }

    protected void additionalAction_Sound(PdfObject aData) {
        PdfObject soundObj = aData.getDictionary(1061502534);
        this.currentPdfFile.checkResolved(soundObj);
        try {
            SoundHandler.play(soundObj);
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
    }

    protected void additionalAction_OCState(int eventType, PdfObject aData) {
        PdfArrayIterator state;
        if (eventType == 3 && (state = aData.getMixedArray(1144079448)) != null && state.getTokenCount() > 0) {
            PdfLayerList layers = (PdfLayerList)this.decode_pdf.getJPedalObject(826881374);
            int count = state.getTokenCount();
            int action = state.getNextValueAsConstant(true);
            for (int jj = 1; jj < count; ++jj) {
                String ref = state.getNextValueAsString(true);
                String layerName = layers.getNameFromRef(ref);
                Runnable updateAComponent = () -> {
                    boolean newState = action == 926376052 ? !layers.isVisible(layerName) : action != 0x1F1616;
                    layers.setVisiblity(layerName, newState);
                    try {
                        this.decode_pdf.decodePage(-1);
                    }
                    catch (Exception e2) {
                        LogWriter.writeLog("Exception: " + e2.getMessage());
                    }
                };
                try {
                    SwingUtilities.invokeAndWait(updateAComponent);
                    continue;
                }
                catch (InterruptedException | InvocationTargetException e2) {
                    LogWriter.writeLog("Exception: " + e2.getMessage());
                }
            }
        }
    }

    protected void additionalAction_Named(int eventType, PdfObject aData) {
        int name = aData.getNameAsConstant(30);
        switch (name) {
            case 1046904697: {
                this.changeTo(null, this.decode_pdf.getlastPageDecoded() + 1, null, null, true);
                break;
            }
            case 1081306235: {
                this.changeTo(null, this.decode_pdf.getlastPageDecoded() - 1, null, null, true);
                break;
            }
            case 1500740239: {
                this.changeTo(null, 1, null, null, true);
                break;
            }
            case 1013086841: {
                this.changeTo(null, this.decode_pdf.getPageCount(), null, null, true);
                break;
            }
            case 286725562: {
                break;
            }
            default: {
                LogWriter.writeLog("{internal only} Named Action NOT IMPLEMENTED " + aData.getName(30) + ' ' + this.decode_pdf.getFileName() + ' ' + eventType);
            }
        }
    }

    protected void additionalAction_SaveAs() {
        LogWriter.writeLog("[forms] {stream} save as action NOT IMPLEMENTED");
    }

    protected void additionalAction_URI(String url) {
        LogWriter.writeLog("[forms] {stream} Can't open " + url + " uri action NOT IMPLEMENTED");
    }

    protected void additionalAction_Print(int eventType) {
        LogWriter.writeLog("[forms] {stream} print action NOT IMPLEMENTED - event type = " + eventType);
    }

    protected void additionalAction_Hide(PdfObject aData) {
        FieldsHideObject fieldsToHide = new FieldsHideObject();
        EmptyActionHandler.getHideMap(aData, fieldsToHide);
        this.setFieldVisibility(fieldsToHide);
    }

    protected void additionalAction_SubmitForm(PdfObject aData) {
        int flags;
        PdfArrayIterator fieldList;
        boolean newExcludeList = false;
        String newSubmitURL = null;
        String[] newListOfFields = null;
        PdfObject dict = aData.getDictionary(22);
        if (dict != null) {
            newSubmitURL = dict.getTextStreamValue(22);
        }
        if ((fieldList = aData.getMixedArray(893143676)) != null) {
            if (fieldList.getTokenCount() < 1) {
                fieldList = null;
            }
            if (fieldList != null) {
                boolean fieldIndex = false;
                newListOfFields = new String[fieldList.getTokenCount()];
                String preName = null;
                StringBuilder names = new StringBuilder();
                while (fieldList.hasMoreTokens()) {
                    String formObject = fieldList.getNextValueAsString(true);
                    if (formObject.contains(".x")) {
                        preName = formObject.substring(formObject.indexOf(46) + 1, formObject.indexOf(".x") + 1);
                    }
                    if (!formObject.contains(" R")) continue;
                    FormObject formObj = new FormObject(formObject);
                    this.currentPdfFile.readObject(formObj);
                    String tok = formObj.getTextStreamValue(36);
                    if (preName != null) {
                        names.append(preName);
                    }
                    names.append(tok);
                    names.append(',');
                }
                newListOfFields[0] = names.toString();
            }
        }
        if (newListOfFields != null && ((flags = aData.getInt(1009858393)) & 1) == 1) {
            newExcludeList = true;
        }
        this.submitURL(newListOfFields, newExcludeList, newSubmitURL);
    }

    protected void additionalAction_ResetForm(PdfObject aData) {
        List fields;
        int flags = aData.getInt(1009858393);
        boolean shouldExclude = (flags & 1) == 1;
        List allFormObjects = Arrays.stream(this.acrorend.getFormComponents(null, ReturnValues.FORMOBJECTS_FROM_REF, -1)).filter(Objects::nonNull).map(FormObject.class::cast).collect(Collectors.toList());
        PdfArrayIterator fieldList = aData.getMixedArray(893143676);
        if (fieldList != null && fieldList.getTokenCount() > 0) {
            fields = new ArrayList(fieldList.getTokenCount());
            while (fieldList.hasMoreTokens()) {
                fields.add(fieldList.getNextValueAsString(true));
            }
        } else {
            fields = Collections.emptyList();
        }
        allFormObjects.stream().filter(formObject -> {
            if (fields.isEmpty()) {
                return true;
            }
            boolean contains = fields.contains(formObject.getTextStreamValue(36));
            return shouldExclude ? !contains : contains;
        }).forEach(FormObject::resetToDefault);
    }

    @Override
    public int gotoDest(PdfObject aData, int eventType, int command) {
        int page = -1;
        PdfArrayIterator Dest = DestHandler.getDestFromObject(aData, this.currentPdfFile);
        if (Dest != null && eventType == 3) {
            String filename = this.getFileName(aData);
            String pageRef = "";
            if (Dest.getTokenCount() > 0) {
                if (Dest.isNextValueNull()) {
                    return -1;
                }
                int possiblePage = Dest.getNextValueAsInteger(false) + 1;
                pageRef = Dest.getNextValueAsString(true);
                page = this.getPage(pageRef, possiblePage);
            }
            if (Dest.getTokenCount() == 0 && aData.getNameAsConstant(35) == 1059340089) {
                command = 1059340089;
            }
            switch (command) {
                case 339034948: {
                    if (Dest.getTokenCount() <= 1) break;
                    this.executeDest(page, Dest, filename);
                    break;
                }
                case 390014015: {
                    if (page == -1) break;
                    this.changeTo(null, page, null, null, true);
                    break;
                }
                case 1059340089: {
                    page = this.executeGotoR(filename, pageRef);
                }
            }
        }
        return page;
    }

    private int getPage(String pageRef, int possiblePage) {
        String newRef;
        int page = -1;
        if (pageRef.endsWith(" R")) {
            page = this.decode_pdf.getPageFromObjectRef(pageRef);
        } else if (possiblePage > 0 && possiblePage != 69561) {
            page = possiblePage;
        }
        if (page == -1 && (newRef = this.currentPdfFile.convertNameToRef(pageRef)) != null && newRef.endsWith(" R")) {
            page = this.decode_pdf.getPageFromObjectRef(newRef);
        }
        return page;
    }

    protected void executeDest(int page, PdfArrayIterator dest, String filename) {
        int type = dest.getNextValueAsConstant(true);
        Integer scale = null;
        Rectangle position = null;
        switch (type) {
            case 2631978: {
                float x2 = dest.getNextValueAsFloat();
                float y2 = dest.getNextValueAsFloat();
                position = new Rectangle((int)x2, (int)y2, 10, 10);
                break;
            }
            case 1456452: 
            case 372851730: {
                scale = -3;
                break;
            }
            case 372851736: {
                scale = -1;
                if (!dest.hasMoreTokens()) break;
                float top = dest.getNextValueAsFloat();
                position = new Rectangle(10, (int)top, 10, 10);
                break;
            }
        }
        this.changeTo(filename, page, position, scale, true);
    }

    private int executeGotoR(String filename, String pageRef) {
        int page;
        int index = pageRef.indexOf("P.");
        if (index != -1) {
            pageRef = pageRef.substring(index + 2);
            page = Integer.parseInt(pageRef);
        } else {
            page = "F".equals(pageRef) ? 1 : 1;
        }
        if (filename != null && new File(filename).exists()) {
            if (page != -1) {
                this.changeTo(filename, page, null, null, true);
            }
            LogWriter.writeLog("[forms] {DefaultActionHamdler.A} Form has GoToR command, needs methods for opening new file on page specified");
        } else {
            EmptyActionHandler.showMessageDialog("The file specified " + filename + " Does Not Exist!");
        }
        return page;
    }

    private String getFileName(PdfObject aData) {
        PdfObject fDic;
        String filename = aData.getTextStreamValue(22);
        if (filename == null && (fDic = aData.getDictionary(22)) != null) {
            filename = fDic.getTextStreamValue(22);
        }
        if (filename != null && filename.indexOf(47) == -1 && filename.indexOf(92) == -1) {
            filename = this.decode_pdf.getObjectStore().getCurrentFilepath() + filename;
        }
        if (filename != null) {
            int index = filename.indexOf(92);
            while (index != -1) {
                filename = filename.substring(0, index) + '/' + filename.substring(index + "\\".length());
                index = filename.indexOf(92);
            }
            int slashIndex = filename.indexOf(":/");
            if (!(slashIndex != -1 && slashIndex <= 1 || filename.startsWith("/"))) {
                File fileStart = new File(this.decode_pdf.getFileName());
                filename = fileStart.getParent() + '/' + filename;
            }
            if ((index = filename.indexOf("/../")) != -1) {
                int start;
                for (start = index - 1; start > 0 && filename.charAt(start) != '/'; --start) {
                }
                if (start > 0) {
                    filename = filename.substring(0, start) + filename.substring(index + 3);
                }
            }
        }
        return filename;
    }

    protected void handleFileAttachment(Object raw, FormObject formObj, PdfObjectReader currentPdfFile) {
        LogWriter.writeLog("[forms] {stream} file attachment action NOT IMPLEMENTED - " + raw + ' ' + formObj + ' ' + currentPdfFile);
    }

    protected void additionalAction_Signature(FormObject formObj, int eventType) {
        LogWriter.writeLog("[forms] {stream} signature action NOT IMPLEMENTED - " + formObj + ' ' + eventType);
    }

    @Override
    public void changeTo(String file, int page, Object location, Integer type, boolean storeView) {
    }

    @Override
    public PdfDecoderInt getPDFDecoder() {
        return this.decode_pdf;
    }

    @Override
    public void E(Object e2, FormObject formObj) {
        this.javascript.execute(formObj, 21, 6, ' ');
    }

    @Override
    public void X(Object e2, FormObject formObj) {
        this.javascript.execute(formObj, 40, 6, ' ');
    }

    @Override
    public void D(Object e2, FormObject formObj) {
        this.javascript.execute(formObj, 20, 6, ' ');
    }

    @Override
    public void U(Object e2, FormObject formObj) {
        this.javascript.execute(formObj, 37, 6, ' ');
    }

    @Override
    public void Fo(Object e2, FormObject formObj) {
        this.javascript.execute(formObj, 5695, 6, ' ');
    }

    @Override
    public void Bl(Object e2, FormObject formObj) {
        this.javascript.execute(formObj, 4668, 6, ' ');
    }

    @Override
    public void O(PdfObject pdfObject, int type) {
        this.O(pdfObject, type, null);
    }

    void O(PdfObject pdfObject, int type, Consumer<String> jsConsumer) {
        PdfObject JS;
        if (this.currentPdfFile == null) {
            return;
        }
        FormObject pageDictionary = (FormObject)pdfObject.getDictionary(type);
        this.currentPdfFile.checkResolved(pageDictionary);
        if (pageDictionary == null) {
            return;
        }
        FormObject Odictionary = (FormObject)pageDictionary.getDictionary(31);
        this.currentPdfFile.checkResolved(Odictionary);
        if (Odictionary == null) {
            return;
        }
        String jsCode = Odictionary.getTextStreamValue(6691);
        if (jsCode == null && (JS = Odictionary.getDictionary(6691)) != null) {
            jsCode = new String(JS.getDecodedStream());
        }
        this.javascript.executeAction(jsCode);
        if (jsConsumer != null) {
            jsConsumer.accept(jsCode);
        }
    }

    @Override
    public void PO(PdfObject pdfObject, int type) {
        this.PO(pdfObject, type, null);
    }

    void PO(PdfObject pdfObject, int type, Consumer<String> jsConsumer) {
        if (this.currentPdfFile == null) {
            return;
        }
        FormObject pageDictionary = (FormObject)pdfObject.getDictionary(type);
        this.currentPdfFile.checkResolved(pageDictionary);
        if (pageDictionary == null) {
            return;
        }
        FormObject POdictionary = (FormObject)pageDictionary.getDictionary(8223);
        this.currentPdfFile.checkResolved(POdictionary);
        if (POdictionary == null) {
            return;
        }
        String jsCode = POdictionary.getTextStreamValue(6691);
        this.javascript.executeAction(jsCode);
        if (jsConsumer != null) {
            jsConsumer.accept(jsCode);
        }
    }

    @Override
    public void PC(PdfObject pdfObject, int type) {
        this.PC(pdfObject, type, null);
    }

    void PC(PdfObject pdfObject, int type, Consumer<String> jsConsumer) {
        FormObject pageDictionary = (FormObject)pdfObject.getDictionary(type);
        this.currentPdfFile.checkResolved(pageDictionary);
        if (pageDictionary == null) {
            return;
        }
        FormObject PCdictionary = (FormObject)pageDictionary.getDictionary(8211);
        this.currentPdfFile.checkResolved(PCdictionary);
        if (PCdictionary == null) {
            return;
        }
        String jsCode = PCdictionary.getTextStreamValue(6691);
        this.javascript.executeAction(jsCode);
        if (jsConsumer != null) {
            jsConsumer.accept(jsCode);
        }
    }

    @Override
    public void PV(PdfObject pdfObject, int type) {
        this.PV(pdfObject, type, null);
    }

    void PV(PdfObject pdfObject, int type, Consumer<String> jsConsumer) {
        FormObject pageDictionary = (FormObject)pdfObject.getDictionary(type);
        this.currentPdfFile.checkResolved(pageDictionary);
        if (pageDictionary == null) {
            return;
        }
        FormObject PVdictionary = (FormObject)pageDictionary.getDictionary(8230);
        this.currentPdfFile.checkResolved(PVdictionary);
        if (PVdictionary == null) {
            return;
        }
        String jsCode = PVdictionary.getTextStreamValue(6691);
        this.javascript.executeAction(jsCode);
        if (jsConsumer != null) {
            jsConsumer.accept(jsCode);
        }
    }

    @Override
    public void PI(PdfObject pdfObject, int type) {
        this.PI(pdfObject, type, null);
    }

    void PI(PdfObject pdfObject, int type, Consumer<String> jsConsumer) {
        FormObject pageDictionary = (FormObject)pdfObject.getDictionary(type);
        this.currentPdfFile.checkResolved(pageDictionary);
        if (pageDictionary == null) {
            return;
        }
        FormObject PIdictionary = (FormObject)pageDictionary.getDictionary(8217);
        this.currentPdfFile.checkResolved(PIdictionary);
        if (PIdictionary == null) {
            return;
        }
        String jsCode = PIdictionary.getTextStreamValue(6691);
        this.javascript.executeAction(jsCode);
        if (jsConsumer != null) {
            jsConsumer.accept(jsCode);
        }
    }

    @Override
    public int K(Object ex, FormObject formObj, int actionID) {
        int result = this.javascript.execute(formObj, 27, actionID, EmptyActionHandler.getKeyPressed(ex));
        int fontSize = formObj.getTextSize();
        if (this.acrorend.getCompData() != null && (fontSize == 0 || fontSize == -1)) {
            this.acrorend.getCompData().setAutoFontSize(formObj);
        }
        return result;
    }

    @Override
    public void F(FormObject formObj) {
        this.javascript.execute(formObj, 22, 6, ' ');
    }

    @Override
    public void V(Object ex, FormObject formObj, int actionID) {
        this.javascript.execute(formObj, 38, actionID, EmptyActionHandler.getKeyPressed(ex));
    }

    @Override
    public void C(FormObject formObj) {
        if (this.Ccalled.get(formObj.getObjectRefAsString()) != null) {
            return;
        }
        this.Ccalled.put(formObj.getObjectRefAsString(), "1");
        this.javascript.execute(formObj, 4866, 6, ' ');
        this.Ccalled.remove(formObj.getObjectRefAsString());
    }

    private static void getHideMap(PdfObject aData, FieldsHideObject fieldToHide) {
        boolean[] hideFlags;
        String fieldList;
        String[] fieldstoHide = fieldToHide.getFieldArray();
        boolean[] whethertoHide = fieldToHide.getHideArray();
        if (aData.getTextStreamValue(36) != null && (fieldList = aData.getTextStreamValue(36)) != null) {
            String[] fields;
            if (fieldstoHide.length > 0) {
                fields = new String[fieldstoHide.length + 1];
                System.arraycopy(fieldstoHide, 0, fields, 0, fieldstoHide.length);
                fields[fields.length - 1] = fieldList;
            } else {
                fields = new String[]{fieldList};
            }
            fieldstoHide = fields;
        }
        boolean hideFlag = aData.getBoolean(24);
        if (whethertoHide.length > 0) {
            hideFlags = new boolean[whethertoHide.length + 1];
            System.arraycopy(whethertoHide, 0, hideFlags, 0, whethertoHide.length);
            hideFlags[hideFlags.length - 1] = hideFlag;
        } else {
            hideFlags = new boolean[]{hideFlag};
        }
        whethertoHide = hideFlags;
        fieldToHide.setFieldArray(fieldstoHide);
        fieldToHide.setHideArray(whethertoHide);
        if (aData.getDictionary(506808388) != null) {
            PdfObject nextDic = aData.getDictionary(506808388);
            EmptyActionHandler.getHideMap(nextDic, fieldToHide);
        }
    }

    protected static void showMessageDialog(String s2) {
        JOptionPane.showMessageDialog(null, s2);
    }

    private static char getKeyPressed(Object raw) {
        try {
            ComponentEvent ex = (ComponentEvent)raw;
            if (ex instanceof KeyEvent) {
                return ((KeyEvent)ex).getKeyChar();
            }
            return ' ';
        }
        catch (Exception ee) {
            System.out.println("Exception " + ee);
            return ' ';
        }
    }

    private void setFieldVisibility(FieldsHideObject fieldToHide) {
        boolean[] whetherToHide;
        String[] fieldsToHide = fieldToHide.getFieldArray();
        if (fieldsToHide.length != (whetherToHide = fieldToHide.getHideArray()).length) {
            LogWriter.writeLog("[forms] {custommouselistener} number of fields and nuber of hides or not the same");
            return;
        }
        for (int i2 = 0; i2 < fieldsToHide.length; ++i2) {
            this.hideComp(fieldsToHide[i2], !whetherToHide[i2]);
        }
    }

    private void hideComp(String compName, boolean visible) {
        Object[] checkObj = this.acrorend.getFormComponents(compName, ReturnValues.FORMOBJECTS_FROM_NAME, -1);
        Object[] allObj = this.acrorend.getFormComponents(compName, ReturnValues.FORMOBJECTS_FROM_NAME, -1);
        if (checkObj != null) {
            for (Object obj : allObj) {
                FormObject formObject = (FormObject)obj;
                Rectangle rect = formObject.getBoundingRectangle();
                if (rect == null) continue;
                float rx = rect.x;
                float ry = rect.y;
                float rwidth = rect.width;
                float rheight = rect.height;
                Rectangle rootRect = new Rectangle((int)rx, (int)ry, (int)rwidth, (int)rheight);
                for (Object possiblyHiddenObj : allObj) {
                    FormObject formObject2 = (FormObject)possiblyHiddenObj;
                    if (formObject2 == null || formObject2.getBoundingRectangle() == null || !rootRect.contains(formObject2.getBoundingRectangle())) continue;
                    formObject2.setVisible(!visible);
                }
                formObject.setVisible(visible);
            }
        }
    }

    protected void submitURL(String[] listOfFields, boolean excludeList, String submitURL) {
        if (submitURL != null) {
            Component[] compsToSubmit = new Component[]{};
            String[] includeNameList = new String[]{};
            if (listOfFields != null) {
                if (!excludeList) {
                    includeNameList = listOfFields;
                }
                for (int i2 = 0; i2 < includeNameList.length; ++i2) {
                    Component[] compsToAdd = (Component[])this.acrorend.getFormComponents(includeNameList[i2], ReturnValues.GUI_FORMS_FROM_NAME, -1);
                    if (compsToAdd == null) continue;
                    Component[] tmp = new Component[compsToSubmit.length + compsToAdd.length];
                    if (compsToAdd.length > 1) {
                        LogWriter.writeLog("[forms] (internal only) SubmitForm multipul components with same name");
                    }
                    int k2 = 0;
                    while (i2 < tmp.length) {
                        if (k2 < compsToSubmit.length) {
                            tmp[k2] = compsToSubmit[k2];
                        } else if (k2 - compsToSubmit.length < compsToAdd.length) {
                            tmp[k2] = compsToAdd[k2 - compsToSubmit.length];
                        }
                        ++k2;
                    }
                    compsToSubmit = tmp;
                }
            } else {
                compsToSubmit = (Component[])this.acrorend.getFormComponents(null, ReturnValues.GUI_FORMS_FROM_NAME, -1);
            }
            StringBuilder text = new StringBuilder();
            if (compsToSubmit != null) {
                for (Component aCompsToSubmit : compsToSubmit) {
                    if (aCompsToSubmit instanceof JTextComponent) {
                        text.append(((JTextComponent)aCompsToSubmit).getText());
                        continue;
                    }
                    if (aCompsToSubmit instanceof AbstractButton) {
                        text.append(((AbstractButton)aCompsToSubmit).getText());
                        continue;
                    }
                    if (aCompsToSubmit == null) continue;
                    LogWriter.writeLog("[forms] (internal only) SubmitForm field form type not accounted for");
                }
            }
        }
    }

    private void popup(Object raw, FormObject formObj, PdfObjectReader currentPdfFile) {
        if (((MouseEvent)raw).getClickCount() == 2) {
            FormObject popupObj = (FormObject)formObj.getDictionary(1061176672);
            currentPdfFile.checkResolved(popupObj);
            FormObject decodedObj = this.acrorend.getFormObject(popupObj.getObjectRefAsString());
            Object comp = decodedObj.getGUIComponent();
            if (comp != null) {
                JComponent popup;
                popup.setVisible(!(popup = (JComponent)comp).isVisible());
            }
            ((Component)((EventObject)raw).getSource()).setFocusable(false);
        }
    }

    @Override
    public PdfLayerList getLayerHandler() {
        if (this.decode_pdf == null) {
            return null;
        }
        Object layer = this.decode_pdf.getJPedalObject(826881374);
        if (layer == null) {
            return null;
        }
        return (PdfLayerList)layer;
    }
}

