/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.actions;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RectangularShape;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.jpedal.PdfDecoder;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.Display;
import org.jpedal.examples.viewer.Viewer;
import org.jpedal.examples.viewer.ViewerCommands;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.swing.SwingMouseUtils;
import org.jpedal.examples.viewer.gui.swing.SwingPortfolioContextMenu;
import org.jpedal.examples.viewer.gui.swing.SwingPortfolioUtils;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.ReturnValues;
import org.jpedal.objects.acroforms.actions.EmptyActionHandler;
import org.jpedal.objects.acroforms.gui.Summary;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.StringUtils;

public class DefaultActionHandler
extends EmptyActionHandler {
    private static final boolean showMethods = false;
    private SwingPortfolioContextMenu contextMenu;
    private final SwingGUI gui;

    public DefaultActionHandler(SwingGUI viewerGUI) {
        this.gui = viewerGUI;
    }

    private static void openNewViewer(String target) {
        try {
            Viewer viewer = new Viewer();
            Viewer.exitOnClose = false;
            viewer.setupViewer();
            viewer.openDefaultFile(ObjectStore.temp_dir + target);
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
    }

    private static void openAcrobatFormsGuide() {
        String acrobatJSGuideURL = "http://www.adobe.com/devnet/acrobat/pdfs/Acro6JSGuide.pdf";
        int option = JOptionPane.showConfirmDialog(null, Messages.getMessage("AcroForm_FormsJSGuide.urlQuestion") + '\n' + "http://www.adobe.com/devnet/acrobat/pdfs/Acro6JSGuide.pdf" + " ?\n\n" + Messages.getMessage("AcroForm_FormsJSGuide.urlFail"), Messages.getMessage("AcroForm_FormsJSGuide.Title"), 0);
        if (option == 0) {
            Viewer viewer = new Viewer();
            Viewer.exitOnClose = false;
            viewer.setupViewer();
            viewer.openDefaultFile("http://www.adobe.com/devnet/acrobat/pdfs/Acro6JSGuide.pdf");
        }
    }

    private void showSig(PdfObject sigObject) {
        PdfDecoder decode_pdf = (PdfDecoder)this.decode_pdf;
        JDialog frame = new JDialog(DefaultActionHandler.getParentJFrame(decode_pdf), "Signature Properties", true);
        Summary summary = new Summary(frame, sigObject);
        summary.setValues(sigObject.getName(506543413), sigObject.getTextStreamValue(826499443), sigObject.getTextStreamValue(1618506351));
        frame.getContentPane().add(summary);
        frame.setSize(550, 220);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    private static JFrame getParentJFrame(Component component) {
        while (component.getParent() != null) {
            if (component.getParent() instanceof JFrame) {
                return (JFrame)component.getParent();
            }
            component = component.getParent();
        }
        return null;
    }

    private void switchPage(int page) {
        PdfDecoder decode_pdf = (PdfDecoder)this.decode_pdf;
        if (decode_pdf.getDisplayView() == 2 || decode_pdf.getDisplayView() == 3) {
            Display d2 = decode_pdf.getPages();
            decode_pdf.scrollRectToVisible(new Rectangle(d2.getXCordForPage(page), d2.getYCordForPage(page), decode_pdf.getPdfPageData().getScaledCropBoxWidth(page), decode_pdf.getPdfPageData().getScaledCropBoxHeight(page)));
        }
    }

    @Override
    protected void additionalAction_OCState(int eventType, PdfObject aData) {
        PdfArrayIterator state;
        if (eventType == 3 && (state = aData.getMixedArray(1144079448)) != null && state.getTokenCount() > 0) {
            PdfLayerList layers = (PdfLayerList)this.decode_pdf.getJPedalObject(826881374);
            int count = state.getTokenCount();
            int action = state.getNextValueAsConstant(true);
            for (int jj = 1; jj < count; ++jj) {
                String ref = state.getNextValueAsString(true);
                String layerName = layers.getNameFromRef(ref);
                Runnable updateAComponent = () -> {
                    PdfDecoderInt decode_pdf2 = this.decode_pdf;
                    ((Component)((Object)decode_pdf2)).invalidate();
                    ((Component)((Object)decode_pdf2)).validate();
                    boolean newState = action == 926376052 ? !layers.isVisible(layerName) : action != 0x1F1616;
                    layers.setVisiblity(layerName, newState);
                    try {
                        this.decode_pdf.decodePage(-1);
                    }
                    catch (Exception e2) {
                        LogWriter.writeLog("Exception: " + e2.getMessage());
                    }
                };
                try {
                    SwingUtilities.invokeAndWait(updateAComponent);
                    continue;
                }
                catch (InterruptedException | InvocationTargetException e2) {
                    LogWriter.writeLog("Exception: " + e2.getMessage());
                }
            }
        }
    }

    private void print() {
        PdfDecoder decode_pdf = (PdfDecoder)this.decode_pdf;
        if (JOptionPane.showConfirmDialog(decode_pdf, Messages.getMessage("PdfViewerPrinting.ConfirmPrint"), Messages.getMessage("PdfViewerPrint.Printing"), 0) == 0) {
            PrinterJob printJob = PrinterJob.getPrinterJob();
            PageFormat pf = printJob.defaultPage();
            int orientation = decode_pdf.getPDFWidth() < decode_pdf.getPDFHeight() ? 1 : 0;
            pf.setOrientation(orientation);
            Paper paper = new Paper();
            paper.setSize(595.0, 842.0);
            paper.setImageableArea(43.0, 43.0, 509.0, 756.0);
            pf.setPaper(paper);
            printJob.setPrintable(decode_pdf, pf);
            try {
                printJob.print();
            }
            catch (PrinterException e1) {
                LogWriter.writeLog("[forms] ERROR Printing from Form AcroRenderer.customMouseListener.mousePressed " + Arrays.toString(e1.getStackTrace()));
            }
            decode_pdf.resetCurrentPrintPage();
            decode_pdf.invalidate();
            decode_pdf.updateUI();
            decode_pdf.repaint();
        }
    }

    private void scrollOnPage(int page, Object location, boolean storeView, int type) {
        SwingGUI gui;
        PdfDecoder decode_pdf = (PdfDecoder)this.decode_pdf;
        if (location != null) {
            Display pages = (Display)decode_pdf.getExternalHandler(16);
            double scaling = decode_pdf.getScaling();
            double x2 = ((double)decode_pdf.getPdfPageData().getMediaBoxWidth(page) - ((RectangularShape)location).getX()) * scaling + (double)pages.getXCordForPage(page);
            double y2 = ((double)decode_pdf.getPdfPageData().getCropBoxHeight(page) - ((RectangularShape)location).getY()) * scaling + (double)pages.getYCordForPage(page);
            location = new Rectangle((int)x2, (int)y2, (int)decode_pdf.getVisibleRect().getWidth(), (int)decode_pdf.getVisibleRect().getHeight());
            decode_pdf.scrollRectToVisible((Rectangle)location);
        }
        if ((gui = (SwingGUI)decode_pdf.getExternalHandler(11)) != null) {
            gui.scaleAndRotate();
            if (storeView) {
                gui.getCommand().executeCommand(ViewerCommands.ADDVIEW, new Object[]{page, location, type});
            }
        }
        decode_pdf.revalidate();
        decode_pdf.repaint();
    }

    @Override
    protected void handleFileAttachment(Object raw, FormObject formObj, PdfObjectReader currentPdfFile) {
        if (SwingMouseUtils.getMouseButton((MouseEvent)raw) == 1) {
            if (((MouseEvent)raw).getClickCount() == 2) {
                String filename;
                byte[] filenameBytes;
                SwingGUI gui = (SwingGUI)this.decode_pdf.getExternalHandler(11);
                PdfObject fileObject = formObj.getDictionary(5667);
                if (fileObject != null && (filenameBytes = fileObject.getTextStreamValueAsByte(9494)) != null && (filenameBytes = fileObject.getTextStreamValueAsByte(22)) != null && (filename = StringUtils.getTextString(filenameBytes, false)) != null) {
                    int pathEnd = filename.lastIndexOf(47);
                    if (pathEnd != -1) {
                        filename = filename.substring(pathEnd + 1);
                    }
                    SwingPortfolioUtils.openFile(gui, currentPdfFile, fileObject, filename);
                }
            }
        } else if (SwingMouseUtils.getMouseButton((MouseEvent)raw) == 3) {
            PdfObject fileObject;
            if (this.contextMenu == null) {
                SwingGUI gui = (SwingGUI)this.decode_pdf.getExternalHandler(11);
                this.contextMenu = new SwingPortfolioContextMenu(gui);
            }
            if ((fileObject = formObj.getDictionary(5667)) != null) {
                this.contextMenu.setUpObjects(currentPdfFile, fileObject);
                this.contextMenu.show(((ComponentEvent)raw).getComponent(), ((MouseEvent)raw).getX(), ((MouseEvent)raw).getY());
            }
        }
    }

    @Override
    public void init(PdfDecoderInt decode_pdf, Javascript javascript, AcroRenderer acrorend) {
        if (decode_pdf == null && this.gui != null && this.gui.getPdfDecoder() != null) {
            super.init(this.gui.getPdfDecoder(), javascript, acrorend);
        } else {
            super.init(decode_pdf, javascript, acrorend);
        }
    }

    @Override
    public Object setHoverCursor() {
        return new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e2) {
                DefaultActionHandler.this.setCursor(4);
            }

            @Override
            public void mouseExited(MouseEvent e2) {
                DefaultActionHandler.this.setCursor(5);
            }
        };
    }

    @Override
    protected void additionalAction_Launch(PdfObject aData) {
        PdfObject dict = aData.getDictionary(22);
        if (dict != null) {
            String target = dict.getTextStreamValue(22);
            try (InputStream sourceFile = this.getClass().getResourceAsStream("/org/jpedal/res/" + target);){
                if (sourceFile == null) {
                    JOptionPane.showMessageDialog(null, "Unable to locate " + target);
                } else {
                    int ptr = target.lastIndexOf(47);
                    if (ptr != -1) {
                        target = target.substring(ptr + 1);
                    }
                    File output = new File(ObjectStore.temp_dir + target);
                    ObjectStore.copy(new BufferedInputStream(sourceFile), new BufferedOutputStream(Files.newOutputStream(output.toPath(), new OpenOption[0])));
                    if (target.endsWith(".pdf")) {
                        DefaultActionHandler.openNewViewer(target);
                    } else if (DecoderOptions.isRunningOnMac) {
                        target = "open " + ObjectStore.temp_dir + target;
                        Runtime.getRuntime().exec(target);
                    }
                }
            }
            catch (HeadlessException | IOException e2) {
                LogWriter.writeLog("Exception: " + e2.getMessage());
            }
            catch (Error err) {
                LogWriter.writeLog("Error: " + err.getMessage());
            }
        }
    }

    @Override
    protected void additionalAction_Named(int eventType, PdfObject aData) {
        int name = aData.getNameAsConstant(30);
        switch (name) {
            case 1111047780: {
                this.additionalAction_Print(eventType);
                break;
            }
            case 1177891956: {
                this.additionalAction_SaveAs();
                break;
            }
            case 305220218: {
                SwingGUI gui = (SwingGUI)this.decode_pdf.getExternalHandler(11);
                if (gui == null) break;
                gui.getCommand().executeCommand(ViewerCommands.BACK, null);
                break;
            }
            case 1060982398: {
                SwingGUI swing;
                int selection;
                JComboBox<String> scaling = new JComboBox<String>(new String[]{Messages.getMessage("PdfViewerScaleWindow.text"), Messages.getMessage("PdfViewerScaleHeight.text"), Messages.getMessage("PdfViewerScaleWidth.text"), "25", "50", "75", "100", "125", "150", "200", "250", "500", "750", "1000"});
                int option = JOptionPane.showConfirmDialog(null, scaling, Messages.getMessage("PdfViewerToolbarScaling.text") + ':', -1);
                if (option == -1 || (selection = scaling.getSelectedIndex()) == -1 || (swing = (SwingGUI)this.decode_pdf.getExternalHandler(11)) == null) break;
                swing.setSelectedComboIndex(252, selection);
                swing.scaleAndRotate();
                break;
            }
            case 2121363126: {
                SwingGUI gui = (SwingGUI)this.decode_pdf.getExternalHandler(11);
                if (gui == null) break;
                gui.getCommand().executeCommand(ViewerCommands.FULLSCREEN, null);
                break;
            }
            case 286725562: {
                DefaultActionHandler.openAcrobatFormsGuide();
                break;
            }
            default: {
                super.additionalAction_Named(eventType, aData);
            }
        }
    }

    @Override
    protected void additionalAction_SaveAs() {
        SwingGUI gui = (SwingGUI)this.decode_pdf.getExternalHandler(11);
        if (gui != null) {
            gui.getCommand().executeCommand(ViewerCommands.SAVEFORM, null);
        }
    }

    @Override
    protected void additionalAction_URI(String url) {
        String noLinkToolTips = System.getProperty("org.jpedal.noURLaccess");
        if (noLinkToolTips != null && !"false".equalsIgnoreCase(noLinkToolTips)) {
            if (!"true".equalsIgnoreCase(noLinkToolTips)) {
                DefaultActionHandler.showMessageDialog(noLinkToolTips);
            }
        } else {
            try {
                if (url != null && !url.isEmpty()) {
                    if (url.startsWith("www.")) {
                        url = "https://" + url;
                        Desktop.getDesktop().browse(new URI(url));
                    } else if (url.startsWith("http")) {
                        Desktop.getDesktop().browse(new URI(url));
                    } else {
                        url = url.contains("/") ? url.replace('/', File.separatorChar) : url.replace('\\', File.separatorChar);
                        String loc = System.getProperty("org.jpedal.targetRelativeLinkDir") != null ? System.getProperty("org.jpedal.targetRelativeLinkDir") : this.decode_pdf.getObjectStore().getCurrentFilepath();
                        int separatorIndex = loc.lastIndexOf(File.separator);
                        String parent = "";
                        if (separatorIndex != -1) {
                            parent = loc.substring(0, separatorIndex);
                        }
                        if (url.contains("..")) {
                            url = parent.substring(0, parent.lastIndexOf(File.separator)) + url.substring(url.indexOf(46) + 2);
                        } else if (url.contains('.' + File.separator)) {
                            url = parent + url.substring(url.indexOf(46) + 1);
                        }
                        if (url.contains("%20")) {
                            url = url.replace("%20", " ");
                        }
                        if (url.startsWith("file:")) {
                            url = url.substring(5);
                        }
                        Desktop.getDesktop().open(new File(url));
                    }
                } else {
                    DefaultActionHandler.showMessageDialog(Messages.getMessage("PdfViewer.UrlError") + ' ' + url);
                }
            }
            catch (Exception e1) {
                DefaultActionHandler.showMessageDialog(Messages.getMessage("PdfViewer.UrlError") + ' ' + url);
                LogWriter.writeLog("Exception: " + e1.getMessage());
            }
        }
    }

    @Override
    protected void executeDest(int page, PdfArrayIterator dest, String filename) {
        if (dest.getTokenCount() > 1) {
            int type = dest.getNextValueAsConstant(true);
            Integer scale = null;
            Rectangle position = null;
            switch (type) {
                case 2631978: {
                    float x2 = dest.getNextValueAsFloat();
                    float y2 = dest.getNextValueAsFloat();
                    position = new Rectangle((int)x2, (int)y2, 10, 10);
                    break;
                }
                case 1456452: 
                case 372851730: {
                    scale = -3;
                    break;
                }
                case 372851736: {
                    scale = -1;
                    if (!dest.hasMoreTokens()) break;
                    float top = dest.getNextValueAsFloat();
                    position = new Rectangle(10, (int)top, 10, 10);
                    break;
                }
                case 372851746: {
                    float fitR_left = dest.getNextValueAsFloat();
                    float fitR_bottom = dest.getNextValueAsFloat();
                    float fitR_right = dest.getNextValueAsFloat();
                    float fitR_top = dest.getNextValueAsFloat();
                    SwingGUI gui = (SwingGUI)this.decode_pdf.getExternalHandler(11);
                    if (gui == null) break;
                    float scaling = gui.scaleToVisible(fitR_left, fitR_right, fitR_top, fitR_bottom);
                    scale = (int)(100.0f / scaling);
                }
            }
            this.changeTo(filename, page, position, scale, true);
        } else {
            this.changeTo(filename, page, null, null, true);
        }
    }

    @Override
    protected void additionalAction_Print(int eventType) {
        if (eventType == 2) {
            this.print();
        }
    }

    @Override
    protected void additionalAction_Signature(FormObject formObj, int eventType) {
        if (eventType == 3) {
            PdfObject sigObject = formObj.getDictionary(38);
            if (sigObject == null) {
                return;
            }
            this.showSig(sigObject);
        } else {
            this.setCursor(eventType);
        }
    }

    @Override
    public void changeTo(String file, int page, Object location, Integer type, boolean storeView) {
        Object gui;
        if (file != null) {
            try {
                gui = (SwingGUI)this.decode_pdf.getExternalHandler(11);
                if (gui != null) {
                    ((SwingGUI)gui).stopThumbnails();
                }
                if (file.startsWith("http://") || file.startsWith("ftp://") || file.startsWith("https:")) {
                    if (gui != null) {
                        ((SwingGUI)gui).getCommand().executeCommand(ViewerCommands.OPENURL, new Object[]{file});
                    } else {
                        this.decode_pdf.openPdfFileFromURL(file, true);
                    }
                } else if (gui != null) {
                    ((SwingGUI)gui).getCommand().executeCommand(ViewerCommands.OPENFILE, new Object[]{file});
                } else {
                    this.decode_pdf.openPdfFile(file);
                }
                if (page == -1) {
                    page = 1;
                }
            }
            catch (PdfException e2) {
                LogWriter.writeLog("Exception: " + e2.getMessage());
            }
        }
        if (page != -1 && this.decode_pdf.getPageCount() != 1 && (this.decode_pdf.getDisplayView() != 1 || this.decode_pdf.getDisplayView() == 1 && this.decode_pdf.getlastPageDecoded() != page) && page > 0 && page < this.decode_pdf.getPageCount() + 1) {
            try {
                this.switchPage(page);
                this.gui.setPage(page);
                this.gui.decodePage();
            }
            catch (Exception e3) {
                LogWriter.writeLog("Exception: " + e3.getMessage());
            }
            this.decode_pdf.setPageParameters(-1.0f, page);
        }
        if (type != null) {
            gui = this.decode_pdf.getExternalHandler(11);
            if (gui != null) {
                if (type < 0) {
                    ((SwingGUI)gui).setSelectedComboIndex(252, type + 3);
                } else {
                    ((SwingGUI)gui).setSelectedComboItem(252, type.toString());
                }
            }
            this.scrollOnPage(page, location, storeView, type);
        }
    }

    @Override
    public void D(Object e2, FormObject formObj) {
        if (formObj.getNameAsConstant(1147962727) == 876043389 || formObj.getNameAsConstant(1147962727) == 1061176672) {
            this.gui.getValues().setFormsChanged(true);
            this.gui.setViewerTitle();
        }
        super.D(e2, formObj);
    }

    @Override
    protected void submitURL(String[] listOfFields, boolean excludeList, String submitURL) {
        if (submitURL != null) {
            Component[] compsToSubmit = new Component[]{};
            String[] includeNameList = new String[]{};
            if (listOfFields != null) {
                if (!excludeList) {
                    includeNameList = listOfFields;
                }
                for (int i2 = 0; i2 < includeNameList.length; ++i2) {
                    Component[] compsToAdd = (Component[])this.acrorend.getFormComponents(includeNameList[i2], ReturnValues.GUI_FORMS_FROM_NAME, -1);
                    if (compsToAdd == null) continue;
                    Component[] tmp = new Component[compsToSubmit.length + compsToAdd.length];
                    if (compsToAdd.length > 1) {
                        LogWriter.writeLog("[forms] (internal only) SubmitForm multiple components with same name");
                    }
                    int k2 = 0;
                    while (i2 < tmp.length) {
                        if (k2 < compsToSubmit.length) {
                            tmp[k2] = compsToSubmit[k2];
                        } else if (k2 - compsToSubmit.length < compsToAdd.length) {
                            tmp[k2] = compsToAdd[k2 - compsToSubmit.length];
                        }
                        ++k2;
                    }
                    compsToSubmit = tmp;
                }
            } else {
                compsToSubmit = (Component[])this.acrorend.getFormComponents(null, ReturnValues.GUI_FORMS_FROM_NAME, -1);
            }
            StringBuilder text = new StringBuilder();
            if (compsToSubmit != null) {
                for (Component aCompsToSubmit : compsToSubmit) {
                    if (aCompsToSubmit instanceof JTextComponent) {
                        text.append(((JTextComponent)aCompsToSubmit).getText());
                        continue;
                    }
                    if (aCompsToSubmit instanceof AbstractButton) {
                        text.append(((AbstractButton)aCompsToSubmit).getText());
                        continue;
                    }
                    if (aCompsToSubmit == null) continue;
                    LogWriter.writeLog("[forms] (internal only) SubmitForm field form type not accounted for");
                }
            }
            try {
                Desktop.getDesktop().browse(new URI(submitURL + "?en&q=" + text));
            }
            catch (Exception e2) {
                LogWriter.writeLog("Exception: " + e2.getMessage());
            }
        }
    }
}

