/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms;

import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import org.jpedal.external.CustomFormPrint;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.FormRenderUtilsG2;
import org.jpedal.objects.acroforms.GUIData;
import org.jpedal.objects.acroforms.creation.AnnotationFactory;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.creation.JPedalBorderFactory;
import org.jpedal.objects.acroforms.overridingImplementations.CustomImageIcon;
import org.jpedal.objects.acroforms.overridingImplementations.FixImageIcon;
import org.jpedal.objects.acroforms.overridingImplementations.ReadOnlyTextIcon;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.utils.LogWriter;

public class SwingData
extends GUIData {
    public static boolean JVMBugRightAlignFix;
    private CustomFormPrint customFormPrint;
    private JFrame dummyPanel;
    private JPanel panel;
    public static int readOnlyScaling;
    private int maxLengthForTextOnPage;

    @Override
    public void dispose() {
        super.dispose();
        if (this.dummyPanel != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.dummyPanel.dispose();
            } else {
                try {
                    SwingUtilities.invokeAndWait(() -> this.dummyPanel.dispose());
                }
                catch (InterruptedException | InvocationTargetException e2) {
                    LogWriter.writeLog(e2);
                }
            }
        }
    }

    private void renderComponent(Graphics2D g2, FormObject formObject, Component comp, int rotation, int indent, boolean isPrinting) {
        boolean printCombo = false;
        if (comp != null) {
            boolean editable = false;
            int page = formObject.getPageNumber();
            if (comp instanceof JComboBox) {
                JComboBox combo = (JComboBox)comp;
                if (combo.isEditable()) {
                    editable = true;
                    combo.setEditable(false);
                }
                if (combo.getComponentCount() > 0) {
                    this.renderAsJTextField(g2, formObject, rotation, indent, isPrinting, combo);
                }
                printCombo = true;
            }
            if (!printCombo) {
                boolean isPainted;
                AffineTransform ax2 = g2.getTransform();
                if (isPrinting) {
                    this.scaleComponent(formObject, 1.0f, rotation, comp, false, indent, true);
                    this.setTransform(g2, comp, rotation, page);
                } else {
                    this.scaleComponent(formObject, 1.0f, rotation, comp, false, indent, false);
                    Rectangle rect = comp.getBounds();
                    g2.translate(rect.x - this.insetW, rect.y + this.cropOtherY[page]);
                    if (comp instanceof JTextComponent) {
                        int rotate;
                        if (this.pageData.getRotation(page) == 90 || this.pageData.getRotation(page) == 270) {
                            comp.setBounds(rect.x, rect.y, rect.height, rect.width);
                            rect = comp.getBounds();
                        }
                        if ((rotate = rotation - this.pageData.getRotation(0)) < 0) {
                            rotate = 360 + rotate;
                        }
                        SwingData.setFixImageTrnasform(g2, rect, rotate);
                    }
                }
                boolean bl2 = isPainted = JVMBugRightAlignFix && comp instanceof JTextField && SwingData.fixBrokenAlignmentInJAvaBug(g2, comp, this.maxLengthForTextOnPage);
                if (!isPainted) {
                    if (SwingUtilities.isEventDispatchThread()) {
                        comp.paint(g2);
                    } else {
                        try {
                            SwingUtilities.invokeAndWait(() -> comp.paint(g2));
                        }
                        catch (InterruptedException | InvocationTargetException e2) {
                            LogWriter.writeLog("Exception " + e2.getMessage());
                        }
                    }
                }
                if (isPrinting && comp instanceof JInternalFrame) {
                    this.scaleComponent(formObject, this.displayScaling, rotation, comp, false, indent, false);
                }
                g2.setTransform(ax2);
            }
            if (editable) {
                ((JComboBox)comp).setEditable(true);
            }
        }
    }

    private static boolean fixBrokenAlignmentInJAvaBug(Graphics2D g2, Component comp, int maxLengthForTextOnPage) {
        boolean isPainted = false;
        JTextField field = new JTextField();
        JTextField source = (JTextField)comp;
        if (source.getHorizontalAlignment() == 4) {
            String newText;
            field.setFont(source.getFont());
            field.setLocation(source.getLocation());
            field.setSize(source.getSize());
            field.setBorder(source.getBorder());
            field.setHorizontalAlignment(4);
            int additionalBlanks = 0;
            int width = g2.getFontMetrics(comp.getFont()).stringWidth(new String(SwingData.createCharArray(maxLengthForTextOnPage - source.getText().length())) + source.getText());
            int eightPointWidth = g2.getFontMetrics(comp.getFont().deriveFont(7.0f)).stringWidth(new String(SwingData.createCharArray(maxLengthForTextOnPage - source.getText().length())) + source.getText());
            int difference = width - eightPointWidth;
            if (difference > 0) {
                additionalBlanks = difference / g2.getFontMetrics(comp.getFont().deriveFont(7.0f)).stringWidth(" ");
            }
            String originalTest = source.getText();
            int bunchOfSpaces = maxLengthForTextOnPage + additionalBlanks - source.getText().length();
            field.setText(new String(SwingData.createCharArray(bunchOfSpaces)) + originalTest);
            width = g2.getFontMetrics(comp.getFont()).stringWidth(field.getText());
            int insets = 0;
            if (field.getBorder() != null) {
                insets = field.getBorder().getBorderInsets((Component)field).left + field.getBorder().getBorderInsets((Component)field).right;
            }
            boolean needsChange = false;
            while (bunchOfSpaces > 0 && width > field.getWidth() - insets) {
                bunchOfSpaces = maxLengthForTextOnPage + additionalBlanks - source.getText().length();
                newText = new String(SwingData.createCharArray(bunchOfSpaces)) + originalTest;
                field.setText(newText);
                --additionalBlanks;
                width = g2.getFontMetrics(comp.getFont().deriveFont(7.0f)).stringWidth(field.getText());
                needsChange = true;
            }
            if (needsChange) {
                bunchOfSpaces = maxLengthForTextOnPage + --additionalBlanks - source.getText().length();
                newText = new String(SwingData.createCharArray(bunchOfSpaces)) + originalTest;
                field.setText(newText);
            }
            field.paint(g2);
            isPainted = true;
        }
        return isPainted;
    }

    private static void setFixImageTrnasform(Graphics2D g2, Rectangle rect, int rotate) {
        switch (rotate) {
            case 270: {
                AffineTransform at2 = AffineTransform.getRotateInstance((double)rotate * Math.PI / 180.0, 0.0, 0.0);
                g2.transform(at2);
                g2.translate(-rect.width, 0);
                break;
            }
            case 90: {
                AffineTransform at3 = AffineTransform.getRotateInstance((double)rotate * Math.PI / 180.0, 0.0, 0.0);
                g2.transform(at3);
                g2.translate(0, -rect.height);
                break;
            }
            case 180: {
                AffineTransform at4 = AffineTransform.getRotateInstance((double)rotate * Math.PI / 180.0, 0.0, 0.0);
                g2.transform(at4);
                g2.translate(-rect.width, -rect.height);
            }
        }
    }

    private void setTransform(Graphics2D g2, Component comp, int rotation, int page) {
        switch (360 - rotation) {
            case 270: {
                AffineTransform at2 = AffineTransform.getRotateInstance(4.71238898038469, 0.0, 0.0);
                g2.translate(comp.getBounds().y + this.cropOtherY[page] - this.insetH, this.pageData.getCropBoxHeight(page) - comp.getBounds().x + this.insetW);
                g2.transform(at2);
                g2.translate(-this.insetW, 0);
                break;
            }
            case 90: {
                AffineTransform at3 = AffineTransform.getRotateInstance(1.5707963267948966, 0.0, 0.0);
                g2.translate(comp.getBounds().y + this.cropOtherY[page] - this.insetH, comp.getBounds().x + this.insetW);
                g2.transform(at3);
                g2.translate(0, -this.insetH);
                break;
            }
            case 180: {
                AffineTransform at4 = AffineTransform.getRotateInstance(Math.PI, 0.0, 0.0);
                g2.translate(comp.getBounds().x - this.insetW, comp.getBounds().y + this.cropOtherY[page]);
                g2.transform(at4);
                g2.translate(-this.insetW, -this.insetH);
                break;
            }
            default: {
                g2.translate(comp.getBounds().x - this.insetW, comp.getBounds().y + this.cropOtherY[page]);
            }
        }
    }

    private void renderAsJTextField(Graphics2D g2, FormObject formObject, int rotation, int indent, boolean isPrinting, JComboBox<String> combo) {
        Object selected = combo.getSelectedItem();
        if (selected != null) {
            JTextField text = new JTextField();
            text.setText(selected.toString());
            text.setBackground(combo.getBackground());
            text.setForeground(combo.getForeground());
            text.setFont(combo.getFont());
            text.setBorder(combo.getBorder());
            this.renderComponent(g2, formObject, text, rotation, indent, isPrinting);
        }
    }

    private void renderComponent(Graphics2D g2, FormObject formObject, boolean isPrinting) {
        int page = formObject.getPageNumber();
        AffineTransform ax2 = g2.getTransform();
        Font backup = g2.getFont();
        Stroke st = g2.getStroke();
        Color old = g2.getColor();
        Shape oldClip = g2.getClip();
        Composite oldCom = g2.getComposite();
        g2.translate(0, this.pageData.getMediaBoxHeight(page) - this.pageData.getCropBoxHeight(page));
        float[] col = formObject.getFloatArray(19);
        Color bgColor = null;
        if (col != null) {
            bgColor = col[0] > 1.0f || col[1] > 1.0f || col[2] > 1.0f ? new Color((int)col[0], (int)col[1], (int)col[2]) : new Color(col[0], col[1], col[2]);
        }
        if (formObject.getNameAsConstant(1147962727) == 1061176672 && formObject.getBoolean(524301630)) {
            FormRenderUtilsG2.renderPopupWindow(g2, formObject, bgColor, isPrinting, this.pageData.getCropBoxHeight(page));
        }
        g2.setFont(backup);
        if (AcroRenderer.isAnnotation(formObject) && formObject.getNameAsConstant(1147962727) != 876043389) {
            BufferedImage bi2 = AnnotationFactory.getIcon(formObject);
            g2.drawImage((Image)bi2, formObject.getBoundingRectangle().x, this.pageData.getCropBoxHeight(page) - (formObject.getBoundingRectangle().y + formObject.getBoundingRectangle().height), null);
        } else {
            int borderWidth = FormRenderUtilsG2.renderBorder(g2, formObject, this.pageData.getCropBoxHeight(page));
            g2.setStroke(st);
            String textValue = formObject.getValue();
            if (textValue != null) {
                FontMetrics metrics = FormRenderUtilsG2.renderFont(g2, formObject, textValue, borderWidth);
                int justification = formObject.getAlignment();
                Rectangle2D r2 = metrics.getStringBounds(textValue, g2);
                if (formObject.getFieldFlags()[17]) {
                    justification = 0;
                }
                if (formObject.getObjectArray(2048068) != null && !formObject.getFieldFlags()[18]) {
                    FormRenderUtilsG2.renderComboForms(g2, formObject, metrics, r2, borderWidth, justification, this.pageData.getCropBoxHeight(page));
                } else if (!textValue.isEmpty()) {
                    g2.setClip(new Rectangle(formObject.getBoundingRectangle().x + borderWidth - 1, this.pageData.getCropBoxHeight(page) - (formObject.getBoundingRectangle().y + formObject.getBoundingRectangle().height) + borderWidth - 1, formObject.getBoundingRectangle().width - borderWidth * 2 + 2, formObject.getBoundingRectangle().height - borderWidth * 2 + 2));
                    if (formObject.getFieldFlags()[13]) {
                        FormRenderUtilsG2.renderMultilineTextField(g2, formObject, metrics, r2, textValue, borderWidth, justification, this.pageData.getCropBoxHeight(page));
                    } else {
                        FormRenderUtilsG2.renderSingleLineTextField(g2, formObject, metrics, r2, textValue, borderWidth, justification, this.pageData.getCropBoxHeight(page));
                    }
                }
            }
            FormRenderUtilsG2.renderQuadPoint(g2, formObject, bgColor, this.pageData.getCropBoxHeight(page));
        }
        g2.setTransform(ax2);
        g2.setFont(backup);
        g2.setStroke(st);
        g2.setColor(old);
        g2.setClip(oldClip);
        g2.setComposite(oldCom);
    }

    private static char[] createCharArray(int count) {
        if (count <= 0) {
            return new char[0];
        }
        char[] result = new char[count];
        Arrays.fill(result, 0, result.length, ' ');
        return result;
    }

    @Override
    public void renderFormsOntoG2(Object raw, int pageIndex, int currentIndent, int currentRotation, Map<Integer, String> componentsToIgnore, FormFactory formFactory, int pageHeight) {
        if (this.formsUnordered != null && !this.rasterizeForms) {
            if (GraphicsEnvironment.isHeadless() || formFactory == null) {
                this.renderFormsOntoG2InHeadless(raw, pageIndex, componentsToIgnore, formFactory);
            } else {
                this.renderFormsOntoG2WithSwing(raw, pageIndex, currentIndent, currentRotation, componentsToIgnore, formFactory, pageHeight);
            }
        }
    }

    @Override
    public void renderFormsOntoG2InHeadless(Object raw, int pageIndex, Map<Integer, String> componentsToIgnore, FormFactory formFactory) {
        if (this.formsOrdered == null || this.formsOrdered[pageIndex] == null) {
            return;
        }
        this.componentsToIgnore = componentsToIgnore;
        boolean isPrinting = formFactory != null;
        Graphics2D g2 = (Graphics2D)raw;
        AffineTransform defaultAf = g2.getTransform();
        AffineTransform aff = g2.getTransform();
        aff.scale(1.0, -1.0);
        aff.translate(0.0, -this.pageData.getCropBoxHeight(pageIndex));
        g2.setTransform(aff);
        for (FormObject nextVal : this.formsOrdered[pageIndex]) {
            FormObject formObject;
            boolean[] flags;
            if (nextVal == null || (flags = (formObject = nextVal).getCharacteristics())[1] || isPrinting && !flags[2]) continue;
            this.renderComponent(g2, formObject, isPrinting);
        }
        g2.setTransform(defaultAf);
    }

    private int getMaxLengthForTextOnPage(List<FormObject> formsOrdered) {
        int maxLengthForTextOnPage = 0;
        for (FormObject o2 : formsOrdered) {
            JTextField text;
            int newLength;
            Component comp;
            if (o2 == null || !((comp = (Component)this.checkGUIObjectResolved(o2)) instanceof JTextField) || (newLength = (text = (JTextField)comp).getText().length()) <= maxLengthForTextOnPage || text.getHorizontalAlignment() != 4) continue;
            maxLengthForTextOnPage = newLength;
        }
        return maxLengthForTextOnPage;
    }

    private void renderFormToG2WithSwing(Component comp, Graphics2D g2, FormObject formObject, int currentRotation, int currentIndent, boolean isPrinting) {
        boolean customPrintoverRide = false;
        if (this.customFormPrint != null) {
            this.scaleComponent(formObject, 1.0f, this.rotation, comp, false, this.indent, isPrinting);
            customPrintoverRide = this.customFormPrint.print(g2, formObject, this);
        }
        if (!customPrintoverRide) {
            Icon obj;
            if (comp instanceof AbstractButton && (obj = ((AbstractButton)comp).getIcon()) != null) {
                if (obj instanceof FixImageIcon) {
                    ((FixImageIcon)obj).setPrinting(true, 1);
                } else if (readOnlyScaling > 0 && obj instanceof ReadOnlyTextIcon) {
                    ((ReadOnlyTextIcon)obj).setPrinting(true, readOnlyScaling);
                }
            }
            this.dummyPanel.add(comp);
            this.renderComponent(g2, formObject, comp, currentRotation, currentIndent, isPrinting);
            this.dummyPanel.remove(comp);
            if (comp instanceof AbstractButton) {
                obj = ((AbstractButton)comp).getIcon();
                if (obj instanceof FixImageIcon) {
                    ((FixImageIcon)obj).setPrinting(false, 1);
                } else if (obj instanceof ReadOnlyTextIcon) {
                    ((ReadOnlyTextIcon)obj).setPrinting(false, 1);
                }
            }
        }
    }

    private void renderListToG2WithSwing(JList<String> comp2, Graphics2D g2, FormObject formObject, int currentRotation, int currentIndent, boolean isPrinting) {
        this.dummyPanel.add(comp2);
        ListModel<String> model = comp2.getModel();
        String[] array = new String[model.getSize()];
        int selectedIndex = comp2.getSelectedIndex();
        int c2 = 0;
        array[c2++] = model.getElementAt(selectedIndex);
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (i2 == selectedIndex) continue;
            array[c2++] = model.getElementAt(i2);
        }
        comp2.setListData((String[])array);
        comp2.setSelectedIndex(0);
        this.renderComponent(g2, formObject, comp2, currentRotation, currentIndent, isPrinting);
        this.dummyPanel.remove(comp2);
    }

    private void renderFormsOntoG2WithSwing(Object raw, int pageIndex, int currentIndent, int currentRotation, Map<Integer, String> componentsToIgnore, FormFactory formFactory, int pageHeight) {
        boolean isPrinting;
        this.componentsToIgnore = componentsToIgnore;
        boolean bl2 = isPrinting = formFactory != null;
        if (JVMBugRightAlignFix && isPrinting) {
            this.maxLengthForTextOnPage = this.getMaxLengthForTextOnPage(this.formsOrdered[pageIndex]);
        }
        Graphics2D g2 = (Graphics2D)raw;
        AffineTransform defaultAf = g2.getTransform();
        AffineTransform aff = g2.getTransform();
        aff.scale(1.0, -1.0);
        aff.translate(0.0, -pageHeight - this.insetH);
        g2.setTransform(aff);
        if (this.dummyPanel == null) {
            this.dummyPanel = new JFrame();
            this.dummyPanel.setDefaultCloseOperation(2);
            this.dummyPanel.pack();
        }
        for (FormObject formObject : this.formsOrdered[pageIndex]) {
            boolean[] flags;
            if (formObject == null || (flags = formObject.getCharacteristics())[1] || isPrinting && !flags[2]) continue;
            this.checkGUIObjectResolved(formObject);
            Component comp = (Component)formObject.getGUIComponent();
            if (comp == null || !comp.isVisible()) continue;
            Rectangle bounds = formObject.getBoundingRectangle();
            float boundHeight = bounds.height;
            if (this.componentsToIgnore != null && (this.componentsToIgnore.containsKey(formObject.getNameAsConstant(1147962727)) || this.componentsToIgnore.containsKey(formObject.getNameAsConstant(608780341)))) continue;
            if (comp instanceof JList && ((JList)comp).getSelectedIndex() != -1 && boundHeight < (float)(comp.getSize().height + 6)) {
                this.renderListToG2WithSwing((JList)comp, g2, formObject, currentRotation, currentIndent, isPrinting);
                continue;
            }
            this.renderFormToG2WithSwing(comp, g2, formObject, currentRotation, currentIndent, isPrinting);
        }
        g2.setTransform(defaultAf);
        if (this.currentPage == pageIndex && this.panel != null) {
            this.resetScaledLocation(this.displayScaling, this.rotation, this.indent);
        }
    }

    private void scaleComponent(FormObject formObject, float scale, int rotate, Component curComp, boolean redraw, int indent, boolean isPrinting) {
        if (curComp == null || formObject.getPageNumber() == -1) {
            return;
        }
        int curPage = formObject.getPageNumber();
        int[] bounds = formObject.getNameAsConstant(1147962727) == 1061176672 && !isPrinting ? this.updateLocation(formObject, scale, rotate) : this.updateLocationAndBounds(formObject, scale, rotate, redraw);
        Font resetFont = curComp.getFont();
        if (resetFont != null) {
            if (formObject.getNameAsConstant(1147962727) == 980909433) {
                byte[] DSString = formObject.getTextStreamValueAsByte(5155);
                if (DSString != null) {
                    AnnotationFactory.loadFontValues(DSString, curComp, scale);
                } else {
                    curComp.setFont(curComp.getFont().deriveFont(formObject.getFontSize()));
                }
            } else if (formObject.getNameAsConstant(1147962727) != 1061176672) {
                SwingData.recalcFontSize(scale, rotate, formObject, curComp);
            } else if (isPrinting) {
                curComp.setFont(curComp.getFont().deriveFont(formObject.getFontSize() * 0.75f));
            } else {
                curComp.setFont(curComp.getFont().deriveFont(formObject.getFontSize()));
            }
        }
        if (curComp instanceof JComponent && ((JComponent)curComp).getBorder() != null) {
            ((JComponent)curComp).setBorder(SwingData.generateBorderfromForm(formObject, scale));
        }
        if (this.xReached != null) {
            bounds[0] = bounds[0] + this.xReached[curPage];
            bounds[1] = bounds[1] + this.yReached[curPage];
        }
        int pageWidth = (this.pageData.getRotation(curPage) + rotate) % 180 == 90 ? this.pageData.getCropBoxHeight(curPage) : this.pageData.getCropBoxWidth(curPage);
        if (this.displayView == 2) {
            double newIndent = rotate == 0 || rotate == 180 ? (double)((this.widestPageNR - pageWidth) / 2) : (double)((this.widestPageR - pageWidth) / 2);
            indent = (int)((double)indent + newIndent * (double)scale);
        }
        int totalOffsetX = this.userX + indent + this.insetW;
        int totalOffsetY = this.userY + this.insetH;
        Rectangle boundRect = new Rectangle(totalOffsetX + bounds[0], totalOffsetY + bounds[1], bounds[2], bounds[3]);
        curComp.setBounds(boundRect);
        if (curComp instanceof AbstractButton) {
            SwingData.rescaleIcon(rotate, curComp, curPage, this.displayView, this.pageData);
        }
    }

    private static void rescaleIcon(int rotate, Component curComp, int curPage, int displayView, PdfPageData pageData) {
        AbstractButton but = (AbstractButton)curComp;
        Icon curIcon = but.getIcon();
        boolean displaySingle = false;
        if (displayView == 1 || displayView == 0) {
            displaySingle = true;
        }
        int combinedRotation = !displaySingle ? rotate + pageData.getRotation(curPage) : rotate;
        if (curIcon instanceof FixImageIcon || curIcon instanceof ReadOnlyTextIcon) {
            ((CustomImageIcon)curIcon).setAttributes(curComp.getWidth(), curComp.getHeight(), combinedRotation, displaySingle);
        }
        if ((curIcon = but.getPressedIcon()) instanceof FixImageIcon) {
            ((CustomImageIcon)curIcon).setAttributes(curComp.getWidth(), curComp.getHeight(), combinedRotation, displaySingle);
        }
        if ((curIcon = but.getSelectedIcon()) instanceof FixImageIcon) {
            ((CustomImageIcon)curIcon).setAttributes(curComp.getWidth(), curComp.getHeight(), combinedRotation, displaySingle);
        }
        if ((curIcon = but.getRolloverIcon()) instanceof FixImageIcon) {
            ((CustomImageIcon)curIcon).setAttributes(curComp.getWidth(), curComp.getHeight(), combinedRotation, displaySingle);
        }
        if ((curIcon = but.getRolloverSelectedIcon()) instanceof FixImageIcon) {
            ((CustomImageIcon)curIcon).setAttributes(curComp.getWidth(), curComp.getHeight(), combinedRotation, displaySingle);
        }
    }

    private static void recalcFontSize(float scale, int rotate, FormObject formObject, Component curComp) {
        int size = GUIData.getFontSize(formObject, rotate, scale);
        Font resetFont = curComp.getFont();
        Font newFont = new Font(resetFont.getFontName(), resetFont.getStyle(), size);
        if (SwingUtilities.isEventDispatchThread()) {
            curComp.setFont(newFont);
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> curComp.setFont(newFont));
            }
            catch (InterruptedException | InvocationTargetException e2) {
                LogWriter.writeLog("Exception: " + e2.getMessage());
            }
        }
    }

    @Override
    public void setAutoFontSize(FormObject formObject) {
        SwingData.recalcFontSize(this.displayScaling, this.rotation, formObject, (Component)formObject.getGUIComponent());
    }

    public static Border generateBorderfromForm(FormObject form, float scaling) {
        float[] BC2 = form.getDictionary(7451).getFloatArray(4627);
        if (BC2 == null && form.getNameAsConstant(1147962727) == 1110792305) {
            BC2 = form.getFloatArray(19);
        }
        Border newBorder = JPedalBorderFactory.createBorderStyle(form.getDictionary(4643), FormObject.generateColor(BC2), Color.white, scaling);
        if (form.isXFAObject()) {
            int[] t2 = form.getMatteBorderDetails();
            newBorder = BorderFactory.createMatteBorder(t2[0], t2[3], t2[2], t2[1], Color.black);
        }
        return newBorder;
    }

    private int[] updateLocationAndBounds(FormObject formObject, float s2, int r2, boolean redraw) {
        float h2;
        float w2;
        float y2;
        float x2;
        Rectangle rect = formObject.getBoundingRectangle();
        int curPage = formObject.getPageNumber();
        float[] box = new float[]{rect.x, rect.y, rect.width + rect.x, rect.height + rect.y};
        if (this.displayView != 1 && this.displayView != 0) {
            r2 = (r2 + this.pageData.getRotation(curPage)) % 360;
        }
        int cropX = this.pageData.getCropBoxX(curPage);
        int cropY = this.pageData.getCropBoxY(curPage);
        int cropW = this.pageData.getCropBoxWidth(curPage);
        int mediaW = this.pageData.getMediaBoxWidth(curPage);
        int mediaH = this.pageData.getMediaBoxHeight(curPage);
        int cropOtherX = mediaW - cropW - cropX;
        switch (r2) {
            case 90: {
                x2 = box[1] - (float)cropY;
                y2 = box[0] - (float)cropX + 1.0f;
                w2 = box[3] - box[1];
                h2 = box[2] - box[0];
                break;
            }
            case 180: {
                y2 = box[1] - (float)cropY + 1.0f;
                x2 = (float)mediaW - box[2] - (float)cropOtherX;
                w2 = box[2] - box[0];
                h2 = box[3] - box[1];
                break;
            }
            case 270: {
                x2 = (float)mediaH - box[3] - (float)this.cropOtherY[curPage];
                y2 = (float)mediaW - box[2] - (float)cropOtherX + 1.0f;
                w2 = box[3] - box[1];
                h2 = box[2] - box[0];
                break;
            }
            default: {
                x2 = redraw ? box[0] - (float)cropX : box[0];
                y2 = (float)mediaH - box[3] - (float)this.cropOtherY[curPage] + 1.0f;
                w2 = box[2] - box[0];
                h2 = box[3] - box[1];
            }
        }
        return new int[]{(int)(x2 * s2), (int)(y2 * s2), (int)(w2 * s2), (int)(h2 * s2)};
    }

    private int[] updateLocation(FormObject formObject, float s2, int r2) {
        float y2;
        float x2;
        Rectangle rect = formObject.getBoundingRectangle();
        int curPage = formObject.getPageNumber();
        float[] box = new float[]{rect.x, rect.y, rect.width + rect.x, rect.height + rect.y};
        if (this.displayView != 1 && this.displayView != 0) {
            r2 = (r2 + this.pageData.getRotation(curPage)) % 360;
        }
        int cropW = this.pageData.getCropBoxWidth(curPage);
        int cropH = this.pageData.getCropBoxHeight(curPage);
        float w2 = box[2] - box[0];
        float h2 = box[3] - box[1];
        switch (r2) {
            case 90: {
                x2 = box[3];
                y2 = box[0];
                break;
            }
            case 180: {
                x2 = (float)cropW - box[0];
                y2 = box[3];
                break;
            }
            case 270: {
                x2 = (float)cropH - box[3];
                y2 = (float)cropW - box[0];
                break;
            }
            default: {
                x2 = box[0];
                y2 = (float)cropH - box[3];
            }
        }
        return new int[]{(int)(x2 * s2), (int)(y2 * s2), (int)(w2 * this.dpi / 72.0f), (int)(h2 * this.dpi / 72.0f)};
    }

    @Override
    protected void removeAllComponentsFromScreen() {
        if (this.panel != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.panel.removeAll();
            } else {
                Runnable doPaintComponent = () -> this.panel.removeAll();
                try {
                    SwingUtilities.invokeAndWait(doPaintComponent);
                }
                catch (InterruptedException | InvocationTargetException e2) {
                    LogWriter.writeLog("Exception: " + e2.getMessage());
                }
            }
        }
    }

    @Override
    public void setRootDisplayComponent(Object rootComp) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.panel = (JPanel)rootComp;
        } else {
            Runnable doPaintComponent = () -> {
                this.panel = (JPanel)rootComp;
            };
            try {
                SwingUtilities.invokeAndWait(doPaintComponent);
            }
            catch (InterruptedException | InvocationTargetException e2) {
                LogWriter.writeLog("Exception: " + e2.getMessage());
            }
        }
    }

    @Override
    public void setGUIComp(FormObject formObject, Object rawField) {
        Component retComponent = (Component)rawField;
        String name2 = formObject.getTextStreamValue(36);
        if (name2 != null) {
            String stateToCheck = formObject.getNormalOnState();
            if (stateToCheck != null && !stateToCheck.isEmpty()) {
                name2 = name2 + "-(" + stateToCheck + ')';
            }
            retComponent.setName(name2);
        }
        this.scaleComponent(formObject, this.displayScaling, this.rotation, retComponent, true, this.indent, false);
    }

    @Override
    public void resetScaledLocation(float currentScaling, int currentRotation, int currentIndent) {
        if (this.formsUnordered == null || this.panel == null || this.startPage == 0) {
            return;
        }
        if (this.forceRedraw || currentScaling != this.lastScaling || (float)currentRotation != this.oldRotation || (float)currentIndent != this.oldIndent) {
            this.oldRotation = currentRotation;
            this.lastScaling = currentScaling;
            this.oldIndent = currentIndent;
            this.forceRedraw = false;
            for (int currentPage = this.startPage; currentPage < this.endPage; ++currentPage) {
                int count = this.formsOrdered[currentPage] == null ? 0 : this.formsOrdered[currentPage].size();
                for (int j2 = 0; j2 < count; ++j2) {
                    FormObject formObject = (FormObject)this.formsOrdered[currentPage].get(j2);
                    formObject.setCurrentScaling(currentScaling);
                    Component rawComp = (Component)formObject.getGUIComponent();
                    if (rawComp == null) continue;
                    if (formObject.getBoundingRectangle().height < rawComp.getPreferredSize().height && rawComp instanceof JList) {
                        JList comp = (JList)rawComp;
                        rawComp = SwingData.wrapComponentInScrollPane(comp);
                        formObject.setGUIComponent(comp, 1);
                        int index = comp.getSelectedIndex();
                        if (index > -1) {
                            comp.ensureIndexIsVisible(index);
                        }
                    }
                    if (SwingUtilities.isEventDispatchThread()) {
                        this.panel.remove(rawComp);
                        this.scaleComponent(formObject, currentScaling, currentRotation, rawComp, true, this.indent, false);
                        this.panel.add(rawComp);
                        continue;
                    }
                    Component finalComp = rawComp;
                    FormObject fo = formObject;
                    Runnable doPaintComponent = () -> {
                        this.panel.remove(finalComp);
                        this.scaleComponent(fo, currentScaling, currentRotation, finalComp, true, this.indent, false);
                        this.panel.add(finalComp);
                    };
                    SwingUtilities.invokeLater(doPaintComponent);
                }
            }
            this.panel.validate();
        }
    }

    @Override
    void removeHiddenForms(int startPage, int endPage) {
        for (int page = startPage; page < endPage; ++page) {
            if (this.formsOrdered[page] == null) continue;
            for (FormObject o2 : this.formsOrdered[page]) {
                FormObject formObject;
                Object comp;
                if (o2 == null || (comp = (formObject = o2).getGUIComponent()) == null) continue;
                this.panel.remove((Component)comp);
            }
        }
    }

    private static Component wrapComponentInScrollPane(JList<String> comp) {
        JScrollPane scroll = new JScrollPane(comp);
        scroll.setVerticalScrollBarPolicy(20);
        scroll.setHorizontalScrollBarPolicy(30);
        scroll.setLocation(comp.getLocation());
        scroll.setPreferredSize(comp.getPreferredSize());
        scroll.setSize(comp.getSize());
        return scroll;
    }

    @Override
    public void setCustomPrintInterface(CustomFormPrint customFormPrint) {
        this.customFormPrint = customFormPrint;
    }

    static {
        readOnlyScaling = -1;
    }
}

