/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jpedal.external.CustomFormPrint;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.ReturnValues;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.raw.FormObject;

public class GUIData {
    boolean rasterizeForms;
    boolean forceRedraw;
    protected int userX;
    protected int userY;
    int widestPageNR;
    int widestPageR;
    int displayView;
    float dpi = 72.0f;
    private final Map<String, FormObject> rawFormData = new HashMap<String, FormObject>();
    protected Map<Integer, String> componentsToIgnore = new HashMap<Integer, String>();
    protected int insetW;
    protected int insetH;
    protected PdfPageData pageData;
    protected int indent;
    int[] cropOtherY;
    protected float displayScaling;
    protected int rotation;
    float lastScaling = -1.0f;
    float oldRotation;
    float oldIndent;
    protected int startPage;
    protected int currentPage;
    int endPage;
    protected int[] xReached;
    protected int[] yReached;
    protected List<FormObject>[] formsUnordered;
    List<FormObject>[] formsOrdered;
    private int formCount;
    protected FormFactory formFactory;

    public void setRasterizeForms(boolean inlineForms) {
        this.rasterizeForms = inlineForms;
    }

    public void setListForPage(int page, List<FormObject> comps, boolean isSorted) {
        if (isSorted) {
            this.formsOrdered[page] = comps;
        } else {
            this.formsUnordered[page] = comps;
        }
    }

    protected Object checkGUIObjectResolved(FormObject formObject) {
        Object comp = null;
        if (formObject != null) {
            comp = formObject.getGUIComponent();
        }
        if (formObject != null && comp == null) {
            comp = this.resolveGUIComponent(formObject);
        }
        if (comp != null) {
            this.setGUIComp(formObject, comp);
        }
        return comp;
    }

    protected Object resolveGUIComponent(FormObject formObject) {
        String formName;
        Object newValue;
        Object retComponent = null;
        int formType = formObject.getNameAsConstant(5668);
        int formFactoryType = this.formFactory.getType();
        if (formFactoryType == 3 && (newValue = this.formFactory.getReplacementValue(formName = formObject.getTextStreamValue(36))) != null) {
            formObject.setFormValue(newValue);
        }
        if (formFactoryType == 4) {
            if (AcroRenderer.isAnnotation(formObject)) {
                retComponent = this.formFactory.annotationButton(formObject);
            }
        } else {
            retComponent = formType == -1 ? this.formFactory.annotationButton(formObject) : this.getFormComponent(formObject, formType);
        }
        if (retComponent != null) {
            formObject.setGUIComponent(retComponent, this.formFactory.getType());
            this.setGUIComp(formObject, retComponent);
        }
        return retComponent;
    }

    private Object getFormComponent(FormObject formObject, int formType) {
        Object retComponent = null;
        boolean[] flags = formObject.getFieldFlags();
        switch (formType) {
            case 1197118: {
                boolean isPushButton = false;
                boolean isRadio = false;
                if (flags != null) {
                    isPushButton = flags[17];
                    isRadio = flags[16];
                }
                if (isPushButton) {
                    retComponent = this.formFactory.pushBut(formObject);
                    break;
                }
                if (isRadio) {
                    retComponent = this.formFactory.radioBut(formObject);
                    break;
                }
                retComponent = this.formFactory.checkBoxBut(formObject);
                break;
            }
            case 9288: {
                boolean isMultiline = false;
                boolean hasPassword = false;
                if (flags != null) {
                    isMultiline = flags[13] || formObject.getTextString() != null && formObject.getTextString().indexOf(10) != -1;
                    hasPassword = flags[14];
                }
                if (isMultiline) {
                    if (hasPassword) {
                        retComponent = this.formFactory.multiLinePassword(formObject);
                        break;
                    }
                    retComponent = this.formFactory.multiLineText(formObject);
                    break;
                }
                if (hasPassword) {
                    retComponent = this.formFactory.singleLinePassword(formObject);
                    break;
                }
                retComponent = this.formFactory.singleLineText(formObject);
                break;
            }
            case 4920: {
                boolean isCombo;
                boolean bl2 = isCombo = flags != null && flags[18];
                if (isCombo) {
                    retComponent = this.formFactory.comboBox(formObject);
                    break;
                }
                retComponent = this.formFactory.listField(formObject);
                break;
            }
            case 2308407: {
                retComponent = this.formFactory.signature(formObject);
            }
        }
        return retComponent;
    }

    public void dispose() {
    }

    protected void displayComponent(FormObject formObject, Object comp) {
    }

    void displayComponents(int startPage, int endPage) {
        if (this.rasterizeForms || this.formsOrdered == null) {
            return;
        }
        this.startPage = startPage;
        this.endPage = endPage;
        if (startPage > 1) {
            this.removeHiddenForms(1, startPage);
        }
        for (int page = startPage; page < endPage; ++page) {
            if (this.formsOrdered[page] == null) continue;
            for (FormObject o2 : this.formsOrdered[page]) {
                FormObject formObject;
                Object comp;
                if (o2 == null || (comp = this.checkGUIObjectResolved(formObject = o2)) == null) continue;
                this.displayComponent(formObject, comp);
            }
        }
        this.removeHiddenForms(endPage, this.pageData.getPageCount() + 1);
    }

    void removeHiddenForms(int startPage, int endPage) {
    }

    public boolean hasformsOnPageDecoded(int page) {
        return this.formsOrdered != null && this.formsOrdered.length > page && this.formsOrdered[page] != null;
    }

    void initParametersForPage(PdfPageData pageData, int page, FormFactory formFactory, float dpi) {
        int cropTop;
        int mediaHeight;
        if (this.cropOtherY == null || this.cropOtherY.length <= page) {
            this.resetComponents(0, pageData.getPageCount(), false);
        }
        this.cropOtherY[page] = (mediaHeight = pageData.getMediaBoxHeight(page)) != (cropTop = pageData.getCropBoxHeight(page) + pageData.getCropBoxY(page)) ? mediaHeight - cropTop : 0;
        this.currentPage = page;
        this.formFactory = formFactory;
        this.dpi = dpi;
    }

    public void resetComponents(int formCount, int pageCount, boolean keepValues) {
        if (keepValues && this.formCount > formCount) {
            return;
        }
        this.formCount = formCount;
        if (!keepValues) {
            if (this.formsUnordered == null && pageCount != 0) {
                this.formsUnordered = new List[pageCount + 1];
                this.formsOrdered = new List[pageCount + 1];
            }
            this.cropOtherY = new int[pageCount + 1];
            this.yReached = null;
            this.xReached = null;
        }
    }

    public void setPageValues(float scaling, int rotation, int indent, int userX, int userY, int displayView, int widestPageNR, int widestPageR) {
        this.rotation = rotation;
        this.displayScaling = scaling;
        this.indent = indent;
        this.userX = userX;
        this.userY = userY;
        this.displayView = displayView;
        this.widestPageNR = widestPageNR;
        this.widestPageR = widestPageR;
    }

    void setPageData(PdfPageData pageData, int insetW, int insetH) {
        this.insetW = insetW;
        this.insetH = insetH;
        this.pageData = pageData;
    }

    public void setPageDisplacements(int[] xReached, int[] yReached) {
        this.xReached = xReached;
        this.yReached = yReached;
        this.forceRedraw = true;
    }

    public void setForceRedraw(boolean forceRedraw) {
        this.forceRedraw = forceRedraw;
    }

    void storeRawData(FormObject formObject) {
        String ref = formObject.getObjectRefAsString();
        this.rawFormData.put(ref, formObject);
    }

    void flushFormData() {
        this.rawFormData.clear();
        this.formsOrdered = null;
        this.formsUnordered = null;
        this.oldIndent = -this.oldIndent;
    }

    Map<String, FormObject> getRawFormData() {
        return Collections.unmodifiableMap(this.rawFormData);
    }

    protected void setGUIComp(FormObject formObject, Object rawField) {
    }

    public List<Object> getFormComponents(String key, ReturnValues value, int pageNumber) {
        Iterator<String> i2 = this.rawFormData.keySet().iterator();
        ArrayList<Object> selectedForms = new ArrayList<Object>();
        block6: while (i2.hasNext()) {
            FormObject form = this.rawFormData.get(i2.next());
            boolean isPageSelected = pageNumber == -1 || form.getPageNumber() == pageNumber;
            String name = form.getTextStreamValue(36);
            boolean isSelected1 = isPageSelected && (key == null || key.equals(name));
            switch (value) {
                case GUI_FORMS_FROM_NAME: {
                    if (!isSelected1) continue block6;
                    selectedForms.add(this.checkGUIObjectResolved(form));
                    continue block6;
                }
                case FORMOBJECTS_FROM_NAME: {
                    if (!isSelected1) continue block6;
                    selectedForms.add(form);
                    continue block6;
                }
                case FORMOBJECTS_FROM_REF: {
                    if (!isPageSelected || key != null && !form.getObjectRefAsString().equals(key)) continue block6;
                    selectedForms.add(form);
                    continue block6;
                }
                case FORM_NAMES: {
                    if (!isPageSelected || name == null || name.isEmpty() || selectedForms.contains(name)) continue block6;
                    selectedForms.add(name);
                    continue block6;
                }
            }
            throw new RuntimeException("value " + (Object)((Object)value) + " not implemented");
        }
        return selectedForms;
    }

    public List<FormObject> getFormComponentsFromRef(String key, int pageNumber) {
        Iterator<String> i2 = this.rawFormData.keySet().iterator();
        ArrayList<FormObject> selectedForms = new ArrayList<FormObject>();
        while (i2.hasNext()) {
            FormObject form = this.rawFormData.get(i2.next());
            boolean isPageSelected = pageNumber == -1 || form.getPageNumber() == pageNumber;
            if (!isPageSelected || key != null && !form.getObjectRefAsString().equals(key)) continue;
            selectedForms.add(form);
        }
        return selectedForms;
    }

    public void resetAfterPrinting() {
        this.forceRedraw = true;
    }

    public static int calculateFontSize(int height, int width, boolean area, String text) {
        int rawSize;
        double w1;
        double x2;
        double y2;
        float areaFactor = 0.8f;
        double h1 = (float)height * 0.8f;
        if (text == null || text.isEmpty()) {
            return (int)h1;
        }
        char[] textChrs = text.toCharArray();
        int maxLen = 0;
        int curLen = 0;
        int lines = 1;
        block3: for (char textChr : textChrs) {
            switch (textChr) {
                case '\n': 
                case '\r': {
                    ++lines;
                    if (maxLen < curLen) {
                        maxLen = curLen;
                    }
                    curLen = 0;
                    continue block3;
                }
                default: {
                    ++curLen;
                }
            }
        }
        if (maxLen < curLen) {
            maxLen = curLen;
        }
        if ((y2 = h1 / (double)lines) > (x2 = (w1 = (double)((float)width * 0.8f)) / (double)maxLen) * 2.0) {
            rawSize = (int)x2 * 2;
        } else {
            if (area && y2 > 14.0) {
                double fontsize = 14.0;
                while (true) {
                    double approxLines;
                    if ((approxLines = (double)height / fontsize) < 5.0) {
                        return (int)fontsize;
                    }
                    fontsize *= 1.1;
                }
            }
            rawSize = (int)y2;
        }
        if (area && (rawSize < 4 || rawSize > 14)) {
            rawSize = 12;
        }
        return rawSize;
    }

    public boolean formsRasterizedForDisplay() {
        return this.rasterizeForms;
    }

    protected static int getFontSize(FormObject formObject, int rotate, float scale) {
        int size;
        int rawSize = formObject.getTextSize();
        if (rawSize == -1) {
            boolean[] flags = formObject.getFieldFlags();
            rawSize = flags != null && flags[13] && !flags[24] ? 12 : 0;
        }
        if (rawSize == 0) {
            Rectangle bounds = formObject.getBoundingRectangle();
            int width = bounds.width;
            int height = bounds.height;
            if (rotate == 90 || rotate == 270) {
                int tmp = height;
                height = width;
                width = tmp;
            }
            rawSize = (int)((double)height * 0.85);
            String textVal = formObject.getTextString();
            int formType = formObject.getFormType();
            if (formType == FormFactory.MULTILINETEXT || formType == FormFactory.MULTILINEPASSWORD) {
                rawSize = GUIData.calculateFontSize(height, width, true, textVal);
            } else if (formType == FormFactory.SINGLELINETEXT || formType == FormFactory.SINGLELINEPASSWORD) {
                rawSize = GUIData.calculateFontSize(height, width, false, textVal);
            } else if (textVal != null) {
                rawSize = GUIData.calculateFontSize(height, width, false, textVal);
            }
        }
        if ((size = (int)((float)rawSize * scale)) < 1) {
            size = 1;
        }
        return size;
    }

    protected void removeAllComponentsFromScreen() {
    }

    public void setAutoFontSize(FormObject formObj) {
    }

    public void renderFormsOntoG2(Object raw, int pageIndex, int currentIndent, int currentRotation, Map<Integer, String> componentsToIgnore, FormFactory formFactory, int pageHeight) {
    }

    public void setCustomPrintInterface(CustomFormPrint customFormPrint) {
    }

    public void resetScaledLocation(float scaling, int i2, int i0) {
    }

    public void setRootDisplayComponent(Object formsPane) {
    }

    public List<FormObject>[] getFormList(boolean isOrdered) {
        if (isOrdered) {
            return this.formsOrdered;
        }
        return this.formsUnordered;
    }

    public void renderFormsOntoG2InHeadless(Object raw, int pageIndex, Map<Integer, String> componentsToIgnore, FormFactory formFactory) {
    }
}

