/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms;

import com.idrsolutions.pdf.color.blends.BlendMode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.StringTokenizer;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;

final class FormRenderUtilsG2 {
    private FormRenderUtilsG2() {
    }

    private static Color getBorderColor(FormObject formObject) {
        Color BC2 = new Color(0, 0, 0, 0);
        if (formObject.getDictionary(7451) != null) {
            PdfObject MK = formObject.getDictionary(7451);
            float[] bc2 = MK.getFloatArray(4627);
            BC2 = FormObject.generateColor(bc2);
        }
        return BC2;
    }

    private static Color getBorderBackgroundColor(FormObject formObject) {
        Color BG = new Color(0, 0, 0, 0);
        if (formObject.getDictionary(7451) != null) {
            PdfObject MK = formObject.getDictionary(7451);
            float[] bg2 = MK.getFloatArray(4631);
            BG = FormObject.generateColor(bg2);
        }
        return BG;
    }

    private static void renderBorderSolid(Graphics2D g2, int borderWidth, int x2, int y2, int w2, int h2) {
        g2.setStroke(new BasicStroke(borderWidth));
        g2.drawRect(x2 + borderWidth - 1, y2 + borderWidth - 1, w2 - borderWidth * 2 + 1, h2 - borderWidth * 2 + 1);
    }

    private static void renderBorderDashed(Graphics2D g2, PdfArrayIterator dashPattern, int borderWidth, int x2, int y2, int w2, int h2) {
        float[] dash = new float[]{3.0f};
        int phase = 0;
        if (dashPattern.getTokenCount() > 0) {
            int count = dashPattern.getTokenCount();
            if (count > 0) {
                dash = dashPattern.getNextValueAsFloatArray();
            }
            if (count > 1) {
                phase = dashPattern.getNextValueAsInteger();
            }
        }
        if (dash.length == 0) {
            g2.setStroke(new BasicStroke(borderWidth));
        } else {
            g2.setStroke(new BasicStroke(borderWidth, 0, 0, 10.0f, dash, phase));
        }
        g2.drawRect(x2 + borderWidth - 1, y2 + borderWidth - 1, w2 - borderWidth * 2 + 1, h2 - borderWidth * 2 + 1);
    }

    private static void renderBorderBeveled(Graphics2D g2, Color BG, int borderWidth, int x2, int y2, int w2, int h2) {
        Color bckUp = g2.getColor();
        g2.setStroke(new BasicStroke(borderWidth, 0, 0, 10.0f));
        g2.drawRect(x2, y2, w2, h2);
        g2.setStroke(new BasicStroke(1.0f));
        g2.setColor(BG.darker());
        g2.fillPolygon(new int[]{++x2 + (w2 -= 2), x2 + w2, x2 + w2 - borderWidth, x2 + w2 - borderWidth, x2 + borderWidth, x2}, new int[]{++y2 + (h2 -= 2), y2, y2 + borderWidth, y2 + h2 - borderWidth, y2 + h2 - borderWidth, y2 + h2}, 6);
        g2.setColor(BG.brighter());
        g2.fillPolygon(new int[]{x2, x2, x2 + borderWidth, x2 + borderWidth, x2 + w2 - borderWidth, x2 + w2}, new int[]{y2, y2 + h2, y2 + h2 - borderWidth, y2 + borderWidth, y2 + borderWidth, y2}, 6);
        g2.setColor(bckUp);
    }

    private static void renderBorderInset(Graphics2D g2, int borderWidth, int x2, int y2, int w2, int h2) {
        Color bckUp = g2.getColor();
        g2.setStroke(new BasicStroke(borderWidth));
        g2.drawRect(x2, y2, w2, h2);
        g2.setStroke(new BasicStroke(1.0f));
        g2.setColor(Color.LIGHT_GRAY);
        g2.fillPolygon(new int[]{++x2 + (w2 -= 2), x2 + w2, x2 + w2 - borderWidth, x2 + w2 - borderWidth, x2 + borderWidth, x2}, new int[]{++y2 + (h2 -= 2), y2, y2 + borderWidth, y2 + h2 - borderWidth, y2 + h2 - borderWidth, y2 + h2}, 6);
        g2.setColor(Color.GRAY);
        g2.fillPolygon(new int[]{x2, x2, x2 + borderWidth, x2 + borderWidth, x2 + w2 - borderWidth, x2 + w2}, new int[]{y2, y2 + h2, y2 + h2 - borderWidth, y2 + borderWidth, y2 + borderWidth, y2}, 6);
        g2.setColor(bckUp);
    }

    private static void renderBorderUnderline(Graphics2D g2, int borderWidth, int x2, int y2, int w2) {
        g2.setStroke(new BasicStroke(borderWidth));
        g2.drawLine(x2 + borderWidth - 1, y2 + borderWidth - 1, x2 + w2 - 1, y2 + borderWidth - 1);
    }

    public static int renderBorder(Graphics2D g2, FormObject formObject, int pageHeight) {
        int x2 = formObject.getBoundingRectangle().x;
        int y2 = pageHeight - (formObject.getBoundingRectangle().y + formObject.getBoundingRectangle().height);
        int w2 = formObject.getBoundingRectangle().width;
        int h2 = formObject.getBoundingRectangle().height;
        return FormRenderUtilsG2.renderBorder(g2, formObject, x2, y2, w2, h2);
    }

    private static int renderBorder(Graphics2D g2, FormObject formObject, int x2, int y2, int w2, int h2) {
        Object antiA = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        int borderWidth = 0;
        Color BC2 = FormRenderUtilsG2.getBorderColor(formObject);
        Color BG = FormRenderUtilsG2.getBorderBackgroundColor(formObject);
        boolean borderCreated = false;
        if (formObject.getDictionary(4643) != null) {
            PdfObject BS = formObject.getDictionary(4643);
            String s2 = BS.getName(35);
            borderWidth = BS.getInt(39);
            if (borderWidth == -1) {
                borderWidth = 1;
            }
            if (borderWidth > 0) {
                g2.setColor(BC2);
                if (null == s2) {
                    FormRenderUtilsG2.renderBorderSolid(g2, borderWidth, x2, y2, w2, h2);
                    borderCreated = true;
                } else {
                    switch (s2) {
                        case "S": {
                            FormRenderUtilsG2.renderBorderSolid(g2, borderWidth, x2, y2, w2, h2);
                            borderCreated = true;
                            break;
                        }
                        case "D": {
                            PdfArrayIterator dashPattern = BS.getMixedArray(20);
                            FormRenderUtilsG2.renderBorderDashed(g2, dashPattern, borderWidth, x2, y2, w2, h2);
                            borderCreated = true;
                            break;
                        }
                        case "B": {
                            FormRenderUtilsG2.renderBorderBeveled(g2, BG, borderWidth, x2, y2, w2, h2);
                            borderCreated = true;
                            break;
                        }
                        case "I": {
                            FormRenderUtilsG2.renderBorderInset(g2, borderWidth, x2, y2, w2, h2);
                            borderCreated = true;
                            break;
                        }
                        case "U": {
                            FormRenderUtilsG2.renderBorderUnderline(g2, borderWidth, x2, y2, w2);
                            borderCreated = true;
                            break;
                        }
                    }
                }
            }
        } else if (formObject.getObjectArray(1110722433) != null) {
            throw new RuntimeException("Border Array not implemented yet");
        }
        if (!borderCreated) {
            g2.setColor(BC2);
            borderWidth = 1;
            g2.setStroke(new BasicStroke(borderWidth));
            g2.drawRect(x2 + borderWidth - 1, y2 + borderWidth - 1, w2 - borderWidth * 2 + 1, h2 - borderWidth * 2 + 1);
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antiA);
        return borderWidth;
    }

    public static FontMetrics renderFont(Graphics2D g2, FormObject formObject, String textValue, int borderWidth) {
        if (formObject.getTextSize() <= 0) {
            if (!formObject.getFieldFlags()[13]) {
                float fh = formObject.getBoundingRectangle().height - borderWidth * 2 - 2;
                g2.setFont(formObject.getTextFont().deriveFont(fh));
                FontMetrics metrics = g2.getFontMetrics(formObject.getTextFont().deriveFont(fh));
                Rectangle2D r2 = metrics.getStringBounds(textValue, g2);
                float scale = (float)((double)(formObject.getBoundingRectangle().width - borderWidth * 2 - 4) / r2.getWidth());
                float hScale = (float)((double)formObject.getBoundingRectangle().height / r2.getHeight());
                if (scale > 1.0f && scale > hScale) {
                    scale = hScale;
                }
                if (scale < 1.0f) {
                    g2.setFont(formObject.getTextFont().deriveFont(fh * scale));
                }
            } else {
                g2.setFont(formObject.getTextFont().deriveFont(12.0f));
            }
        } else {
            g2.setFont(formObject.getTextFont());
        }
        if (formObject.getTextColor() != null) {
            g2.setColor(formObject.getTextColor());
        } else {
            g2.setColor(Color.BLACK);
        }
        return g2.getFontMetrics();
    }

    public static void renderComboForms(Graphics2D g2, FormObject formObject, FontMetrics metrics, Rectangle2D r2, int borderWidth, int justification, int pageHeight) {
        String[] values = formObject.getItemsList();
        if (values != null) {
            int[] selected = formObject.getIntArray(25);
            int startingIndex = formObject.getInt(9241);
            if (startingIndex < 0) {
                startingIndex = 0;
            }
            if (selected != null) {
                Color c2 = g2.getColor();
                Color highlight = new Color((float)(DecoderOptions.highlightColor.getRed() / 255), (float)(DecoderOptions.highlightColor.getGreen() / 255), (float)(DecoderOptions.highlightColor.getBlue() / 255), DecoderOptions.highlightComposite);
                g2.setColor(highlight);
                if (formObject.getBoundingRectangle().getHeight() < (double)(metrics.getHeight() * values.length)) {
                    startingIndex = selected[0];
                }
                for (int i2 = 0; i2 != selected.length; ++i2) {
                    int x2 = formObject.getBoundingRectangle().x + borderWidth;
                    int y2 = pageHeight - (formObject.getBoundingRectangle().y + formObject.getBoundingRectangle().height) - borderWidth;
                    y2 += metrics.getDescent();
                    g2.fillRect(x2, (y2 += metrics.getHeight() * (selected[i2] - startingIndex)) + borderWidth, formObject.getBoundingRectangle().width - borderWidth * 2 + 2, metrics.getHeight());
                }
                g2.setColor(c2);
            }
            g2.setClip(new Rectangle(formObject.getBoundingRectangle().x + borderWidth - 1, pageHeight - (formObject.getBoundingRectangle().y + formObject.getBoundingRectangle().height) + borderWidth - 1, formObject.getBoundingRectangle().width - borderWidth * 2 + 2, formObject.getBoundingRectangle().height - borderWidth * 2 + 2));
            for (int i3 = startingIndex; i3 != values.length; ++i3) {
                int x3 = formObject.getBoundingRectangle().x + borderWidth + 2;
                int y3 = pageHeight - (formObject.getBoundingRectangle().y + formObject.getBoundingRectangle().height) + borderWidth + metrics.getHeight() - borderWidth;
                FormRenderUtilsG2.renderTextString(g2, formObject, values[i3], r2, x3, y3 += metrics.getHeight() * (i3 - startingIndex), borderWidth, justification);
            }
        }
    }

    public static void renderMultilineTextField(Graphics2D g2, FormObject formObject, FontMetrics metrics, Rectangle2D r2, String textValue, int borderWidth, int justification, int pageHeight) {
        int x2 = formObject.getBoundingRectangle().x + borderWidth;
        int y2 = pageHeight - (formObject.getBoundingRectangle().y + formObject.getBoundingRectangle().height) - borderWidth - borderWidth;
        StringTokenizer tokenizer = new StringTokenizer(textValue, "\n");
        while (tokenizer.hasMoreTokens()) {
            FormRenderUtilsG2.renderTextString(g2, formObject, tokenizer.nextToken(), r2, x2, y2 += metrics.getHeight(), borderWidth, justification);
        }
    }

    public static void renderSingleLineTextField(Graphics2D g2, FormObject formObject, FontMetrics metrics, Rectangle2D r2, String textValue, int borderWidth, int justification, int pageHeight) {
        int x2 = formObject.getBoundingRectangle().x + borderWidth;
        int y2 = pageHeight - formObject.getBoundingRectangle().y - (formObject.getBoundingRectangle().height - metrics.getHeight());
        FormRenderUtilsG2.renderTextString(g2, formObject, textValue, r2, x2, y2, borderWidth, justification);
    }

    private static void renderTextString(Graphics2D g2, FormObject formObject, String textValue, Rectangle2D r2, int x2, int y2, int borderWidth, int justification) {
        switch (justification) {
            case 0: {
                g2.drawString(textValue, (int)((double)x2 + ((double)(formObject.getBoundingRectangle().width - borderWidth * 2) - r2.getWidth()) / 2.0), y2);
                break;
            }
            case 4: {
                g2.drawString(textValue, (int)((double)(x2 + formObject.getBoundingRectangle().width - borderWidth * 2) - r2.getWidth()) - 2, y2);
                break;
            }
            default: {
                g2.drawString(textValue, x2 + 2, y2);
            }
        }
    }

    public static void renderQuadPoint(Graphics2D g2, FormObject formObject, Color bgColor, int pageHeight) {
        float[] quadPoints = formObject.getFloatArray(1785890247);
        if (quadPoints != null) {
            Color c2 = g2.getColor();
            Composite com = g2.getComposite();
            for (int i2 = 0; i2 != quadPoints.length / 8; ++i2) {
                float minX = 0.0f;
                float minY = 0.0f;
                float maxX = 0.0f;
                float maxY = 0.0f;
                for (int j2 = 0; j2 != 8; ++j2) {
                    if (j2 < 2) {
                        if (j2 % 2 == 0) {
                            minX = quadPoints[i2 * 8 + j2];
                            maxX = quadPoints[i2 * 8 + j2];
                            continue;
                        }
                        minY = quadPoints[i2 * 8 + j2];
                        maxY = quadPoints[i2 * 8 + j2];
                        continue;
                    }
                    if (j2 % 2 == 0) {
                        if (quadPoints[i2 * 8 + j2] < minX) {
                            minX = quadPoints[i2 * 8 + j2];
                        }
                        if (!(quadPoints[i2 * 8 + j2] > maxX)) continue;
                        maxX = quadPoints[i2 * 8 + j2];
                        continue;
                    }
                    if (quadPoints[i2 * 8 + j2] < minY) {
                        minY = quadPoints[i2 * 8 + j2];
                    }
                    if (!(quadPoints[i2 * 8 + j2] > maxY)) continue;
                    maxY = quadPoints[i2 * 8 + j2];
                }
                if (formObject.getNameAsConstant(1147962727) == 1919840408) {
                    g2.setColor(bgColor);
                    g2.setComposite(new BlendMode(1451587725, 0.5f));
                    g2.fillRect((int)minX, (int)((float)pageHeight - maxY), (int)(maxX - minX), (int)(maxY - minY));
                }
                g2.setColor(c2);
                g2.setComposite(com);
            }
        }
    }

    public static void renderPopupWindow(Graphics2D g2, FormObject formObject, Color bgColor, boolean isPrinting, int pageHeight) {
        String t2;
        int lineCount;
        StringTokenizer tokenizer;
        String mStream = formObject.getParentPdfObj().getTextStreamValue(29);
        StringBuilder date = null;
        if (mStream != null) {
            date = FormRenderUtilsG2.addHardcodedDate(mStream);
        }
        String subject = formObject.getParentPdfObj().getTextStreamValue(591737402);
        String popupTitle = formObject.getParentPdfObj().getTextStreamValue(36);
        if (popupTitle == null) {
            popupTitle = "";
        }
        String title = "";
        if (subject != null) {
            title = title + subject + '\t';
        }
        if (date != null) {
            title = title + date;
        }
        title = title + '\n' + popupTitle;
        String contents = formObject.getParentPdfObj().getTextStreamValue(1216184967);
        if (contents == null) {
            contents = "";
        }
        if (contents.indexOf(13) != -1) {
            contents = contents.replaceAll("\r", "\n");
        }
        float[] rect = formObject.getFloatArray(573911876);
        int titleBarHeight = 24;
        if (isPrinting) {
            g2.translate(0, 24);
        }
        g2.setColor(Color.WHITE);
        g2.fillRect((int)rect[0], pageHeight - (int)rect[3], (int)(rect[2] - rect[0]), (int)(rect[3] - rect[1]));
        g2.setColor(bgColor);
        g2.fillRect((int)rect[0], pageHeight - (int)rect[3], (int)(rect[2] - rect[0]), 26);
        g2.setColor(Color.BLACK);
        g2.setFont(new Font("Monospaced", 0, 12));
        g2.setFont(g2.getFont().deriveFont(8.0f));
        if (title.indexOf(10) == -1) {
            g2.drawString(title, (int)rect[0] + 2, (int)((float)(pageHeight - (int)rect[3]) + g2.getFont().getSize2D()) + 2);
        } else {
            tokenizer = new StringTokenizer(title, "\n", true);
            lineCount = 1;
            while (tokenizer.hasMoreTokens()) {
                t2 = tokenizer.nextToken();
                if (!"\n".equals(t2)) {
                    g2.drawString(t2, (int)rect[0] + 2, (int)((float)(pageHeight - (int)rect[3]) + (g2.getFont().getSize2D() + 2.0f) * (float)lineCount));
                    continue;
                }
                ++lineCount;
            }
        }
        g2.setFont(g2.getFont().deriveFont(7.0f));
        if (contents.indexOf(10) == -1) {
            g2.drawString(contents, (int)rect[0], (int)((float)(pageHeight - (int)rect[3]) + g2.getFont().getSize2D() + 24.0f));
        } else {
            tokenizer = new StringTokenizer(contents, "\n", true);
            lineCount = 1;
            while (tokenizer.hasMoreTokens()) {
                t2 = tokenizer.nextToken();
                if (!"\n".equals(t2)) {
                    g2.drawString(t2, (int)rect[0] + 2, (int)((float)(pageHeight - (int)rect[3]) + (g2.getFont().getSize2D() + 3.0f) * (float)lineCount + 24.0f));
                    continue;
                }
                ++lineCount;
            }
        }
    }

    private static StringBuilder addHardcodedDate(String mStream) {
        StringBuilder date = new StringBuilder(mStream);
        date.delete(0, 2);
        date.insert(10, ':');
        date.insert(13, ':');
        date.insert(16, ' ');
        String year = date.substring(0, 4);
        String day = date.substring(6, 8);
        date.delete(6, 8);
        date.delete(0, 4);
        date.insert(0, day);
        date.insert(4, year);
        date.insert(2, '/');
        date.insert(5, '/');
        date.insert(10, ' ');
        return date;
    }
}

