/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms;

import com.idrsolutions.pdf.acroforms.xfa.XFAPageContent;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.FormTypes;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.FormStream;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.xfa.XFAFormStream;
import org.jpedal.parser.FormFlattener;
import org.jpedal.parser.FormFlattenerXFA;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.PrintStreamDecoder;
import org.jpedal.parser.XFAStreamDecoder;
import org.jpedal.parser.XFAStreamDecoderForPrinting;
import org.jpedal.utils.BrandingHelper;
import org.jpedal.utils.LogWriter;

public class AcroRendererXFA
extends AcroRenderer {
    private final HashMap<String, Object> globalMap = new HashMap();
    private static final String[] jsFiles = new String[]{"FDFXFASTYLE", "FDFXFAENCODING", "FDFXFAMIN"};
    private static final String[] jsExt = new String[]{"css", "js", "js", "js", "js", "js"};

    @Override
    public PdfStreamDecoder getStreamDecoder(PdfObjectReader currentPdfFile, PdfLayerList layer, boolean isFirst) {
        if (this.isXFA() && this.useXFA()) {
            return new XFAStreamDecoder(currentPdfFile, layer, this);
        }
        return super.getStreamDecoder(currentPdfFile, layer, isFirst);
    }

    @Override
    public boolean showFormWarningMessage(int page) {
        return false;
    }

    @Override
    public int openFile(int pageCount, int insetW, int insetH, PdfPageData pageData, PdfObjectReader currentPdfFile, PdfObject acroObj) {
        super.openFile(pageCount, insetW, insetH, pageData, currentPdfFile, acroObj);
        if (this.isXFA() && this.useXFA()) {
            int XFApageCount = this.getPageMapXFA().size();
            if (pageCount != XFApageCount && ExternalHandlers.isJPedalPresent() && !ExternalHandlers.isFormvuPresent()) {
                this.hasXFA = false;
            } else {
                pageCount = XFApageCount;
            }
        }
        return pageCount;
    }

    @Override
    void processXFAFields(PdfObject acroObj1, PdfObjectReader currentPdfFile1, PdfPageData pageData1) {
        this.resolveIndirectFieldList(true);
        if (this.fieldList != null) {
            int fieldCount;
            for (int fieldNum = fieldCount = this.fieldList.getTokenCount() - 1; fieldNum > -1; --fieldNum) {
                String objRef = this.fieldList.getNextValueAsString(true);
                if (objRef == null) continue;
                FormObject formObject = this.convertRefToFormObject(objRef, -1);
                this.globalMap.put("signature", formObject);
            }
        }
        this.fDecoder = new com.idrsolutions.pdf.acroforms.xfa.XFAFormStream(acroObj1, currentPdfFile1, this);
        if (this.fDecoder.isXFA()) {
            ((com.idrsolutions.pdf.acroforms.xfa.XFAFormStream)this.fDecoder).updatePageData(pageData1);
            this.PDFformType = ((com.idrsolutions.pdf.acroforms.xfa.XFAFormStream)this.fDecoder).getPDFFormType();
            this.pageCount = pageData1.getPageCount();
        } else {
            this.hasXFA = false;
            this.fDecoder = new FormStream();
            this.PDFformType = FormTypes.NON_XFA;
        }
    }

    @Override
    Map<String, String> createAndStoreFormComponents(PdfStreamDecoder current, List<FormObject> unsortedForms, List<FormObject> sortedForms, int page) {
        FormObject[] xfaFormList = null;
        if (this.hasXFA && this.useXFA) {
            xfaFormList = this.createXFADisplayComponentsForPage(page);
        }
        return this.createComponents(current, unsortedForms, sortedForms, page, xfaFormList);
    }

    private FormObject[] createXFADisplayComponentsForPage(int page) {
        FormObject[] xfaFormList = ((com.idrsolutions.pdf.acroforms.xfa.XFAFormStream)this.fDecoder).createAppearanceString(page);
        this.Fforms = xfaFormList;
        if (!this.globalMap.isEmpty()) {
            for (int z2 = 0; z2 < this.Fforms.length; ++z2) {
                int subType = this.Fforms[z2].getNameAsConstant(5668);
                if (subType != 2308407) continue;
                FormObject xForm = this.Fforms[z2];
                FormObject gForm = (FormObject)this.globalMap.get("signature");
                Rectangle rect = xForm.getBoundingRectangle();
                float[] floatCoords = new float[]{(float)rect.getX(), (float)rect.getY(), (float)(rect.getX() + rect.getWidth()), (float)(rect.getY() + rect.getHeight())};
                gForm.setFloatArray(573911876, floatCoords);
                gForm.setRef(xForm.getObjectRefAsString());
                gForm.setPageNumber(xForm.getPageNumber());
                gForm.setAppreancesUsed(true);
                this.Fforms[z2] = gForm;
            }
        }
        return xfaFormList;
    }

    public HashMap<Integer, XFAPageContent> getPageMapXFA() {
        return ((com.idrsolutions.pdf.acroforms.xfa.XFAFormStream)this.fDecoder).getPageMapXFA();
    }

    @Override
    public byte[] getXMLContentAsBytes(int key) {
        return this.fDecoder.getXFA(key);
    }

    private String getXMLContentAsBase64(int key) {
        byte[] data = this.getXMLContentAsBytes(key);
        if (data == null) {
            return "";
        }
        try {
            return Base64.getEncoder().encodeToString(data);
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception in reading XML data " + e2);
            return "";
        }
    }

    private String getXMLTemplateAsBAse64() {
        byte[] data = ((com.idrsolutions.pdf.acroforms.xfa.XFAFormStream)this.fDecoder).getAlteredTemplateBytes();
        try {
            return Base64.getEncoder().encodeToString(data);
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception in handling script " + e2);
            return "";
        }
    }

    @Override
    public void outputJavascriptXFA(String outputDir, String fileName, boolean applyBranding) {
        HashSet<String> settings = new HashSet<String>();
        settings.add("outputMenu");
        if (applyBranding) {
            settings.add("applyBranding");
        }
        this.outputJavascriptXFA(outputDir, fileName, settings);
    }

    @Override
    public void outputJavascriptXFA(String outputDir, String fileName, Set<String> settings) {
        Map settingsMap = settings.stream().collect(HashMap::new, (hashMap, s2) -> hashMap.put(s2, "true"), HashMap::putAll);
        this.outputJavascriptXFA(outputDir, fileName, settingsMap);
    }

    @Override
    public void outputJavascriptXFA(String outputDir, String fileName, Map<String, String> settings) {
        boolean outputMenu = settings.containsKey("outputMenu") && Boolean.parseBoolean(settings.get("outputMenu"));
        String applyBranding = settings.getOrDefault("applyBranding", "");
        boolean inlineJavaScriptAndCSS = settings.containsKey("inlineJavaScriptAndCSS") && Boolean.parseBoolean(settings.get("inlineJavaScriptAndCSS"));
        String seperator = File.separator;
        File eventsDir = new File(outputDir + seperator + "js");
        File eventsFile = new File(outputDir + seperator + "form.html");
        try {
            File outputDirectory = new File(outputDir);
            if (!outputDirectory.exists()) {
                outputDirectory.mkdirs();
            }
            if (!inlineJavaScriptAndCSS && !eventsDir.exists()) {
                eventsDir.mkdirs();
            }
            if (!eventsFile.exists()) {
                eventsFile.createNewFile();
            }
        }
        catch (IOException e2) {
            LogWriter.writeLog(e2);
        }
        try (PrintWriter writer = new PrintWriter(eventsFile);){
            String start;
            if (inlineJavaScriptAndCSS) {
                StringBuilder startBuilder = new StringBuilder("<!DOCTYPE html>\n<html>\n<head>\n<title>" + fileName + "</title>\n");
                String fdfxfaStyle = this.resourceToString("/com/idrsolutions/pdf/acroforms/xfa/res/js/FDFXFASTYLE.css");
                startBuilder.append("<style type=\"text/css\">\n").append(fdfxfaStyle).append("\n</style>\n");
                String fdfxfaEncoding = this.resourceToString("/com/idrsolutions/pdf/acroforms/xfa/res/js/FDFXFAENCODING.js");
                startBuilder.append("<script type=\"text/javascript\">\n").append(fdfxfaEncoding).append("\n</script>\n");
                String fdfxfaMin = this.resourceToString("/com/idrsolutions/pdf/acroforms/xfa/res/js/FDFXFAMIN.js");
                startBuilder.append("<script type=\"text/javascript\">\n").append(fdfxfaMin).append("\n</script>\n");
                startBuilder.append("</head>\n");
                start = startBuilder.toString();
            } else {
                start = "<!DOCTYPE html>\n<html>\n<head>\n<title>" + fileName + "</title>\n<link rel=\"stylesheet\" href=\"js/FDFXFASTYLE.css\"/>\n<script type=\"text/javascript\" src=\"js/FDFXFAENCODING.js\"></script>\n<script type=\"text/javascript\" src=\"js/FDFXFAMIN.js\"></script>\n</head>\n";
            }
            String toolBarStr = "<div id='FDFXFA_Menu'><a title='Go To FirstPage'onclick=\"app.execMenuItem('FirstPage')\">&#xF01C;</a><a title='Go To PrevPage'onclick=\"app.execMenuItem('PrevPage')\">&#xF01D;</a><label id='FDFXFA_PageLabel'><span>1</span></label><label id='FDFXFA_PageCount'>/ <span>1</span></label><a title='Go To NextPage'onclick=\"app.execMenuItem('NextPage')\">&#xF01E;</a><a title='Go To LastPage'onclick=\"app.execMenuItem('LastPage')\">&#xF01F;</a><a title='Save As Editable PDF'onclick=\"app.execMenuItem('SaveAs')\">&#xF01A;</a></div>";
            String end = "<body onload=\"app.parseDocument()\">\n<form id='FDFXFA_Form' method='post' action=''><textarea name='pdfdata' id='FDFXFA_Textarea'></textarea></form><div id=\"FDFXFA_FormType\">XFA</div><div id=\"FDFXFA_PDFName\">" + fileName + "</div>" + (outputMenu ? "<div id='FDFXFA_Menu'><a title='Go To FirstPage'onclick=\"app.execMenuItem('FirstPage')\">&#xF01C;</a><a title='Go To PrevPage'onclick=\"app.execMenuItem('PrevPage')\">&#xF01D;</a><label id='FDFXFA_PageLabel'><span>1</span></label><label id='FDFXFA_PageCount'>/ <span>1</span></label><a title='Go To NextPage'onclick=\"app.execMenuItem('NextPage')\">&#xF01E;</a><a title='Go To LastPage'onclick=\"app.execMenuItem('LastPage')\">&#xF01F;</a><a title='Save As Editable PDF'onclick=\"app.execMenuItem('SaveAs')\">&#xF01A;</a></div>" : "") + "<form id=\"mainXFAForm\"></form>\n<div style=\"display: none\">\n<div id=\"templateDump\">" + this.getXMLTemplateAsBAse64() + "</div>\n<div id=\"dataDump\">" + this.getXMLContentAsBase64(1130793076) + "</div>\n<div id=\"configDump\">" + this.getXMLContentAsBase64(1043741046) + "</div>\n<div id=\"localeSetDump\">" + this.getXMLContentAsBase64(1951819392) + "</div>\n<div id=\"formDump\">" + this.getXMLContentAsBase64(4145725) + "</div>\n</div>\n<div id=\"preRenderer\" style=\"display:invisible\" ></div>" + (!applyBranding.isEmpty() ? '\n' + BrandingHelper.outputBranding(applyBranding, "FormVu", "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") + '\n' : "") + "</body>\n</html>";
            writer.write(start + end);
            writer.close();
            writer.flush();
        }
        catch (IOException e3) {
            LogWriter.writeLog(e3);
        }
        if (!inlineJavaScriptAndCSS) {
            for (int z2 = 0; z2 < jsFiles.length; ++z2) {
                File dest = new File(outputDir + seperator + "js" + seperator + jsFiles[z2] + '.' + jsExt[z2]);
                try (InputStream inputStream = this.getClass().getResourceAsStream("/com/idrsolutions/pdf/acroforms/xfa/res/js/" + jsFiles[z2] + '.' + jsExt[z2]);
                     FileOutputStream outputStream = new FileOutputStream(dest);){
                    ObjectStore.copy(inputStream, outputStream);
                    continue;
                }
                catch (IOException ex) {
                    LogWriter.writeLog(ex);
                }
            }
        }
    }

    @Override
    public PrintStreamDecoder getStreamDecoderForPrinting(PdfObjectReader currentPdfFile, PdfLayerList pdfLayerList) {
        if (this.isXFA() && this.useXFA()) {
            return new XFAStreamDecoderForPrinting(currentPdfFile, pdfLayerList, this);
        }
        return super.getStreamDecoderForPrinting(currentPdfFile, pdfLayerList);
    }

    @Override
    public BufferedImage decode(PdfObject formObj, PdfObjectReader currentPdfFile, PdfObject XObject2, int subtype, int width, int height, int offsetImage, float pageScaling) {
        return XFAFormStream.decode(formObj, currentPdfFile, XObject2);
    }

    @Override
    public FormFlattener getFormFlattener() {
        return new FormFlattenerXFA();
    }

    private String resourceToString(String resourcePath) {
        String string;
        BufferedReader br2 = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(resourcePath), StandardCharsets.UTF_8));
        try {
            string = br2.lines().collect(Collectors.joining(System.lineSeparator()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    br2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e2) {
                LogWriter.writeLog(e2);
                return "";
            }
        }
        br2.close();
        return string;
    }
}

