/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jpedal.objects.PdfShape;
import org.jpedal.utils.Matrix;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_Int;

public class SwingShape
implements Serializable,
PdfShape {
    private static final int initSize = 1000;
    private final Vector_Float shape_primitive_x2 = new Vector_Float(1000);
    private final Vector_Float shape_primitive_y = new Vector_Float(1000);
    private final Vector_Int shape_primitives = new Vector_Int(1000);
    private int winding_rule = 1;
    private final Vector_Float shape_primitive_x3 = new Vector_Float(1000);
    private final Vector_Float shape_primitive_y3 = new Vector_Float(1000);
    private final Vector_Float shape_primitive_y2 = new Vector_Float(1000);
    private final Vector_Float shape_primitive_x = new Vector_Float(1000);
    private static final int H = 3;
    private static final int L = 2;
    private static final int V = 6;
    private static final int M = 1;
    private static final int Y = 4;
    private static final int C = 5;
    private boolean isClip;
    private Shape currentShape;
    private boolean isClosed;

    public SwingShape(Shape currentShape) {
        this.currentShape = currentShape;
    }

    public SwingShape() {
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public final void closeShape() {
        this.shape_primitives.addElement(3);
        this.shape_primitive_x.addElement(0.0f);
        this.shape_primitive_y.addElement(0.0f);
        this.shape_primitive_x2.addElement(0.0f);
        this.shape_primitive_y2.addElement(0.0f);
        this.shape_primitive_x3.addElement(0.0f);
        this.shape_primitive_y3.addElement(0.0f);
    }

    @Override
    public final void addBezierCurveC(float x2, float y2, float x22, float y22, float x3, float y3) {
        this.shape_primitives.addElement(5);
        this.shape_primitive_x.addElement(x2);
        this.shape_primitive_y.addElement(y2);
        this.shape_primitive_x2.addElement(x22);
        this.shape_primitive_y2.addElement(y22);
        this.shape_primitive_x3.addElement(x3);
        this.shape_primitive_y3.addElement(y3);
    }

    @Override
    public final void setNONZEROWindingRule() {
        this.winding_rule = 1;
    }

    @Override
    public final void lineTo(float x2, float y2) {
        this.shape_primitives.addElement(2);
        this.shape_primitive_x.addElement(x2);
        this.shape_primitive_y.addElement(y2);
        this.shape_primitive_x2.addElement(0.0f);
        this.shape_primitive_y2.addElement(0.0f);
        this.shape_primitive_x3.addElement(0.0f);
        this.shape_primitive_y3.addElement(0.0f);
    }

    @Override
    public final void addBezierCurveV(float x2, float y2, float x3, float y3) {
        this.shape_primitives.addElement(6);
        this.shape_primitive_x.addElement(200.0f);
        this.shape_primitive_y.addElement(200.0f);
        this.shape_primitive_x2.addElement(x2);
        this.shape_primitive_y2.addElement(y2);
        this.shape_primitive_x3.addElement(x3);
        this.shape_primitive_y3.addElement(y3);
    }

    @Override
    public final Shape generateShapeFromPath(float[][] CTM, float thickness, int cmd) {
        this.isClosed = false;
        boolean is_clip = this.isClip;
        if (cmd == 110) {
            is_clip = false;
        }
        Path2D current_path = null;
        Area current_area = null;
        this.currentShape = null;
        float[] x2 = this.shape_primitive_x.get();
        float[] y2 = this.shape_primitive_y.get();
        float[] x22 = this.shape_primitive_x2.get();
        float[] y22 = this.shape_primitive_y2.get();
        float[] x3 = this.shape_primitive_x3.get();
        float[] y3 = this.shape_primitive_y3.get();
        int[] command = this.shape_primitives.get();
        int end = this.shape_primitives.size() - 1;
        if (end == 6 && cmd == 66 && thickness >= 0.9f && is_clip) {
            SwingShape.fixRounding(x2);
        }
        block9: for (int i2 = 0; i2 < end; ++i2) {
            if (current_path == null) {
                if (command[i2] != 1) continue;
                current_path = new GeneralPath(this.winding_rule);
                ((Path2D.Float)current_path).moveTo(x2[i2], y2[i2]);
            }
            if (command[i2] == 3) {
                this.isClosed = true;
                current_path.closePath();
                if (is_clip) {
                    current_area = SwingShape.updateArea((GeneralPath)current_path, current_area);
                    current_path = null;
                }
            }
            if (current_path == null) continue;
            switch (command[i2]) {
                case 2: {
                    ((Path2D.Float)current_path).lineTo(x2[i2], y2[i2]);
                    continue block9;
                }
                case 1: {
                    ((Path2D.Float)current_path).moveTo(x2[i2], y2[i2]);
                    continue block9;
                }
                default: {
                    switch (command[i2]) {
                        case 4: {
                            ((Path2D.Float)current_path).curveTo(x2[i2], y2[i2], x3[i2], y3[i2], x3[i2], y3[i2]);
                            continue block9;
                        }
                        case 5: {
                            ((Path2D.Float)current_path).curveTo(x2[i2], y2[i2], x22[i2], y22[i2], x3[i2], y3[i2]);
                            continue block9;
                        }
                        case 6: {
                            float c_x = (float)current_path.getCurrentPoint().getX();
                            float c_y = (float)current_path.getCurrentPoint().getY();
                            ((Path2D.Float)current_path).curveTo(c_x, c_y, x22[i2], y22[i2], x3[i2], y3[i2]);
                            continue block9;
                        }
                    }
                }
            }
        }
        if (CTM[0][0] != 1.0f || CTM[1][0] != 0.0f || CTM[2][0] != 0.0f || CTM[0][1] != 0.0f || CTM[1][1] != 1.0f || CTM[2][1] != 0.0f || CTM[0][2] != 0.0f || CTM[1][2] != 0.0f || CTM[2][2] != 1.0f) {
            SwingShape.scaleShape(CTM, (GeneralPath)current_path, current_area);
        }
        this.currentShape = !is_clip ? current_path : current_area;
        return this.currentShape;
    }

    private static void scaleShape(float[][] CTM, GeneralPath current_path, Area current_area) {
        AffineTransform CTM_transform = Matrix.toAffine(CTM);
        if (current_path != null) {
            current_path.transform(CTM_transform);
        } else if (current_area != null) {
            current_area.transform(CTM_transform);
        }
    }

    private static Area updateArea(GeneralPath current_path, Area current_area) {
        if (current_area == null) {
            current_area = new Area(current_path);
            if (current_area.getBounds2D().getWidth() <= 0.0 || current_area.getBounds2D().getHeight() <= 0.0) {
                Rectangle2D bounds = current_path.getBounds2D();
                current_area = new Area(new Rectangle2D.Double(bounds.getX(), bounds.getY(), Math.max(bounds.getWidth(), 0.1), Math.max(bounds.getHeight(), 0.1)));
            }
        } else {
            current_area.add(new Area(current_path));
        }
        return current_area;
    }

    private static void fixRounding(float[] x2) {
        for (int aa2 = 0; aa2 < 8; ++aa2) {
            float diff = x2[aa2] - (float)((int)x2[aa2]);
            if (!(diff > 0.5f)) continue;
            x2[aa2] = (float)((int)x2[aa2]) - 1.0f;
        }
    }

    @Override
    public final void appendRectangle(float x2, float y2, float w2, float h2) {
        if (w2 == 0.0f) {
            w2 = 0.5f;
        }
        if (h2 == 0.0f) {
            h2 = 0.5f;
        }
        this.moveTo(x2, y2);
        this.lineTo(x2 + w2, y2);
        this.lineTo(x2 + w2, y2 + h2);
        this.lineTo(x2, y2 + h2);
        this.lineTo(x2, y2);
        this.closeShape();
    }

    @Override
    public final void moveTo(float x2, float y2) {
        this.shape_primitives.addElement(1);
        this.shape_primitive_x.addElement(x2);
        this.shape_primitive_y.addElement(y2);
        this.shape_primitive_x2.addElement(0.0f);
        this.shape_primitive_y2.addElement(0.0f);
        this.shape_primitive_x3.addElement(0.0f);
        this.shape_primitive_y3.addElement(0.0f);
    }

    @Override
    public final void addBezierCurveY(float x2, float y2, float x3, float y3) {
        this.shape_primitives.addElement(4);
        this.shape_primitive_x.addElement(x2);
        this.shape_primitive_y.addElement(y2);
        this.shape_primitive_x2.addElement(0.0f);
        this.shape_primitive_y2.addElement(0.0f);
        this.shape_primitive_x3.addElement(x3);
        this.shape_primitive_y3.addElement(y3);
    }

    @Override
    public final void resetPath() {
        this.shape_primitives.clear();
        this.shape_primitive_x.clear();
        this.shape_primitive_y.clear();
        this.shape_primitive_x2.clear();
        this.shape_primitive_y2.clear();
        this.shape_primitive_x3.clear();
        this.shape_primitive_y3.clear();
        this.winding_rule = 1;
    }

    @Override
    public final void setEVENODDWindingRule() {
        this.winding_rule = 0;
    }

    @Override
    public int getSegmentCount() {
        return this.shape_primitives.size() - 1;
    }

    @Override
    public void setClip(boolean b2) {
        this.isClip = b2;
    }

    @Override
    public boolean isClip() {
        return this.isClip;
    }

    @Override
    public void setShape(Shape currentShape) {
        this.currentShape = currentShape;
    }

    @Override
    public Shape getShape() {
        return this.currentShape;
    }
}

