/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.outlines.OutlineData;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.Document;

public class PdfResources {
    public static final int AcroFormObj = 1;
    public static final int GlobalResources = 2;
    public static final int StructTreeRootObj = 3;
    public static final int MarkInfoObj = 4;
    public static final int ViewerPreferencesObj = 5;
    private PdfLayerList layers;
    private PdfObject metadataObj;
    private PdfObject acroFormObj;
    private PdfObject globalResources;
    private PdfObject PropertiesObj;
    private PdfObject structTreeRootObj;
    private PdfObject OCProperties;
    private PdfObject markInfoObj;
    private PdfObject OutlinesObj;
    private PdfObject ViewerPreferences;
    private OutlineData outlineData;

    public void setupResources(PdfStreamDecoder current, boolean alwaysCheck, PdfObject Resources, int pageNumber, PdfObjectReader currentPdfFile) {
        PdfObject propObj;
        if (this.globalResources != null) {
            current.readResources(this.globalResources, true);
            propObj = this.globalResources.getDictionary(-2089186617);
            if (propObj != null) {
                this.PropertiesObj = propObj;
            }
        }
        if (Resources != null) {
            current.readResources(Resources, true);
            propObj = Resources.getDictionary(-2089186617);
            if (propObj != null) {
                this.PropertiesObj = propObj;
            }
        }
        if (this.OCProperties != null && (this.layers == null || pageNumber != this.layers.getOCpageNumber() || alwaysCheck)) {
            currentPdfFile.checkResolved(this.OCProperties);
            if (this.layers == null) {
                this.layers = new PdfLayerList();
            }
            this.layers.init(this.OCProperties, this.PropertiesObj, currentPdfFile, pageNumber);
        }
        current.setObjectValue(-4, this.layers);
    }

    public PdfObject getPdfObject(int key) {
        PdfObject obj = null;
        switch (key) {
            case 1: {
                obj = this.acroFormObj;
                break;
            }
            case 2: {
                obj = this.globalResources;
                break;
            }
            case 4: {
                obj = this.markInfoObj;
                break;
            }
            case 3: {
                obj = this.structTreeRootObj;
                break;
            }
            case 5: {
                obj = this.ViewerPreferences;
            }
        }
        return obj;
    }

    public void setPdfObject(int key, PdfObject obj) {
        if (key == 2) {
            this.globalResources = obj;
        }
    }

    public void flush() {
        this.globalResources = null;
    }

    public void flushObjects() {
        this.metadataObj = null;
        this.acroFormObj = null;
        this.markInfoObj = null;
        this.PropertiesObj = null;
        this.OCProperties = null;
        this.structTreeRootObj = null;
        this.OutlinesObj = null;
        this.ViewerPreferences = null;
        this.layers = null;
    }

    public final boolean hasOutline() {
        return this.OutlinesObj != null;
    }

    public void setValues(PdfObject pdfObject, PdfObjectReader currentPdfFile) {
        currentPdfFile.checkResolved(pdfObject);
        this.metadataObj = pdfObject.getDictionary(1365674082);
        this.acroFormObj = pdfObject.getDictionary(661816444);
        currentPdfFile.checkResolved(this.acroFormObj);
        this.markInfoObj = pdfObject.getDictionary(913275002);
        this.structTreeRootObj = pdfObject.getDictionary(-2000237823);
        this.OCProperties = pdfObject.getDictionary(-1567847737);
        this.OutlinesObj = pdfObject.getDictionary(1485011327);
        this.ViewerPreferences = pdfObject.getDictionary(-272760568);
        this.outlineData = null;
    }

    public OutlineData getOutlineData() {
        return this.outlineData;
    }

    public Document getOutlineAsXML(PdfObjectReader currentPdfFile) {
        if (this.outlineData == null && this.OutlinesObj != null) {
            try {
                currentPdfFile.checkResolved(this.OutlinesObj);
                this.outlineData = new OutlineData();
                this.outlineData.readOutlineFileMetadata(this.OutlinesObj, currentPdfFile);
            }
            catch (Exception e2) {
                LogWriter.writeLog("Exception " + e2 + " accessing outline ");
                this.outlineData = null;
            }
        }
        if (this.outlineData != null) {
            return this.outlineData.getList();
        }
        return null;
    }

    public PdfFileInformation getMetaData(PdfObjectReader currentPdfFile) {
        if (currentPdfFile != null) {
            return new PdfFileInformation().readPdfFileMetadata(this.metadataObj, currentPdfFile);
        }
        return null;
    }

    public boolean isForm() {
        return this.acroFormObj != null && this.acroFormObj.getMixedArray(893143676).getTokenCount() > 0;
    }

    public PdfLayerList getPdfLayerList() {
        return this.layers;
    }
}

