/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.javascript.DefaultParser;
import org.jpedal.objects.javascript.ExpressionEngine;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.utils.repositories.Vector_String;

public class Javascript {
    private ExpressionEngine jsParser;
    private boolean actionsExecuted;
    private static boolean disableJavascript;
    private final Map<String, String> javascriptCommands = new HashMap<String, String>();
    private final Map<Integer, String> javascriptTypesUsed = new HashMap<Integer, String>();
    private final Map<String, Vector_String> linkedjavascriptCommands = new HashMap<String, Vector_String>();
    private final Map<String, String> javascriptNamesObjects = new HashMap<String, String>();

    public Javascript(ExpressionEngine userExpressionEngine, AcroRenderer acro) {
        if (disableJavascript) {
            return;
        }
        this.jsParser = userExpressionEngine != null ? userExpressionEngine : new DefaultParser();
        this.jsParser.setAcroRenderer(acro);
    }

    public void executeAction(String jsCode) {
        this.actionsExecuted = true;
        if (disableJavascript) {
            return;
        }
        this.jsParser.executeFunctions(jsCode, null);
    }

    public int execute(FormObject ref, int type, int eventType, char keyPressed) {
        String refName;
        Vector_String linkedObj;
        boolean executeChangedCode;
        int returnCode = this.executeCommand(ref, type, eventType, keyPressed);
        boolean bl2 = executeChangedCode = eventType == 6 && (type != 4866 || returnCode == 0 || returnCode == 3);
        if (executeChangedCode && (linkedObj = this.linkedjavascriptCommands.get(refName = ref.getTextStreamValue(36))) != null) {
            linkedObj.trim();
        }
        return returnCode;
    }

    public String getJavascriptCommand(String ref, int type) {
        return this.javascriptCommands.get(ref + '-' + type);
    }

    private int executeCommand(FormObject ref, int type, int eventType, char keyPressed) {
        int message = 0;
        if (disableJavascript) {
            return message;
        }
        if (ref == null) {
            return message;
        }
        String js = this.javascriptCommands.get(ref.getObjectRefAsString() + '-' + type);
        if (js == null) {
            js = this.javascriptCommands.get(ref.getTextStreamValue(36) + '-' + type);
        }
        if (js == null) {
            return 0;
        }
        message = this.jsParser.execute(ref, type, js, eventType, keyPressed);
        this.actionsExecuted = true;
        return message;
    }

    public void setCode(String name, String value) {
        if (disableJavascript) {
            return;
        }
        this.javascriptNamesObjects.put(name, value);
        this.jsParser.addCode(value);
    }

    public String getJavaScript(String key) {
        String str;
        if (key == null) {
            Collection<String> c2 = this.javascriptNamesObjects.values();
            Iterator<String> itr = c2.iterator();
            StringBuilder s2 = new StringBuilder();
            while (itr.hasNext()) {
                s2.append(itr.next());
            }
            str = s2.toString();
        } else {
            str = this.javascriptNamesObjects.get(key);
        }
        return str;
    }

    public Collection<String> getJavaScriptNameEntries() {
        return this.javascriptNamesObjects.keySet();
    }

    public void closeFile() {
        this.javascriptTypesUsed.clear();
        this.javascriptCommands.clear();
        this.linkedjavascriptCommands.clear();
        if (disableJavascript) {
            return;
        }
        if (this.actionsExecuted && !ExternalHandlers.isULCPresent()) {
            this.jsParser.closeFile();
        }
    }

    public void storeJavascript(String name, String script, int type) {
        this.javascriptCommands.put(name + '-' + type, script);
        this.javascriptTypesUsed.put(type, "x");
    }

    public void dispose() {
        if (disableJavascript) {
            return;
        }
        this.jsParser.dispose();
    }

    public static void disableJavascript() {
        disableJavascript = true;
    }
}

