/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.linear;

import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.FileAccess;
import org.jpedal.exception.PdfException;
import org.jpedal.io.LinearizedHintTable;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.security.CryptoIDR;
import org.jpedal.linear.LinearThread;
import org.jpedal.objects.raw.LinearizedObject;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.utils.FastByteArrayOutputStream;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;

public class LinearParser {
    private boolean isLinearizationTested;
    private PageObject linObject;
    private final Map<Integer, PageObject> linObjects = new HashMap<Integer, PageObject>();
    private int linearPageCount = -1;
    private PdfObject linearObj;
    private LinearizedHintTable linHintTable;
    private int E = -1;
    public LinearThread linearizedBackgroundReaderer;

    public void closePdfFile() {
        this.E = -1;
        this.linearObj = null;
        this.isLinearizationTested = false;
        this.linObjects.clear();
        if (this.linearizedBackgroundReaderer != null && this.linearizedBackgroundReaderer.isAlive()) {
            this.linearizedBackgroundReaderer.interrupt();
        }
        while (this.linearizedBackgroundReaderer != null && this.linearizedBackgroundReaderer.isAlive()) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception e2) {
                LogWriter.writeLog("Exception: " + e2.getMessage());
            }
        }
        this.linHintTable = null;
    }

    private void testForLinearlized(byte[] buffer, PdfObjectReader currentPdfFile) {
        int start = 0;
        int end = 0;
        boolean isLinear = false;
        int len = buffer.length;
        for (int i2 = 0; i2 < len; ++i2) {
            if (start == 0 && i2 + 2 < len && buffer[i2] == 111 && buffer[i2 + 1] == 98 && buffer[i2 + 2] == 106) {
                start = i2 + 3;
                continue;
            }
            if (end == 0 && i2 + 5 < len && buffer[i2] == 101 && buffer[i2 + 1] == 110 && buffer[i2 + 2] == 100 && buffer[i2 + 3] == 111 && buffer[i2 + 4] == 98 && buffer[i2 + 5] == 106) {
                end = i2 + 7;
                continue;
            }
            if (isLinear || i2 + 6 >= len || buffer[i2] != 47 || buffer[i2 + 1] != 76 || buffer[i2 + 2] != 105 || buffer[i2 + 3] != 110 || buffer[i2 + 4] != 101 || buffer[i2 + 5] != 97 || buffer[i2 + 6] != 114) continue;
            isLinear = true;
        }
        if (isLinear) {
            int dataLength = end - start;
            byte[] data = new byte[dataLength + 1];
            System.arraycopy(buffer, start, data, 0, dataLength);
            this.linearObj = new LinearizedObject("0 0 R");
            this.linearObj.setUnresolvedData(data, 2004845231);
            currentPdfFile.checkResolved(this.linearObj);
        } else {
            this.linearObj = null;
        }
    }

    public boolean isPageAvailable(int rawPage, PdfObjectReader currentPdfFile) {
        boolean isPageAvailable = true;
        try {
            if (this.linearizedBackgroundReaderer != null && this.linearizedBackgroundReaderer.isAlive() && rawPage > 1 && this.linHintTable != null) {
                Integer key = rawPage;
                if (this.linObjects.containsKey(key)) {
                    this.linObject = this.linObjects.get(key);
                    return true;
                }
                int objID = this.linHintTable.getPageObjectRef(rawPage);
                byte[] pageData = this.linHintTable.getObjData(objID);
                if (pageData != null) {
                    this.linObject = new PageObject(objID + " 0 R");
                    this.linObject.setUnresolvedData(pageData, 540096309);
                    this.linObject.isDataExternal(true);
                    PdfFileReader objectReader = currentPdfFile.getObjectReader();
                    if (!ObjectDecoder.resolveFully(this.linObject, objectReader)) {
                        isPageAvailable = false;
                    } else {
                        if (this.linObject != null) {
                            byte[] b_data = currentPdfFile.getObjectReader().readPageIntoStream(this.linObject);
                            if (b_data == null) {
                                isPageAvailable = false;
                            } else {
                                PdfObject Resources = this.linObject.getDictionary(2004251818);
                                if (Resources == null || !ObjectDecoder.resolveFully(Resources, objectReader)) {
                                    this.linObject = null;
                                    isPageAvailable = false;
                                } else {
                                    Resources.isDataExternal(true);
                                    new PdfStreamDecoder(currentPdfFile).readResources(Resources, true);
                                    if (!Resources.isFullyResolved()) {
                                        this.linObject = null;
                                        isPageAvailable = false;
                                    }
                                }
                            }
                        }
                        if (isPageAvailable && this.linObject != null) {
                            this.linObjects.put(key, this.linObject);
                        }
                    }
                } else {
                    isPageAvailable = false;
                }
            } else {
                this.linObject = null;
            }
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
            isPageAvailable = false;
        }
        return isPageAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readLinearData(byte[] password, PdfObjectReader currentPdfFile, File tempURLFile, InputStream is, FileAccess fileAccess) {
        try {
            int read;
            RandomAccessFile random = new RandomAccessFile(tempURLFile, "rws");
            FileChannel fos = random.getChannel();
            fos.force(true);
            FastByteArrayOutputStream bos = new FastByteArrayOutputStream(8192);
            CryptoIDR crypto = null;
            if (password != null) {
                crypto = new CryptoIDR(password);
            }
            byte[] buffer = new byte[4096];
            int bytesRead = 0;
            while ((read = is.read(buffer)) != -1) {
                if (read > 0) {
                    FileChannel fileChannel = fos;
                    synchronized (fileChannel) {
                        byte[] b2 = new byte[read];
                        System.arraycopy(buffer, 0, b2, 0, read);
                        if (password != null) {
                            b2 = crypto.encrypt(b2, bytesRead);
                        }
                        ByteBuffer f2 = ByteBuffer.wrap(b2);
                        fos.write(f2);
                    }
                }
                bytesRead += read;
                if (this.E != -1) {
                    bos.write(buffer, 0, read);
                    if (this.E >= bytesRead) continue;
                    byte[] linearBytes = bos.toByteArray();
                    this.linHintTable = new LinearizedHintTable(fos, password);
                    currentPdfFile.getObjectReader().storeLinearizedTables(this.linHintTable);
                    this.linearizedBackgroundReaderer = new LinearThread(is, fos, password, tempURLFile, this.linearObj, linearBytes, this.linHintTable, fileAccess);
                    return linearBytes;
                }
                if (this.isLinearizationTested) continue;
                this.isLinearizationTested = true;
                this.testForLinearlized(buffer, currentPdfFile);
                if (this.linearObj == null) continue;
                this.E = this.linearObj.getInt(21);
                bos.write(buffer, 0, read);
            }
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception - " + e2.getMessage());
        }
        return null;
    }

    public PdfObject readHintTable(PdfObjectReader currentPdfFile) throws PdfException {
        PdfObject pdfObject;
        long Ooffset = -1L;
        this.linearPageCount = -1;
        int O2 = this.linearObj.getInt(31);
        if (O2 != -1) {
            this.linearObj.setIntNumber(31, -1);
            currentPdfFile.getObjectReader().readReferenceTable(this.linearObj);
            pdfObject = new PageObject(O2, 0);
            currentPdfFile.readObject(pdfObject);
            this.linearPageCount = this.linearObj.getInt(30);
            Ooffset = currentPdfFile.getObjectReader().getOffset(O2);
        } else {
            pdfObject = currentPdfFile.getObjectReader().readReferenceTable(null);
        }
        int[] H2 = this.linearObj.getIntArray(24);
        byte[] hintStream = currentPdfFile.getObjectReader().getBytes(H2[0], H2[1]);
        int length = hintStream.length;
        int startHint = 0;
        int i2 = 0;
        boolean contentIsDodgy = false;
        int keyStart2 = i2;
        while (hintStream[i2] != 10 && hintStream[i2] != 13 && hintStream[i2] != 32 && hintStream[i2] != 47 && hintStream[i2] != 60 && hintStream[i2] != 62) {
            if (hintStream[i2] < 48 || hintStream[i2] > 57) {
                contentIsDodgy = true;
                break;
            }
            ++i2;
        }
        if (!contentIsDodgy) {
            int number = NumberUtils.parseInt(keyStart2, i2, hintStream);
            while (hintStream[i2] == 10 || hintStream[i2] == 13 || hintStream[i2] == 32 || hintStream[i2] == 47 || hintStream[i2] == 60) {
                ++i2;
            }
            keyStart2 = i2;
            while (i2 < 10 && hintStream[i2] != 10 && hintStream[i2] != 13 && hintStream[i2] != 32 && hintStream[i2] != 47 && hintStream[i2] != 60 && hintStream[i2] != 62) {
                ++i2;
            }
            int generation = NumberUtils.parseInt(keyStart2, i2, hintStream);
            while (i2 < length - 1) {
                if (hintStream[i2] == 60 && hintStream[i2 + 1] == 60) {
                    startHint = i2;
                    i2 = length;
                }
                ++i2;
            }
            byte[] data = new byte[length - startHint];
            System.arraycopy(hintStream, startHint, data, 0, data.length);
            LinearizedObject hintObj = new LinearizedObject(number, generation);
            hintObj.setUnresolvedData(data, 2004845231);
            currentPdfFile.checkResolved(hintObj);
            this.linHintTable.readTable(hintObj, this.linearObj, O2, Ooffset);
        }
        return pdfObject;
    }

    public int getPageCount() {
        return this.linearPageCount;
    }

    public boolean hasLinearData() {
        return this.linearObj != null && this.E != -1;
    }

    public PdfObject getLinearPageObject() {
        return this.linObject;
    }

    public PdfObject getLinearObject(boolean isOpen, PdfObjectReader currentPdfFile) {
        if (!this.isLinearizationTested && isOpen) {
            this.isLinearizationTested = true;
            this.testForLinearlized(currentPdfFile.getObjectReader().getBytes(0L, 400), currentPdfFile);
        }
        return this.linearObj;
    }
}

