/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.segment.tables;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.jbig2.decoders.JBIG2StreamDecoder;
import org.jpedal.jbig2.image.JBIG2Bitmap;
import org.jpedal.jbig2.segment.Segment;

public class CodeTableSegment
extends Segment {
    private int[][] table;

    public CodeTableSegment(JBIG2StreamDecoder streamDecoder) {
        super(streamDecoder);
    }

    @Override
    public void readSegment() {
        CodeTableSegmentData data = new CodeTableSegmentData(this.decoder);
        this.decoder.consumeRemainingBits();
        HashMap<Integer, Integer> CODES = new HashMap<Integer, Integer>();
        Map<Integer, Integer> PREFLEN = data.getPreflen();
        Map<Integer, Integer> RANGELOW = data.getRangeLow();
        Map<Integer, Integer> RANGELEN = data.getRangeLen();
        int NTEMP = data.getNTemp();
        CodeTableSegment.setCodes(CODES, PREFLEN, NTEMP);
        this.table = new int[PREFLEN.size() + 1][];
        ArrayList<int[]> newTable = new ArrayList<int[]>();
        Object[] sortedPrefLens = PREFLEN.values().toArray();
        Arrays.sort(sortedPrefLens);
        for (int i2 = 0; i2 < sortedPrefLens.length; ++i2) {
            int count = 1;
            int val = (Integer)sortedPrefLens[i2];
            while (i2 + 1 < sortedPrefLens.length && sortedPrefLens[i2 + 1] == sortedPrefLens[i2]) {
                ++i2;
                ++count;
            }
            if (val == 0) continue;
            int[] entryNumbers = CodeTableSegment.findEntries(PREFLEN, count, val);
            if (entryNumbers.length == 1) {
                int entry = entryNumbers[0];
                newTable.add(new int[]{RANGELOW.get(entry), PREFLEN.get(entry), RANGELEN.get(entry), CODES.get(entry) == null ? 0 : CODES.get(entry)});
                continue;
            }
            CodeTableSegment.handleArray(CODES, PREFLEN, RANGELOW, RANGELEN, newTable, count, entryNumbers);
        }
        newTable.add(new int[]{0, 0, -1, 0});
        this.table = new int[newTable.size()][];
        System.arraycopy(newTable.toArray((T[])this.table), 0, this.table, 0, newTable.size());
    }

    private static void handleArray(HashMap<Integer, Integer> CODES, Map<Integer, Integer> PREFLEN, Map<Integer, Integer> RANGELOW, Map<Integer, Integer> RANGELEN, ArrayList<int[]> newTable, int count, int[] entryNumbers) {
        int[] sortedRangeLow = new int[count];
        int ptr = 0;
        for (int entry : entryNumbers) {
            sortedRangeLow[ptr] = RANGELOW.get(entry);
            ++ptr;
        }
        Arrays.sort(sortedRangeLow);
        for (int rangeLow : sortedRangeLow) {
            ptr = 0;
            while (RANGELOW.get(entryNumbers[ptr]) != rangeLow) {
                ++ptr;
            }
            int entry = entryNumbers[ptr];
            newTable.add(new int[]{RANGELOW.get(entry), PREFLEN.get(entry), RANGELEN.get(entry), CODES.get(entry) == null ? 0 : CODES.get(entry)});
        }
    }

    private static int[] findEntries(Map<Integer, Integer> PREFLEN, int count, int val) {
        int entriesFound = 0;
        int[] entryNumbers = new int[count];
        for (int ptr = 0; entriesFound < count && ptr < PREFLEN.size(); ++ptr) {
            if (PREFLEN.get(ptr) != val) continue;
            entryNumbers[entriesFound] = ptr;
            ++entriesFound;
        }
        return entryNumbers;
    }

    private static void setCodes(HashMap<Integer, Integer> CODES, Map<Integer, Integer> PREFLEN, int NTEMP) {
        HashMap<Integer, Integer> LENCOUNT = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> FIRSTCODE = new HashMap<Integer, Integer>();
        int LENMAX = CodeTableSegment.countSegments(LENCOUNT, PREFLEN);
        FIRSTCODE.put(0, 0);
        LENCOUNT.put(0, 0);
        for (int CURLEN = 1; CURLEN <= LENMAX; ++CURLEN) {
            int thisLenCount = 0;
            if (LENCOUNT.get(CURLEN - 1) != null) {
                thisLenCount = LENCOUNT.get(CURLEN - 1);
            }
            FIRSTCODE.put(CURLEN, ((Integer)FIRSTCODE.get(CURLEN - 1) + thisLenCount) * 2);
            int CURCODE = (Integer)FIRSTCODE.get(CURLEN);
            for (int CURTEMP = 0; CURTEMP < NTEMP; ++CURTEMP) {
                if (PREFLEN.get(CURTEMP) != CURLEN) continue;
                CODES.put(CURTEMP, CURCODE);
                ++CURCODE;
            }
        }
    }

    private static int countSegments(HashMap<Integer, Integer> LENCOUNT, Map<Integer, Integer> PREFLEN) {
        int LENMAX = 0;
        for (Integer length : PREFLEN.values()) {
            Integer count = LENCOUNT.get(length);
            if (count == null) {
                count = 1;
            } else {
                Integer n2 = count;
                Integer n3 = count = Integer.valueOf(count + 1);
            }
            LENCOUNT.put(length, count);
            if (length <= LENMAX) continue;
            LENMAX = length;
        }
        return LENMAX;
    }

    public int[][] getHuffTable() {
        return this.table;
    }

    @Override
    public JBIG2Bitmap[] getBitmaps() {
        return null;
    }

    class CodeTableSegmentData {
        final Map<Integer, Integer> RANGELOW = new HashMap<Integer, Integer>();
        final Map<Integer, Integer> RANGELEN = new HashMap<Integer, Integer>();
        final Map<Integer, Integer> PREFLEN = new HashMap<Integer, Integer>();
        final boolean HTOOB;
        final int HTPS;
        final int HTRS;
        final int HTLOW;
        final int HTHIGH;
        int CURRANGELOW;
        int NTEMP;
        final int LOWPREFLEN;
        final int HIGHPREFLEN;

        CodeTableSegmentData(JBIG2StreamDecoder decoder) {
            decoder.readBit();
            this.HTRS = decoder.readBits(3) + 1;
            this.HTPS = decoder.readBits(3) + 1;
            this.HTOOB = decoder.readBit() == 1;
            this.HTLOW = (decoder.readByte() & 0xFF) << 24 | (decoder.readByte() & 0xFF) << 16 | (decoder.readByte() & 0xFF) << 8 | decoder.readByte() & 0xFF;
            this.HTHIGH = (decoder.readByte() & 0xFF) << 24 | (decoder.readByte() & 0xFF) << 16 | (decoder.readByte() & 0xFF) << 8 | decoder.readByte() & 0xFF;
            this.CURRANGELOW = this.HTLOW;
            this.NTEMP = 0;
            boolean moreLines = true;
            while (moreLines) {
                this.PREFLEN.put(this.NTEMP, decoder.readBits(this.HTPS));
                this.RANGELEN.put(this.NTEMP, decoder.readBits(this.HTRS));
                this.RANGELOW.put(this.NTEMP, this.CURRANGELOW);
                this.CURRANGELOW += (int)Math.pow(2.0, this.RANGELEN.get(this.NTEMP).intValue());
                ++this.NTEMP;
                if (this.CURRANGELOW < this.HTHIGH) continue;
                moreLines = false;
            }
            this.LOWPREFLEN = decoder.readBits(this.HTPS);
            this.PREFLEN.put(this.NTEMP, this.LOWPREFLEN);
            this.RANGELEN.put(this.NTEMP, 32);
            this.RANGELOW.put(this.NTEMP, this.HTHIGH - 1);
            ++this.NTEMP;
            this.HIGHPREFLEN = decoder.readBits(this.HTPS);
            this.PREFLEN.put(this.NTEMP, this.HIGHPREFLEN);
            this.RANGELEN.put(this.NTEMP, 32);
            this.RANGELOW.put(this.NTEMP, this.HTHIGH);
            ++this.NTEMP;
            if (this.HTOOB) {
                int OOBPREFLEN = decoder.readBits(this.HTPS);
                this.PREFLEN.put(this.NTEMP, OOBPREFLEN);
                this.RANGELEN.put(this.NTEMP, -2);
                ++this.NTEMP;
            }
        }

        Map<Integer, Integer> getPreflen() {
            return this.PREFLEN;
        }

        Map<Integer, Integer> getRangeLow() {
            return this.RANGELOW;
        }

        Map<Integer, Integer> getRangeLen() {
            return this.RANGELEN;
        }

        int getNTemp() {
            return this.NTEMP;
        }
    }
}

