/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.segment.symboldictionary;

import java.util.ArrayList;
import org.jpedal.jbig2.decoders.ArithmeticDecoderStats;
import org.jpedal.jbig2.decoders.DecodeIntResult;
import org.jpedal.jbig2.decoders.HuffmanDecoder;
import org.jpedal.jbig2.decoders.JBIG2StreamDecoder;
import org.jpedal.jbig2.image.JBIG2Bitmap;
import org.jpedal.jbig2.segment.Segment;
import org.jpedal.jbig2.segment.symboldictionary.SymbolDictionaryFlags;
import org.jpedal.jbig2.segment.tables.CodeTableSegment;
import org.jpedal.jbig2.util.BinaryOperation;

public class SymbolDictionarySegment
extends Segment {
    private int noOfExportedSymbols;
    private int noOfNewSymbols;
    private final short[] symbolDictionaryAdaptiveTemplateX = new short[4];
    private final short[] symbolDictionaryAdaptiveTemplateY = new short[4];
    private final short[] symbolDictionaryRAdaptiveTemplateX = new short[2];
    private final short[] symbolDictionaryRAdaptiveTemplateY = new short[2];
    private JBIG2Bitmap[] bitmaps;
    private final SymbolDictionaryFlags symbolDictionaryFlags = new SymbolDictionaryFlags();
    private ArithmeticDecoderStats genericRegionStats;
    private ArithmeticDecoderStats refinementRegionStats;

    public SymbolDictionarySegment(JBIG2StreamDecoder streamDecoder) {
        super(streamDecoder);
    }

    @Override
    public void readSegment() {
        int i2;
        this.readSymbolDictionaryFlags();
        ArrayList<Segment> codeTables = new ArrayList<Segment>();
        int numberOfInputSymbols = 0;
        int noOfReferredToSegments = this.segmentHeader.getReferredToSegmentCount();
        int[] referredToSegments = this.segmentHeader.getReferredToSegments();
        numberOfInputSymbols = this.getNumberOfInputSymbols(codeTables, numberOfInputSymbols, noOfReferredToSegments, referredToSegments);
        int symbolCodeLength = 0;
        for (i2 = 1; i2 < numberOfInputSymbols + this.noOfNewSymbols; i2 <<= 1) {
            ++symbolCodeLength;
        }
        JBIG2Bitmap[] bitmaps = new JBIG2Bitmap[numberOfInputSymbols + this.noOfNewSymbols];
        SymbolDictionarySegment inputSymbolDictionary = this.getSymbolDictionarySegment(noOfReferredToSegments, referredToSegments, bitmaps);
        int[][] huffmanDHTable = null;
        int[][] huffmanDWTable = null;
        int[][] huffmanBMSizeTable = null;
        int[][] huffmanAggInstTable = null;
        boolean sdHuffman = this.symbolDictionaryFlags.getFlagValue("SD_HUFF") != 0;
        int sdHuffmanDifferenceHeight = this.symbolDictionaryFlags.getFlagValue("SD_HUFF_DH");
        int sdHuffmanDifferenceWidth = this.symbolDictionaryFlags.getFlagValue("SD_HUFF_DW");
        int sdHuffBitmapSize = this.symbolDictionaryFlags.getFlagValue("SD_HUFF_BM_SIZE");
        int sdHuffAggregationInstances = this.symbolDictionaryFlags.getFlagValue("SD_HUFF_AGG_INST");
        i2 = 0;
        if (sdHuffman) {
            switch (sdHuffmanDifferenceHeight) {
                case 0: {
                    huffmanDHTable = HuffmanDecoder.huffmanTableD;
                    break;
                }
                case 1: {
                    huffmanDHTable = HuffmanDecoder.huffmanTableE;
                    break;
                }
                default: {
                    huffmanDHTable = ((CodeTableSegment)codeTables.get(i2++)).getHuffTable();
                }
            }
            switch (sdHuffmanDifferenceWidth) {
                case 0: {
                    huffmanDWTable = HuffmanDecoder.huffmanTableB;
                    break;
                }
                case 1: {
                    huffmanDWTable = HuffmanDecoder.huffmanTableC;
                    break;
                }
                default: {
                    huffmanDWTable = ((CodeTableSegment)codeTables.get(i2++)).getHuffTable();
                }
            }
            huffmanBMSizeTable = sdHuffBitmapSize == 0 ? HuffmanDecoder.huffmanTableA : ((CodeTableSegment)codeTables.get(i2++)).getHuffTable();
            huffmanAggInstTable = sdHuffAggregationInstances == 0 ? HuffmanDecoder.huffmanTableA : ((CodeTableSegment)codeTables.get(i2)).getHuffTable();
        }
        int contextUsed = this.symbolDictionaryFlags.getFlagValue("BITMAP_CC_USED");
        int sdTemplate = this.symbolDictionaryFlags.getFlagValue("SD_TEMPLATE");
        if (!sdHuffman) {
            if (contextUsed != 0 && inputSymbolDictionary != null) {
                this.arithmeticDecoder.resetGenericStats(sdTemplate, inputSymbolDictionary.genericRegionStats);
            } else {
                this.arithmeticDecoder.resetGenericStats(sdTemplate, null);
            }
            this.arithmeticDecoder.resetIntStats(symbolCodeLength);
            this.arithmeticDecoder.start();
        }
        int sdRefinementAggregate = this.symbolDictionaryFlags.getFlagValue("SD_REF_AGG");
        int sdRefinementTemplate = this.symbolDictionaryFlags.getFlagValue("SD_R_TEMPLATE");
        if (sdRefinementAggregate != 0) {
            if (contextUsed != 0 && inputSymbolDictionary != null) {
                this.arithmeticDecoder.resetRefinementStats(sdRefinementTemplate, inputSymbolDictionary.refinementRegionStats);
            } else {
                this.arithmeticDecoder.resetRefinementStats(sdRefinementTemplate, null);
            }
        }
        int[] deltaWidths = new int[this.noOfNewSymbols];
        int deltaHeight = 0;
        i2 = 0;
        while (i2 < this.noOfNewSymbols) {
            DecodeIntResult decodeIntResult;
            int instanceDeltaHeight = sdHuffman ? this.huffmanDecoder.decodeInt(huffmanDHTable).intResult() : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iadhStats).intResult();
            deltaHeight += instanceDeltaHeight;
            int symbolWidth = 0;
            int totalWidth = 0;
            int j2 = i2;
            while ((decodeIntResult = sdHuffman ? this.huffmanDecoder.decodeInt(huffmanDWTable) : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iadwStats)).booleanResult()) {
                int deltaWidth = decodeIntResult.intResult();
                symbolWidth += deltaWidth;
                if (sdHuffman && sdRefinementAggregate == 0) {
                    deltaWidths[i2] = symbolWidth;
                    totalWidth += symbolWidth;
                } else if (sdRefinementAggregate == 1) {
                    int refAggNum = sdHuffman ? this.huffmanDecoder.decodeInt(huffmanAggInstTable).intResult() : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iaaiStats).intResult();
                    if (refAggNum == 1) {
                        int referenceDY;
                        int referenceDX;
                        int symbolID;
                        if (sdHuffman) {
                            symbolID = this.decoder.readBits(symbolCodeLength);
                            referenceDX = this.huffmanDecoder.decodeInt(HuffmanDecoder.huffmanTableO).intResult();
                            referenceDY = this.huffmanDecoder.decodeInt(HuffmanDecoder.huffmanTableO).intResult();
                            this.decoder.consumeRemainingBits();
                            this.arithmeticDecoder.start();
                        } else {
                            symbolID = (int)this.arithmeticDecoder.decodeIAID(symbolCodeLength, this.arithmeticDecoder.iaidStats);
                            referenceDX = this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iardxStats).intResult();
                            referenceDY = this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iardyStats).intResult();
                        }
                        JBIG2Bitmap referredToBitmap = bitmaps[symbolID];
                        JBIG2Bitmap bitmap = new JBIG2Bitmap(symbolWidth, deltaHeight, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder, this.decoder);
                        bitmap.readGenericRefinementRegion(sdRefinementTemplate, false, referredToBitmap, referenceDX, referenceDY, this.symbolDictionaryRAdaptiveTemplateX, this.symbolDictionaryRAdaptiveTemplateY);
                        bitmaps[numberOfInputSymbols + i2] = bitmap;
                    } else {
                        JBIG2Bitmap bitmap = new JBIG2Bitmap(symbolWidth, deltaHeight, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder, this.decoder);
                        bitmap.readTextRegion(sdHuffman, true, refAggNum, 0, numberOfInputSymbols + i2, null, symbolCodeLength, bitmaps, 0, 0, false, 1, 0, HuffmanDecoder.huffmanTableF, HuffmanDecoder.huffmanTableH, HuffmanDecoder.huffmanTableK, HuffmanDecoder.huffmanTableO, HuffmanDecoder.huffmanTableO, HuffmanDecoder.huffmanTableO, HuffmanDecoder.huffmanTableO, sdRefinementTemplate, this.symbolDictionaryRAdaptiveTemplateX, this.symbolDictionaryRAdaptiveTemplateY, this.decoder);
                        bitmaps[numberOfInputSymbols + i2] = bitmap;
                    }
                } else {
                    JBIG2Bitmap bitmap = new JBIG2Bitmap(symbolWidth, deltaHeight, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder, this.decoder);
                    bitmap.readBitmap(sdTemplate, false, false, null, this.symbolDictionaryAdaptiveTemplateX, this.symbolDictionaryAdaptiveTemplateY);
                    bitmaps[numberOfInputSymbols + i2] = bitmap;
                }
                ++i2;
            }
            if (!sdHuffman || sdRefinementAggregate != 0) continue;
            int bmSize = this.huffmanDecoder.decodeInt(huffmanBMSizeTable).intResult();
            this.decoder.consumeRemainingBits();
            JBIG2Bitmap collectiveBitmap = new JBIG2Bitmap(totalWidth, deltaHeight, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder, this.decoder);
            if (bmSize == 0) {
                int padding = totalWidth % 8;
                int bytesPerRow = (int)Math.ceil((double)totalWidth / 8.0);
                int size = deltaHeight * (totalWidth + 7 >> 3);
                short[] bitmap = new short[size];
                this.decoder.readByte(bitmap);
                short[][] logicalMap = new short[deltaHeight][bytesPerRow];
                int count = 0;
                for (int row = 0; row < deltaHeight; ++row) {
                    for (int col = 0; col < bytesPerRow; ++col) {
                        logicalMap[row][col] = bitmap[count];
                        ++count;
                    }
                }
                int collectiveBitmapRow = 0;
                int collectiveBitmapCol = 0;
                for (int row = 0; row < deltaHeight; ++row) {
                    for (int col = 0; col < bytesPerRow; ++col) {
                        int bit;
                        short mask;
                        int bitPointer;
                        short currentByte;
                        if (col == bytesPerRow - 1) {
                            currentByte = logicalMap[row][col];
                            for (bitPointer = 7; bitPointer >= padding; --bitPointer) {
                                mask = (short)(1 << bitPointer);
                                bit = (currentByte & mask) >> bitPointer;
                                collectiveBitmap.setPixel(collectiveBitmapCol, collectiveBitmapRow, bit);
                                ++collectiveBitmapCol;
                            }
                            ++collectiveBitmapRow;
                            collectiveBitmapCol = 0;
                            continue;
                        }
                        currentByte = logicalMap[row][col];
                        for (bitPointer = 7; bitPointer >= 0; --bitPointer) {
                            mask = (short)(1 << bitPointer);
                            bit = (currentByte & mask) >> bitPointer;
                            collectiveBitmap.setPixel(collectiveBitmapCol, collectiveBitmapRow, bit);
                            ++collectiveBitmapCol;
                        }
                    }
                }
            } else {
                collectiveBitmap.readBitmapWithMMR(bmSize);
            }
            int x2 = 0;
            while (j2 < i2) {
                bitmaps[numberOfInputSymbols + j2] = collectiveBitmap.getSlice(x2, 0, deltaWidths[j2], deltaHeight);
                x2 += deltaWidths[j2];
                ++j2;
            }
            collectiveBitmap.getDataWriter().clearResources();
        }
        this.bitmaps = new JBIG2Bitmap[this.noOfExportedSymbols];
        i2 = 0;
        int j3 = 0;
        boolean export = false;
        while (i2 < numberOfInputSymbols + this.noOfNewSymbols) {
            int run = sdHuffman ? this.huffmanDecoder.decodeInt(HuffmanDecoder.huffmanTableA).intResult() : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iaexStats).intResult();
            if (export) {
                for (int cnt = 0; cnt < run; ++cnt) {
                    this.bitmaps[j3++] = bitmaps[i2++];
                }
            } else {
                i2 += run;
            }
            export = !export;
        }
        int contextRetained = this.symbolDictionaryFlags.getFlagValue("BITMAP_CC_RETAINED");
        if (!sdHuffman && contextRetained == 1) {
            this.genericRegionStats = this.genericRegionStats.copy();
            if (sdRefinementAggregate == 1) {
                this.refinementRegionStats = this.refinementRegionStats.copy();
            }
        }
        this.decoder.consumeRemainingBits();
    }

    private SymbolDictionarySegment getSymbolDictionarySegment(int noOfReferredToSegments, int[] referredToSegments, JBIG2Bitmap[] bitmaps) {
        int k2 = 0;
        SymbolDictionarySegment inputSymbolDictionary = null;
        for (int i2 = 0; i2 < noOfReferredToSegments; ++i2) {
            Segment seg = this.decoder.findSegment(referredToSegments[i2]);
            if (seg.getSegmentHeader().getSegmentType() != 0) continue;
            inputSymbolDictionary = (SymbolDictionarySegment)seg;
            for (int j2 = 0; j2 < inputSymbolDictionary.noOfExportedSymbols; ++j2) {
                bitmaps[k2++] = inputSymbolDictionary.bitmaps[j2];
            }
        }
        return inputSymbolDictionary;
    }

    private int getNumberOfInputSymbols(ArrayList<Segment> codeTables, int numberOfInputSymbols, int noOfReferredToSegments, int[] referredToSegments) {
        for (int i2 = 0; i2 < noOfReferredToSegments; ++i2) {
            Segment seg = this.decoder.findSegment(referredToSegments[i2]);
            int type = seg.getSegmentHeader().getSegmentType();
            if (type == 0) {
                numberOfInputSymbols += ((SymbolDictionarySegment)seg).noOfExportedSymbols;
                continue;
            }
            if (type != 53) continue;
            codeTables.add(seg);
        }
        return numberOfInputSymbols;
    }

    private void readSymbolDictionaryFlags() {
        int noOfNewSymbols;
        int noOfExportedSymbols;
        short[] symbolDictionaryFlagsField = new short[2];
        this.decoder.readByte(symbolDictionaryFlagsField);
        int flags = BinaryOperation.getInt16(symbolDictionaryFlagsField);
        this.symbolDictionaryFlags.setFlags(flags);
        int sdHuff = this.symbolDictionaryFlags.getFlagValue("SD_HUFF");
        int sdTemplate = this.symbolDictionaryFlags.getFlagValue("SD_TEMPLATE");
        if (sdHuff == 0) {
            if (sdTemplate == 0) {
                this.symbolDictionaryAdaptiveTemplateX[0] = this.readATValue();
                this.symbolDictionaryAdaptiveTemplateY[0] = this.readATValue();
                this.symbolDictionaryAdaptiveTemplateX[1] = this.readATValue();
                this.symbolDictionaryAdaptiveTemplateY[1] = this.readATValue();
                this.symbolDictionaryAdaptiveTemplateX[2] = this.readATValue();
                this.symbolDictionaryAdaptiveTemplateY[2] = this.readATValue();
                this.symbolDictionaryAdaptiveTemplateX[3] = this.readATValue();
                this.symbolDictionaryAdaptiveTemplateY[3] = this.readATValue();
            } else {
                this.symbolDictionaryAdaptiveTemplateX[0] = this.readATValue();
                this.symbolDictionaryAdaptiveTemplateY[0] = this.readATValue();
            }
        }
        int refAgg = this.symbolDictionaryFlags.getFlagValue("SD_REF_AGG");
        int sdrTemplate = this.symbolDictionaryFlags.getFlagValue("SD_R_TEMPLATE");
        if (refAgg != 0 && sdrTemplate == 0) {
            this.symbolDictionaryRAdaptiveTemplateX[0] = this.readATValue();
            this.symbolDictionaryRAdaptiveTemplateY[0] = this.readATValue();
            this.symbolDictionaryRAdaptiveTemplateX[1] = this.readATValue();
            this.symbolDictionaryRAdaptiveTemplateY[1] = this.readATValue();
        }
        short[] noOfExportedSymbolsField = new short[4];
        this.decoder.readByte(noOfExportedSymbolsField);
        this.noOfExportedSymbols = noOfExportedSymbols = BinaryOperation.getInt32(noOfExportedSymbolsField);
        short[] noOfNewSymbolsField = new short[4];
        this.decoder.readByte(noOfNewSymbolsField);
        this.noOfNewSymbols = noOfNewSymbols = BinaryOperation.getInt32(noOfNewSymbolsField);
    }

    public int getNoOfExportedSymbols() {
        return this.noOfExportedSymbols;
    }

    @Override
    public JBIG2Bitmap[] getBitmaps() {
        return this.bitmaps;
    }
}

