/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.segment.region.halftone;

import java.io.IOException;
import org.jpedal.jbig2.JBIG2Exception;
import org.jpedal.jbig2.decoders.JBIG2StreamDecoder;
import org.jpedal.jbig2.image.JBIG2Bitmap;
import org.jpedal.jbig2.segment.Segment;
import org.jpedal.jbig2.segment.pageinformation.PageInformationSegment;
import org.jpedal.jbig2.segment.pattern.PatternDictionarySegment;
import org.jpedal.jbig2.segment.region.RegionSegment;
import org.jpedal.jbig2.segment.region.halftone.HalftoneRegionFlags;
import org.jpedal.jbig2.util.BinaryOperation;

public class HalftoneRegionSegment
extends RegionSegment {
    private final HalftoneRegionFlags halftoneRegionFlags = new HalftoneRegionFlags();
    private final boolean inlineImage;

    public HalftoneRegionSegment(JBIG2StreamDecoder streamDecoder, boolean inlineImage) {
        super(streamDecoder);
        this.inlineImage = inlineImage;
    }

    @Override
    public void readSegment() throws IOException, JBIG2Exception {
        super.readSegment();
        this.readHalftoneRegionFlags();
        SegmentData segData = new SegmentData(this.decoder);
        int[] referredToSegments = this.segmentHeader.getReferredToSegments();
        Segment segment = this.decoder.findSegment(referredToSegments[0]);
        PatternDictionarySegment patternDictionarySegment = (PatternDictionarySegment)segment;
        int bitsPerValue = HalftoneRegionSegment.getBitsPerValue(patternDictionarySegment);
        JBIG2Bitmap bitmap = patternDictionarySegment.getBitmaps()[0];
        int patternWidth = bitmap.getWidth();
        int patternHeight = bitmap.getHeight();
        boolean useMMR = this.halftoneRegionFlags.getFlagValue("H_MMR") != 0;
        int template = this.halftoneRegionFlags.getFlagValue("H_TEMPLATE");
        if (!useMMR) {
            this.arithmeticDecoder.resetGenericStats(template, null);
            this.arithmeticDecoder.start();
        }
        int halftoneDefaultPixel = this.halftoneRegionFlags.getFlagValue("H_DEF_PIXEL");
        bitmap = new JBIG2Bitmap(this.regionBitmapWidth, this.regionBitmapHeight, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder, this.decoder);
        bitmap.clear(halftoneDefaultPixel);
        boolean enableSkip = this.halftoneRegionFlags.getFlagValue("H_ENABLE_SKIP") != 0;
        JBIG2Bitmap skipBitmap = null;
        if (enableSkip) {
            skipBitmap = this.getJbig2Bitmap(segData, patternWidth, patternHeight);
        }
        int[] grayScaleImage = new int[segData.gridWidth * segData.gridHeight];
        short[] genericBAdaptiveTemplateX = new short[4];
        short[] genericBAdaptiveTemplateY = new short[4];
        genericBAdaptiveTemplateX[0] = (short)(template <= 1 ? 3 : 2);
        genericBAdaptiveTemplateY[0] = -1;
        genericBAdaptiveTemplateX[1] = -3;
        genericBAdaptiveTemplateY[1] = -1;
        genericBAdaptiveTemplateX[2] = 2;
        genericBAdaptiveTemplateY[2] = -2;
        genericBAdaptiveTemplateX[3] = -2;
        genericBAdaptiveTemplateY[3] = -2;
        JBIG2Bitmap grayBitmap = this.handleGray(segData, bitsPerValue, useMMR, template, enableSkip, skipBitmap, grayScaleImage, genericBAdaptiveTemplateX, genericBAdaptiveTemplateY);
        HalftoneRegionSegment.combineValues(segData, patternDictionarySegment, bitmap, enableSkip, skipBitmap, grayScaleImage, this.halftoneRegionFlags);
        if (this.inlineImage) {
            this.returnInlinedImage(bitmap);
        } else {
            bitmap.setBitmapNumber(this.getSegmentHeader().getSegmentNumber());
            this.decoder.appendBitmap(bitmap);
        }
    }

    private static void combineValues(SegmentData segData, PatternDictionarySegment patternDictionarySegment, JBIG2Bitmap bitmap, boolean enableSkip, JBIG2Bitmap skipBitmap, int[] grayScaleImage, HalftoneRegionFlags halftoneRegionFlags) {
        int combinationOperator = halftoneRegionFlags.getFlagValue("H_COMB_OP");
        int i2 = 0;
        for (int col = 0; col < segData.gridHeight; ++col) {
            int xx = segData.gridX + col * segData.stepY;
            int yy = segData.gridY + col * segData.stepX;
            for (int row = 0; row < segData.gridWidth; ++row) {
                if (!enableSkip || skipBitmap.getPixel(col, row) != 1) {
                    JBIG2Bitmap patternBitmap = patternDictionarySegment.getBitmaps()[grayScaleImage[i2]];
                    bitmap.combine(patternBitmap, xx >> 8, yy >> 8, combinationOperator);
                }
                xx += segData.stepX;
                yy -= segData.stepY;
                ++i2;
            }
        }
    }

    private JBIG2Bitmap handleGray(SegmentData segData, int bitsPerValue, boolean useMMR, int template, boolean enableSkip, JBIG2Bitmap skipBitmap, int[] grayScaleImage, short[] genericBAdaptiveTemplateX, short[] genericBAdaptiveTemplateY) {
        JBIG2Bitmap grayBitmap = null;
        for (int j2 = bitsPerValue - 1; j2 >= 0; --j2) {
            grayBitmap = new JBIG2Bitmap(segData.gridWidth, segData.gridHeight, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder, this.decoder);
            if (useMMR) {
                grayBitmap.readBitmapWithMMR(-1);
            } else {
                grayBitmap.readBitmap(template, false, enableSkip, skipBitmap, genericBAdaptiveTemplateX, genericBAdaptiveTemplateY);
            }
            int i2 = 0;
            for (int row = 0; row < segData.gridHeight; ++row) {
                for (int col = 0; col < segData.gridWidth; ++col) {
                    int bit = grayBitmap.getPixel(col, row) ^ grayScaleImage[i2] & 1;
                    grayScaleImage[i2] = grayScaleImage[i2] << 1 | bit;
                    ++i2;
                }
            }
            grayBitmap.getDataWriter().clearResources();
        }
        return grayBitmap;
    }

    private static int getBitsPerValue(PatternDictionarySegment patternDictionarySegment) {
        int bitsPerValue = 0;
        for (int i2 = 1; i2 < patternDictionarySegment.getSize(); i2 <<= 1) {
            ++bitsPerValue;
        }
        return bitsPerValue;
    }

    private JBIG2Bitmap getJbig2Bitmap(SegmentData segData, int patternWidth, int patternHeight) {
        JBIG2Bitmap skipBitmap = new JBIG2Bitmap(segData.gridWidth, segData.gridHeight, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder, this.decoder);
        skipBitmap.clear(0);
        for (int y2 = 0; y2 < segData.gridHeight; ++y2) {
            for (int x2 = 0; x2 < segData.gridWidth; ++x2) {
                int xx = segData.gridX + y2 * segData.stepY + x2 * segData.stepX;
                int yy = segData.gridY + y2 * segData.stepX - x2 * segData.stepY;
                if (xx + patternWidth >> 8 > 0 && xx >> 8 < this.regionBitmapWidth && yy + patternHeight >> 8 > 0 && yy >> 8 < this.regionBitmapHeight) continue;
                skipBitmap.setPixel(y2, x2, 1);
            }
        }
        skipBitmap.getDataWriter().clearResources();
        return skipBitmap;
    }

    private void returnInlinedImage(JBIG2Bitmap bitmap) {
        PageInformationSegment pageSegment = this.decoder.findPageSegment(this.segmentHeader.getPageAssociation());
        JBIG2Bitmap pageBitmap = pageSegment.getPageBitmap();
        int externalCombinationOperator = this.regionFlags.getFlagValue("EXTERNAL_COMBINATION_OPERATOR");
        pageBitmap.combine(bitmap, this.regionBitmapXLocation, this.regionBitmapYLocation, externalCombinationOperator);
        bitmap.getDataWriter().clearResources();
    }

    private void readHalftoneRegionFlags() {
        short halftoneRegionFlagsField = this.decoder.readByte();
        this.halftoneRegionFlags.setFlags(halftoneRegionFlagsField);
    }

    @Override
    public JBIG2Bitmap[] getBitmaps() {
        return null;
    }

    class SegmentData {
        final int gridWidth;
        final int gridHeight;
        final int gridX;
        final int gridY;
        final int stepX;
        final int stepY;

        SegmentData(JBIG2StreamDecoder decoder) {
            short[] buf = new short[4];
            decoder.readByte(buf);
            this.gridWidth = BinaryOperation.getInt32(buf);
            buf = new short[4];
            decoder.readByte(buf);
            this.gridHeight = BinaryOperation.getInt32(buf);
            buf = new short[4];
            decoder.readByte(buf);
            this.gridX = BinaryOperation.getInt32(buf);
            buf = new short[4];
            decoder.readByte(buf);
            this.gridY = BinaryOperation.getInt32(buf);
            buf = new short[2];
            decoder.readByte(buf);
            this.stepX = BinaryOperation.getInt16(buf);
            buf = new short[2];
            decoder.readByte(buf);
            this.stepY = BinaryOperation.getInt16(buf);
        }
    }
}

