/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.segment.region.generic;

import java.io.IOException;
import org.jpedal.jbig2.JBIG2Exception;
import org.jpedal.jbig2.decoders.JBIG2StreamDecoder;
import org.jpedal.jbig2.image.JBIG2Bitmap;
import org.jpedal.jbig2.segment.pageinformation.PageInformationSegment;
import org.jpedal.jbig2.segment.region.RegionSegment;
import org.jpedal.jbig2.segment.region.generic.GenericRegionFlags;

public class GenericRegionSegment
extends RegionSegment {
    private final GenericRegionFlags genericRegionFlags = new GenericRegionFlags();
    private final boolean inlineImage;
    private boolean unknownLength;

    public GenericRegionSegment(JBIG2StreamDecoder streamDecoder, boolean inlineImage) {
        super(streamDecoder);
        this.inlineImage = inlineImage;
    }

    @Override
    public void readSegment() throws IOException, JBIG2Exception {
        super.readSegment();
        if (Math.abs(this.regionBitmapWidth) > 65535 || Math.abs(this.regionBitmapHeight) > 65535) {
            this.hasError = true;
            return;
        }
        this.readGenericRegionFlags();
        boolean useMMR = this.genericRegionFlags.getFlagValue("MMR") != 0;
        int template = this.genericRegionFlags.getFlagValue("GB_TEMPLATE");
        short[] genericBAdaptiveTemplateX = new short[4];
        short[] genericBAdaptiveTemplateY = new short[4];
        if (!useMMR) {
            if (template == 0) {
                genericBAdaptiveTemplateX[0] = this.readATValue();
                genericBAdaptiveTemplateY[0] = this.readATValue();
                genericBAdaptiveTemplateX[1] = this.readATValue();
                genericBAdaptiveTemplateY[1] = this.readATValue();
                genericBAdaptiveTemplateX[2] = this.readATValue();
                genericBAdaptiveTemplateY[2] = this.readATValue();
                genericBAdaptiveTemplateX[3] = this.readATValue();
                genericBAdaptiveTemplateY[3] = this.readATValue();
            } else {
                genericBAdaptiveTemplateX[0] = this.readATValue();
                genericBAdaptiveTemplateY[0] = this.readATValue();
            }
            this.arithmeticDecoder.resetGenericStats(template, null);
            this.arithmeticDecoder.start();
        }
        boolean typicalPredictionGenericDecodingOn = this.genericRegionFlags.getFlagValue("TPGDON") != 0;
        int length = this.segmentHeader.getSegmentDataLength();
        if (length == -1) {
            short match2;
            short match1;
            this.unknownLength = true;
            if (useMMR) {
                match1 = 0;
                match2 = 0;
            } else {
                match1 = 255;
                match2 = 172;
            }
            int bytesRead = 0;
            while (true) {
                short bite1 = this.decoder.readByte();
                ++bytesRead;
                if (bite1 != match1) continue;
                short bite2 = this.decoder.readByte();
                ++bytesRead;
                if (bite2 == match2) break;
            }
            this.decoder.movePointer(-bytesRead);
        }
        JBIG2Bitmap bitmap = new JBIG2Bitmap(this.regionBitmapWidth, this.regionBitmapHeight, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder, this.decoder);
        bitmap.clear(0);
        if (useMMR) {
            bitmap.readBitmapWithMMR(0);
        } else {
            bitmap.readBitmap(template, typicalPredictionGenericDecodingOn, false, null, genericBAdaptiveTemplateX, genericBAdaptiveTemplateY);
        }
        if (this.inlineImage) {
            PageInformationSegment pageSegment = this.decoder.findPageSegment(this.segmentHeader.getPageAssociation());
            JBIG2Bitmap pageBitmap = pageSegment.getPageBitmap();
            int extCombOp = this.regionFlags.getFlagValue("EXTERNAL_COMBINATION_OPERATOR");
            if (pageSegment.getPageBitmapHeight() == -1 && this.regionBitmapYLocation + this.regionBitmapHeight > pageBitmap.getHeight()) {
                pageBitmap.expand(this.regionBitmapYLocation + this.regionBitmapHeight);
            }
            pageBitmap.combine(bitmap, this.regionBitmapXLocation, this.regionBitmapYLocation, extCombOp);
            bitmap.getDataWriter().clearResources();
        } else {
            bitmap.setBitmapNumber(this.getSegmentHeader().getSegmentNumber());
            this.decoder.appendBitmap(bitmap);
        }
        if (this.unknownLength) {
            this.decoder.movePointer(4);
        }
    }

    private void readGenericRegionFlags() {
        short genericRegionFlagsField = this.decoder.readByte();
        this.genericRegionFlags.setFlags(genericRegionFlagsField);
    }

    @Override
    public JBIG2Bitmap[] getBitmaps() {
        return null;
    }
}

