/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.io;

import com.idrsolutions.image.filter.Filter;
import com.idrsolutions.image.filter.JBIG2FilterOptions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import org.jpedal.jbig2.JBIG2Data;
import org.jpedal.jbig2.JBIG2Decoder;

public final class JBIG2
extends Filter {
    public JBIG2(JBIG2FilterOptions options) {
        super(options);
    }

    @Override
    public byte[] decode(byte[] data) throws Exception {
        return JBIG2.JBIGDecode(data, null);
    }

    @Override
    public void decode(BufferedInputStream bis, BufferedOutputStream streamCache, String cacheName, Map<String, String> cachedObjects) throws Exception {
        byte[] data = new byte[bis.available()];
        bis.read(data);
        JBIG2.JBIGDecodeToStream(new JBIG2Data(data), null, streamCache);
    }

    @Override
    public byte[] encode(byte[] data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void encode(BufferedInputStream bis, BufferedOutputStream bos) throws Exception {
        throw new UnsupportedOperationException();
    }

    public static byte[] JBIGDecode(byte[] data, byte[] globalData) throws Exception {
        JBIG2Data jBIG2Data = new JBIG2Data(data);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        JBIG2.JBIGDecodeToStream(jBIG2Data, globalData, bos);
        bos.flush();
        bos.close();
        return bos.toByteArray();
    }

    private static void JBIGDecodeToStream(JBIG2Data jBIG2Data, byte[] globalData, OutputStream outputStream) throws Exception {
        JBIG2Decoder decoder = new JBIG2Decoder();
        if (globalData != null && globalData.length > 0) {
            decoder.setGlobalData(globalData);
        }
        decoder.decodeJBIG2(jBIG2Data);
        decoder.getPageAsJBIG2Bitmap(0).putWriteSafeDataIntoStream(true, outputStream);
    }
}

