/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.image;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.jpedal.jbig2.JBIG2DataWriter;
import org.jpedal.jbig2.decoders.ArithmeticDecoder;
import org.jpedal.jbig2.decoders.DecodeIntResult;
import org.jpedal.jbig2.decoders.HuffmanDecoder;
import org.jpedal.jbig2.decoders.JBIG2StreamDecoder;
import org.jpedal.jbig2.decoders.MMRDecoder;
import org.jpedal.jbig2.image.BitmapPointer;
import org.jpedal.jbig2.segment.region.text.HuffManTables;

public final class JBIG2Bitmap {
    private int height;
    private final int width;
    private final int line;
    private int bitmapNumber;
    private final JBIG2DataWriter jBIG2DataWriter;
    private final ArithmeticDecoder arithmeticDecoder;
    private final HuffmanDecoder huffmanDecoder;
    private final MMRDecoder mmrDecoder;
    private final JBIG2StreamDecoder decoder;

    public JBIG2Bitmap(int width, int height, ArithmeticDecoder arithmeticDecoder, HuffmanDecoder huffmanDecoder, MMRDecoder mmrDecoder, JBIG2StreamDecoder decoder) {
        this.width = width;
        this.height = height;
        this.arithmeticDecoder = arithmeticDecoder;
        this.huffmanDecoder = huffmanDecoder;
        this.mmrDecoder = mmrDecoder;
        this.line = width + 7 >> 3;
        this.decoder = decoder;
        int bytesNeeded = this.line * (height + 1);
        this.jBIG2DataWriter = new JBIG2DataWriter(new byte[bytesNeeded]);
    }

    public void readBitmap(int template, boolean typicalPredictionGenericDecodingOn, boolean useSkip, JBIG2Bitmap skipBitmap, short[] adaptiveTemplateX, short[] adaptiveTemplateY) {
        int skipLine;
        JBIG2DataWriter skipBitMapDataWriter;
        BitmapPointer cxPtr0 = new BitmapPointer(this);
        BitmapPointer cxPtr1 = new BitmapPointer(this);
        BitmapPointer atPtr0 = new BitmapPointer(this);
        BitmapPointer atPtr1 = new BitmapPointer(this);
        BitmapPointer atPtr2 = new BitmapPointer(this);
        BitmapPointer atPtr3 = new BitmapPointer(this);
        long ltpCX = 0L;
        if (typicalPredictionGenericDecodingOn) {
            ltpCX = JBIG2Bitmap.getLtpCX(template);
        }
        boolean ltp = false;
        if (useSkip) {
            skipBitMapDataWriter = skipBitmap.jBIG2DataWriter;
            skipLine = skipBitmap.line;
        } else {
            skipBitMapDataWriter = null;
            skipLine = 0;
        }
        block6: for (int row = 0; row < this.height; ++row) {
            if (typicalPredictionGenericDecodingOn) {
                int bit = this.arithmeticDecoder.decodeBit(ltpCX, this.arithmeticDecoder.genericRegionStats);
                if (bit != 0) {
                    boolean bl2 = ltp = !ltp;
                }
                if (ltp) {
                    this.duplicateRow(row, row - 1);
                    continue;
                }
            }
            switch (template) {
                case 0: {
                    this.handleTemplate0(cxPtr0, row, cxPtr1, atPtr0, adaptiveTemplateX, adaptiveTemplateY, atPtr1, atPtr2, atPtr3, useSkip, skipLine, skipBitMapDataWriter);
                    continue block6;
                }
                case 1: {
                    this.handleTemplate1(cxPtr0, row, cxPtr1, atPtr0, adaptiveTemplateX, adaptiveTemplateY, useSkip, skipLine, skipBitMapDataWriter);
                    continue block6;
                }
                case 2: {
                    this.handleTemplate2(cxPtr0, row, cxPtr1, atPtr0, adaptiveTemplateX, adaptiveTemplateY, useSkip, skipLine, skipBitMapDataWriter);
                    continue block6;
                }
                case 3: {
                    this.handleTemplate3(cxPtr1, row, atPtr0, adaptiveTemplateX, adaptiveTemplateY, useSkip, skipLine, skipBitMapDataWriter);
                }
            }
        }
    }

    private void handleTemplate3(BitmapPointer cxPtr1, int row, BitmapPointer atPtr0, short[] adaptiveTemplateX, short[] adaptiveTemplateY, boolean useSkip, int skipLine, JBIG2DataWriter skipBitMapDataWriter) {
        cxPtr1.setPointer(0, row - 1);
        long cx1 = cxPtr1.nextPixel();
        cx1 = cx1 << 1 & 0xFFFFFFFFL | (long)cxPtr1.nextPixel();
        long cx2 = 0L;
        atPtr0.setPointer(adaptiveTemplateX[0], row + adaptiveTemplateY[0]);
        for (int col = 0; col < this.width; ++col) {
            int pixel;
            long cx = cx1 << 5 & 0xFFFFFFFFL | cx2 << 1 & 0xFFFFFFFFL | (long)atPtr0.nextPixel();
            if (useSkip && JBIG2Bitmap.getPixel(col, row, skipLine, skipBitMapDataWriter) != 0) {
                pixel = 0;
            } else {
                pixel = this.arithmeticDecoder.decodeBit(cx, this.arithmeticDecoder.genericRegionStats);
                if (pixel != 0) {
                    this.setPixel(col, row, 1);
                }
            }
            cx1 = (cx1 << 1 & 0xFFFFFFFFL | (long)cxPtr1.nextPixel()) & 0x1FL;
            cx2 = (cx2 << 1 & 0xFFFFFFFFL | (long)pixel) & 0xFL;
        }
    }

    private void handleTemplate2(BitmapPointer cxPtr0, int row, BitmapPointer cxPtr1, BitmapPointer atPtr0, short[] adaptiveTemplateX, short[] adaptiveTemplateY, boolean useSkip, int skipLine, JBIG2DataWriter skipBitMapDataWriter) {
        cxPtr0.setPointer(0, row - 2);
        long cx0 = cxPtr0.nextPixel();
        cx0 = cx0 << 1 & 0xFFFFFFFFL | (long)cxPtr0.nextPixel();
        cxPtr1.setPointer(0, row - 1);
        long cx1 = cxPtr1.nextPixel();
        cx1 = cx1 << 1 & 0xFFFFFFFFL | (long)cxPtr1.nextPixel();
        long cx2 = 0L;
        atPtr0.setPointer(adaptiveTemplateX[0], row + adaptiveTemplateY[0]);
        for (int col = 0; col < this.width; ++col) {
            int pixel;
            long cx = cx0 << 7 & 0xFFFFFFFFL | cx1 << 3 & 0xFFFFFFFFL | cx2 << 1 & 0xFFFFFFFFL | (long)atPtr0.nextPixel();
            if (useSkip && JBIG2Bitmap.getPixel(col, row, skipLine, skipBitMapDataWriter) != 0) {
                pixel = 0;
            } else {
                pixel = this.arithmeticDecoder.decodeBit(cx, this.arithmeticDecoder.genericRegionStats);
                if (pixel != 0) {
                    this.setPixel(col, row, 1);
                }
            }
            cx0 = (cx0 << 1 & 0xFFFFFFFFL | (long)cxPtr0.nextPixel()) & 7L;
            cx1 = (cx1 << 1 & 0xFFFFFFFFL | (long)cxPtr1.nextPixel()) & 0xFL;
            cx2 = (cx2 << 1 & 0xFFFFFFFFL | (long)pixel) & 3L;
        }
    }

    private void handleTemplate1(BitmapPointer cxPtr0, int row, BitmapPointer cxPtr1, BitmapPointer atPtr0, short[] adaptiveTemplateX, short[] adaptiveTemplateY, boolean useSkip, int skipLine, JBIG2DataWriter skipBitMapDataWriter) {
        cxPtr0.setPointer(0, row - 2);
        long cx0 = cxPtr0.nextPixel();
        cx0 = cx0 << 1 & 0xFFFFFFFFL | (long)cxPtr0.nextPixel();
        cx0 = cx0 << 1 & 0xFFFFFFFFL | (long)cxPtr0.nextPixel();
        cxPtr1.setPointer(0, row - 1);
        long cx1 = cxPtr1.nextPixel();
        cx1 = cx1 << 1 & 0xFFFFFFFFL | (long)cxPtr1.nextPixel();
        cx1 = cx1 << 1 & 0xFFFFFFFFL | (long)cxPtr1.nextPixel();
        long cx2 = 0L;
        atPtr0.setPointer(adaptiveTemplateX[0], row + adaptiveTemplateY[0]);
        for (int col = 0; col < this.width; ++col) {
            int pixel;
            long cx = cx0 << 9 & 0xFFFFFFFFL | cx1 << 4 & 0xFFFFFFFFL | cx2 << 1 & 0xFFFFFFFFL | (long)atPtr0.nextPixel();
            if (useSkip && JBIG2Bitmap.getPixel(col, row, skipLine, skipBitMapDataWriter) != 0) {
                pixel = 0;
            } else {
                pixel = this.arithmeticDecoder.decodeBit(cx, this.arithmeticDecoder.genericRegionStats);
                if (pixel != 0) {
                    this.setPixel(col, row, 1);
                }
            }
            cx0 = (cx0 << 1 & 0xFFFFFFFFL | (long)cxPtr0.nextPixel()) & 0xFL;
            cx1 = (cx1 << 1 & 0xFFFFFFFFL | (long)cxPtr1.nextPixel()) & 0x1FL;
            cx2 = (cx2 << 1 & 0xFFFFFFFFL | (long)pixel) & 7L;
        }
    }

    private void handleTemplate0(BitmapPointer cxPtr0, int row, BitmapPointer cxPtr1, BitmapPointer atPtr0, short[] adaptiveTemplateX, short[] adaptiveTemplateY, BitmapPointer atPtr1, BitmapPointer atPtr2, BitmapPointer atPtr3, boolean useSkip, int skipLine, JBIG2DataWriter skipBitMapDataWriter) {
        cxPtr0.setPointer(0, row - 2);
        long cx0 = cxPtr0.nextPixel();
        cx0 = cx0 << 1 & 0xFFFFFFFFL | (long)cxPtr0.nextPixel();
        cxPtr1.setPointer(0, row - 1);
        long cx1 = cxPtr1.nextPixel();
        cx1 = cx1 << 1 & 0xFFFFFFFFL | (long)cxPtr1.nextPixel();
        cx1 = cx1 << 1 & 0xFFFFFFFFL | (long)cxPtr1.nextPixel();
        long cx2 = 0L;
        atPtr0.setPointer(adaptiveTemplateX[0], row + adaptiveTemplateY[0]);
        atPtr1.setPointer(adaptiveTemplateX[1], row + adaptiveTemplateY[1]);
        atPtr2.setPointer(adaptiveTemplateX[2], row + adaptiveTemplateY[2]);
        atPtr3.setPointer(adaptiveTemplateX[3], row + adaptiveTemplateY[3]);
        for (int col = 0; col < this.width; ++col) {
            int pixel;
            long cx = cx0 << 13 & 0xFFFFFFFFL | cx1 << 8 & 0xFFFFFFFFL | cx2 << 4 & 0xFFFFFFFFL | (long)(atPtr0.nextPixel() << 3) | (long)(atPtr1.nextPixel() << 2) | (long)(atPtr2.nextPixel() << 1) | (long)atPtr3.nextPixel();
            if (useSkip && JBIG2Bitmap.getPixel(col, row, skipLine, skipBitMapDataWriter) != 0) {
                pixel = 0;
            } else {
                pixel = this.arithmeticDecoder.decodeBit(cx, this.arithmeticDecoder.genericRegionStats);
                if (pixel != 0) {
                    this.setPixel(col, row, 1);
                }
            }
            cx0 = (cx0 << 1 & 0xFFFFFFFFL | (long)cxPtr0.nextPixel()) & 7L;
            cx1 = (cx1 << 1 & 0xFFFFFFFFL | (long)cxPtr1.nextPixel()) & 0x1FL;
            cx2 = (cx2 << 1 & 0xFFFFFFFFL | (long)pixel) & 0xFL;
        }
    }

    private static long getLtpCX(int template) {
        switch (template) {
            case 0: {
                return 14675L;
            }
            case 1: {
                return 1946L;
            }
            case 2: {
                return 227L;
            }
            case 3: {
                return 394L;
            }
        }
        return 0L;
    }

    public void readBitmapWithMMR(int mmrDataLength) {
        this.mmrDecoder.reset();
        int[] referenceLine = new int[this.width + 2];
        int[] codingLine = new int[this.width + 2];
        codingLine[0] = this.width;
        codingLine[1] = this.width;
        for (int row = 0; row < this.height; ++row) {
            int i2 = 0;
            while (codingLine[i2] < this.width) {
                referenceLine[i2] = codingLine[i2];
                ++i2;
            }
            referenceLine[i2] = this.width;
            referenceLine[i2 + 1] = this.width;
            int referenceI = 0;
            int codingI = 0;
            int a02 = 0;
            block13: do {
                int code1 = this.mmrDecoder.get2DCode();
                switch (code1) {
                    case 0: {
                        if (referenceLine[referenceI] >= this.width) break;
                        a02 = referenceLine[referenceI + 1];
                        referenceI += 2;
                        break;
                    }
                    case 1: {
                        int code2;
                        int code3;
                        if (codingI & true) {
                            code1 = 0;
                            do {
                                code3 = this.mmrDecoder.getBlackCode();
                                code1 += code3;
                            } while (code3 >= 64);
                            code2 = 0;
                            do {
                                code3 = this.mmrDecoder.getWhiteCode();
                                code2 += code3;
                            } while (code3 >= 64);
                        } else {
                            code1 = 0;
                            do {
                                code3 = this.mmrDecoder.getWhiteCode();
                                code1 += code3;
                            } while (code3 >= 64);
                            code2 = 0;
                            do {
                                code3 = this.mmrDecoder.getBlackCode();
                                code2 += code3;
                            } while (code3 >= 64);
                        }
                        if (code1 <= 0 && code2 <= 0) continue block13;
                        codingLine[codingI] = a02 += code1;
                        codingLine[++codingI] = a02 += code2;
                        ++codingI;
                        while (referenceLine[referenceI] <= a02 && referenceLine[referenceI] < this.width) {
                            referenceI += 2;
                        }
                        continue block13;
                    }
                    case 2: {
                        codingLine[codingI] = a02 = referenceLine[referenceI];
                        ++codingI;
                        if (referenceLine[referenceI] >= this.width) break;
                        ++referenceI;
                        break;
                    }
                    case 3: {
                        codingLine[codingI] = a02 = referenceLine[referenceI] + 1;
                        ++codingI;
                        if (referenceLine[referenceI] >= this.width) break;
                        ++referenceI;
                        while (referenceLine[referenceI] <= a02 && referenceLine[referenceI] < this.width) {
                            referenceI += 2;
                        }
                        continue block13;
                    }
                    case 5: {
                        codingLine[codingI] = a02 = referenceLine[referenceI] + 2;
                        ++codingI;
                        if (referenceLine[referenceI] >= this.width) break;
                        ++referenceI;
                        while (referenceLine[referenceI] <= a02 && referenceLine[referenceI] < this.width) {
                            referenceI += 2;
                        }
                        continue block13;
                    }
                    case 7: {
                        codingLine[codingI] = a02 = referenceLine[referenceI] + 3;
                        ++codingI;
                        if (referenceLine[referenceI] >= this.width) break;
                        ++referenceI;
                        while (referenceLine[referenceI] <= a02 && referenceLine[referenceI] < this.width) {
                            referenceI += 2;
                        }
                        continue block13;
                    }
                    case 4: {
                        codingLine[codingI] = a02 = referenceLine[referenceI] - 1;
                        ++codingI;
                        referenceI = referenceI > 0 ? --referenceI : ++referenceI;
                        while (referenceLine[referenceI] <= a02 && referenceLine[referenceI] < this.width) {
                            referenceI += 2;
                        }
                        continue block13;
                    }
                    case 6: {
                        codingLine[codingI] = a02 = referenceLine[referenceI] - 2;
                        ++codingI;
                        referenceI = referenceI > 0 ? --referenceI : ++referenceI;
                        while (referenceLine[referenceI] <= a02 && referenceLine[referenceI] < this.width) {
                            referenceI += 2;
                        }
                        continue block13;
                    }
                    case 8: {
                        codingLine[codingI] = a02 = referenceLine[referenceI] - 3;
                        ++codingI;
                        referenceI = referenceI > 0 ? --referenceI : ++referenceI;
                        while (referenceLine[referenceI] <= a02 && referenceLine[referenceI] < this.width) {
                            referenceI += 2;
                        }
                        break block0;
                    }
                }
            } while (a02 < this.width);
            codingLine[codingI] = this.width;
            int j2 = 0;
            while (codingLine[j2] < this.width) {
                for (int col = codingLine[j2]; col < codingLine[j2 + 1]; ++col) {
                    this.setPixel(col, row, 1);
                }
                j2 += 2;
            }
        }
        if (mmrDataLength >= 0) {
            this.mmrDecoder.skipTo(mmrDataLength);
        } else if (this.mmrDecoder.get24Bits() != 4097L) {
            // empty if block
        }
    }

    public void readGenericRefinementRegion(int template, boolean typicalPredictionGenericRefinementOn, JBIG2Bitmap referredToBitmap, int referenceDX, int referenceDY, short[] adaptiveTemplateX, short[] adaptiveTemplateY) {
        BitmapPointer cxPtr6;
        BitmapPointer cxPtr5;
        BitmapPointer cxPtr4;
        BitmapPointer cxPtr3;
        BitmapPointer cxPtr2;
        BitmapPointer cxPtr1;
        BitmapPointer cxPtr0;
        long ltpCX;
        if (template != 0) {
            ltpCX = 8L;
            cxPtr0 = new BitmapPointer(this);
            cxPtr1 = new BitmapPointer(this);
            cxPtr2 = new BitmapPointer(referredToBitmap);
            cxPtr3 = new BitmapPointer(referredToBitmap);
            cxPtr4 = new BitmapPointer(referredToBitmap);
            cxPtr5 = new BitmapPointer(this);
            cxPtr6 = new BitmapPointer(this);
        } else {
            ltpCX = 16L;
            cxPtr0 = new BitmapPointer(this);
            cxPtr1 = new BitmapPointer(this);
            cxPtr2 = new BitmapPointer(referredToBitmap);
            cxPtr3 = new BitmapPointer(referredToBitmap);
            cxPtr4 = new BitmapPointer(referredToBitmap);
            cxPtr5 = new BitmapPointer(this);
            cxPtr6 = new BitmapPointer(referredToBitmap);
        }
        BitmapPointer typicalPredictionGenericRefinementCXPtr0 = new BitmapPointer(referredToBitmap);
        BitmapPointer typicalPredictionGenericRefinementCXPtr1 = new BitmapPointer(referredToBitmap);
        BitmapPointer typicalPredictionGenericRefinementCXPtr2 = new BitmapPointer(referredToBitmap);
        boolean ltp = false;
        for (int row = 0; row < this.height; ++row) {
            long cx;
            int pixel;
            int decodeBit;
            int col;
            long typicalPredictionGenericRefinementCX2;
            long typicalPredictionGenericRefinementCX1;
            long typicalPredictionGenericRefinementCX0;
            long cx4;
            long cx3;
            long cx0;
            if (template != 0) {
                cxPtr0.setPointer(0, row - 1);
                cx0 = cxPtr0.nextPixel();
                cxPtr1.setPointer(-1, row);
                cxPtr2.setPointer(-referenceDX, row - 1 - referenceDY);
                cxPtr3.setPointer(-1 - referenceDX, row - referenceDY);
                cx3 = cxPtr3.nextPixel();
                cx3 = cx3 << 1 & 0xFFFFFFFFL | (long)cxPtr3.nextPixel();
                cxPtr4.setPointer(-referenceDX, row + 1 - referenceDY);
                cx4 = cxPtr4.nextPixel();
                typicalPredictionGenericRefinementCX0 = 0L;
                typicalPredictionGenericRefinementCX1 = 0L;
                typicalPredictionGenericRefinementCX2 = 0L;
                if (typicalPredictionGenericRefinementOn) {
                    typicalPredictionGenericRefinementCXPtr0.setPointer(-1 - referenceDX, row - 1 - referenceDY);
                    typicalPredictionGenericRefinementCX0 = typicalPredictionGenericRefinementCXPtr0.nextPixel();
                    typicalPredictionGenericRefinementCX0 = typicalPredictionGenericRefinementCX0 << 1 & 0xFFFFFFFFL | (long)typicalPredictionGenericRefinementCXPtr0.nextPixel();
                    typicalPredictionGenericRefinementCX0 = typicalPredictionGenericRefinementCX0 << 1 & 0xFFFFFFFFL | (long)typicalPredictionGenericRefinementCXPtr0.nextPixel();
                    typicalPredictionGenericRefinementCXPtr1.setPointer(-1 - referenceDX, row - referenceDY);
                    typicalPredictionGenericRefinementCX1 = typicalPredictionGenericRefinementCXPtr1.nextPixel();
                    typicalPredictionGenericRefinementCX1 = typicalPredictionGenericRefinementCX1 << 1 & 0xFFFFFFFFL | (long)typicalPredictionGenericRefinementCXPtr1.nextPixel();
                    typicalPredictionGenericRefinementCX1 = typicalPredictionGenericRefinementCX1 << 1 & 0xFFFFFFFFL | (long)typicalPredictionGenericRefinementCXPtr1.nextPixel();
                    typicalPredictionGenericRefinementCXPtr2.setPointer(-1 - referenceDX, row + 1 - referenceDY);
                    typicalPredictionGenericRefinementCX2 = typicalPredictionGenericRefinementCXPtr2.nextPixel();
                    typicalPredictionGenericRefinementCX2 = typicalPredictionGenericRefinementCX2 << 1 & 0xFFFFFFFFL | (long)typicalPredictionGenericRefinementCXPtr2.nextPixel();
                    typicalPredictionGenericRefinementCX2 = typicalPredictionGenericRefinementCX2 << 1 & 0xFFFFFFFFL | (long)typicalPredictionGenericRefinementCXPtr2.nextPixel();
                }
                for (col = 0; col < this.width; ++col) {
                    cx0 = (cx0 << 1 & 0xFFFFFFFFL | (long)cxPtr0.nextPixel()) & 7L;
                    cx3 = (cx3 << 1 & 0xFFFFFFFFL | (long)cxPtr3.nextPixel()) & 7L;
                    cx4 = (cx4 << 1 & 0xFFFFFFFFL | (long)cxPtr4.nextPixel()) & 3L;
                    if (typicalPredictionGenericRefinementOn) {
                        typicalPredictionGenericRefinementCX0 = (typicalPredictionGenericRefinementCX0 << 1 & 0xFFFFFFFFL | (long)typicalPredictionGenericRefinementCXPtr0.nextPixel()) & 7L;
                        typicalPredictionGenericRefinementCX1 = (typicalPredictionGenericRefinementCX1 << 1 & 0xFFFFFFFFL | (long)typicalPredictionGenericRefinementCXPtr1.nextPixel()) & 7L;
                        typicalPredictionGenericRefinementCX2 = (typicalPredictionGenericRefinementCX2 << 1 & 0xFFFFFFFFL | (long)typicalPredictionGenericRefinementCXPtr2.nextPixel()) & 7L;
                        decodeBit = this.arithmeticDecoder.decodeBit(ltpCX, this.arithmeticDecoder.refinementRegionStats);
                        if (decodeBit != 0) {
                            boolean bl2 = ltp = !ltp;
                        }
                        if (typicalPredictionGenericRefinementCX0 == 0L && typicalPredictionGenericRefinementCX1 == 0L && typicalPredictionGenericRefinementCX2 == 0L) {
                            this.setPixel(col, row, 0);
                            continue;
                        }
                        if (typicalPredictionGenericRefinementCX0 == 7L && typicalPredictionGenericRefinementCX1 == 7L && typicalPredictionGenericRefinementCX2 == 7L) {
                            this.setPixel(col, row, 1);
                            continue;
                        }
                    }
                    if ((pixel = this.arithmeticDecoder.decodeBit(cx = cx0 << 7 & 0xFFFFFFFFL | (long)(cxPtr1.nextPixel() << 6) | (long)(cxPtr2.nextPixel() << 5) | cx3 << 2 & 0xFFFFFFFFL | cx4, this.arithmeticDecoder.refinementRegionStats)) != 1) continue;
                    this.setPixel(col, row, 1);
                }
                continue;
            }
            cxPtr0.setPointer(0, row - 1);
            cx0 = cxPtr0.nextPixel();
            cxPtr1.setPointer(-1, row);
            cxPtr2.setPointer(-referenceDX, row - 1 - referenceDY);
            long cx2 = cxPtr2.nextPixel();
            cxPtr3.setPointer(-1 - referenceDX, row - referenceDY);
            cx3 = cxPtr3.nextPixel();
            cx3 = cx3 << 1 & 0xFFFFFFFFL | (long)cxPtr3.nextPixel();
            cxPtr4.setPointer(-1 - referenceDX, row + 1 - referenceDY);
            cx4 = cxPtr4.nextPixel();
            cx4 = cx4 << 1 & 0xFFFFFFFFL | (long)cxPtr4.nextPixel();
            cxPtr5.setPointer(adaptiveTemplateX[0], row + adaptiveTemplateY[0]);
            cxPtr6.setPointer(adaptiveTemplateX[1] - referenceDX, row + adaptiveTemplateY[1] - referenceDY);
            typicalPredictionGenericRefinementCX0 = 0L;
            typicalPredictionGenericRefinementCX1 = 0L;
            typicalPredictionGenericRefinementCX2 = 0L;
            if (typicalPredictionGenericRefinementOn) {
                typicalPredictionGenericRefinementCXPtr0.setPointer(-1 - referenceDX, row - 1 - referenceDY);
                typicalPredictionGenericRefinementCX0 = typicalPredictionGenericRefinementCXPtr0.nextPixel();
                typicalPredictionGenericRefinementCX0 = typicalPredictionGenericRefinementCX0 << 1 & 0xFFFFFFFFL | (long)typicalPredictionGenericRefinementCXPtr0.nextPixel();
                typicalPredictionGenericRefinementCX0 = typicalPredictionGenericRefinementCX0 << 1 & 0xFFFFFFFFL | (long)typicalPredictionGenericRefinementCXPtr0.nextPixel();
                typicalPredictionGenericRefinementCXPtr1.setPointer(-1 - referenceDX, row - referenceDY);
                typicalPredictionGenericRefinementCX1 = typicalPredictionGenericRefinementCXPtr1.nextPixel();
                typicalPredictionGenericRefinementCX1 = typicalPredictionGenericRefinementCX1 << 1 & 0xFFFFFFFFL | (long)typicalPredictionGenericRefinementCXPtr1.nextPixel();
                typicalPredictionGenericRefinementCX1 = typicalPredictionGenericRefinementCX1 << 1 & 0xFFFFFFFFL | (long)typicalPredictionGenericRefinementCXPtr1.nextPixel();
                typicalPredictionGenericRefinementCXPtr2.setPointer(-1 - referenceDX, row + 1 - referenceDY);
                typicalPredictionGenericRefinementCX2 = typicalPredictionGenericRefinementCXPtr2.nextPixel();
                typicalPredictionGenericRefinementCX2 = typicalPredictionGenericRefinementCX2 << 1 & 0xFFFFFFFFL | (long)typicalPredictionGenericRefinementCXPtr2.nextPixel();
                typicalPredictionGenericRefinementCX2 = typicalPredictionGenericRefinementCX2 << 1 & 0xFFFFFFFFL | (long)typicalPredictionGenericRefinementCXPtr2.nextPixel();
            }
            for (col = 0; col < this.width; ++col) {
                cx0 = (cx0 << 1 & 0xFFFFFFFFL | (long)cxPtr0.nextPixel()) & 3L;
                cx2 = (cx2 << 1 & 0xFFFFFFFFL | (long)cxPtr2.nextPixel()) & 3L;
                cx3 = (cx3 << 1 & 0xFFFFFFFFL | (long)cxPtr3.nextPixel()) & 7L;
                cx4 = (cx4 << 1 & 0xFFFFFFFFL | (long)cxPtr4.nextPixel()) & 7L;
                if (typicalPredictionGenericRefinementOn) {
                    typicalPredictionGenericRefinementCX0 = (typicalPredictionGenericRefinementCX0 << 1 & 0xFFFFFFFFL | (long)typicalPredictionGenericRefinementCXPtr0.nextPixel()) & 7L;
                    typicalPredictionGenericRefinementCX1 = (typicalPredictionGenericRefinementCX1 << 1 & 0xFFFFFFFFL | (long)typicalPredictionGenericRefinementCXPtr1.nextPixel()) & 7L;
                    typicalPredictionGenericRefinementCX2 = (typicalPredictionGenericRefinementCX2 << 1 & 0xFFFFFFFFL | (long)typicalPredictionGenericRefinementCXPtr2.nextPixel()) & 7L;
                    decodeBit = this.arithmeticDecoder.decodeBit(ltpCX, this.arithmeticDecoder.refinementRegionStats);
                    if (decodeBit == 1) {
                        boolean bl3 = ltp = !ltp;
                    }
                    if (typicalPredictionGenericRefinementCX0 == 0L && typicalPredictionGenericRefinementCX1 == 0L && typicalPredictionGenericRefinementCX2 == 0L) {
                        this.setPixel(col, row, 0);
                        continue;
                    }
                    if (typicalPredictionGenericRefinementCX0 == 7L && typicalPredictionGenericRefinementCX1 == 7L && typicalPredictionGenericRefinementCX2 == 7L) {
                        this.setPixel(col, row, 1);
                        continue;
                    }
                }
                if ((pixel = this.arithmeticDecoder.decodeBit(cx = cx0 << 11 & 0xFFFFFFFFL | (long)(cxPtr1.nextPixel() << 10) | cx2 << 8 & 0xFFFFFFFFL | cx3 << 5 & 0xFFFFFFFFL | cx4 << 2 & 0xFFFFFFFFL | (long)(cxPtr5.nextPixel() << 1) | (long)cxPtr6.nextPixel(), this.arithmeticDecoder.refinementRegionStats)) != 1) continue;
                this.setPixel(col, row, 1);
            }
        }
    }

    public void readTextRegion(boolean huffman, boolean symbolRefine, int noOfSymbolInstances, int logStrips, int noOfSymbols, int[][] symbolCodeTable, int symbolCodeLength, JBIG2Bitmap[] symbols, int defaultPixel, int combinationOperator, boolean transposed, int referenceCorner, int sOffset, HuffManTables huffManTables, int template, short[] symbolRegionAdaptiveTemplateX, short[] symbolRegionAdaptiveTemplateY, JBIG2StreamDecoder decoder) {
        int[][] huffmanFSTable = huffManTables.huffmanFSTable;
        int[][] huffmanDSTable = huffManTables.huffmanDSTable;
        int[][] huffmanDTTable = huffManTables.huffmanDTTable;
        int[][] huffmanRDWTable = huffManTables.huffmanRDWTable;
        int[][] huffmanRDHTable = huffManTables.huffmanRDHTable;
        int[][] huffmanRDXTable = huffManTables.huffmanRDXTable;
        int[][] huffmanRDYTable = huffManTables.huffmanRDYTable;
        this.readTextRegion(huffman, symbolRefine, noOfSymbolInstances, logStrips, noOfSymbols, symbolCodeTable, symbolCodeLength, symbols, defaultPixel, combinationOperator, transposed, referenceCorner, sOffset, huffmanFSTable, huffmanDSTable, huffmanDTTable, huffmanRDWTable, huffmanRDHTable, huffmanRDXTable, huffmanRDYTable, template, symbolRegionAdaptiveTemplateX, symbolRegionAdaptiveTemplateY, decoder);
    }

    public void readTextRegion(boolean huffman, boolean symbolRefine, int noOfSymbolInstances, int logStrips, int noOfSymbols, int[][] symbolCodeTable, int symbolCodeLength, JBIG2Bitmap[] symbols, int defaultPixel, int combinationOperator, boolean transposed, int referenceCorner, int sOffset, int[][] huffmanFSTable, int[][] huffmanDSTable, int[][] huffmanDTTable, int[][] huffmanRDWTable, int[][] huffmanRDHTable, int[][] huffmanRDXTable, int[][] huffmanRDYTable, int template, short[] symbolRegionAdaptiveTemplateX, short[] symbolRegionAdaptiveTemplateY, JBIG2StreamDecoder decoder) {
        int strips = 1 << logStrips;
        this.clear(defaultPixel);
        int t2 = JBIG2Bitmap.getT(huffman, huffmanDTTable, strips, this.huffmanDecoder, this.arithmeticDecoder);
        int firstS = 0;
        block0: for (int currentInstance = 0; currentInstance < noOfSymbolInstances; ++currentInstance) {
            int dt = huffman ? this.huffmanDecoder.decodeInt(huffmanDTTable).intResult() : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iadtStats).intResult();
            t2 += dt * strips;
            int ds = huffman ? this.huffmanDecoder.decodeInt(huffmanFSTable).intResult() : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iafsStats).intResult();
            int s2 = firstS += ds;
            while (true) {
                JBIG2Bitmap symbolBitmap;
                dt = strips == 1 ? 0 : (huffman ? decoder.readBits(logStrips) : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iaitStats).intResult());
                int tt = t2 + dt;
                long symbolID = huffman ? (symbolCodeTable != null ? (long)this.huffmanDecoder.decodeInt(symbolCodeTable).intResult() : (long)decoder.readBits(symbolCodeLength)) : this.arithmeticDecoder.decodeIAID(symbolCodeLength, this.arithmeticDecoder.iaidStats);
                if (symbolID >= (long)noOfSymbols) continue block0;
                int ri = symbolRefine ? (huffman ? decoder.readBit() : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iariStats).intResult()) : 0;
                boolean newSymbolMap = false;
                if (ri != 0) {
                    symbolBitmap = this.getJbig2Bitmap(huffman, symbols[(int)symbolID], huffmanRDWTable, huffmanRDHTable, huffmanRDXTable, huffmanRDYTable, template, symbolRegionAdaptiveTemplateX, symbolRegionAdaptiveTemplateY, decoder);
                    newSymbolMap = true;
                } else {
                    symbolBitmap = symbols[(int)symbolID];
                }
                int bitmapWidth = symbolBitmap.width - 1;
                int bitmapHeight = symbolBitmap.height - 1;
                s2 = transposed ? this.transpose(combinationOperator, referenceCorner, symbolBitmap, tt, s2, bitmapWidth, bitmapHeight) : this.nonTransposed(combinationOperator, referenceCorner, symbolBitmap, tt, s2, bitmapWidth, bitmapHeight);
                if (!newSymbolMap) continue block0;
                symbolBitmap.jBIG2DataWriter.clearResources();
                DecodeIntResult decodeIntResult = huffman ? this.huffmanDecoder.decodeInt(huffmanDSTable) : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iadsStats);
                if (!decodeIntResult.booleanResult()) continue block0;
                ds = decodeIntResult.intResult();
                s2 += sOffset + ds;
            }
        }
    }

    private static int getT(boolean huffman, int[][] huffmanDTTable, int strips, HuffmanDecoder huffmanDecoder, ArithmeticDecoder arithmeticDecoder) {
        int t2 = huffman ? huffmanDecoder.decodeInt(huffmanDTTable).intResult() : arithmeticDecoder.decodeInt(arithmeticDecoder.iadtStats).intResult();
        return t2 *= -strips;
    }

    private int nonTransposed(int combinationOperator, int referenceCorner, JBIG2Bitmap symbolBitmap, int tt, int s2, int bitmapWidth, int bitmapHeight) {
        switch (referenceCorner) {
            case 0: 
            case 2: {
                this.combine(symbolBitmap, s2, tt - bitmapHeight, combinationOperator);
                break;
            }
            case 1: 
            case 3: {
                this.combine(symbolBitmap, s2, tt, combinationOperator);
            }
        }
        return s2 += bitmapWidth;
    }

    private int transpose(int combinationOperator, int referenceCorner, JBIG2Bitmap symbolBitmap, int tt, int s2, int bitmapWidth, int bitmapHeight) {
        switch (referenceCorner) {
            case 0: 
            case 1: {
                this.combine(symbolBitmap, tt, s2, combinationOperator);
                break;
            }
            case 2: 
            case 3: {
                this.combine(symbolBitmap, tt - bitmapWidth, s2, combinationOperator);
            }
        }
        return s2 += bitmapHeight;
    }

    private JBIG2Bitmap getJbig2Bitmap(boolean huffman, JBIG2Bitmap symbol, int[][] huffmanRDWTable, int[][] huffmanRDHTable, int[][] huffmanRDXTable, int[][] huffmanRDYTable, int template, short[] symbolRegionAdaptiveTemplateX, short[] symbolRegionAdaptiveTemplateY, JBIG2StreamDecoder decoder) {
        int refinementDeltaY;
        int refinementDeltaX;
        int refinementDeltaHeight;
        int refinementDeltaWidth;
        if (huffman) {
            refinementDeltaWidth = this.huffmanDecoder.decodeInt(huffmanRDWTable).intResult();
            refinementDeltaHeight = this.huffmanDecoder.decodeInt(huffmanRDHTable).intResult();
            refinementDeltaX = this.huffmanDecoder.decodeInt(huffmanRDXTable).intResult();
            refinementDeltaY = this.huffmanDecoder.decodeInt(huffmanRDYTable).intResult();
            decoder.consumeRemainingBits();
            this.arithmeticDecoder.start();
        } else {
            refinementDeltaWidth = this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iardwStats).intResult();
            refinementDeltaHeight = this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iardhStats).intResult();
            refinementDeltaX = this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iardxStats).intResult();
            refinementDeltaY = this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iardyStats).intResult();
        }
        refinementDeltaX = (refinementDeltaWidth >= 0 ? refinementDeltaWidth : refinementDeltaWidth - 1) / 2 + refinementDeltaX;
        refinementDeltaY = (refinementDeltaHeight >= 0 ? refinementDeltaHeight : refinementDeltaHeight - 1) / 2 + refinementDeltaY;
        JBIG2Bitmap symbolBitmap = new JBIG2Bitmap(refinementDeltaWidth + symbol.width, refinementDeltaHeight + symbol.height, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder, decoder);
        symbolBitmap.readGenericRefinementRegion(template, false, symbol, refinementDeltaX, refinementDeltaY, symbolRegionAdaptiveTemplateX, symbolRegionAdaptiveTemplateY);
        return symbolBitmap;
    }

    public void clear(int defPixel) {
        byte value = defPixel == 0 ? (byte)0 : -1;
        int divider = 1024;
        int fullLen = this.jBIG2DataWriter.getDataLength();
        int rounds = fullLen / 1024;
        int bal = fullLen % 1024;
        int offset = 0;
        for (int a10 = 0; a10 <= rounds; ++a10) {
            int dataLen = a10 == rounds ? bal : 1024;
            byte[] bytes = new byte[dataLen];
            if (value != 0) {
                Arrays.fill(bytes, value);
            }
            this.jBIG2DataWriter.putBytes(bytes, offset, dataLen);
            offset += 1024;
        }
    }

    public void combine(JBIG2Bitmap bitmap, int x2, int y2, long combOp) {
        int srcWidth = bitmap.width;
        int srcHeight = bitmap.height;
        int srcLine = bitmap.line;
        int srcRow = 0;
        int srcCol = 0;
        int comb = (int)combOp;
        JBIG2DataWriter srcDataWriter = bitmap.jBIG2DataWriter;
        if (x2 % 8 == 0) {
            int byteEnd = (x2 + srcWidth) / 8 * 8;
            for (int row = y2; row < y2 + srcHeight; ++row) {
                int srcRowLine = srcRow * srcLine;
                for (int col = x2 / 8; col < byteEnd / 8; ++col) {
                    int index = row * this.line + col;
                    if (index < this.jBIG2DataWriter.getDataLength() && index >= 0) {
                        switch (comb) {
                            case 0: {
                                this.jBIG2DataWriter.setItemAt(index, (byte)(this.jBIG2DataWriter.getItemAt(index) | srcDataWriter.getItemAt(srcRowLine + srcCol)));
                                break;
                            }
                            case 1: {
                                this.jBIG2DataWriter.setItemAt(index, (byte)(this.jBIG2DataWriter.getItemAt(index) & srcDataWriter.getItemAt(srcRowLine + srcCol)));
                                break;
                            }
                            case 2: {
                                this.jBIG2DataWriter.setItemAt(index, (byte)(this.jBIG2DataWriter.getItemAt(index) ^ srcDataWriter.getItemAt(srcRowLine + srcCol)));
                                break;
                            }
                            case 3: {
                                this.jBIG2DataWriter.setItemAt(index, (byte)(this.jBIG2DataWriter.getItemAt(index) ^ srcDataWriter.getItemAt(srcRowLine + srcCol)));
                                this.jBIG2DataWriter.setItemAt(index, (byte)(this.jBIG2DataWriter.getItemAt(index) ^ 0xFF));
                                break;
                            }
                            case 4: {
                                this.jBIG2DataWriter.setItemAt(index, srcDataWriter.getItemAt(srcRowLine + srcCol));
                            }
                        }
                    }
                    ++srcCol;
                }
                srcCol = 0;
                ++srcRow;
            }
            srcRow = 0;
            srcCol = byteEnd - x2;
            this.setPixels(x2, y2, srcWidth, srcHeight, srcLine, srcRow, srcCol, comb, srcDataWriter, byteEnd, byteEnd - x2);
        } else {
            this.setPixels(x2, y2, srcWidth, srcHeight, srcLine, srcRow, srcCol, comb, srcDataWriter, x2, 0);
        }
    }

    private void setPixels(int x2, int y2, int srcWidth, int srcHeight, int srcLine, int srcRow, int srcCol, int comb, JBIG2DataWriter srcDataWriter, int byteEnd, int i2) {
        for (int row = y2; row < y2 + srcHeight; ++row) {
            for (int col = byteEnd; col < x2 + srcWidth; ++col) {
                int srcPixel = JBIG2Bitmap.getPixel(srcCol, srcRow, srcLine, srcDataWriter);
                switch (comb) {
                    case 0: {
                        this.setPixel(col, row, JBIG2Bitmap.getPixel(col, row, this.line, this.jBIG2DataWriter) | srcPixel);
                        break;
                    }
                    case 1: {
                        this.setPixel(col, row, JBIG2Bitmap.getPixel(col, row, this.line, this.jBIG2DataWriter) & srcPixel);
                        break;
                    }
                    case 2: {
                        this.setPixel(col, row, JBIG2Bitmap.getPixel(col, row, this.line, this.jBIG2DataWriter) ^ srcPixel);
                        break;
                    }
                    case 3: {
                        if (JBIG2Bitmap.getPixel(col, row, this.line, this.jBIG2DataWriter) == 1 && srcPixel == 1 || JBIG2Bitmap.getPixel(col, row, this.line, this.jBIG2DataWriter) == 0 && srcPixel == 0) {
                            this.setPixel(col, row, 1);
                            break;
                        }
                        this.setPixel(col, row, 0);
                        break;
                    }
                    case 4: {
                        this.setPixel(col, row, srcPixel);
                    }
                }
                ++srcCol;
            }
            srcCol = i2;
            ++srcRow;
        }
    }

    private void duplicateRow(int yDest, int ySrc) {
        for (int i2 = 0; i2 < this.width; ++i2) {
            this.setPixel(i2, yDest, JBIG2Bitmap.getPixel(i2, ySrc, this.line, this.jBIG2DataWriter));
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLine() {
        return this.line;
    }

    public JBIG2DataWriter getDataWriter() {
        return this.jBIG2DataWriter;
    }

    public void putWriteSafeDataIntoStream(boolean switchPixelColor, OutputStream outputStream) throws IOException {
        int divider = 1024;
        int fullLen = this.jBIG2DataWriter.getDataLength();
        int rounds = fullLen / 1024;
        int bal = fullLen % 1024;
        int offset = 0;
        for (int a10 = 0; a10 <= rounds; ++a10) {
            int dataLen = a10 == rounds ? bal : 1024;
            byte[] bytes = this.jBIG2DataWriter.readBytes(offset, dataLen);
            if (switchPixelColor) {
                int i2 = 0;
                while (i2 < bytes.length) {
                    int n2 = i2++;
                    bytes[n2] = (byte)(bytes[n2] ^ 0xFF);
                }
            }
            outputStream.write(bytes);
            offset += 1024;
        }
    }

    public JBIG2Bitmap getSlice(int x2, int y2, int width, int height) {
        JBIG2Bitmap slice = new JBIG2Bitmap(width, height, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder, this.decoder);
        int sliceRow = 0;
        int sliceCol = 0;
        for (int row = y2; row < height; ++row) {
            for (int col = x2; col < x2 + width; ++col) {
                slice.setPixel(sliceCol, sliceRow, JBIG2Bitmap.getPixel(col, row, this.line, this.jBIG2DataWriter));
                ++sliceCol;
            }
            sliceCol = 0;
            ++sliceRow;
        }
        return slice;
    }

    public void setPixel(int col, int row, int value) {
        int index = row * this.line + col / 8;
        if (index >= this.jBIG2DataWriter.getDataLength() || index < 0) {
            return;
        }
        int b2 = this.jBIG2DataWriter.getItemAt(index);
        b2 = value == 0 ? (b2 &= ~(1 << 7 - col % 8)) : (b2 |= 1 << 7 - col % 8);
        this.jBIG2DataWriter.setItemAt(index, (byte)b2);
    }

    private static int getPixel(int col, int row, int line, JBIG2DataWriter jBIG2DataWriter) {
        int ptr = row * line + (col >> 3);
        if (ptr < jBIG2DataWriter.getDataLength() && ptr >= 0) {
            return (jBIG2DataWriter.getItemAt(ptr) & 1 << 7 - (col & 7)) != 0 ? 1 : 0;
        }
        return 0;
    }

    public int getPixel(int col, int row) {
        return (this.jBIG2DataWriter.getItemAt(row * this.line + (col >> 3)) & 1 << 7 - (col & 7)) != 0 ? 1 : 0;
    }

    public void expand(int newHeight) {
        byte[] newData = new byte[newHeight * this.line];
        if (this.jBIG2DataWriter.getData() != null) {
            System.arraycopy(this.jBIG2DataWriter.getData(), 0, newData, 0, this.height * this.line);
            this.height = newHeight;
            this.jBIG2DataWriter.setData(newData);
        }
    }

    public void setBitmapNumber(int segmentNumber) {
        this.bitmapNumber = segmentNumber;
    }

    public int getBitmapNumber() {
        return this.bitmapNumber;
    }
}

