/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.security.DecryptionFactory;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public final class TextStream {
    private TextStream() {
    }

    public static int readTextStream(PdfObject pdfObject, int i2, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        try {
            DecryptionFactory decryption;
            byte[] newString;
            if (raw[i2] != 60 && raw[i2] != 40) {
                ++i2;
            }
            boolean isRef = raw[i2 = StreamReaderUtils.skipSpaces(raw, i2)] != 60 && raw[i2] != 40;
            int j2 = i2;
            byte[] data = raw;
            if (isRef) {
                int[] values = StreamReaderUtils.readRefFromStream(raw, i2);
                int number = values[0];
                int generation = values[1];
                i2 = StreamReaderUtils.skipSpaces(raw, values[2]);
                if (raw[i2] != 82) {
                    return raw.length;
                }
                data = objectReader.readObjectAsByteArray(pdfObject, objectReader.isCompressed(number, generation), number, generation);
                if (data == null) {
                    pdfObject.setFullyResolved(false);
                    if (ObjectDecoder.debugFastCode) {
                        System.out.println(ObjectDecoder.padding + "Data not yet loaded");
                    }
                    LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (7)");
                    return raw.length;
                }
                if (data[0] == 40) {
                    j2 = 0;
                } else {
                    j2 = 3;
                    while (data[j2 - 1] != 106 && data[j2 - 2] != 98 && data[j2 - 3] != 111) {
                        ++j2;
                    }
                    j2 = StreamReaderUtils.skipSpaces(data, j2);
                }
            }
            while (data[j2] != 40 && data[j2] != 60) {
                ++j2;
            }
            int start = j2;
            j2 = TextStream.skipToEnd(data, j2);
            if (data[start] == 60) {
                newString = TextStream.handleHexString(data, j2, ++start);
            } else {
                if (data[start] == 40) {
                    ++start;
                }
                newString = ObjectUtils.readEscapedValue(j2, data, start, TextStream.getLbKeepReturns(pdfObject, PDFkeyInt));
            }
            if (pdfObject.getObjectType() != 1113489015 && pdfObject.getObjectType() != 487790868 && (!pdfObject.isInCompressedStream() || TextStream.isSignature(pdfObject) && (PDFkeyInt == 506543413 || PDFkeyInt == 826499443 || PDFkeyInt == 1618506351 || PDFkeyInt == 29)) && (decryption = objectReader.getDecryptionObject()) != null) {
                newString = decryption.decryptString(newString, pdfObject.getObjectRefAsString());
            }
            pdfObject.setTextStreamValue(PDFkeyInt, newString);
            if (ObjectDecoder.debugFastCode) {
                System.out.println(ObjectDecoder.padding + "TextStream=" + new String(newString) + " in pdfObject=" + pdfObject);
            }
            if (!isRef) {
                i2 = j2;
            }
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
        return i2;
    }

    private static boolean getLbKeepReturns(PdfObject pdfObject, int PDFkeyInt) {
        boolean lbKeepReturns = false;
        switch (PDFkeyInt) {
            case 1216184967: {
                lbKeepReturns = pdfObject.getNameAsConstant(1147962727) == 980909433;
                break;
            }
            case 6420: {
                lbKeepReturns = true;
                break;
            }
            case 31: 
            case 37: {
                lbKeepReturns = pdfObject.getObjectType() == 1113489015;
            }
        }
        return lbKeepReturns;
    }

    private static boolean isSignature(PdfObject pdfObject) {
        return pdfObject.getNameAsConstant(5668) == 2308407 || pdfObject.getNameAsConstant(608780341) == 2308407;
    }

    private static byte[] handleHexString(byte[] data, int j2, int start) {
        int byteCount = j2 - start >> 1;
        byte[] newString = new byte[byteCount];
        int byteReached = 0;
        while (start != j2) {
            start = StreamReaderUtils.skipSpaces(data, start);
            int topHex = TextStream.toNumber(data[start]);
            start = StreamReaderUtils.skipSpaces(data, start + 1);
            int bottomHex = TextStream.toNumber(data[start]);
            ++start;
            newString[byteReached] = (byte)(bottomHex + (topHex << 4));
            ++byteReached;
        }
        return newString;
    }

    static int skipToEnd(byte[] data, int j2) {
        byte startChar = data[j2];
        int bracketCount = 1;
        while (j2 < data.length - 1) {
            if (!(startChar != 40 || data[++j2] != 41 && data[j2] != 40 || ObjectUtils.isEscaped(data, j2))) {
                if (data[j2] == 40) {
                    ++bracketCount;
                } else if (data[j2] == 41) {
                    --bracketCount;
                }
                if (bracketCount == 0) break;
            }
            if (startChar != 60 || data[j2] != 62 && data[j2] != 0) continue;
            break;
        }
        return j2;
    }

    private static int toNumber(int rawVal) {
        if (rawVal >= 65 && rawVal <= 70) {
            rawVal -= 55;
        } else if (rawVal >= 97 && rawVal <= 102) {
            rawVal -= 87;
        } else if (rawVal >= 48 && rawVal <= 57) {
            rawVal -= 48;
        }
        return rawVal;
    }

    public static int setTextStreamValue(PdfObject pdfObject, int i2, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        if (raw[i2 + 1] == 40 && raw[i2 + 2] == 41) {
            pdfObject.setTextStreamValue(PDFkeyInt, new byte[1]);
            if (raw[i2 += 3] == 47) {
                --i2;
            }
        } else {
            i2 = TextStream.readTextStream(pdfObject, i2, raw, PDFkeyInt, objectReader);
        }
        return i2;
    }
}

